/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ReferencesBrowserController;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTableCellRenderer;
import org.netbeans.modules.profiler.heapwalk.ui.FieldTreeCellRenderer;
import org.openide.util.Lookup;

public class ReferencesBrowserControllerUI
extends JTitledPanel {
    private static Icon ICON_FIELDS = Icons.getIcon((String)"HeapWalkerIcons.IncomingReferences");
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private int columnCount;
    private CardLayout contents;
    private FieldTreeCellRenderer treeCellRenderer = new FieldTreeCellRenderer(false);
    private FieldsListTreeTableModel realFieldsListTableModel;
    private ExtendedTreeTableModel fieldsListTableModel;
    private JMenuItem showGcRootItem;
    private JMenuItem showInstanceItem;
    private JMenuItem showLoopOriginItem;
    private JMenuItem copyPathFromRootItem;
    private JMenuItem showSourceItem;
    private JMenuItem showInThreadsItem;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private JTreeTable fieldsListTable;
    private ReferencesBrowserController referencesBrowserController;
    private String filterValue = "";
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private boolean internalCornerButtonClick = false;
    private boolean needsUpdate = true;
    private boolean sortingOrder = true;
    private int sortingColumn = 0;
    private boolean retainedSizeSupported;
    private static final int MAX_STEP = 10;
    private List expandedPaths = null;
    private TreePath selectedPath = null;

    public ReferencesBrowserControllerUI(ReferencesBrowserController referencesBrowserController) {
        super(Bundle.ReferencesBrowserControllerUI_ViewTitleReferences(), ICON_FIELDS, true);
        this.referencesBrowserController = referencesBrowserController;
        this.retainedSizeSupported = referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() != -1;
        this.columnCount = this.retainedSizeSupported ? 6 : 5;
        this.realFieldsListTableModel = new FieldsListTreeTableModel();
        this.fieldsListTableModel = new ExtendedTreeTableModel((AbstractTreeTableModel)this.realFieldsListTableModel);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ReferencesBrowserControllerUI.this.isShowing() && ReferencesBrowserControllerUI.this.needsUpdate) {
                    ReferencesBrowserControllerUI.this.update();
                }
            }
        });
        this.initColumnsData();
        this.initData();
        this.initComponents();
        referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().addStateListener(new HeapFragmentWalker.StateListener(){

            @Override
            public void stateChanged(HeapFragmentWalker.StateEvent e) {
                if (e.getRetainedSizesStatus() == 3 && e.isMasterChange()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(5, true);
                            ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                            ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                            ReferencesBrowserControllerUI.this.setColumnsData();
                        }
                    });
                }
            }
        });
    }

    public void refreshView() {
        if (this.fieldsListTable != null) {
            if (this.expandedPaths != null || this.selectedPath != null) {
                BrowserUtils.restoreState(this.fieldsListTable, this.expandedPaths, this.selectedPath);
                this.expandedPaths = null;
                this.selectedPath = null;
            } else {
                this.fieldsListTable.updateTreeTable();
            }
        }
    }

    public void selectNode(HeapWalkerNode node) {
        CCTNode[] pathArr = this.fieldsListTable.getPathToRoot((CCTNode)node);
        this.selectPath(pathArr, Math.min(pathArr.length, 10));
    }

    private void selectPath(final CCTNode[] path, final int length) {
        if (length >= path.length) {
            final CCTNode node = (CCTNode)new TreePath(path).getLastPathComponent();
            this.fieldsListTable.selectNode(node, true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReferencesBrowserControllerUI.this.fieldsListTable.selectNode(node, true);
                }
            });
        } else {
            Object[] shortPath = new Object[length];
            System.arraycopy(path, 0, shortPath, 0, length);
            TreePath p = new TreePath(shortPath);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReferencesBrowserControllerUI.this.selectPath(path, length + 10);
                }
            });
        }
    }

    public List<TreePath> getExpandedPaths() {
        if (!this.showsData()) {
            return null;
        }
        return this.fieldsListTable.getExpandedPaths();
    }

    public TreePath getSelectedRow() {
        if (!this.showsData()) {
            return null;
        }
        return this.fieldsListTable.getTree().getSelectionPath();
    }

    public void restoreState(List expanded, TreePath selected) {
        if (this.showsData()) {
            this.expandedPaths = expanded;
            this.selectedPath = selected;
        } else {
            this.expandedPaths = null;
            this.selectedPath = null;
        }
    }

    private boolean showsData() {
        Object root = this.fieldsListTableModel.getRoot();
        return root != null && root != ReferencesBrowserController.EMPTY_INSTANCE_NODE;
    }

    public void update() {
        if (this.isShowing()) {
            this.initData();
            if (this.contents != null) {
                if (!this.showsData()) {
                    this.contents.show(this.getContentPanel(), NO_DATA);
                } else {
                    this.contents.show(this.getContentPanel(), DATA);
                }
                this.fieldsListTable.resetTreeCellOffsetX();
            }
            this.needsUpdate = false;
        } else {
            this.needsUpdate = true;
        }
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realFieldsListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.realFieldsListTableModel.getColumnName(i));
            menuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(menuItem);
            if (this.fieldsListTable != null) {
                menuItem.setState(this.fieldsListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.fieldsListTable.getColumnModel();
        this.fieldsListTable.setTreeCellRenderer((EnhancedTreeCellRenderer)this.treeCellRenderer);
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int index = this.fieldsListTableModel.getRealColumn(i);
            if (index == 0) continue;
            colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(final JCheckBoxMenuItem menuItem) {
        final boolean[] internalChange = new boolean[1];
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (internalChange[0]) {
                    return;
                }
                final int column = Integer.parseInt(e.getActionCommand());
                if (column == 5 && !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(column)) {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            final int retainedSizesState = ReferencesBrowserControllerUI.this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().computeRetainedSizes(false, true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (retainedSizesState != 3) {
                                        internalChange[0] = true;
                                        menuItem.setSelected(!menuItem.isSelected());
                                        internalChange[0] = false;
                                    } else {
                                        ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(column, !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(column));
                                        ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                                        ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                                        ReferencesBrowserControllerUI.this.setColumnsData();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    ReferencesBrowserControllerUI.this.fieldsListTableModel.setRealColumnVisibility(column, !ReferencesBrowserControllerUI.this.fieldsListTableModel.isRealColumnVisible(column));
                    ReferencesBrowserControllerUI.this.fieldsListTable.createDefaultColumnsFromModel();
                    ReferencesBrowserControllerUI.this.fieldsListTable.updateTreeTableHeader();
                    ReferencesBrowserControllerUI.this.setColumnsData();
                }
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu headerPopup) {
        final JButton cornerButton = new JButton(Icons.getIcon((String)"GeneralIcons.HideColumn"));
        cornerButton.setToolTipText(Bundle.ReferencesBrowserControllerUI_ShowHideColumnsString());
        cornerButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 1));
        }
        cornerButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 32) {
                    ReferencesBrowserControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        cornerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (headerPopup.isVisible()) {
                    ReferencesBrowserControllerUI.this.internalCornerButtonClick = true;
                    cornerButton.getModel().setArmed(false);
                } else {
                    ReferencesBrowserControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        ReferencesBrowserControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !ReferencesBrowserControllerUI.this.internalCornerButtonClick) {
                    ReferencesBrowserControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        return cornerButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        this.showInstanceItem = new JMenuItem(Bundle.ReferencesBrowserControllerUI_ShowInstanceItemText());
        this.showInstanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferencesBrowserControllerUI.this.performDefaultAction();
            }
        });
        this.showInstanceItem.setFont(popup.getFont().deriveFont(1));
        this.showGcRootItem = new JMenuItem(Bundle.ReferencesBrowserControllerUI_ShowGcRootItemText());
        this.showGcRootItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceNode instanceNode;
                HeapWalkerNode node = ReferencesBrowserControllerUI.this.getSelectedNode();
                if (node instanceof InstanceNode && (instanceNode = (InstanceNode)node).hasInstance()) {
                    ReferencesBrowserControllerUI.this.referencesBrowserController.navigateToNearestGCRoot(instanceNode);
                }
            }
        });
        this.showLoopOriginItem = new JMenuItem(Bundle.ReferencesBrowserControllerUI_ShowLoopItemText());
        this.showLoopOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapWalkerNode node = ReferencesBrowserControllerUI.this.getSelectedNode();
                if (node instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)node)).isLoop()) {
                    ReferencesBrowserControllerUI.this.selectNode(((HeapWalkerInstanceNode)((Object)node)).getLoopTo());
                }
            }
        });
        this.copyPathFromRootItem = new JMenuItem(Bundle.ReferencesBrowserControllerUI_CopyPathFromRoot());
        this.copyPathFromRootItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow();
                if (row != -1) {
                    TreePath path = ReferencesBrowserControllerUI.this.fieldsListTable.getTree().getPathForRow(row);
                    BrowserUtils.copyPathFromRoot(path);
                }
            }
        });
        if (GoToSource.isAvailable()) {
            this.showSourceItem = new JMenuItem(Bundle.ReferencesBrowserControllerUI_GoToSourceItemText());
            this.showSourceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeapWalkerNode node = ReferencesBrowserControllerUI.this.getSelectedNode();
                    if (node != null) {
                        String className = BrowserUtils.getArrayBaseType(node.getType());
                        Lookup.Provider p = ReferencesBrowserControllerUI.this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getHeapDumpProject();
                        GoToSource.openSource((Lookup.Provider)p, (String)className, null, null);
                    }
                }
            });
        }
        this.showInThreadsItem = new JMenuItem(Bundle.ReferencesBrowserControllerUI_ShowInThreadsItemText());
        this.showInThreadsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapWalkerNode node = ReferencesBrowserControllerUI.this.getSelectedNode();
                if (node instanceof HeapWalkerInstanceNode) {
                    Instance instance = ((HeapWalkerInstanceNode)((Object)node)).getInstance();
                    ReferencesBrowserControllerUI.this.referencesBrowserController.showInThreads(instance);
                }
            }
        });
        popup.add(this.showInstanceItem);
        popup.add(this.showGcRootItem);
        popup.add(this.showInThreadsItem);
        popup.addSeparator();
        popup.add(this.copyPathFromRootItem);
        popup.addSeparator();
        popup.add(this.showLoopOriginItem);
        if (this.showSourceItem != null) {
            popup.add(this.showSourceItem);
        }
        return popup;
    }

    private void initColumnsData() {
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = Bundle.ReferencesBrowserControllerUI_FieldColumnName();
        this.columnToolTips[0] = Bundle.ReferencesBrowserControllerUI_FieldColumnDescr();
        this.columnNames[1] = Bundle.ReferencesBrowserControllerUI_TypeColumnName();
        this.columnToolTips[1] = Bundle.ReferencesBrowserControllerUI_TypeColumnDescr();
        this.columnNames[2] = Bundle.ReferencesBrowserControllerUI_FullTypeColumnName();
        this.columnToolTips[2] = Bundle.ReferencesBrowserControllerUI_FullTypeColumnDescr();
        this.columnNames[3] = Bundle.ReferencesBrowserControllerUI_ValueColumnName();
        this.columnToolTips[3] = Bundle.ReferencesBrowserControllerUI_ValueColumnDescr();
        this.columnNames[4] = Bundle.ReferencesBrowserControllerUI_SizeColumnName();
        this.columnToolTips[4] = Bundle.ReferencesBrowserControllerUI_SizeColumnDescr();
        if (this.retainedSizeSupported) {
            this.columnNames[5] = Bundle.ReferencesBrowserControllerUI_RetainedSizeColumnName();
            this.columnToolTips[5] = Bundle.ReferencesBrowserControllerUI_RetainedSizeColumnDescr();
        }
        int unitWidth = this.getFontMetrics(this.getFont()).charWidth('W');
        LabelTableCellRenderer dataCellRendererL = new LabelTableCellRenderer(10);
        LabelTableCellRenderer dataCellRendererT = new LabelTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = unitWidth * 18;
        this.columnRenderers[1] = dataCellRendererL;
        this.columnWidths[1] = unitWidth * 28;
        this.columnRenderers[2] = dataCellRendererL;
        this.columnWidths[2] = unitWidth * 20;
        this.columnRenderers[3] = new FieldTableCellRenderer();
        this.columnWidths[3] = unitWidth * 7;
        this.columnRenderers[4] = dataCellRendererT;
        if (this.retainedSizeSupported) {
            this.columnWidths[4] = unitWidth * 7;
            this.columnRenderers[5] = dataCellRendererT;
        }
    }

    private void initComponents() {
        this.treeCellRenderer.setLeafIcon(null);
        this.treeCellRenderer.setClosedIcon(null);
        this.treeCellRenderer.setOpenIcon(null);
        this.fieldsListTableModel.setRealColumnVisibility(2, false);
        this.fieldsListTableModel.setRealColumnVisibility(4, false);
        if (this.retainedSizeSupported) {
            this.fieldsListTableModel.setRealColumnVisibility(5, this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getRetainedSizesStatus() == 3);
        }
        this.fieldsListTable = new JTreeTable((AbstractTreeTableModel)this.fieldsListTableModel){

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                TableColumnModel colModel = this.getColumnModel();
                for (int i = 0; i < ReferencesBrowserControllerUI.this.fieldsListTableModel.getColumnCount(); ++i) {
                    if (ReferencesBrowserControllerUI.this.fieldsListTableModel.getRealColumn(i) == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    colModel.getColumn(realFirstColumn).setPreferredWidth(this.getWidth() - columnsWidthsSum);
                }
                super.doLayout();
            }
        };
        this.fieldsListTable.setSelectionMode(0);
        this.fieldsListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.fieldsListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.fieldsListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.fieldsListTable.setShowHorizontalLines(false);
        this.fieldsListTable.setShowVerticalLines(true);
        this.fieldsListTable.setRowMargin(0);
        this.fieldsListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.fieldsListTable.getTree().setLargeModel(true);
        this.fieldsListTable.getTree().setToggleClickCount(0);
        this.fieldsListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.fieldsListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.fieldsListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferencesBrowserControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(this.fieldsListTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.fieldsListTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet(this.fieldsListTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.fieldsListTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JTreeTablePanel tablePanel = new JTreeTablePanel(this.fieldsListTable);
        tablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.add((Component)tablePanel, "Center");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hintArea = new HTMLTextArea();
        hintArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String instancesRes = Icons.getResource((String)"HeapWalkerIcons.Instances");
        String hintText = Bundle.ReferencesBrowserControllerUI_NoInstanceSelectedMsg("<img border='0' align='bottom' src='nbresloc:/" + instancesRes + "'>");
        hintArea.setText(hintText);
        this.noDataPanel.add((Component)hintArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add(this.noDataPanel, NO_DATA);
        this.add(this.dataPanel, DATA);
        this.fieldsListTable.addMouseListener((MouseListener)new FieldsListTableMouseListener());
        this.fieldsListTable.addKeyListener((KeyListener)new FieldsListTableKeyListener());
    }

    private void initData() {
        this.fieldsListTableModel.setRoot((Object)this.referencesBrowserController.getFilteredSortedReferences(this.filterValue, this.sortingColumn, this.sortingOrder));
        this.refreshView();
    }

    private void navigateToInstance(Instance instance) {
        this.referencesBrowserController.navigateToInstance(instance);
    }

    private void performDefaultAction() {
        HeapWalkerNode node = this.getSelectedNode();
        if (node instanceof HeapWalkerInstanceNode) {
            this.referencesBrowserController.createNavigationHistoryPoint();
            HeapWalkerInstanceNode instanceNode = (HeapWalkerInstanceNode)((Object)node);
            this.referencesBrowserController.navigateToInstance(instanceNode.getInstance());
        }
    }

    private void saveColumnsData() {
        TableColumnModel colModel = this.fieldsListTable.getColumnModel();
        for (int i = 0; i < this.fieldsListTableModel.getColumnCount(); ++i) {
            int index = this.fieldsListTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
    }

    private void showColumnSelectionPopup(JPopupMenu headerPopup, JButton cornerButton) {
        this.initColumnSelectorItems();
        headerPopup.show(cornerButton, cornerButton.getWidth() - headerPopup.getPreferredSize().width, cornerButton.getHeight());
    }

    public HeapWalkerNode getSelectedNode() {
        int row = this.fieldsListTable.getSelectedRow();
        return this.getSelectedNode(row);
    }

    public HeapWalkerNode getSelectedNode(int row) {
        return row == -1 ? null : (HeapWalkerNode)((Object)this.fieldsListTable.getTree().getPathForRow(row).getLastPathComponent());
    }

    public void showRootGCRoot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HeapWalkerNode node = ReferencesBrowserControllerUI.this.getSelectedNode(0);
                if (node != null && ReferencesBrowserControllerUI.this.isComputed(node)) {
                    ReferencesBrowserControllerUI.this.referencesBrowserController.navigateToNearestGCRoot((InstanceNode)node);
                } else {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            ReferencesBrowserControllerUI.this.showRootGCRoot();
                        }
                    }, 100);
                }
            }
        });
    }

    private boolean isComputed(HeapWalkerNode node) {
        return node instanceof HeapWalkerInstanceNode && (!node.currentlyHasChildren() || node.getNChildren() != 1 || !HeapWalkerNodeFactory.isMessageNode(node.getChild(0)));
    }

    private void showPopupMenu(int row, int x, int y) {
        if (row == -1) {
            return;
        }
        HeapWalkerNode node = this.getSelectedNode(row);
        if (node instanceof HeapWalkerInstanceNode && ((HeapWalkerInstanceNode)((Object)node)).isLoop()) {
            this.showLoopOriginItem.setVisible(true);
        } else {
            this.showLoopOriginItem.setVisible(false);
        }
        if (node != null && node.isRoot()) {
            this.showInstanceItem.setEnabled(false);
            this.copyPathFromRootItem.setEnabled(false);
        } else {
            this.showInstanceItem.setEnabled(node instanceof HeapWalkerInstanceNode && (!(node instanceof HeapWalkerFieldNode) || !((HeapWalkerFieldNode)((Object)node)).isStatic()));
            this.copyPathFromRootItem.setEnabled(node != null);
        }
        this.showGcRootItem.setEnabled(this.isComputed(node));
        if (this.showSourceItem != null) {
            HeapWalkerInstanceNode instanceNode;
            String className = null;
            if (node instanceof HeapWalkerInstanceNode && (instanceNode = (HeapWalkerInstanceNode)((Object)node)).hasInstance()) {
                className = instanceNode.getInstance().getJavaClass().getName();
            }
            this.showSourceItem.setEnabled(className != null && !VMUtils.isPrimitiveType((String)BrowserUtils.getArrayBaseType(className)));
        }
        this.showInThreadsItem.setEnabled(false);
        if (node instanceof HeapWalkerInstanceNode) {
            JavaFrameGCRoot frameVar;
            Instance rootInstance = ((HeapWalkerInstanceNode)((Object)node)).getInstance();
            Heap heap = this.referencesBrowserController.getReferencesControllerHandler().getHeapFragmentWalker().getHeapFragment();
            GCRoot gcRoot = heap.getGCRoot(rootInstance);
            if (gcRoot != null && "Java frame".equals(gcRoot.getKind()) && (frameVar = (JavaFrameGCRoot)gcRoot).getFrameNumber() != -1) {
                this.showInThreadsItem.setEnabled(true);
            }
        }
        if (x == -1 || y == -1) {
            Rectangle rowBounds = this.fieldsListTable.getCellRect(row, 0, true);
            if (x == -1) {
                x = rowBounds.x + rowBounds.width / 2;
            }
            if (y == -1) {
                y = rowBounds.y + rowBounds.height / 2;
            }
        }
        this.tablePopup.show((Component)this.fieldsListTable, x, y);
    }

    private class FieldsListTreeTableModel
    extends AbstractTreeTableModel {
        private FieldsListTreeTableModel() {
            super((CCTNode)ReferencesBrowserController.EMPTY_INSTANCE_NODE);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public int getColumnCount() {
            return ReferencesBrowserControllerUI.this.columnCount;
        }

        public String getColumnName(int columnIndex) {
            return ReferencesBrowserControllerUI.this.columnNames[columnIndex];
        }

        public String getColumnToolTipText(int col) {
            return ReferencesBrowserControllerUI.this.columnToolTips[col];
        }

        public boolean isLeaf(Object node) {
            return ((HeapWalkerNode)((Object)node)).isLeaf();
        }

        public Object getValueAt(Object object, int columnIndex) {
            HeapWalkerNode fieldNode = (HeapWalkerNode)((Object)object);
            switch (columnIndex) {
                case 0: {
                    return fieldNode;
                }
                case 1: {
                    return fieldNode.getSimpleType();
                }
                case 2: {
                    return fieldNode.getType();
                }
                case 3: {
                    return fieldNode;
                }
                case 4: {
                    return fieldNode.getSize();
                }
                case 5: {
                    return fieldNode.getRetainedSize();
                }
            }
            return null;
        }
    }

    private class FieldsListTableMouseListener
    extends MouseAdapter {
        private FieldsListTableMouseListener() {
        }

        private void updateSelection(int row) {
            ReferencesBrowserControllerUI.this.fieldsListTable.requestFocusInWindow();
            if (row != -1) {
                ReferencesBrowserControllerUI.this.fieldsListTable.setRowSelectionInterval(row, row);
            } else {
                ReferencesBrowserControllerUI.this.fieldsListTable.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (e.isPopupTrigger()) {
                ReferencesBrowserControllerUI.this.showPopupMenu(row, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (e.isPopupTrigger()) {
                ReferencesBrowserControllerUI.this.showPopupMenu(row, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                HeapWalkerNode node;
                int row = ReferencesBrowserControllerUI.this.fieldsListTable.rowAtPoint(e.getPoint());
                if (e.getX() >= ((ReferencesBrowserControllerUI)ReferencesBrowserControllerUI.this).fieldsListTable.getTree().getRowBounds((int)row).x - ReferencesBrowserControllerUI.this.fieldsListTable.getTreeCellOffsetX() && row != -1 && (node = ReferencesBrowserControllerUI.this.getSelectedNode(row)) instanceof HeapWalkerInstanceNode) {
                    ReferencesBrowserControllerUI.this.performDefaultAction();
                }
            }
        }
    }

    private class FieldsListTableKeyListener
    extends KeyAdapter {
        private FieldsListTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int selectedRow;
            if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = ReferencesBrowserControllerUI.this.fieldsListTable.getSelectedRow()) != -1) {
                ReferencesBrowserControllerUI.this.showPopupMenu(selectedRow, -1, -1);
            }
        }
    }
}

