/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.api.debugger.Session;

public final class SessionBridge {
    private static SessionBridge instance;
    private final Map<String, Set<SessionChanger>> sessionChangers = new HashMap<String, Set<SessionChanger>>();
    private final List<SessionChanger> lookupSessionChangers;

    private SessionBridge() {
        Lookup.MetaInf lookup = new Lookup.MetaInf(null);
        final List<SessionChanger> scList = ((Lookup)lookup).lookup(null, SessionChanger.class);
        ((Customizer)((Object)scList)).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (SessionChanger sc : SessionBridge.this.lookupSessionChangers) {
                    SessionBridge.this.removeSessionChangerListener(sc);
                }
                SessionBridge.this.lookupSessionChangers.clear();
                for (SessionChanger sc : scList) {
                    SessionBridge.this.lookupSessionChangers.add(sc);
                    SessionBridge.this.addSessionChangerListener(sc);
                }
            }
        });
        this.lookupSessionChangers = new ArrayList<SessionChanger>();
        for (SessionChanger sc : scList) {
            this.lookupSessionChangers.add(sc);
            this.addSessionChangerListener(sc);
        }
    }

    public static synchronized SessionBridge getDefault() {
        if (instance == null) {
            instance = new SessionBridge();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suggestChange(Session origin, String action, Map<Object, Object> properties) {
        Set<SessionChanger> scs;
        Map<String, Set<SessionChanger>> map = this.sessionChangers;
        synchronized (map) {
            scs = this.sessionChangers.get(action);
        }
        if (scs != null) {
            for (SessionChanger sc : scs) {
                Session newSession = sc.changeSuggested(origin, action, properties);
                if (newSession == null) continue;
                if (DebuggerManager.getDebuggerManager().getCurrentSession() == origin) {
                    DebuggerManager.getDebuggerManager().setCurrentSession(newSession);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChangerFor(String action) {
        Map<String, Set<SessionChanger>> map = this.sessionChangers;
        synchronized (map) {
            Set<SessionChanger> scs = this.sessionChangers.get(action);
            return scs != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSessionChangerListener(SessionChanger sc) {
        Set<String> actions = sc.getActions();
        Map<String, Set<SessionChanger>> map = this.sessionChangers;
        synchronized (map) {
            for (String action : actions) {
                Set<SessionChanger> scs = this.sessionChangers.get(action);
                if (scs == null) {
                    this.sessionChangers.put(action, Collections.singleton(sc));
                    continue;
                }
                if (scs.size() == 1) {
                    SessionChanger old = scs.iterator().next();
                    scs = new CopyOnWriteArraySet<SessionChanger>();
                    scs.add(old);
                }
                scs.add(sc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionChangerListener(SessionChanger sc) {
        Set<String> actions = sc.getActions();
        Map<String, Set<SessionChanger>> map = this.sessionChangers;
        synchronized (map) {
            for (String action : actions) {
                Set<SessionChanger> scs = this.sessionChangers.get(action);
                if (scs == null) continue;
                if (scs.size() == 1) {
                    SessionChanger old = scs.iterator().next();
                    if (!sc.equals(old)) continue;
                    this.sessionChangers.remove(action);
                    continue;
                }
                scs.remove(sc);
            }
        }
    }

    public static interface SessionChanger {
        public Set<String> getActions();

        public Session changeSuggested(Session var1, String var2, Map<Object, Object> var3);
    }
}

