/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedPatternTree;
import com.sun.source.tree.PatternTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.filesystems.FileObject;

public class ConvertToNestedRecordPattern {
    private static final int RECORD_PATTERN_PREVIEW_JDK_VERSION = 19;

    public static ErrorDescription convertToNestedRecordPattern(final HintContext ctx) {
        if (Utilities.isJDKVersionLower(19) && !CompilerOptionsQuery.getOptions((FileObject)ctx.getInfo().getFileObject()).getArguments().contains("--enable-preview")) {
            return null;
        }
        TreePath t = ctx.getPath();
        if (!t.getParentPath().getLeaf().getKind().equals((Object)Tree.Kind.INSTANCE_OF)) {
            return null;
        }
        final HashSet<String> recordPatternVarSet = new HashSet<String>();
        Map<PatternTree, List<PatternTree>> recordComponentMap = new LinkedHashMap<PatternTree, List<PatternTree>>();
        DeconstructionPatternTree recordPattern = (DeconstructionPatternTree)t.getLeaf();
        recordComponentMap = ConvertToNestedRecordPattern.findNested(recordPattern, recordComponentMap);
        for (PatternTree p : recordComponentMap.keySet()) {
            BindingPatternTree bTree = (BindingPatternTree)p;
            recordPatternVarSet.add(bTree.getVariable().getName().toString());
        }
        while (t != null && t.getLeaf().getKind() != Tree.Kind.BLOCK) {
            t = t.getParentPath();
        }
        final HashSet<TreePath> convertPath = new HashSet<TreePath>();
        final ArrayList<String> localVarList = new ArrayList<String>();
        final HashMap<String, List<UserVariables>> userVars = new HashMap<String, List<UserVariables>>();
        new CancellableTreePathScanner<Void, Void>(){

            public Void visitVariable(VariableTree node, Void p) {
                localVarList.add(node.getName().toString());
                HashMap outerVariables = new HashMap();
                HashMap innerVariables = new HashMap();
                List<UserVariables> nList = new ArrayList<UserVariables>();
                boolean match = MatcherUtilities.matches((HintContext)ctx, (TreePath)this.getCurrentPath(), (String)"$type $var1 = $expr3.$meth1()", outerVariables, new HashMap(), innerVariables);
                if (match && recordPatternVarSet.contains(((TreePath)outerVariables.get("$expr3")).getLeaf().toString())) {
                    String expr3 = ((TreePath)outerVariables.get("$expr3")).getLeaf().toString();
                    nList.clear();
                    if (userVars.get(expr3) != null) {
                        nList = (List)userVars.get(expr3);
                    }
                    nList.add(new UserVariables((String)innerVariables.get("$var1"), (String)innerVariables.get("$meth1")));
                    userVars.put(expr3, nList);
                    convertPath.add(this.getCurrentPath());
                }
                return (Void)super.visitVariable(node, (Object)p);
            }

            protected boolean isCanceled() {
                return ctx.isCanceled();
            }
        }.scan(t, null);
        if (!convertPath.isEmpty()) {
            Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), convertPath, localVarList, userVars).toEditorFix();
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToNestedRecordPattern(), (Fix[])new Fix[]{fix});
        }
        return null;
    }

    private static Map<PatternTree, List<PatternTree>> findNested(PatternTree pTree, Map<PatternTree, List<PatternTree>> recordComponentMap) {
        switch (pTree.getKind()) {
            case BINDING_PATTERN: {
                recordComponentMap.put(pTree, new ArrayList());
                return recordComponentMap;
            }
            case DECONSTRUCTION_PATTERN: {
                DeconstructionPatternTree bTree = (DeconstructionPatternTree)pTree;
                for (PatternTree patternTree : bTree.getNestedPatterns()) {
                    ConvertToNestedRecordPattern.findNested(patternTree, recordComponentMap);
                }
                break;
            }
            case PARENTHESIZED_PATTERN: {
                ParenthesizedPatternTree parenthTree = (ParenthesizedPatternTree)pTree;
                ConvertToNestedRecordPattern.findNested(parenthTree.getPattern(), recordComponentMap);
                break;
            }
            default: {
                return recordComponentMap;
            }
        }
        return recordComponentMap;
    }

    private static PatternTree createNestedPattern(PatternTree pTree, WorkingCopy wc, Map<PatternTree, List<PatternTree>> map) {
        switch (pTree.getKind()) {
            case BINDING_PATTERN: {
                if (map.containsKey(pTree) && !map.get(pTree).isEmpty()) {
                    BindingPatternTree p = (BindingPatternTree)pTree;
                    VariableTree v = p.getVariable();
                    return wc.getTreeMaker().RecordPattern((ExpressionTree)v.getType(), map.get(pTree), v);
                }
                return pTree;
            }
            case DECONSTRUCTION_PATTERN: {
                DeconstructionPatternTree bTree = (DeconstructionPatternTree)pTree;
                ArrayList<PatternTree> list = new ArrayList<PatternTree>();
                for (PatternTree patternTree : bTree.getNestedPatterns()) {
                    PatternTree val = ConvertToNestedRecordPattern.createNestedPattern(patternTree, wc, map);
                    list.add(val);
                }
                return wc.getTreeMaker().RecordPattern(bTree.getDeconstructor(), list, bTree.getVariable());
            }
            case PARENTHESIZED_PATTERN: {
                ParenthesizedPatternTree parenthTree = (ParenthesizedPatternTree)pTree;
                return ConvertToNestedRecordPattern.createNestedPattern(parenthTree.getPattern(), wc, map);
            }
        }
        return pTree;
    }

    private static final class FixImpl
    extends JavaFix {
        private final Map<String, List<UserVariables>> userVars;
        private final Set<TreePathHandle> replaceOccurrences;
        List<String> localVarList;

        public FixImpl(CompilationInfo info, TreePath main, Set<TreePath> replaceOccurrences, List<String> localVarList, Map<String, List<UserVariables>> userVars) {
            super(info, main);
            this.replaceOccurrences = replaceOccurrences.stream().map(tp -> TreePathHandle.create((TreePath)tp, (CompilationInfo)info)).collect(Collectors.toSet());
            this.userVars = userVars;
            this.localVarList = localVarList;
        }

        protected String getText() {
            return Bundle.ERR_ConvertToNestedRecordPattern();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath t = ctx.getPath();
            TypeElement type = null;
            Map recordComponentMap = new LinkedHashMap();
            DeconstructionPatternTree recordPattern = (DeconstructionPatternTree)t.getLeaf();
            recordComponentMap = ConvertToNestedRecordPattern.findNested(recordPattern, recordComponentMap);
            HashSet<String> localVars = new HashSet<String>(this.localVarList);
            for (PatternTree p : recordComponentMap.keySet()) {
                ArrayList<BindingPatternTree> bindTree = new ArrayList<BindingPatternTree>();
                BindingPatternTree bTree = (BindingPatternTree)p;
                VariableTree v = bTree.getVariable();
                type = (TypeElement)wc.getTrees().getElement(TreePath.getPath(t, v.getType()));
                if (type == null || type.getRecordComponents().size() == 0) continue;
                block1: for (RecordComponentElement recordComponentElement : type.getRecordComponents()) {
                    String name = recordComponentElement.getSimpleName().toString();
                    TypeMirror returnType = recordComponentElement.getAccessor().getReturnType();
                    if (this.userVars.get(v.getName().toString()) != null) {
                        for (UserVariables var : this.userVars.get(v.getName().toString())) {
                            if (!var.getMethodName().equals(name)) continue;
                            bindTree.add((BindingPatternTree)wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)var.getVariable(), wc.getTreeMaker().Type(returnType), null)));
                            continue block1;
                        }
                    }
                    String baseName = name;
                    int cnt = 1;
                    while (SourceVersion.isKeyword(name) || localVars.contains(name)) {
                        name = CodeStyleUtils.addPrefixSuffix((CharSequence)(baseName + cnt++), (String)"", (String)"");
                    }
                    localVars.add(name);
                    bindTree.add((BindingPatternTree)wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, wc.getTreeMaker().Type(returnType), null)));
                }
                recordComponentMap.put(p, bindTree);
            }
            DeconstructionPatternTree d = (DeconstructionPatternTree)ConvertToNestedRecordPattern.createNestedPattern((PatternTree)t.getLeaf(), wc, recordComponentMap);
            while (t != null && t.getLeaf().getKind() != Tree.Kind.BLOCK) {
                t = t.getParentPath();
            }
            List removeList = this.replaceOccurrences.stream().map(tph -> tph.resolve((CompilationInfo)wc).getLeaf()).collect(Collectors.toList());
            for (Tree tree : removeList) {
                StatementTree statementTree = (StatementTree)tree;
                Utilities.removeStatements(wc, TreePath.getPath(t, (Tree)statementTree), null);
            }
            wc.rewrite(ctx.getPath().getLeaf(), (Tree)d);
        }
    }

    private static class UserVariables {
        String methodName;
        String variable;

        UserVariables(String variable, String methodName) {
            this.variable = variable;
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

