/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import java.util.List;
import javax.xml.soap.SOAPMessage;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.design.javamodel.FaultModel;
import org.netbeans.modules.websvc.design.javamodel.JavadocModel;
import org.netbeans.modules.websvc.design.javamodel.ParamModel;
import org.netbeans.modules.websvc.design.javamodel.ResultModel;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.openide.filesystems.FileObject;

public class MethodModel {
    private FileObject implementationClass;
    String javaName;
    String operationName;
    String action;
    private ResultModel result;
    private List<ParamModel> params;
    boolean oneWay;
    private JavadocModel javadoc;
    private List<FaultModel> faults;
    private SOAPMessage soapRequest;
    private SOAPMessage soapResponse;
    private ElementHandle methodHandle;

    MethodModel(FileObject implementationClass, String operationName) {
        this.implementationClass = implementationClass;
        this.operationName = operationName;
    }

    MethodModel() {
    }

    public FileObject getImplementationClass() {
        if (!this.implementationClass.isValid()) {
            FileObject parent = this.implementationClass.getParent();
            this.implementationClass = parent.getFileObject(this.implementationClass.getNameExt());
        }
        return this.implementationClass;
    }

    void setImplementationClass(FileObject impl) {
        this.implementationClass = impl;
    }

    public ElementHandle getMethodHandle() {
        return this.methodHandle;
    }

    void setMethodHandle(ElementHandle methodHandle) {
        this.methodHandle = methodHandle;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        if (this.operationName == null || !this.operationName.equals(operationName)) {
            JaxWsUtils.setWebMethodAttrValue((FileObject)this.getImplementationClass(), (ElementHandle)this.methodHandle, (String)"operationName", (String)operationName);
            this.operationName = operationName == null ? this.javaName : operationName;
        }
    }

    public ResultModel getResult() {
        return this.result;
    }

    void setResult(ResultModel result) {
        this.result = result;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public List<ParamModel> getParams() {
        return this.params;
    }

    void setParams(List<ParamModel> params) {
        this.params = params;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    public JavadocModel getJavadoc() {
        return this.javadoc;
    }

    void setJavadoc(JavadocModel javadoc) {
        this.javadoc = javadoc;
    }

    public void setJavadoc(String javadoc) {
        Utils.setJavadoc(this.implementationClass, this, javadoc);
    }

    public List<FaultModel> getFaults() {
        return this.faults;
    }

    void setFaults(List<FaultModel> faults) {
        this.faults = faults;
    }

    public boolean isEqualTo(MethodModel model) {
        int i;
        if (!this.operationName.equals(model.operationName)) {
            return false;
        }
        if (!this.result.isEqualTo(model.result)) {
            return false;
        }
        if (this.oneWay != model.oneWay) {
            return false;
        }
        if (!Utils.isEqualTo(this.action, model.action)) {
            return false;
        }
        if (this.javadoc != null ? !this.javadoc.isEqualTo(model.javadoc) : model.javadoc != null) {
            return false;
        }
        if (this.params.size() != model.params.size()) {
            return false;
        }
        for (i = 0; i < this.params.size(); ++i) {
            if (this.params.get(i).isEqualTo(model.params.get(i))) continue;
            return false;
        }
        if (this.faults.size() != model.faults.size()) {
            return false;
        }
        for (i = 0; i < this.faults.size(); ++i) {
            if (this.faults.get(i).isEqualTo(model.faults.get(i))) continue;
            return false;
        }
        return true;
    }

    public SOAPMessage getSoapRequest() {
        return this.soapRequest;
    }

    void setSoapRequest(SOAPMessage soapRequest) {
        this.soapRequest = soapRequest;
    }

    public SOAPMessage getSoapResponse() {
        return this.soapResponse;
    }

    void setSoapResponse(SOAPMessage soapResponse) {
        this.soapResponse = soapResponse;
    }
}

