/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.less;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.css.prep.less.Bundle;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.util.FileUtils;
import org.netbeans.modules.css.prep.util.InvalidExternalExecutableException;
import org.netbeans.modules.css.prep.util.StringUtils;
import org.netbeans.modules.css.prep.util.UiUtils;
import org.netbeans.modules.css.prep.util.VersionOutputProcessorFactory;
import org.netbeans.modules.web.common.api.Version;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.netbeans.modules.web.common.ui.api.ExternalExecutableValidator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class LessExecutable {
    private static final Logger LOGGER = Logger.getLogger(LessExecutable.class.getName());
    public static final String EXECUTABLE_NAME = "lessc";
    public static final String EXECUTABLE_LONG_NAME = "lessc" + FileUtils.getScriptExtension(true, true);
    private static final String DEBUG_PARAM = "--line-numbers=all";
    private static final String SOURCE_MAP_PARAM = "--source-map";
    private static final String SOURCE_MAP_ROOTPATH_PARAM = "--source-map-rootpath=%s";
    private static final String SOURCE_MAP_URL_PARAM = "--source-map-url=%s";
    private static final String VERSION_PARAM = "--version";
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final Version MINIMAL_VERSION_WITH_SOURCEMAP = Version.fromDottedNotationWithFallback((String)"1.5.0");
    static final String VERSION_PATTERN = "lessc\\s+(\\d+(\\.\\d+)*)";
    private static volatile Version version;
    protected final String lessPath;

    LessExecutable(String lessPath) {
        assert (lessPath != null);
        this.lessPath = lessPath;
    }

    public static LessExecutable getDefault() throws InvalidExternalExecutableException {
        String path = CssPrepOptions.getInstance().getLessPath();
        String error = LessExecutable.validate(path);
        if (error != null) {
            throw new InvalidExternalExecutableException(error);
        }
        if (Utilities.isMac()) {
            return new MacLessExecutable(path);
        }
        return new LessExecutable(path);
    }

    public static String validate(String path) {
        return ExternalExecutableValidator.validateCommand((String)path, (String)Bundle.Less_executable_label());
    }

    public static void resetVersion() {
        version = null;
    }

    @CheckForNull
    private static Version getVersion() {
        block8: {
            assert (!EventQueue.isDispatchThread());
            if (version != null) {
                return version;
            }
            VersionOutputProcessorFactory versionOutputProcessorFactory = new VersionOutputProcessorFactory(VERSION_PATTERN);
            try {
                LessExecutable lessExecutable = LessExecutable.getDefault();
                lessExecutable.getExecutable("Less version", TMP_DIR).additionalParameters(lessExecutable.getVersionParameters()).runAndWait(LessExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)versionOutputProcessorFactory, "Detecting Less version...");
                String detectedVersion = versionOutputProcessorFactory.getVersion();
                if (detectedVersion != null) {
                    version = Version.fromDottedNotationWithFallback((String)detectedVersion);
                    return version;
                }
            }
            catch (CancellationException ex) {
                assert (false);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (InvalidExternalExecutableException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return null;
    }

    @CheckForNull
    public void compile(File workDir, File source, final File target, List<String> compilerOptions) throws ExecutionException {
        assert (!EventQueue.isDispatchThread());
        assert (workDir.isDirectory()) : "Not directory given: " + workDir;
        assert (source.isFile()) : "Not file given: " + source;
        final File targetDir = target.getParentFile();
        if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
            LOGGER.log(Level.WARNING, "Cannot create directory {0}", targetDir);
            return;
        }
        try {
            this.getExecutable(Bundle.Less_compile(), workDir).additionalParameters(this.getCompileParameters(source, target, compilerOptions)).runAndWait(this.getDescriptor(new Runnable(){

                @Override
                public void run() {
                    FileUtil.refreshFor((File[])new File[]{targetDir});
                    UiUtils.refreshCssInBrowser(target);
                }
            }), "Compiling less files...");
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            throw ex;
        }
    }

    String getCommand() {
        return this.lessPath;
    }

    private ExternalExecutable getExecutable(String title, File workDir) {
        return new ExternalExecutable(this.getCommand()).workDir(workDir).displayName(title).optionsPath("Html5/CssPreprocessors");
    }

    private ExecutionDescriptor getDescriptor(Runnable postTask) {
        return new ExecutionDescriptor().inputOutput(IOProvider.getDefault().getIO(Bundle.Less_compile(), false)).inputVisible(false).frontWindow(false).frontWindowOnError(CssPrepOptions.getInstance().getLessOutputOnError()).noReset(true).showProgress(true).postExecution(postTask);
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false);
    }

    List<String> getCompileParameters(File inputFile, File outputFile, List<String> compilerOptions) {
        ArrayList<String> params = new ArrayList<String>();
        boolean debug = CssPrepOptions.getInstance().getLessDebug();
        if (debug) {
            Version installedVersion = LessExecutable.getVersion();
            if (installedVersion != null && installedVersion.isAboveOrEqual(MINIMAL_VERSION_WITH_SOURCEMAP)) {
                params.add(SOURCE_MAP_PARAM);
                params.add(String.format(SOURCE_MAP_ROOTPATH_PARAM, this.getRelativeRootPath(inputFile, outputFile)));
                params.add(String.format(SOURCE_MAP_URL_PARAM, outputFile.getName() + ".map"));
            } else {
                params.add(DEBUG_PARAM);
            }
        }
        params.addAll(compilerOptions);
        params.add(inputFile.getAbsolutePath());
        params.add(outputFile.getAbsolutePath());
        return params;
    }

    List<String> getVersionParameters() {
        return Collections.singletonList(VERSION_PARAM);
    }

    private String getRelativeRootPath(File inputFile, File outputFile) {
        String relativePath = PropertyUtils.relativizeFile((File)outputFile.getParentFile(), (File)inputFile.getParentFile());
        assert (relativePath != null) : "input: " + inputFile + " ==> output: " + outputFile;
        return relativePath;
    }

    private static final class MacLessExecutable
    extends LessExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacLessExecutable(String lessPath) {
            super(lessPath);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getCompileParameters(File inputFile, File outputFile, List<String> compilerOptions) {
            return this.getParams(super.getCompileParameters(inputFile, outputFile, compilerOptions));
        }

        @Override
        List<String> getVersionParameters() {
            return this.getParams(super.getVersionParameters());
        }

        private List<String> getParams(List<String> originalParams) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.lessPath);
            sb.append("\" \"");
            sb.append(StringUtils.implode(originalParams, "\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }
}

