/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProjectLibraryProvider
implements ArealLibraryProvider<ProjectLibraryArea, ProjectLibraryImplementation>,
PropertyChangeListener,
AntProjectListener {
    private static final Logger LOG = Logger.getLogger(ProjectLibraryProvider.class.getName());
    private static final String NAMESPACE = "http://www.netbeans.org/ns/ant-project-libraries/1";
    private static final String EL_LIBRARIES = "libraries";
    private static final String EL_DEFINITIONS = "definitions";
    private static final String SFX_DISPLAY_NAME = "displayName";
    private static final String PROP_PREFIX = "prop-";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private AntProjectListener apl;
    public static ProjectLibraryProvider INSTANCE;
    private volatile boolean listening = true;
    private final Map<ProjectLibraryArea, Reference<LP>> providers = new HashMap<ProjectLibraryArea, Reference<LP>>();
    static final Pattern LIBS_LINE;
    private static final RequestProcessor RP;
    public static boolean FIRE_CHANGES_SYNCH;

    public ProjectLibraryProvider() {
        INSTANCE = this;
    }

    public Class<ProjectLibraryArea> areaType() {
        return ProjectLibraryArea.class;
    }

    public Class<ProjectLibraryImplementation> libraryType() {
        return ProjectLibraryImplementation.class;
    }

    public String toString() {
        return "ProjectLibraryProvider";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ProjectLibraryArea> getOpenAreas() {
        ProjectLibraryProvider projectLibraryProvider = this;
        synchronized (projectLibraryProvider) {
            if (this.apl == null) {
                this.apl = (AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, null);
                OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjects.getDefault()));
            }
        }
        HashSet<ProjectLibraryArea> areas = new HashSet<ProjectLibraryArea>();
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            AntProjectHelper helper = AntBasedProjectFactorySingleton.getHelperFor(p);
            if (helper == null) continue;
            helper.removeAntProjectListener(this.apl);
            helper.addAntProjectListener(this.apl);
            Definitions def = ProjectLibraryProvider.findDefinitions(helper);
            if (def == null) continue;
            areas.add(new ProjectLibraryArea(def.mainPropertiesFile));
        }
        return areas;
    }

    public ProjectLibraryArea createArea() {
        JFileChooser jfc = new JFileChooser();
        jfc.setApproveButtonText(NbBundle.getMessage(ProjectLibraryProvider.class, (String)"ProjectLibraryProvider.open_or_create"));
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".properties") && !f.getName().endsWith("-private.properties");
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ProjectLibraryProvider.class, (String)"ProjectLibraryProvider.properties_files");
            }
        };
        jfc.setFileFilter(filter);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jfc, null);
        while (jfc.showOpenDialog(Utilities.findDialogParent()) == 0) {
            File f = jfc.getSelectedFile();
            if (!filter.accept(f)) continue;
            return new ProjectLibraryArea(f);
        }
        return null;
    }

    public ProjectLibraryArea loadArea(URL location) {
        if (location.getProtocol().equals("file") && location.getPath().endsWith(".properties")) {
            try {
                return new ProjectLibraryArea(BaseUtilities.toFile((URI)location.toURI()));
            }
            catch (URISyntaxException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("openProjects".equals(ev.getPropertyName())) {
            this.pcs.firePropertyChange("openAreas", null, null);
        }
    }

    @Override
    public void configurationXmlChanged(AntProjectEvent ev) {
        if ("nbproject/project.xml".equals(ev.getPath())) {
            this.pcs.firePropertyChange("openAreas", null, null);
        }
    }

    @Override
    public void propertiesChanged(AntProjectEvent ev) {
    }

    public synchronized LP getLibraries(ProjectLibraryArea area) {
        LP lp;
        Reference<LP> rlp = this.providers.get(area);
        LP lP = lp = rlp != null ? rlp.get() : null;
        if (lp == null) {
            lp = new LP(area);
            this.providers.put(area, new WeakReference<LP>(lp));
        }
        return lp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectLibraryImplementation createLibrary(String type, String name, ProjectLibraryArea area, Map<String, List<URI>> contents) throws IOException {
        File f = area.mainPropertiesFile;
        assert (this.listening);
        this.listening = false;
        try {
            if (type.equals("j2se")) {
                ProjectLibraryProvider.replaceProperty(f, true, "libs." + name + ".classpath", "");
            } else {
                ProjectLibraryProvider.replaceProperty(f, false, "libs." + name + ".type", type);
            }
        }
        finally {
            this.listening = true;
        }
        LP lp = this.getLibraries(area);
        boolean fire = this.delta(lp.libraries, ProjectLibraryProvider.calculate(area), new HashMap<ProjectLibraryImplementation, List<String>>());
        ProjectLibraryImplementation impl = lp.getLibrary(name);
        assert (impl != null) : name + " not found in " + f;
        for (Map.Entry<String, List<URI>> entry : contents.entrySet()) {
            impl.setURIContent(entry.getKey(), entry.getValue());
        }
        if (fire) {
            lp.pcs.firePropertyChange(EL_LIBRARIES, null, null);
        }
        return impl;
    }

    public void remove(ProjectLibraryImplementation pli) throws IOException {
        LP lp;
        String prefix = "libs." + pli.name + ".";
        for (File f : new File[]{pli.mainPropertiesFile, pli.privatePropertiesFile}) {
            for (String k : ProjectLibraryProvider.loadProperties(f).keySet()) {
                if (!k.startsWith(prefix)) continue;
                ProjectLibraryProvider.replaceProperty(f, false, k, new String[0]);
            }
        }
        ProjectLibraryArea pla = this.loadArea(BaseUtilities.toURI((File)pli.mainPropertiesFile).toURL());
        if (pla != null && (lp = this.getLibraries(pla)).libraries.remove(pli.name) != null) {
            lp.pcs.firePropertyChange(EL_LIBRARIES, null, null);
        }
    }

    private static Definitions findDefinitions(AntProjectHelper helper) {
        File mainPropertiesFile;
        String text = ProjectLibraryProvider.getLibrariesLocationText(helper.createAuxiliaryConfiguration());
        if (text != null && (mainPropertiesFile = helper.resolveFile(text)).getName().endsWith(".properties")) {
            return new Definitions(mainPropertiesFile);
        }
        return null;
    }

    public static File getLibrariesLocation(AuxiliaryConfiguration aux, File projectFolder) {
        String text = ProjectLibraryProvider.getLibrariesLocationText(aux);
        if (text != null) {
            return PropertyUtils.resolveFile(projectFolder, text);
        }
        return null;
    }

    public static String getLibrariesLocationText(AuxiliaryConfiguration aux) {
        Iterator iterator;
        Element libraries = aux.getConfigurationFragment(EL_LIBRARIES, NAMESPACE, true);
        if (libraries != null && (iterator = XMLUtil.findSubElements((Element)libraries).iterator()).hasNext()) {
            Element definitions = (Element)iterator.next();
            assert (definitions.getLocalName().equals(EL_DEFINITIONS)) : definitions;
            String text = XMLUtil.findText((Node)definitions);
            assert (text != null) : aux;
            return text;
        }
        return null;
    }

    private static Map<String, String> loadProperties(File f) {
        if (!f.isFile()) {
            return Collections.emptyMap();
        }
        Properties p = new Properties();
        try {
            try (FileInputStream is = new FileInputStream(f);){
                p.load(is);
            }
            return NbCollections.checkedMapByFilter((Map)p, String.class, String.class, (boolean)true);
        }
        catch (IOException x) {
            LOG.log(Level.INFO, "Loading: " + f, x);
            return Collections.emptyMap();
        }
    }

    private static Map<String, ProjectLibraryImplementation> calculate(ProjectLibraryArea area) {
        HashMap<String, ProjectLibraryImplementation> libs = new HashMap<String, ProjectLibraryImplementation>();
        Definitions def = new Definitions(area.mainPropertiesFile);
        HashMap<String, HashMap<String, String>> data = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, String> entry : def.properties(false).entrySet()) {
            Matcher match = LIBS_LINE.matcher(entry.getKey());
            if (!match.matches()) continue;
            String name = match.group(1);
            HashMap<String, String> subdata = (HashMap<String, String>)data.get(name);
            if (subdata == null) {
                subdata = new HashMap<String, String>();
                data.put(name, subdata);
            }
            subdata.put(match.group(2), entry.getValue());
        }
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String name = entry.getKey();
            String type = "j2se";
            String description = null;
            String displayName = null;
            HashMap<String, List<URI>> contents = new HashMap<String, List<URI>>();
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry subentry : ((Map)((Object)entry.getValue())).entrySet()) {
                String k = (String)subentry.getKey();
                if (k.equals("type")) {
                    type = ProjectLibraryProvider.sanitizeSpaces((String)subentry.getValue());
                    continue;
                }
                if (k.equals("name")) continue;
                if (k.equals("description")) {
                    description = (String)subentry.getValue();
                    continue;
                }
                if (k.equals(SFX_DISPLAY_NAME)) {
                    displayName = (String)subentry.getValue();
                    continue;
                }
                if (k.startsWith(PROP_PREFIX)) {
                    properties.put(k.substring(PROP_PREFIX.length()), (String)subentry.getValue());
                    continue;
                }
                String[] path = ProjectLibraryProvider.sanitizeHttp((String)subentry.getKey(), PropertyUtils.tokenizePath((String)subentry.getValue()));
                ArrayList<URI> volume = new ArrayList<URI>(path.length);
                for (String component : path) {
                    component = ProjectLibraryProvider.sanitizeSpaces(component);
                    String jarFolder = null;
                    int index = component.indexOf("!" + File.separatorChar);
                    if (index != -1) {
                        jarFolder = component.substring(index + 2);
                        component = component.substring(0, index);
                    }
                    String f = component.replace('/', File.separatorChar).replace('\\', File.separatorChar).replace("${base}" + File.separatorChar, "");
                    File normalizedFile = FileUtil.normalizeFile((File)new File(component.replace('/', File.separatorChar).replace('\\', File.separatorChar).replace("${base}", area.mainPropertiesFile.getParent())));
                    try {
                        URI u = LibrariesSupport.convertFilePathToURI((String)f);
                        if (FileUtil.isArchiveFile((URL)BaseUtilities.toURI((File)normalizedFile).toURL())) {
                            u = ProjectLibraryProvider.appendJarFolder(u, jarFolder);
                        } else {
                            if (normalizedFile.exists() && !normalizedFile.isDirectory()) {
                                LOG.log(Level.INFO, "Ignoring wrong reference: {0} from library: {1}", new Object[]{component, name});
                                continue;
                            }
                            if (!u.getPath().endsWith("/")) {
                                u = new URI(u.toString() + "/");
                            }
                        }
                        volume.add(u);
                    }
                    catch (URISyntaxException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                    catch (MalformedURLException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }
                contents.put(k, volume);
            }
            libs.put(name, new ProjectLibraryImplementation(def.mainPropertiesFile, def.privatePropertiesFile, type, name, description, displayName, contents, properties));
        }
        return libs;
    }

    private boolean delta(Map<String, ProjectLibraryImplementation> libraries, Map<String, ProjectLibraryImplementation> newLibraries, Map<ProjectLibraryImplementation, List<String>> toFire) {
        if (!this.listening) {
            return false;
        }
        assert (toFire != null);
        HashSet<String> added = new HashSet<String>(newLibraries.keySet());
        added.removeAll(libraries.keySet());
        HashSet<String> removed = new HashSet<String>();
        for (Map.Entry<String, ProjectLibraryImplementation> entry : libraries.entrySet()) {
            List<String> props;
            String name = entry.getKey();
            ProjectLibraryImplementation old = entry.getValue();
            ProjectLibraryImplementation nue = newLibraries.get(name);
            if (nue == null) {
                removed.add(name);
                continue;
            }
            if (!old.type.equals(nue.type)) {
                added.add(name);
                removed.add(name);
                libraries.put(name, nue);
                continue;
            }
            assert (old.name.equals(nue.name));
            if (!BaseUtilities.compareObjects((Object)old.description, (Object)nue.description)) {
                old.description = nue.description;
                props = toFire.get(old);
                if (props == null) {
                    props = new ArrayList<String>();
                    toFire.put(old, props);
                }
                props.add("description");
            }
            if (old.contents.equals(nue.contents)) continue;
            old.contents = nue.contents;
            props = toFire.get(old);
            if (props == null) {
                props = new ArrayList<String>();
                toFire.put(old, props);
            }
            props.add("content");
        }
        for (String name : added) {
            libraries.put(name, newLibraries.get(name));
        }
        for (String name : removed) {
            libraries.remove(name);
        }
        return !added.isEmpty() || !removed.isEmpty();
    }

    private static String getJarFolder(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1 && index + 2 < u.length()) {
            return u.substring(index + 2);
        }
        return null;
    }

    private static URI appendJarFolder(URI u, String jarFolder) {
        try {
            if (u.isAbsolute()) {
                return new URI("jar:" + u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
            }
            return new URI(u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String[] sanitizeHttp(String type, String ... entries) {
        if (!"javadoc".equals(type)) {
            return entries;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < entries.length; ++i) {
            String schemeSpecificPart;
            if (i < entries.length - 1 && entries[i].matches("https?") && (schemeSpecificPart = entries[i + 1].replace('\\', '/')).startsWith("//")) {
                result.add(entries[i] + ':' + schemeSpecificPart);
                ++i;
                continue;
            }
            result.add(entries[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @NonNull
    private static String sanitizeSpaces(@NonNull String str) {
        return str.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceProperty(File propfile, boolean classPathLikeValue, String key, String ... value) throws IOException {
        EditableProperties ep = new EditableProperties(true);
        if (propfile.isFile()) {
            try (FileInputStream is = new FileInputStream(propfile);){
                ep.load(is);
            }
        }
        if (BaseUtilities.compareObjects((Object)value, (Object)ep.getProperty(key))) {
            return;
        }
        if (value.length > 0) {
            if (classPathLikeValue) {
                ep.setProperty(key, value);
            } else {
                assert (value.length == 1) : Arrays.asList(value);
                ep.setProperty(key, value[0]);
            }
        } else {
            ep.remove(key);
        }
        FileObject fo = FileUtil.createData((File)propfile);
        try (OutputStream os = fo.getOutputStream();){
            ep.store(os);
        }
    }

    public static PropertyProvider createPropertyProvider(AntProjectHelper helper) {
        class PP
        implements PropertyProvider,
        FileChangeListener,
        AntProjectListener {
            final ChangeSupport cs = new ChangeSupport((Object)this);
            final Set<File> listeningTo = new HashSet<File>();
            final /* synthetic */ AntProjectHelper val$helper;

            PP(AntProjectHelper antProjectHelper) {
                this.val$helper = antProjectHelper;
                this.val$helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)this.val$helper));
            }

            private void listenTo(File f, Set<File> noLongerListeningTo) {
                if (f != null) {
                    noLongerListeningTo.remove(f);
                    if (this.listeningTo.add(f)) {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                    }
                }
            }

            @Override
            public synchronized Map<String, String> getProperties() {
                HashMap<String, String> m = new HashMap<String, String>();
                HashSet<File> noLongerListeningTo = new HashSet<File>(this.listeningTo);
                Definitions def = ProjectLibraryProvider.findDefinitions(this.val$helper);
                if (def != null) {
                    m.putAll(def.properties(true));
                    this.listenTo(def.mainPropertiesFile, noLongerListeningTo);
                    this.listenTo(def.privatePropertiesFile, noLongerListeningTo);
                }
                for (File f : noLongerListeningTo) {
                    this.listeningTo.remove(f);
                    FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
                }
                return m;
            }

            @Override
            public void addChangeListener(ChangeListener l) {
                this.cs.addChangeListener(l);
            }

            @Override
            public void removeChangeListener(ChangeListener l) {
                this.cs.removeChangeListener(l);
            }

            public void fileFolderCreated(FileEvent fe) {
                this.fireChangeNowOrLater();
            }

            public void fileDataCreated(FileEvent fe) {
                this.fireChangeNowOrLater();
            }

            public void fileChanged(FileEvent fe) {
                this.fireChangeNowOrLater();
            }

            public void fileDeleted(FileEvent fe) {
                this.fireChangeNowOrLater();
            }

            public void fileRenamed(FileRenameEvent fe) {
                this.fireChangeNowOrLater();
            }

            public void fileAttributeChanged(FileAttributeEvent fe) {
                this.fireChangeNowOrLater();
            }

            void fireChangeNowOrLater() {
                if (!this.cs.hasListeners()) {
                    return;
                }
                Mutex.Action<Void> action = new Mutex.Action<Void>(){

                    public Void run() {
                        cs.fireChange();
                        return null;
                    }
                };
                if (ProjectManager.mutex().isWriteAccess() || FIRE_CHANGES_SYNCH) {
                    ProjectManager.mutex().readAccess((Mutex.Action)action);
                } else if (ProjectManager.mutex().isReadAccess()) {
                    action.run();
                } else {
                    RP.post(new Runnable((Mutex.Action)action){
                        final /* synthetic */ Mutex.Action val$action;
                        {
                            this.val$action = action;
                        }

                        @Override
                        public void run() {
                            ProjectManager.mutex().readAccess(this.val$action);
                        }
                    });
                }
            }

            @Override
            public void configurationXmlChanged(AntProjectEvent ev) {
                this.cs.fireChange();
            }

            @Override
            public void propertiesChanged(AntProjectEvent ev) {
            }
        }
        return new PP(helper);
    }

    public static boolean isReachableLibrary(Library library, AntProjectHelper helper) {
        URL location = library.getManager().getLocation();
        if (location == null) {
            return false;
        }
        ProjectLibraryArea area = INSTANCE.loadArea(location);
        if (area == null) {
            return false;
        }
        ProjectLibraryImplementation pli = INSTANCE.getLibraries(area).getLibrary(library.getName());
        if (pli == null) {
            return false;
        }
        Definitions def = ProjectLibraryProvider.findDefinitions(helper);
        if (def == null) {
            return false;
        }
        return def.mainPropertiesFile.equals(pli.mainPropertiesFile);
    }

    public static Element createLibrariesElement(Document doc, String location) {
        Element libraries = doc.createElementNS(NAMESPACE, EL_LIBRARIES);
        libraries.appendChild(libraries.getOwnerDocument().createElementNS(NAMESPACE, EL_DEFINITIONS)).appendChild(libraries.getOwnerDocument().createTextNode(location));
        return libraries;
    }

    public static LibraryManager getProjectLibraryManager(AntProjectHelper helper) {
        Definitions defs = ProjectLibraryProvider.findDefinitions(helper);
        if (defs != null) {
            try {
                return LibraryManager.forLocation((URL)BaseUtilities.toURI((File)defs.mainPropertiesFile).toURL());
            }
            catch (MalformedURLException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return null;
    }

    public static void setLibrariesLocation(AntProjectHelper helper, String librariesDefinition) {
        if (librariesDefinition == null) {
            helper.createAuxiliaryConfiguration().removeConfigurationFragment(EL_LIBRARIES, NAMESPACE, true);
            return;
        }
        Element libraries = helper.createAuxiliaryConfiguration().getConfigurationFragment(EL_LIBRARIES, NAMESPACE, true);
        if (libraries == null) {
            libraries = XMLUtil.createDocument((String)"dummy", null, null, null).createElementNS(NAMESPACE, EL_LIBRARIES);
        } else {
            List elements = XMLUtil.findSubElements((Element)libraries);
            if (elements.size() == 1) {
                libraries.removeChild((Node)elements.get(0));
            }
        }
        libraries.appendChild(libraries.getOwnerDocument().createElementNS(NAMESPACE, EL_DEFINITIONS)).appendChild(libraries.getOwnerDocument().createTextNode(librariesDefinition));
        helper.createAuxiliaryConfiguration().putConfigurationFragment(libraries, true);
    }

    public static List<String> getUnsharablePathsWithinProject(AntProjectHelper helper) {
        ArrayList<String> paths = new ArrayList<String>();
        Definitions defs = ProjectLibraryProvider.findDefinitions(helper);
        if (defs != null && defs.privatePropertiesFile != null) {
            paths.add(defs.privatePropertiesFile.getAbsolutePath());
        }
        return paths;
    }

    public static Library copyLibrary(final Library lib, URL location, final boolean generateLibraryUniqueName) throws IOException {
        String[] volumes;
        File libBaseFolder = BaseUtilities.toFile((URI)URI.create(location.toExternalForm())).getParentFile();
        FileObject sharedLibFolder = null;
        final HashMap content = new HashMap();
        for (String volume : volumes = LibrariesSupport.getLibraryTypeProvider((String)lib.getType()).getSupportedVolumeTypes()) {
            ArrayList<URI> volumeContent = new ArrayList<URI>();
            Iterator iterator = lib.getContent(volume).iterator();
            while (iterator.hasNext()) {
                String name;
                FileObject newFO;
                FileObject libEntryFO;
                URL origlibEntry;
                URL libEntry = origlibEntry = (URL)iterator.next();
                String jarFolder = null;
                if ("jar".equals(libEntry.getProtocol())) {
                    jarFolder = ProjectLibraryProvider.getJarFolder(URI.create(libEntry.toExternalForm()));
                    libEntry = FileUtil.getArchiveFile((URL)libEntry);
                }
                if ((libEntryFO = URLMapper.findFileObject((URL)libEntry)) == null) {
                    if (!"file".equals(libEntry.getProtocol()) && !"nbinst".equals(libEntry.getProtocol())) {
                        LOG.info("copyLibrary is ignoring entry " + libEntry);
                        continue;
                    }
                    LOG.log(Level.WARNING, "Library ''{0}'' contains entry ({1}) which does not exist. This entry is ignored and will not be copied to sharable libraries location.", new Object[]{lib.getDisplayName(), libEntry});
                    continue;
                }
                if (CollocationQuery.areCollocated((URI)BaseUtilities.toURI((File)libBaseFolder), (URI)libEntryFO.toURI())) {
                    newFO = libEntryFO;
                    name = PropertyUtils.relativizeFile(libBaseFolder, FileUtil.toFile((FileObject)newFO));
                } else {
                    if (sharedLibFolder == null) {
                        sharedLibFolder = ProjectLibraryProvider.getSharedLibFolder(libBaseFolder, lib);
                    }
                    if (libEntryFO.isFolder()) {
                        newFO = ProjectLibraryProvider.copyFolderRecursively(libEntryFO, sharedLibFolder);
                        name = sharedLibFolder.getNameExt() + File.separatorChar + newFO.getName() + File.separatorChar;
                    } else {
                        String libEntryName = ProjectLibraryProvider.getUniqueName(sharedLibFolder, libEntryFO.getName(), libEntryFO.getExt());
                        newFO = FileUtil.copyFile((FileObject)libEntryFO, (FileObject)sharedLibFolder, (String)libEntryName);
                        name = sharedLibFolder.getNameExt() + File.separatorChar + newFO.getNameExt();
                    }
                }
                URI u = LibrariesSupport.convertFilePathToURI((String)name);
                if (FileUtil.isArchiveFile((FileObject)newFO)) {
                    u = ProjectLibraryProvider.appendJarFolder(u, jarFolder);
                }
                volumeContent.add(u);
            }
            content.put(volume, volumeContent);
        }
        final LibraryManager man = LibraryManager.forLocation((URL)location);
        try {
            return (Library)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Library>(){

                public Library run() throws IOException {
                    String displayName;
                    String name = lib.getName();
                    if (generateLibraryUniqueName) {
                        int index = 2;
                        while (man.getLibrary(name) != null) {
                            name = lib.getName() + "-" + index;
                            ++index;
                        }
                    }
                    if (name.equals(displayName = lib.getDisplayName())) {
                        displayName = null;
                    }
                    return man.createURILibrary(lib.getType(), name, displayName, lib.getDescription(), content, lib.getProperties());
                }
            });
        }
        catch (MutexException ex) {
            throw (IOException)ex.getException();
        }
    }

    private static FileObject getSharedLibFolder(final File libBaseFolder, final Library lib) throws IOException {
        FileObject sharedLibFolder;
        try {
            sharedLibFolder = (FileObject)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<FileObject>(){

                public FileObject run() throws IOException {
                    FileObject lf = FileUtil.toFileObject((File)libBaseFolder);
                    if (lf == null) {
                        lf = FileUtil.createFolder((File)libBaseFolder);
                    }
                    return lf.createFolder(ProjectLibraryProvider.getUniqueName(lf, lib.getName(), null));
                }
            });
        }
        catch (MutexException ex) {
            throw (IOException)ex.getException();
        }
        return sharedLibFolder;
    }

    private static String getUniqueName(FileObject baseFolder, String nameFileName, String extension) {
        assert (baseFolder != null);
        int suffix = 2;
        String name = nameFileName;
        while (baseFolder.getFileObject(name + (extension != null ? "." + extension : "")) != null) {
            name = nameFileName + "-" + suffix;
            ++suffix;
        }
        return name;
    }

    private static FileObject copyFolderRecursively(final FileObject sourceFolder, final FileObject destination) throws IOException {
        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

            public void run() throws IOException {
                assert (sourceFolder.isFolder()) : sourceFolder;
                assert (destination.isFolder()) : destination;
                FileObject destinationSubFolder = destination.getFileObject(sourceFolder.getName());
                if (destinationSubFolder == null) {
                    destinationSubFolder = destination.createFolder(sourceFolder.getName());
                }
                for (FileObject fo : sourceFolder.getChildren()) {
                    if (fo.isFolder()) {
                        ProjectLibraryProvider.copyFolderRecursively(fo, destinationSubFolder);
                        continue;
                    }
                    FileObject foExists = destinationSubFolder.getFileObject(fo.getName(), fo.getExt());
                    if (foExists != null) {
                        foExists.delete();
                    }
                    FileUtil.copyFile((FileObject)fo, (FileObject)destinationSubFolder, (String)fo.getName(), (String)fo.getExt());
                }
            }
        });
        return destination.getFileObject(sourceFolder.getName());
    }

    static {
        LIBS_LINE = Pattern.compile("libs\\.([^${}]+)\\.([^${}.]+)");
        RP = new RequestProcessor("ProjectLibraryProvider.RP");
        FIRE_CHANGES_SYNCH = false;
    }

    public static final class SharabilityQueryImpl
    implements SharabilityQueryImplementation2 {
        public SharabilityQuery.Sharability getSharability(URI uri) {
            if (uri.toString().endsWith("-private.properties")) {
                return SharabilityQuery.Sharability.NOT_SHARABLE;
            }
            return SharabilityQuery.Sharability.UNKNOWN;
        }
    }

    static final class ProjectLibraryArea
    implements LibraryStorageArea {
        final File mainPropertiesFile;

        ProjectLibraryArea(File mainPropertiesFile) {
            assert (mainPropertiesFile.getName().endsWith(".properties")) : mainPropertiesFile;
            this.mainPropertiesFile = mainPropertiesFile;
        }

        public String getDisplayName() {
            return this.mainPropertiesFile.getAbsolutePath();
        }

        public URL getLocation() {
            try {
                return BaseUtilities.toURI((File)this.mainPropertiesFile).toURL();
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof ProjectLibraryArea && ((ProjectLibraryArea)obj).mainPropertiesFile.equals(this.mainPropertiesFile);
        }

        public int hashCode() {
            return this.mainPropertiesFile.hashCode();
        }

        public String toString() {
            return "ProjectLibraryArea[" + this.mainPropertiesFile + "]";
        }
    }

    static final class ProjectLibraryImplementation
    implements LibraryImplementation2,
    LibraryImplementation3 {
        final File mainPropertiesFile;
        final File privatePropertiesFile;
        final String type;
        String name;
        String description;
        String displayName;
        Map<String, List<URI>> contents;
        private Map<String, String> properties;
        final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        static Field libraryImplField;

        private String getGlobalLibBundle(Library lib) {
            if (libraryImplField != null) {
                try {
                    LibraryImplementation impl = (LibraryImplementation)libraryImplField.get(lib);
                    String toRet = impl.getLocalizingBundle();
                    return toRet;
                }
                catch (Exception exc) {
                    LOG.log(Level.FINE, "Cannot access field by reflection", exc);
                }
            }
            return null;
        }

        ProjectLibraryImplementation(File mainPropertiesFile, File privatePropertiesFile, String type, String name, @NullAllowed String description, @NullAllowed String displayName, @NonNull Map<String, List<URI>> contents, @NonNull Map<String, String> properties) {
            this.mainPropertiesFile = mainPropertiesFile;
            this.privatePropertiesFile = privatePropertiesFile;
            this.type = type;
            this.name = name;
            this.description = description;
            this.displayName = displayName;
            this.contents = contents;
            this.properties = properties;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLocalizingBundle() {
            Library lib = LibraryManager.getDefault().getLibrary(this.name);
            if (lib != null) {
                return this.getGlobalLibBundle(lib);
            }
            return null;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<URL> getContent(String volumeType) throws IllegalArgumentException {
            List<URI> uris = this.getURIContent(volumeType);
            ArrayList<URL> resolvedUrls = new ArrayList<URL>(uris.size());
            for (URI u : uris) {
                try {
                    resolvedUrls.add(LibrariesSupport.resolveLibraryEntryURI((URL)BaseUtilities.toURI((File)this.mainPropertiesFile).toURL(), (URI)u).toURL());
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.INFO, "#184304: " + u, ex);
                }
            }
            return resolvedUrls;
        }

        public List<URI> getURIContent(String volumeType) throws IllegalArgumentException {
            List<URI> content = this.contents.get(volumeType);
            if (content == null) {
                content = Collections.emptyList();
            }
            return content;
        }

        public void setName(String name) {
            this.name = name;
            this.pcs.firePropertyChange("name", null, null);
            throw new UnsupportedOperationException();
        }

        public void setDescription(String text) {
        }

        public void setContent(String volumeType, List<URL> path) throws IllegalArgumentException {
            ArrayList<URI> uris = new ArrayList<URI>(path.size());
            for (URL u : path) {
                uris.add(URI.create(u.toExternalForm()));
            }
            this.setURIContent(volumeType, uris);
        }

        public void setURIContent(String volumeType, List<URI> path) throws IllegalArgumentException {
            if (path.equals(this.contents.get(volumeType))) {
                return;
            }
            this.contents.put(volumeType, new ArrayList<URI>(path));
            ArrayList<String> value = new ArrayList<String>();
            for (URI entry : path) {
                String jarFolder = null;
                if (entry.toString().contains("!/")) {
                    jarFolder = ProjectLibraryProvider.getJarFolder(entry);
                    entry = LibrariesSupport.getArchiveFile((URI)entry);
                } else if (entry.isAbsolute() && !"file".equals(entry.getScheme())) {
                    this.verifyAbsoluteURI(entry);
                    StringBuilder sb = new StringBuilder(entry.toString());
                    if (value.size() + 1 != path.size()) {
                        sb.append(File.pathSeparatorChar);
                    }
                    value.add(sb.toString());
                    LOG.log(Level.FINE, "Setting uri={0} as content for library volume type: {1}", new Object[]{entry, volumeType});
                    continue;
                }
                String entryPath = LibrariesSupport.convertURIToFilePath((URI)entry).replace('\\', '/');
                StringBuilder s = new StringBuilder();
                if (entryPath.startsWith("${")) {
                    s.append(entryPath.replace('\\', '/'));
                } else if (entry.isAbsolute()) {
                    this.verifyAbsoluteURI(entry);
                    s.append(entryPath);
                } else {
                    s.append("${base}/").append(entryPath);
                }
                if (jarFolder != null) {
                    s.append("!/");
                    s.append(jarFolder);
                }
                if (value.size() + 1 != path.size()) {
                    s.append(File.pathSeparatorChar);
                }
                value.add(s.toString());
            }
            String key = "libs." + this.name + "." + volumeType;
            try {
                ProjectLibraryProvider.replaceProperty(this.mainPropertiesFile, true, key, value.toArray(new String[value.size()]));
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x);
            }
            this.pcs.firePropertyChange("content", null, null);
        }

        private void verifyAbsoluteURI(URI entry) throws IllegalArgumentException {
            try {
                entry.toURL();
            }
            catch (MalformedURLException x) {
                throw new IllegalArgumentException("#184304: " + entry + ": " + x, x);
            }
        }

        public void setLocalizingBundle(String resourceName) {
            throw new UnsupportedOperationException();
        }

        public void setDisplayName(@NullAllowed String displayName) {
            if (BaseUtilities.compareObjects((Object)this.displayName, (Object)displayName)) {
                return;
            }
            String oldDisplayName = this.displayName;
            this.displayName = displayName;
            try {
                String[] stringArray;
                String key = String.format("libs.%s.%s", this.name, ProjectLibraryProvider.SFX_DISPLAY_NAME);
                if (displayName == null) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = displayName;
                }
                ProjectLibraryProvider.replaceProperty(this.mainPropertiesFile, false, key, stringArray);
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x);
            }
            this.pcs.firePropertyChange(ProjectLibraryProvider.SFX_DISPLAY_NAME, oldDisplayName, displayName);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public String toString() {
            return "ProjectLibraryImplementation[name=" + this.name + ",file=" + this.mainPropertiesFile + ",contents=" + this.contents + "]";
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public void setProperties(Map<String, String> properties) {
            if (BaseUtilities.compareObjects(this.properties, properties)) {
                return;
            }
            Map<String, String> oldProperties = this.properties;
            this.properties = new HashMap<String, String>(properties);
            try {
                for (Map.Entry<String, String> e : this.properties.entrySet()) {
                    String key = String.format("libs.%s.%s%s", this.name, ProjectLibraryProvider.PROP_PREFIX, e.getKey());
                    ProjectLibraryProvider.replaceProperty(this.mainPropertiesFile, false, key, new String[]{e.getValue()});
                }
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x);
            }
            this.pcs.firePropertyChange("properties", oldProperties, this.properties);
        }

        static {
            try {
                libraryImplField = Library.class.getDeclaredField("impl");
                libraryImplField.setAccessible(true);
            }
            catch (Exception exc) {
                LOG.log(Level.FINE, "Cannot find field by reflection", exc);
            }
        }
    }

    private static final class Definitions {
        final File mainPropertiesFile;
        final File privatePropertiesFile;
        private Map<String, String> properties;

        Definitions(File mainPropertiesFile) {
            this.mainPropertiesFile = mainPropertiesFile;
            String suffix = ".properties";
            String name = mainPropertiesFile.getName();
            this.privatePropertiesFile = name.endsWith(suffix) ? new File(mainPropertiesFile.getParentFile(), name.substring(0, name.length() - suffix.length()) + "-private" + suffix) : null;
        }

        synchronized Map<String, String> properties(boolean resolveBase) {
            if (this.properties == null) {
                String value;
                this.properties = new HashMap<String, String>();
                String basedir = this.mainPropertiesFile.getParent();
                for (Map.Entry entry : ProjectLibraryProvider.loadProperties(this.mainPropertiesFile).entrySet()) {
                    value = (String)entry.getValue();
                    if (resolveBase) {
                        value = value.replace("${base}", basedir);
                    }
                    this.properties.put((String)entry.getKey(), value.replace('/', File.separatorChar));
                }
                if (this.privatePropertiesFile != null) {
                    for (Map.Entry entry : ProjectLibraryProvider.loadProperties(this.privatePropertiesFile).entrySet()) {
                        value = (String)entry.getValue();
                        if (resolveBase) {
                            value = value.replace("${base}", basedir);
                        }
                        this.properties.put((String)entry.getKey(), value.replace('/', File.separatorChar));
                    }
                }
            }
            return this.properties;
        }
    }

    private final class LP
    implements LibraryProvider<ProjectLibraryImplementation>,
    FileChangeListener {
        private final ProjectLibraryArea area;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Map<String, ProjectLibraryImplementation> libraries;

        LP(ProjectLibraryArea area) {
            this.area = area;
            this.libraries = ProjectLibraryProvider.calculate(area);
            Definitions defs = new Definitions(area.mainPropertiesFile);
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)defs.mainPropertiesFile);
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)defs.privatePropertiesFile);
        }

        public synchronized ProjectLibraryImplementation[] getLibraries() {
            return this.libraries.values().toArray(new ProjectLibraryImplementation[this.libraries.size()]);
        }

        ProjectLibraryImplementation getLibrary(String name) {
            return this.libraries.get(name);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.recalculate();
        }

        public void fileDataCreated(FileEvent fe) {
            this.recalculate();
        }

        public void fileChanged(FileEvent fe) {
            this.recalculate();
        }

        public void fileDeleted(FileEvent fe) {
            this.recalculate();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.recalculate();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.recalculate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recalculate() {
            boolean fire;
            HashMap toFire = new HashMap();
            LP lP = this;
            synchronized (lP) {
                fire = ProjectLibraryProvider.this.delta(this.libraries, ProjectLibraryProvider.calculate(this.area), toFire);
            }
            if (toFire.size() > 0) {
                for (ProjectLibraryImplementation impl : toFire.keySet()) {
                    for (String prop : (List)toFire.get(impl)) {
                        impl.pcs.firePropertyChange(prop, null, null);
                    }
                }
            }
            if (fire) {
                this.pcs.firePropertyChange(ProjectLibraryProvider.EL_LIBRARIES, null, null);
            }
        }
    }
}

