/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.adm.ApplicationDependencyManagementAsync;
import com.oracle.bmc.adm.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.adm.internal.http.ChangeKnowledgeBaseCompartmentConverter;
import com.oracle.bmc.adm.internal.http.ChangeVulnerabilityAuditCompartmentConverter;
import com.oracle.bmc.adm.internal.http.CreateKnowledgeBaseConverter;
import com.oracle.bmc.adm.internal.http.CreateVulnerabilityAuditConverter;
import com.oracle.bmc.adm.internal.http.DeleteKnowledgeBaseConverter;
import com.oracle.bmc.adm.internal.http.DeleteVulnerabilityAuditConverter;
import com.oracle.bmc.adm.internal.http.GetKnowledgeBaseConverter;
import com.oracle.bmc.adm.internal.http.GetVulnerabilityAuditConverter;
import com.oracle.bmc.adm.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.adm.internal.http.ListApplicationDependencyVulnerabilitiesConverter;
import com.oracle.bmc.adm.internal.http.ListKnowledgeBasesConverter;
import com.oracle.bmc.adm.internal.http.ListVulnerabilityAuditsConverter;
import com.oracle.bmc.adm.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.adm.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.adm.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.adm.internal.http.UpdateKnowledgeBaseConverter;
import com.oracle.bmc.adm.internal.http.UpdateVulnerabilityAuditConverter;
import com.oracle.bmc.adm.requests.CancelWorkRequestRequest;
import com.oracle.bmc.adm.requests.ChangeKnowledgeBaseCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeVulnerabilityAuditCompartmentRequest;
import com.oracle.bmc.adm.requests.CreateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.CreateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.DeleteKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.DeleteVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.GetVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetWorkRequestRequest;
import com.oracle.bmc.adm.requests.ListApplicationDependencyVulnerabilitiesRequest;
import com.oracle.bmc.adm.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.adm.requests.ListVulnerabilityAuditsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestsRequest;
import com.oracle.bmc.adm.requests.UpdateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.UpdateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.responses.CancelWorkRequestResponse;
import com.oracle.bmc.adm.responses.ChangeKnowledgeBaseCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeVulnerabilityAuditCompartmentResponse;
import com.oracle.bmc.adm.responses.CreateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.CreateVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.DeleteKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.DeleteVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.GetVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetWorkRequestResponse;
import com.oracle.bmc.adm.responses.ListApplicationDependencyVulnerabilitiesResponse;
import com.oracle.bmc.adm.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.adm.responses.ListVulnerabilityAuditsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestsResponse;
import com.oracle.bmc.adm.responses.UpdateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.UpdateVulnerabilityAuditResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDependencyManagementAsyncClient
implements ApplicationDependencyManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDependencyManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLICATIONDEPENDENCYMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://adm.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public ApplicationDependencyManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApplicationDependencyManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApplicationDependencyManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApplicationDependencyManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApplicationDependencyManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApplicationDependencyManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApplicationDependencyManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ApplicationDependencyManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration, isNonBufferingApacheClient);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"CancelWorkRequest", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeKnowledgeBaseCompartmentResponse> changeKnowledgeBaseCompartment(ChangeKnowledgeBaseCompartmentRequest request, AsyncHandler<ChangeKnowledgeBaseCompartmentRequest, ChangeKnowledgeBaseCompartmentResponse> handler) {
        LOG.trace("Called async changeKnowledgeBaseCompartment");
        ChangeKnowledgeBaseCompartmentRequest interceptedRequest = ChangeKnowledgeBaseCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeKnowledgeBaseCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeKnowledgeBaseCompartmentResponse> transformer = ChangeKnowledgeBaseCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ChangeKnowledgeBaseCompartment", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ChangeKnowledgeBaseCompartmentRequest, ChangeKnowledgeBaseCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeKnowledgeBaseCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeKnowledgeBaseCompartmentRequest, ChangeKnowledgeBaseCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeVulnerabilityAuditCompartmentResponse> changeVulnerabilityAuditCompartment(ChangeVulnerabilityAuditCompartmentRequest request, AsyncHandler<ChangeVulnerabilityAuditCompartmentRequest, ChangeVulnerabilityAuditCompartmentResponse> handler) {
        LOG.trace("Called async changeVulnerabilityAuditCompartment");
        ChangeVulnerabilityAuditCompartmentRequest interceptedRequest = ChangeVulnerabilityAuditCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVulnerabilityAuditCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVulnerabilityAuditCompartmentResponse> transformer = ChangeVulnerabilityAuditCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ChangeVulnerabilityAuditCompartment", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ChangeVulnerabilityAuditCompartmentRequest, ChangeVulnerabilityAuditCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeVulnerabilityAuditCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeVulnerabilityAuditCompartmentRequest, ChangeVulnerabilityAuditCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateKnowledgeBaseResponse> createKnowledgeBase(CreateKnowledgeBaseRequest request, AsyncHandler<CreateKnowledgeBaseRequest, CreateKnowledgeBaseResponse> handler) {
        LOG.trace("Called async createKnowledgeBase");
        CreateKnowledgeBaseRequest interceptedRequest = CreateKnowledgeBaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateKnowledgeBaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateKnowledgeBaseResponse> transformer = CreateKnowledgeBaseConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"CreateKnowledgeBase", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<CreateKnowledgeBaseRequest, CreateKnowledgeBaseResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateKnowledgeBaseDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateKnowledgeBaseRequest, CreateKnowledgeBaseResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateVulnerabilityAuditResponse> createVulnerabilityAudit(CreateVulnerabilityAuditRequest request, AsyncHandler<CreateVulnerabilityAuditRequest, CreateVulnerabilityAuditResponse> handler) {
        LOG.trace("Called async createVulnerabilityAudit");
        CreateVulnerabilityAuditRequest interceptedRequest = CreateVulnerabilityAuditConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVulnerabilityAuditConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVulnerabilityAuditResponse> transformer = CreateVulnerabilityAuditConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"CreateVulnerabilityAudit", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<CreateVulnerabilityAuditRequest, CreateVulnerabilityAuditResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateVulnerabilityAuditDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateVulnerabilityAuditRequest, CreateVulnerabilityAuditResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(DeleteKnowledgeBaseRequest request, AsyncHandler<DeleteKnowledgeBaseRequest, DeleteKnowledgeBaseResponse> handler) {
        LOG.trace("Called async deleteKnowledgeBase");
        DeleteKnowledgeBaseRequest interceptedRequest = DeleteKnowledgeBaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteKnowledgeBaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteKnowledgeBaseResponse> transformer = DeleteKnowledgeBaseConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"DeleteKnowledgeBase", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<DeleteKnowledgeBaseRequest, DeleteKnowledgeBaseResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteKnowledgeBaseRequest, DeleteKnowledgeBaseResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteVulnerabilityAuditResponse> deleteVulnerabilityAudit(DeleteVulnerabilityAuditRequest request, AsyncHandler<DeleteVulnerabilityAuditRequest, DeleteVulnerabilityAuditResponse> handler) {
        LOG.trace("Called async deleteVulnerabilityAudit");
        DeleteVulnerabilityAuditRequest interceptedRequest = DeleteVulnerabilityAuditConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVulnerabilityAuditConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVulnerabilityAuditResponse> transformer = DeleteVulnerabilityAuditConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"DeleteVulnerabilityAudit", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<DeleteVulnerabilityAuditRequest, DeleteVulnerabilityAuditResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteVulnerabilityAuditRequest, DeleteVulnerabilityAuditResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetKnowledgeBaseResponse> getKnowledgeBase(GetKnowledgeBaseRequest request, AsyncHandler<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> handler) {
        LOG.trace("Called async getKnowledgeBase");
        GetKnowledgeBaseRequest interceptedRequest = GetKnowledgeBaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetKnowledgeBaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetKnowledgeBaseResponse> transformer = GetKnowledgeBaseConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"GetKnowledgeBase", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetVulnerabilityAuditResponse> getVulnerabilityAudit(GetVulnerabilityAuditRequest request, AsyncHandler<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse> handler) {
        LOG.trace("Called async getVulnerabilityAudit");
        GetVulnerabilityAuditRequest interceptedRequest = GetVulnerabilityAuditConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVulnerabilityAuditConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVulnerabilityAuditResponse> transformer = GetVulnerabilityAuditConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"GetVulnerabilityAudit", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"GetWorkRequest", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListApplicationDependencyVulnerabilitiesResponse> listApplicationDependencyVulnerabilities(ListApplicationDependencyVulnerabilitiesRequest request, AsyncHandler<ListApplicationDependencyVulnerabilitiesRequest, ListApplicationDependencyVulnerabilitiesResponse> handler) {
        LOG.trace("Called async listApplicationDependencyVulnerabilities");
        ListApplicationDependencyVulnerabilitiesRequest interceptedRequest = ListApplicationDependencyVulnerabilitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplicationDependencyVulnerabilitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApplicationDependencyVulnerabilitiesResponse> transformer = ListApplicationDependencyVulnerabilitiesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ListApplicationDependencyVulnerabilities", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ListApplicationDependencyVulnerabilitiesRequest, ListApplicationDependencyVulnerabilitiesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListApplicationDependencyVulnerabilitiesRequest, ListApplicationDependencyVulnerabilitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListKnowledgeBasesResponse> listKnowledgeBases(ListKnowledgeBasesRequest request, AsyncHandler<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse> handler) {
        LOG.trace("Called async listKnowledgeBases");
        ListKnowledgeBasesRequest interceptedRequest = ListKnowledgeBasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListKnowledgeBasesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListKnowledgeBasesResponse> transformer = ListKnowledgeBasesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ListKnowledgeBases", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListVulnerabilityAuditsResponse> listVulnerabilityAudits(ListVulnerabilityAuditsRequest request, AsyncHandler<ListVulnerabilityAuditsRequest, ListVulnerabilityAuditsResponse> handler) {
        LOG.trace("Called async listVulnerabilityAudits");
        ListVulnerabilityAuditsRequest interceptedRequest = ListVulnerabilityAuditsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVulnerabilityAuditsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVulnerabilityAuditsResponse> transformer = ListVulnerabilityAuditsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ListVulnerabilityAudits", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ListVulnerabilityAuditsRequest, ListVulnerabilityAuditsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListVulnerabilityAuditsRequest, ListVulnerabilityAuditsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ListWorkRequestErrors", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ListWorkRequestLogs", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"ListWorkRequests", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateKnowledgeBaseResponse> updateKnowledgeBase(UpdateKnowledgeBaseRequest request, AsyncHandler<UpdateKnowledgeBaseRequest, UpdateKnowledgeBaseResponse> handler) {
        LOG.trace("Called async updateKnowledgeBase");
        UpdateKnowledgeBaseRequest interceptedRequest = UpdateKnowledgeBaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateKnowledgeBaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateKnowledgeBaseResponse> transformer = UpdateKnowledgeBaseConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"UpdateKnowledgeBase", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<UpdateKnowledgeBaseRequest, UpdateKnowledgeBaseResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateKnowledgeBaseDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateKnowledgeBaseRequest, UpdateKnowledgeBaseResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateVulnerabilityAuditResponse> updateVulnerabilityAudit(UpdateVulnerabilityAuditRequest request, AsyncHandler<UpdateVulnerabilityAuditRequest, UpdateVulnerabilityAuditResponse> handler) {
        LOG.trace("Called async updateVulnerabilityAudit");
        UpdateVulnerabilityAuditRequest interceptedRequest = UpdateVulnerabilityAuditConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVulnerabilityAuditConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVulnerabilityAuditResponse> transformer = UpdateVulnerabilityAuditConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"ApplicationDependencyManagement", (String)"UpdateVulnerabilityAudit", (String)ib.getRequestUri().toString(), (String)"");
        AsyncHandler<UpdateVulnerabilityAuditRequest, UpdateVulnerabilityAuditResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateVulnerabilityAuditDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateVulnerabilityAuditRequest, UpdateVulnerabilityAuditResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplicationDependencyManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApplicationDependencyManagementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApplicationDependencyManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

