/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Node {
    private final JSONObject properties;
    private List<Node> children;
    private List<Node> shadowRoots;
    private List<Attribute> attributes;
    private Node contentDocument;
    private Node parent;

    Node(JSONObject node) {
        JSONObject document;
        JSONArray array;
        Object shadowRootsValue;
        this.properties = node;
        Object childrenValue = node.get((Object)"children");
        if (childrenValue != null) {
            this.initChildren();
            JSONArray childrenArray = (JSONArray)childrenValue;
            ArrayList<Node> newChildren = new ArrayList<Node>(childrenArray.size());
            for (Object child : childrenArray) {
                newChildren.add(new Node((JSONObject)child));
            }
            this.addChildren(newChildren);
        }
        if ((shadowRootsValue = node.get((Object)"shadowRoots")) instanceof JSONArray) {
            JSONArray shadowRootArray = (JSONArray)shadowRootsValue;
            for (Object shadowRoot : shadowRootArray) {
                this.addShadowRoot(new Node((JSONObject)shadowRoot));
            }
        }
        if ((array = (JSONArray)this.getProperties().get((Object)"attributes")) != null) {
            for (int i = 0; i < array.size() / 2; ++i) {
                String name = (String)array.get(2 * i);
                String value = (String)array.get(2 * i + 1);
                this.setAttribute(name, value);
            }
        }
        if ((document = (JSONObject)this.getProperties().get((Object)"contentDocument")) != null) {
            this.contentDocument = new Node(document);
            this.contentDocument.parent = this;
            this.initChildren();
        }
        node.remove((Object)"children");
        node.remove((Object)"attributes");
        node.remove((Object)"contentDocument");
    }

    private JSONObject getProperties() {
        return this.properties;
    }

    public int getNodeId() {
        Number nodeId = (Number)this.getProperties().get((Object)"nodeId");
        if (nodeId == null) {
            nodeId = (Number)this.getProperties().get((Object)"id");
        }
        return nodeId.intValue();
    }

    public int getNodeType() {
        return ((Number)this.getProperties().get((Object)"nodeType")).intValue();
    }

    public String getNodeName() {
        return (String)this.getProperties().get((Object)"nodeName");
    }

    public String getLocalName() {
        return (String)this.getProperties().get((Object)"localName");
    }

    public synchronized String getNodeValue() {
        return (String)this.getProperties().get((Object)"nodeValue");
    }

    synchronized void setNodeValue(String value) {
        this.getProperties().put((Object)"nodeValue", (Object)value);
    }

    final synchronized void initChildren() {
        this.children = new CopyOnWriteArrayList<Node>();
        this.getProperties().remove((Object)"childNodeCount");
    }

    public synchronized List<Node> getChildren() {
        return this.children;
    }

    public synchronized int getChildrenCount() {
        int count = -1;
        if (this.children == null) {
            Object nodeCount = this.getProperties().get((Object)"childNodeCount");
            if (nodeCount instanceof Number) {
                count = ((Number)nodeCount).intValue();
            }
        } else {
            count = this.children.size();
        }
        return count;
    }

    final synchronized void addChildren(List<Node> newChildren) {
        if (this.children == null) {
            this.initChildren();
        }
        this.children.addAll(newChildren);
        for (Node child : newChildren) {
            child.parent = this;
        }
    }

    final synchronized void removeChild(Node child) {
        this.children.remove(child);
        child.parent = null;
    }

    final synchronized void insertChild(Node child, Node previousChild) {
        if (this.children == null) {
            this.initChildren();
        }
        int index = previousChild == null ? 0 : this.children.indexOf(previousChild) + 1;
        this.children.add(index, child);
        child.parent = this;
    }

    public final synchronized List<Node> getShadowRoots() {
        return this.shadowRoots == null ? Collections.emptyList() : this.shadowRoots;
    }

    final synchronized void addShadowRoot(Node shadowRoot) {
        if (this.shadowRoots == null) {
            this.shadowRoots = new LinkedList<Node>();
        }
        shadowRoot.parent = this;
        this.shadowRoots.add(shadowRoot);
    }

    final synchronized void removeShadowRoot(Node shadowRoot) {
        this.shadowRoots.remove(shadowRoot);
    }

    final synchronized void setAttribute(String name, String value) {
        Attribute attribute = this.getAttribute(name);
        if (attribute == null) {
            attribute = new Attribute(name, value);
            if (this.attributes == null) {
                this.attributes = new ArrayList<Attribute>();
            }
            this.attributes.add(attribute);
        } else {
            attribute.setValue(value);
        }
    }

    final synchronized void removeAttribute(String name) {
        Attribute attribute = this.getAttribute(name);
        if (attribute != null) {
            this.attributes.remove(attribute);
        }
    }

    public synchronized Attribute getAttribute(String name) {
        Attribute result = null;
        for (Attribute attr : this.getAttributes()) {
            if (!name.equals(attr.getName())) continue;
            result = attr;
            break;
        }
        return result;
    }

    public synchronized List<Attribute> getAttributes() {
        return this.attributes == null ? Collections.emptyList() : this.attributes;
    }

    public String getDocumentURL() {
        return (String)this.getProperties().get((Object)"documentURL");
    }

    public String getPublicId() {
        return (String)this.getProperties().get((Object)"publicId");
    }

    public String getSystemId() {
        return (String)this.getProperties().get((Object)"systemId");
    }

    public String getInternalSubset() {
        return (String)this.getProperties().get((Object)"internalSubset");
    }

    public String getXmlVersion() {
        return (String)this.getProperties().get((Object)"xmlVersion");
    }

    public String getName() {
        return (String)this.getProperties().get((Object)"name");
    }

    public String getValue() {
        return (String)this.getProperties().get((Object)"value");
    }

    public boolean isInjectedByNetBeans() {
        return this.getAttribute(":netbeans_generated") != null;
    }

    public Node getContentDocument() {
        return this.contentDocument;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Node) {
            int nodeId = ((Node)obj).getNodeId();
            equal = nodeId == this.getNodeId();
        }
        return equal;
    }

    public int hashCode() {
        return this.getNodeId();
    }

    public static class Attribute {
        private final String name;
        private String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        void setValue(String value) {
            this.value = value;
        }
    }
}

