/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;

public abstract class HCLArithmeticOperation
extends HCLExpression {
    public final Operator op;

    public HCLArithmeticOperation(Operator op) {
        this.op = op;
    }

    public static final class Unary
    extends HCLArithmeticOperation {
        public final HCLExpression operand;

        public Unary(Operator op, HCLExpression operand) {
            super(op);
            this.operand = operand;
        }

        @Override
        public String asString() {
            return this.op.toString() + this.operand.toString();
        }

        @Override
        public List<? extends HCLExpression> getChildren() {
            return Collections.singletonList(this.operand);
        }
    }

    public static final class Binary
    extends HCLArithmeticOperation {
        public final HCLExpression left;
        public final HCLExpression right;

        public Binary(Operator op, HCLExpression left, HCLExpression right) {
            super(op);
            this.left = left;
            this.right = right;
        }

        @Override
        public String asString() {
            return this.left.toString() + this.op.toString() + this.right.toString();
        }

        @Override
        public List<? extends HCLExpression> getChildren() {
            return Arrays.asList(this.left, this.right);
        }
    }

    public static enum Operator {
        NOT("!"),
        MINUS("-"),
        MUL("*"),
        DIV("/"),
        MOD("%"),
        ADD("+"),
        SUB("-"),
        OR("||"),
        AND("&&"),
        LTE("<="),
        GTE(">="),
        LT("<"),
        GT(">"),
        EQUALS("=="),
        NOT_EQUALS("!=");

        final String op;

        private Operator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

