/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.OutlineNode;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.input.KeyRobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.actions.SystemAction;

public class Action {
    public static final int MENU_MODE = 0;
    public static final int POPUP_MODE = 1;
    public static final int API_MODE = 2;
    public static final int SHORTCUT_MODE = 3;
    protected static final long SELECTION_WAIT_TIME = 300L;
    protected static final long AFTER_ACTION_WAIT_TIME = 0L;
    protected static final long WAIT_AFTER_SHORTCUT_TIMEOUT = 0L;
    private static final int[][] sequence = new int[][]{{0, 1, 3, 2}, {1, 0, 3, 2}, {2, 1, 0, 3}, {3, 1, 0, 2}};
    protected String menuPath;
    protected String popupPath;
    protected Class systemActionClass;
    protected String layerInstancePath;
    protected KeyStroke[] keystrokes;
    private static Operator.StringComparator defaultComparator;
    private Operator.StringComparator comparator;

    public Action(String menuPath, String popupPath) {
        this(menuPath, popupPath, null, (KeyStroke[])null);
    }

    public Action(String menuPath, String popupPath, String systemActionClass) {
        this(menuPath, popupPath, systemActionClass, (KeyStroke[])null);
    }

    @Deprecated
    public Action(String menuPath, String popupPath, Shortcut[] shortcuts) {
        this(menuPath, popupPath, null, shortcuts);
    }

    @Deprecated
    public Action(String menuPath, String popupPath, Shortcut shortcut) {
        this(menuPath, popupPath, null, new Shortcut[]{shortcut});
    }

    @Deprecated
    public Action(String menuPath, String popupPath, String systemActionClass, Shortcut[] shortcuts) {
        this(menuPath, popupPath, systemActionClass, Action.convertShortcuts(shortcuts));
    }

    private static KeyStroke[] convertShortcuts(Shortcut[] shortcuts) {
        KeyStroke[] keystrokes = null;
        if (shortcuts != null) {
            keystrokes = new KeyStroke[shortcuts.length];
            for (int i = 0; i < shortcuts.length; ++i) {
                keystrokes[i] = KeyStroke.getKeyStroke(shortcuts[i].getKeyCode(), shortcuts[i].getKeyModifiers());
            }
        }
        return keystrokes;
    }

    @Deprecated
    public Action(String menuPath, String popupPath, String systemActionClass, Shortcut shortcut) {
        this(menuPath, popupPath, systemActionClass, new Shortcut[]{shortcut});
    }

    public Action(String menuPath, String popupPath, KeyStroke keystroke) {
        this(menuPath, popupPath, null, keystroke);
    }

    public Action(String menuPath, String popupPath, KeyStroke[] keystrokes) {
        this(menuPath, popupPath, null, keystrokes);
    }

    public Action(String menuPath, String popupPath, String systemActionClass, KeyStroke keystroke) {
        this(menuPath, popupPath, systemActionClass, new KeyStroke[]{keystroke});
    }

    public Action(String menuPath, String popupPath, String systemActionClass, KeyStroke[] keystrokes) {
        this.menuPath = menuPath;
        this.popupPath = popupPath;
        if (systemActionClass == null) {
            this.systemActionClass = null;
        } else if (systemActionClass.endsWith(".instance")) {
            this.layerInstancePath = systemActionClass;
        } else {
            try {
                this.systemActionClass = Class.forName(systemActionClass);
            }
            catch (ClassNotFoundException e) {
                try {
                    this.systemActionClass = Class.forName(systemActionClass, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e2) {
                    this.systemActionClass = null;
                }
            }
        }
        if (keystrokes != null) {
            this.keystrokes = (KeyStroke[])keystrokes.clone();
        }
    }

    private void perform(int mode) {
        switch (mode) {
            case 1: {
                this.performPopup();
                break;
            }
            case 0: {
                this.performMenu();
                break;
            }
            case 2: {
                this.performAPI();
                break;
            }
            case 3: {
                this.performShortcut();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(Node node, int mode) {
        switch (mode) {
            case 1: {
                this.performPopup(node);
                break;
            }
            case 0: {
                this.performMenu(node);
                break;
            }
            case 2: {
                this.performAPI(node);
                break;
            }
            case 3: {
                this.performShortcut(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(Node[] nodes, int mode) {
        switch (mode) {
            case 1: {
                this.performPopup(nodes);
                break;
            }
            case 0: {
                this.performMenu(nodes);
                break;
            }
            case 2: {
                this.performAPI(nodes);
                break;
            }
            case 3: {
                this.performShortcut(nodes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(OutlineNode node, int mode) {
        switch (mode) {
            case 1: {
                this.performPopup(node);
                break;
            }
            case 0: {
                this.performMenu(node);
                break;
            }
            case 2: {
                this.performAPI(node);
                break;
            }
            case 3: {
                this.performShortcut(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(ComponentOperator component, int mode) {
        switch (mode) {
            case 1: {
                this.performPopup(component);
                break;
            }
            case 0: {
                this.performMenu(component);
                break;
            }
            case 2: {
                this.performAPI(component);
                break;
            }
            case 3: {
                this.performShortcut(component);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    public void perform() {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(modes[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(Node node) {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(node, modes[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(Node[] nodes) {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(nodes, modes[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(OutlineNode node) {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(node, modes[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(ComponentOperator component) {
        int[] modes = sequence[this.getDefaultMode()];
        for (int i = 0; i < modes.length; ++i) {
            try {
                this.perform(component, modes[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void performMenu() {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        new EventTool().waitNoEvent(500L);
        MainWindowOperator.getDefault().menuBar().pushMenu(this.menuPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performMenu(Node node) {
        this.performMenu(new Node[]{node});
    }

    public void performMenu(Node[] nodes) {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        this.testNodes(nodes);
        nodes[0].select();
        for (int i = 1; i < nodes.length; ++i) {
            nodes[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performMenu();
    }

    public void performMenu(OutlineNode node) {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        node.select();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performMenu();
    }

    public void performMenu(ComponentOperator component) {
        component.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performMenu();
    }

    public void performPopup() {
        throw new UnsupportedOperationException(this.getClass().toString() + " does not implement performPopup()");
    }

    public void performPopup(Node node) {
        this.performPopup(new Node[]{node});
    }

    public void performPopup(Node[] nodes) {
        this.callPopup(nodes).pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performPopup(OutlineNode node) {
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        node.callPopup().pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    JPopupMenuOperator callPopup(Node[] nodes) {
        JPopupMenuOperator popup;
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        this.testNodes(nodes);
        Operator.ComponentVisualizer treeVisualizer = nodes[0].tree().getVisualizer();
        Operator.ComponentVisualizer oldVisualizer = null;
        if (treeVisualizer instanceof EmptyVisualizer) {
            oldVisualizer = Operator.getDefaultComponentVisualizer();
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)treeVisualizer);
        }
        new EventTool().waitNoEvent(500L);
        TreePath[] paths = new TreePath[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            paths[i] = nodes[i].getTreePath();
        }
        try {
            popup = new JPopupMenuOperator(nodes[0].tree().callPopupOnPaths(paths));
        }
        catch (JTreeOperator.NoSuchPathException e) {
            for (int i = 0; i < nodes.length; ++i) {
                paths[i] = nodes[i].getTreePath();
            }
            popup = new JPopupMenuOperator(nodes[0].tree().callPopupOnPaths(paths));
        }
        if (oldVisualizer != null) {
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)oldVisualizer);
        }
        popup.setComparator(this.getComparator());
        return popup;
    }

    public void performPopup(ComponentOperator component) {
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        new EventTool().waitNoEvent(500L);
        component.clickForPopup();
        new JPopupMenuOperator((Operator)component).pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performAPI() {
        if (this.systemActionClass == null && this.layerInstancePath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not support API call.");
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (Action.this.layerInstancePath != null) {
                        try {
                            FileObject fo = FileUtil.getConfigFile((String)Action.this.layerInstancePath);
                            DataObject dob = DataObject.find((FileObject)fo);
                            javax.swing.Action action = (javax.swing.Action)((InstanceCookie)dob).instanceCreate();
                            action.actionPerformed(new ActionEvent(new Container(), 0, null));
                        }
                        catch (Exception e) {
                            throw new JemmyException("Cannot perform declaratively defined action  \"" + Action.this.layerInstancePath + "\".", (Throwable)e);
                        }
                    } else if (SystemAction.class.isAssignableFrom(Action.this.systemActionClass)) {
                        SystemAction.get((Class)Action.this.systemActionClass).actionPerformed(new ActionEvent(new Container(), 0, null));
                    } else if (javax.swing.Action.class.isAssignableFrom(Action.this.systemActionClass)) {
                        try {
                            ((javax.swing.Action)Action.this.systemActionClass.newInstance()).actionPerformed(new ActionEvent(new Container(), 0, null));
                        }
                        catch (Exception e) {
                            throw new JemmyException("Exception when trying to create instance of action \"" + Action.this.systemActionClass.getName() + "\".", (Throwable)e);
                        }
                    } else if (ActionListener.class.isAssignableFrom(Action.this.systemActionClass)) {
                        try {
                            ((ActionListener)Action.this.systemActionClass.newInstance()).actionPerformed(new ActionEvent(new Container(), 0, null));
                        }
                        catch (Exception e) {
                            throw new JemmyException("Exception when trying to create instance of action \"" + Action.this.systemActionClass.getName() + "\".", (Throwable)e);
                        }
                    } else {
                        throw new JemmyException("Cannot create instance of action \"" + Action.this.systemActionClass.getName() + "\".");
                    }
                }
            });
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("API call failed.", (Throwable)e);
        }
    }

    public void performAPI(Node node) {
        this.performAPI(new Node[]{node});
    }

    public void performAPI(Node[] nodes) {
        if (this.systemActionClass == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define SystemAction");
        }
        this.testNodes(nodes);
        nodes[0].select();
        for (int i = 1; i < nodes.length; ++i) {
            nodes[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        int selectedNodes = nodes[0].tree().getSelectionCount();
        if (selectedNodes != nodes.length) {
            nodes[0].select();
            for (int i = 1; i < nodes.length; ++i) {
                nodes[i].addSelectionPath();
            }
        }
        this.performAPI();
    }

    public void performAPI(OutlineNode node) {
        if (this.systemActionClass == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define SystemAction");
        }
        node.select();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performAPI();
    }

    public void performAPI(ComponentOperator component) {
        component.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performAPI();
    }

    public void performShortcut() {
        KeyStroke[] strokes = this.getKeyStrokes();
        if (strokes == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        for (int i = 0; i < strokes.length; ++i) {
            new KeyRobotDriver(null).pushKey(null, strokes[i].getKeyCode(), strokes[i].getModifiers(), JemmyProperties.getCurrentTimeouts().create("ComponentOperator.PushKeyTimeout"));
            JemmyProperties.getProperties().getTimeouts().sleep("Action.WaitAfterShortcutTimeout");
        }
        try {
            Thread.sleep(0L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void performShortcut(Node node) {
        this.performShortcut(new Node[]{node});
    }

    public void performShortcut(Node[] nodes) {
        KeyStroke[] strokes = this.getKeyStrokes();
        if (strokes == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        this.testNodes(nodes);
        nodes[0].select();
        for (int i = 1; i < nodes.length; ++i) {
            nodes[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performShortcut();
    }

    public void performShortcut(OutlineNode node) {
        KeyStroke[] strokes = this.getKeyStrokes();
        if (strokes == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        node.select();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performShortcut();
    }

    public void performShortcut(ComponentOperator component) {
        component.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
        this.performShortcut();
    }

    protected void testNodes(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("argument nodes is null or empty");
        }
        Component nodesTree = nodes[0].tree().getSource();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) {
                throw new IllegalArgumentException("argument nodes contains null value");
            }
            if (nodesTree.equals(nodes[i].tree().getSource())) continue;
            throw new IllegalArgumentException(nodes[i].toString() + " is from different tree");
        }
    }

    public int getDefaultMode() {
        int mode = (Integer)JemmyProperties.getCurrentProperty((String)"Action.DefaultMode");
        if (mode < 0 || mode > 3) {
            return 1;
        }
        return mode;
    }

    public int setDefaultMode(int mode) {
        int oldMode = (Integer)JemmyProperties.getCurrentProperty((String)"Action.DefaultMode");
        if (mode < 0 || mode > 3) {
            mode = 1;
        }
        JemmyProperties.setCurrentProperty((String)"Action.DefaultMode", (Object)mode);
        return oldMode;
    }

    public void setComparator(Operator.StringComparator comparator) {
        this.comparator = comparator;
    }

    public Operator.StringComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = defaultComparator;
        }
        return this.comparator;
    }

    public String getPopupPath() {
        return this.popupPath;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public Class getSystemActionClass() {
        return this.systemActionClass;
    }

    public KeyStroke[] getKeyStrokes() {
        if (this.keystrokes != null) {
            return (KeyStroke[])this.keystrokes.clone();
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.systemActionClass != null) {
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.menuPath != null) {
            return MainWindowOperator.getDefault().menuBar().showMenuItem(this.menuPath, "|", this.getComparator()).isEnabled();
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    public boolean isEnabled(Node[] nodes) {
        this.testNodes(nodes);
        if (this.systemActionClass != null) {
            nodes[0].select();
            for (int i = 1; i < nodes.length; ++i) {
                nodes[i].addSelectionPath();
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                throw new JemmyException("Sleeping interrupted", (Throwable)e);
            }
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.popupPath != null) {
            TreePath[] paths = new TreePath[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                paths[i] = nodes[i].getTreePath();
            }
            Operator.ComponentVisualizer treeVisualizer = nodes[0].tree().getVisualizer();
            Operator.ComponentVisualizer oldVisualizer = null;
            if (treeVisualizer instanceof EmptyVisualizer) {
                oldVisualizer = Operator.getDefaultComponentVisualizer();
                Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)treeVisualizer);
            }
            new EventTool().waitNoEvent(500L);
            JPopupMenuOperator popup = new JPopupMenuOperator(nodes[0].tree().callPopupOnPaths(paths));
            if (oldVisualizer != null) {
                Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)oldVisualizer);
            }
            boolean enabled = popup.showMenuItem(this.popupPath, "|", this.getComparator()).isEnabled();
            popup.setVisible(false);
            return enabled;
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    public boolean isEnabled(Node node) {
        return this.isEnabled(new Node[]{node});
    }

    public boolean isEnabled(ComponentOperator componentOperator) {
        componentOperator.makeComponentVisible();
        componentOperator.getFocus();
        if (this.systemActionClass != null) {
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.popupPath != null) {
            new EventTool().waitNoEvent(500L);
            componentOperator.clickForPopup();
            return new JPopupMenuOperator((Operator)componentOperator).showMenuItem(this.popupPath, "|", this.getComparator()).isEnabled();
        }
        if (this.menuPath != null) {
            return MainWindowOperator.getDefault().menuBar().showMenuItem(this.menuPath, "|", this.getComparator()).isEnabled();
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    static {
        JellyVersion.checkJemmyVersion();
        if (JemmyProperties.getCurrentProperty((String)"Action.DefaultMode") == null) {
            JemmyProperties.setCurrentProperty((String)"Action.DefaultMode", (Object)1);
        }
        Timeouts.initDefault((String)"Action.WaitAfterShortcutTimeout", (long)0L);
        boolean compareExactly = !Operator.getDefaultStringComparator().equals("abc", "a");
        defaultComparator = new Operator.DefaultStringComparator(compareExactly, true);
    }

    @Deprecated
    public static class Shortcut {
        protected int keyCode;
        protected int keyModifiers;

        public Shortcut(int keyCode) {
            this(keyCode, 0);
        }

        public Shortcut(int keyCode, int keyModifiers) {
            this.keyCode = keyCode;
            this.keyModifiers = keyModifiers;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getKeyModifiers() {
            return this.keyModifiers;
        }

        public String toString() {
            return Actions.keyStrokeToString((KeyStroke)KeyStroke.getKeyStroke(this.getKeyCode(), this.getKeyModifiers()));
        }
    }
}

