/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.java.file.launcher.queries.MultiSourceRootProvider;
import org.netbeans.modules.java.file.launcher.spi.SingleFileOptionsQueryImplementation;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class SingleSourceFileUtil {
    public static final Logger LOG = Logger.getLogger(SingleSourceFileUtil.class.getPackage().getName());
    public static final String FILE_ARGUMENTS = "single_file_run_arguments";
    public static final String FILE_VM_OPTIONS = "single_file_vm_options";
    private static final LineParser PARSER = new LineParser();

    public static int findJavaVersion() throws NumberFormatException {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        int version = Integer.parseInt(javaVersion);
        return version;
    }

    public static FileObject getJavaFileWithoutProjectFromLookup(Lookup lookup) {
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            if (!SingleSourceFileUtil.isSingleSourceFile(fObj)) continue;
            return fObj;
        }
        for (FileObject fObj : lookup.lookupAll(FileObject.class)) {
            if (!SingleSourceFileUtil.isSingleSourceFile(fObj)) continue;
            return fObj;
        }
        return null;
    }

    public static boolean isSingleSourceFile(FileObject fObj) {
        return SingleSourceFileUtil.isSupportedFile(fObj) && fObj.getExt().equalsIgnoreCase("java");
    }

    public static boolean isSupportedFile(FileObject file) {
        if (file == null) {
            return false;
        }
        try {
            FileObject dir = file.getParent();
            File dirFile = dir != null ? FileUtil.toFile((FileObject)dir) : null;
            return !MultiSourceRootProvider.DISABLE_MULTI_SOURCE_ROOT && FileOwnerQuery.getOwner((FileObject)file) == null && !file.getFileSystem().isReadOnly() && (dirFile == null || !dirFile.getName().startsWith("vcs-") || !dirFile.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir")));
        }
        catch (FileStateInvalidException ex) {
            return false;
        }
    }

    public static Process compileJavaSource(FileObject fileObject) {
        String vmOptions;
        FileObject javac = JavaPlatformManager.getDefault().getDefaultPlatform().findTool("javac");
        File javacFile = FileUtil.toFile((FileObject)javac);
        String javacPath = javacFile.getAbsolutePath();
        ArrayList<String> compileCommandList = new ArrayList<String>();
        Object compilerVmOptionsObj = fileObject.getAttribute(FILE_VM_OPTIONS);
        compileCommandList.add(javacPath);
        compileCommandList.add("-g");
        String string = vmOptions = compilerVmOptionsObj != null ? ((String)compilerVmOptionsObj).trim() : "";
        if (!vmOptions.isEmpty()) {
            compileCommandList.addAll(Arrays.asList(vmOptions.split(" ")));
        }
        compileCommandList.add(fileObject.getPath());
        ProcessBuilder compileProcessBuilder = new ProcessBuilder(compileCommandList);
        compileProcessBuilder.directory(new File(fileObject.getParent().getPath()));
        compileProcessBuilder.redirectErrorStream(true);
        compileProcessBuilder.redirectOutput();
        try {
            return compileProcessBuilder.start();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not get InputStream of Compile Process");
            return null;
        }
    }

    public static boolean hasClassSibling(FileObject fo) {
        return fo.getParent().getFileObject(fo.getName(), "class") != null;
    }

    public static SingleFileOptionsQueryImplementation.Result getOptionsFor(FileObject file) {
        if (MultiSourceRootProvider.DISABLE_MULTI_SOURCE_ROOT) {
            return null;
        }
        for (SingleFileOptionsQueryImplementation i : Lookup.getDefault().lookupAll(SingleFileOptionsQueryImplementation.class)) {
            SingleFileOptionsQueryImplementation.Result r = i.optionsFor(file);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static List<String> parseLine(String line) {
        return PARSER.doParse(line);
    }

    private static class LineParser
    extends CompilerOptionsQueryImplementation.Result {
        private LineParser() {
        }

        public List<String> doParse(String line) {
            return this.parseLine(line);
        }

        public List<? extends String> getArguments() {
            return null;
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }
}

