/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail;

import java.io.Serializable;
import java.util.Date;
import org.springframework.mail.MailMessage;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SimpleMailMessage
implements MailMessage,
Serializable {
    private String from;
    private String replyTo;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private Date sentDate;
    private String subject;
    private String text;

    public SimpleMailMessage() {
    }

    public SimpleMailMessage(SimpleMailMessage original) {
        Assert.notNull((Object)original, (String)"'original' message argument must not be null");
        this.from = original.getFrom();
        this.replyTo = original.getReplyTo();
        this.to = SimpleMailMessage.copyOrNull(original.getTo());
        this.cc = SimpleMailMessage.copyOrNull(original.getCc());
        this.bcc = SimpleMailMessage.copyOrNull(original.getBcc());
        this.sentDate = original.getSentDate();
        this.subject = original.getSubject();
        this.text = original.getText();
    }

    @Override
    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setTo(String to) {
        this.to = new String[]{to};
    }

    @Override
    public void setTo(String[] to) {
        this.to = to;
    }

    public String[] getTo() {
        return this.to;
    }

    @Override
    public void setCc(String cc) {
        this.cc = new String[]{cc};
    }

    @Override
    public void setCc(String[] cc) {
        this.cc = cc;
    }

    public String[] getCc() {
        return this.cc;
    }

    @Override
    public void setBcc(String bcc) {
        this.bcc = new String[]{bcc};
    }

    @Override
    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    @Override
    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void copyTo(MailMessage target) {
        Assert.notNull((Object)target, (String)"'target' MailMessage must not be null");
        if (this.getFrom() != null) {
            target.setFrom(this.getFrom());
        }
        if (this.getReplyTo() != null) {
            target.setReplyTo(this.getReplyTo());
        }
        if (this.getTo() != null) {
            target.setTo(SimpleMailMessage.copy(this.getTo()));
        }
        if (this.getCc() != null) {
            target.setCc(SimpleMailMessage.copy(this.getCc()));
        }
        if (this.getBcc() != null) {
            target.setBcc(SimpleMailMessage.copy(this.getBcc()));
        }
        if (this.getSentDate() != null) {
            target.setSentDate(this.getSentDate());
        }
        if (this.getSubject() != null) {
            target.setSubject(this.getSubject());
        }
        if (this.getText() != null) {
            target.setText(this.getText());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleMailMessage)) {
            return false;
        }
        SimpleMailMessage otherMessage = (SimpleMailMessage)other;
        return ObjectUtils.nullSafeEquals((Object)this.from, (Object)otherMessage.from) && ObjectUtils.nullSafeEquals((Object)this.replyTo, (Object)otherMessage.replyTo) && ObjectUtils.nullSafeEquals((Object)this.to, (Object)otherMessage.to) && ObjectUtils.nullSafeEquals((Object)this.cc, (Object)otherMessage.cc) && ObjectUtils.nullSafeEquals((Object)this.bcc, (Object)otherMessage.bcc) && ObjectUtils.nullSafeEquals((Object)this.sentDate, (Object)otherMessage.sentDate) && ObjectUtils.nullSafeEquals((Object)this.subject, (Object)otherMessage.subject) && ObjectUtils.nullSafeEquals((Object)this.text, (Object)otherMessage.text);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.from);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.replyTo);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object[])this.to);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object[])this.cc);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object[])this.bcc);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.sentDate);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.subject);
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleMailMessage: ");
        sb.append("from=").append(this.from).append("; ");
        sb.append("replyTo=").append(this.replyTo).append("; ");
        sb.append("to=").append(StringUtils.arrayToCommaDelimitedString((Object[])this.to)).append("; ");
        sb.append("cc=").append(StringUtils.arrayToCommaDelimitedString((Object[])this.cc)).append("; ");
        sb.append("bcc=").append(StringUtils.arrayToCommaDelimitedString((Object[])this.bcc)).append("; ");
        sb.append("sentDate=").append(this.sentDate).append("; ");
        sb.append("subject=").append(this.subject).append("; ");
        sb.append("text=").append(this.text);
        return sb.toString();
    }

    private static String[] copyOrNull(String[] state) {
        if (state == null) {
            return null;
        }
        return SimpleMailMessage.copy(state);
    }

    private static String[] copy(String[] state) {
        String[] copy = new String[state.length];
        System.arraycopy(state, 0, copy, 0, state.length);
        return copy;
    }
}

