/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.simple.JSONValue;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.ui.wizard.BaseWizardIterator;
import org.netbeans.modules.javascript.nodejs.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Pair;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class NewSampleWizardIterator
extends BaseWizardIterator {
    private static final Logger LOGGER = Logger.getLogger(NewSampleWizardIterator.class.getName());
    private final String wizardTitle;
    private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> baseWizard;

    private NewSampleWizardIterator(String wizardTitle, String projectName) {
        assert (wizardTitle != null);
        assert (projectName != null);
        this.wizardTitle = wizardTitle;
        this.baseWizard = CreateProjectUtils.createBaseWizardPanel((String)projectName);
    }

    public static NewSampleWizardIterator newListDirectorySample() {
        return new NewSampleWizardIterator(Bundle.NewSampleWizardIterator_newListDirectorySample_displayName(), "ListDirectory");
    }

    public static NewSampleWizardIterator newMessagesKnockoutSample() {
        return new NewSampleWizardIterator(Bundle.NewSampleWizardIterator_newMessagesKnockoutSample_displayName(), "MessagesKnockout");
    }

    public static NewSampleWizardIterator newMessagesAngularSample() {
        return new NewSampleWizardIterator(Bundle.NewSampleWizardIterator_newMessagesAngularSample_displayName(), "MessagesAngular");
    }

    public static NewSampleWizardIterator newMessagesExpressSample() {
        return new NewSampleWizardIterator(Bundle.NewSampleWizardIterator_newMessagesExpressSample_displayName(), "MessagesExpress");
    }

    @Override
    String getWizardTitle() {
        return this.wizardTitle;
    }

    @Override
    WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
        return new WizardDescriptor.Panel[]{(WizardDescriptor.Panel)this.baseWizard.first()};
    }

    @Override
    String[] createSteps() {
        return new String[]{(String)this.baseWizard.second()};
    }

    @Override
    void uninitializeInternal() {
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(Bundle.NewSampleWizardIterator_progress_creating());
        HashSet<FileObject> files = new HashSet<FileObject>();
        File projectDir = FileUtil.normalizeFile((File)((File)this.wizardDescriptor.getProperty("PROJECT_DIRECTORY")));
        if (!projectDir.isDirectory() && !projectDir.mkdirs()) {
            throw new IOException("Cannot create project directory: " + projectDir);
        }
        final FileObject projectDirectory = FileUtil.toFileObject((File)projectDir);
        assert (projectDirectory != null) : "FileObject must be found for " + projectDir;
        files.add(projectDirectory);
        final FileObject template = Templates.getTemplate((WizardDescriptor)this.wizardDescriptor);
        final String projectName = (String)this.wizardDescriptor.getProperty("NAME");
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    NewSampleWizardIterator.unZipFile(template, projectDirectory, projectName);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            throw (IOException)ex.getException();
        }
        ProjectManager.getDefault().clearNonProjectCache();
        Project project = FileOwnerQuery.getOwner((FileObject)projectDirectory);
        assert (project != null) : projectDirectory;
        NodeJsSupport nodeJsSupport = NodeJsSupport.forProject(project);
        String startFile = nodeJsSupport.getPreferences().getStartFile();
        assert (startFile != null) : projectDirectory;
        FileObject fo = FileUtil.toFileObject((File)new File(startFile));
        assert (fo != null) : startFile;
        files.add(fo);
        PackageJson packageJson = nodeJsSupport.getPackageJson();
        if (packageJson.exists()) {
            files.add(FileUtil.toFileObject((File)packageJson.getFile()));
        }
        handle.finish();
        return files;
    }

    static void unZipFile(FileObject template, FileObject projectDir, String projectName) throws IOException {
        try (InputStream source = template.getInputStream();){
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectDir, (String)name);
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)projectDir, (String)name);
                if ("nbproject/project.xml".equals(name)) {
                    NewSampleWizardIterator.filterProjectXml(fo, str, projectName);
                    continue;
                }
                if ("package.json".equals(name) || "bower.json".equals(name)) {
                    NewSampleWizardIterator.writeFile(str, fo);
                    NewSampleWizardIterator.filterJson(fo, projectName);
                    continue;
                }
                NewSampleWizardIterator.writeFile(str, fo);
            }
        }
    }

    private static void writeFile(ZipInputStream str, FileObject fo) throws IOException {
        try (OutputStream out = fo.getOutputStream();){
            FileUtil.copy((InputStream)str, (OutputStream)out);
        }
    }

    private static void filterProjectXml(FileObject fo, ZipInputStream str, String name) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)str, (OutputStream)baos);
            Document doc = XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(baos.toByteArray())), (boolean)false, (boolean)false, null, null);
            NodeList nl = doc.getDocumentElement().getElementsByTagName("name");
            if (nl != null) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    if (el.getParentNode() == null || !"data".equals(el.getParentNode().getNodeName())) continue;
                    NodeList nl2 = el.getChildNodes();
                    if (nl2.getLength() <= 0) break;
                    nl2.item(0).setNodeValue(name);
                    break;
                }
            }
            try (OutputStream out = fo.getOutputStream();){
                XMLUtil.write((Document)doc, (OutputStream)out, (String)StandardCharsets.UTF_8.name());
            }
        }
        catch (IOException | DOMException | SAXException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            NewSampleWizardIterator.writeFile(str, fo);
        }
    }

    private static void filterJson(FileObject fo, String name) throws IOException {
        Path path = FileUtil.toFile((FileObject)fo).toPath();
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(path), charset);
        content = content.replace("${project.name}", JSONValue.escape((String)name));
        Files.write(path, content.getBytes(charset), new OpenOption[0]);
    }
}

