/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cloud.oracle.adm.VulnerabilityReport;
import org.openide.modules.Places;

final class AuditCache {
    private static final Logger LOG = Logger.getLogger(AuditCache.class.getName());
    private static final String FILE_REPORT = "audit-report.json";
    private static final String CACHE_SUBDIR = "oracle-cloud-adm";
    private static final String SEGMENTS_FILE = "segments";
    private static final AuditCache INSTANCE = new AuditCache();
    private Properties segments = new Properties();
    private long loadTimestamp;

    private AuditCache() {
    }

    static AuditCache getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties loadSegments() {
        Properties p;
        File cacheDir = Places.getCacheSubdirectory((String)CACHE_SUBDIR);
        Path segPath = cacheDir.toPath().resolve(SEGMENTS_FILE);
        if (!Files.exists(segPath, new LinkOption[0])) {
            AuditCache auditCache = this;
            synchronized (auditCache) {
                this.segments.clear();
                return this.segments;
            }
        }
        try {
            long ts;
            AuditCache auditCache = this;
            synchronized (auditCache) {
                ts = Files.getLastModifiedTime(segPath, new LinkOption[0]).toMillis();
                if (ts < this.loadTimestamp) {
                    return this.segments;
                }
            }
            p = new Properties();
            p.load(Files.newBufferedReader(segPath));
            auditCache = this;
            synchronized (auditCache) {
                if (ts > this.loadTimestamp) {
                    this.segments = p;
                    this.loadTimestamp = ts;
                } else {
                    p = this.segments;
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not load segment properties", ex);
            p = this.segments;
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VulnerabilityReport cacheAuditResults(VulnerabilityReport report) throws IOException {
        String segName;
        boolean writeSegment;
        Properties segments = this.loadSegments();
        String k = "knowledge.segment." + report.summary.getKnowledgeBaseId();
        File cacheDir = Places.getCacheSubdirectory((String)CACHE_SUBDIR);
        Path segPath = cacheDir.toPath().resolve(SEGMENTS_FILE);
        boolean bl = writeSegment = !Files.exists(segPath, new LinkOption[0]);
        if (writeSegment) {
            AuditCache auditCache = this;
            synchronized (auditCache) {
                this.segments.clear();
            }
        }
        if ((segName = segments.getProperty(k)) == null) {
            int segNo = 1;
            IOException saveException = null;
            for (int attempts = 0; attempts < 5; ++attempts) {
                while (segments.get("s" + segNo) != null) {
                    ++segNo;
                }
                String sN = "s" + segNo;
                segments.put(sN, k);
                segments.put(k, sN);
                Path dirPath = cacheDir.toPath().resolve(sN);
                try {
                    Files.createDirectories(dirPath, new FileAttribute[0]);
                    segName = sN;
                    break;
                }
                catch (IOException ex) {
                    saveException = ex;
                    continue;
                }
            }
            if (segName == null) {
                throw saveException;
            }
            try (OutputStream ostm = Files.newOutputStream(segPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                segments.store(ostm, null);
            }
        }
        Path dirPath = cacheDir.toPath().resolve(segName);
        Files.createDirectories(dirPath, new FileAttribute[0]);
        Path reportData = dirPath.resolve(FILE_REPORT);
        ObjectWriter om = new ObjectMapper().writer((FilterProvider)new SimpleFilterProvider().addFilter("explicitlySetFilter", (SimpleBeanPropertyFilter)new ExplicitlySetFilter()));
        om.writeValue(reportData.toFile(), (Object)report);
        Path stampPath = reportData.resolveSibling("lastReadStamp");
        Files.write(stampPath, Arrays.asList(""), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VulnerabilityReport loadAudit(String knowledgeBaseId) throws IOException {
        Path reportData;
        String k;
        Properties segments = this.loadSegments();
        String segName = segments.getProperty(k = "knowledge.segment." + knowledgeBaseId);
        if (segName == null) {
            return null;
        }
        File cacheDir = Places.getCacheSubdirectory((String)CACHE_SUBDIR);
        Path dirPath = cacheDir.toPath().resolve(segName);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            AuditCache auditCache = this;
            synchronized (auditCache) {
                segments.remove(k);
                segments.remove(segName);
            }
        }
        if (!Files.exists(reportData = dirPath.resolve(FILE_REPORT), new LinkOption[0])) {
            return null;
        }
        ObjectMapper om = new ObjectMapper();
        VulnerabilityReport res = (VulnerabilityReport)om.readValue(reportData.toFile(), VulnerabilityReport.class);
        Path stampPath = reportData.resolveSibling("lastReadStamp");
        Files.write(stampPath, Arrays.asList(""), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return res;
    }

    static class ExplicitlySetFilter
    extends SimpleBeanPropertyFilter {
        private static final Method NO_METHOD;
        private Map<Class, Method> explicitlySetMethods = new HashMap<Class, Method>();

        ExplicitlySetFilter() {
        }

        private boolean isExplicitlySet(Object v, String name) {
            if (v == null) {
                return true;
            }
            Method m = this.explicitlySetMethods.get(v.getClass());
            if (m == null) {
                try {
                    m = v.getClass().getMethod("get__explicitlySet__", new Class[0]);
                    m.setAccessible(true);
                }
                catch (ReflectiveOperationException ex) {
                    m = NO_METHOD;
                }
                this.explicitlySetMethods.put(v.getClass(), m);
            }
            if (m == NO_METHOD) {
                return true;
            }
            try {
                Set props = (Set)m.invoke(v, new Object[0]);
                return props == null || props.contains(name);
            }
            catch (ReflectiveOperationException ex) {
                return true;
            }
        }

        public void serializeAsElement(Object elementValue, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            if (this.isExplicitlySet(elementValue, writer.getName())) {
                super.serializeAsElement(elementValue, jgen, provider, writer);
            }
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            if (this.isExplicitlySet(pojo, writer.getName())) {
                super.serializeAsField(pojo, jgen, provider, writer);
            }
        }

        static {
            try {
                NO_METHOD = ExplicitlySetFilter.class.getDeclaredMethod("isExplicitlySet", Object.class, String.class);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

