/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.form.I18nService;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.i18n.FileSelector;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.i18n.form.FormI18nInteger;
import org.netbeans.modules.i18n.form.FormI18nMnemonic;
import org.netbeans.modules.i18n.form.FormI18nString;
import org.netbeans.modules.i18n.form.FormI18nStringEditor;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class I18nServiceImpl
implements I18nService {
    private Map changesMap = new HashMap();

    public I18nValue create(String key, String value, DataObject srcDataObject) {
        FormI18nString i18nString = new FormI18nString(srcDataObject);
        i18nString.setKey(key);
        i18nString.setValue(value);
        return i18nString;
    }

    public I18nValue copy(I18nValue value) {
        FormI18nString i18nString = (FormI18nString)value;
        FormI18nString copy = new FormI18nString(i18nString);
        copy.getSupport().getResourceHolder().setResource(null);
        if (i18nString.allData == null && i18nString.getKey() != null) {
            JavaResourceHolder jrh = (JavaResourceHolder)i18nString.getSupport().getResourceHolder();
            copy.allData = jrh.getAllData(i18nString.getKey());
        } else {
            copy.allData = i18nString.allData;
        }
        return copy;
    }

    public I18nValue changeKey(I18nValue prev, String newKey) {
        FormI18nString changedI18nString;
        FormI18nString oldI18nString = (FormI18nString)prev;
        if (oldI18nString.getKey() == "#auto") {
            changedI18nString = oldI18nString;
        } else {
            changedI18nString = new FormI18nString(oldI18nString);
            changedI18nString.allData = oldI18nString.allData;
        }
        changedI18nString.setKey(newKey);
        return changedI18nString;
    }

    public I18nValue changeValue(I18nValue prev, String value) {
        FormI18nString i18nString = new FormI18nString((FormI18nString)prev);
        i18nString.setValue(value);
        return i18nString;
    }

    public I18nValue switchLocale(I18nValue value, String localeSuffix) {
        if (value == null || value.getKey() == null) {
            return value;
        }
        FormI18nString i18nString = value instanceof FormI18nInteger ? new FormI18nInteger((FormI18nInteger)value) : (value instanceof FormI18nMnemonic ? new FormI18nMnemonic((FormI18nMnemonic)value) : new FormI18nString((FormI18nString)value));
        JavaResourceHolder rh = (JavaResourceHolder)i18nString.getSupport().getResourceHolder();
        rh.setLocalization(localeSuffix);
        i18nString.setValue(rh.getValueForKey(i18nString.getKey()));
        i18nString.setComment(rh.getCommentForKey(i18nString.getKey()));
        return i18nString;
    }

    public void update(I18nValue oldValue, I18nValue newValue, DataObject srcDataObject, String bundleName, String localeSuffix, boolean canRemove) throws IOException {
        FormI18nString oldI18nString = (FormI18nString)oldValue;
        FormI18nString newI18nString = (FormI18nString)newValue;
        if (oldI18nString != null) {
            ResourceHolder newRH;
            ResourceHolder oldRH = oldI18nString.getSupport().getResourceHolder();
            DataObject oldRes = oldRH.getResource();
            DataObject newRes = null;
            if (newI18nString != null && (newRes = (newRH = newI18nString.getSupport().getResourceHolder()).getResource()) == null) {
                newRH.setResource(oldRes);
                newRes = oldRes;
            }
            String oldKey = oldI18nString.getKey();
            if (canRemove && oldKey != null) {
                JavaResourceHolder jrh = (JavaResourceHolder)oldRH;
                Object allData = jrh.getAllData(oldKey);
                this.registerChange(srcDataObject, oldRes, oldKey, allData);
                if (newI18nString == null || newI18nString.getKey() == null || !newI18nString.getKey().equals(oldKey) || newRes != oldRes) {
                    oldI18nString.allData = allData;
                    jrh.removeProperty((Object)oldKey);
                    if (newI18nString != null) {
                        newI18nString.allData = oldI18nString.allData;
                    }
                } else if (localeSuffix != null && !localeSuffix.equals("")) {
                    oldI18nString.allData = allData;
                }
                if (newI18nString == null && oldRes == I18nServiceImpl.getPropertiesDataObject(srcDataObject.getPrimaryFile(), bundleName)) {
                    oldRH.setResource(null);
                }
            }
        }
        if (newI18nString != null && newI18nString.getKey() != null) {
            JavaResourceHolder rh = (JavaResourceHolder)newI18nString.getSupport().getResourceHolder();
            String key = newI18nString.getKey();
            if (rh.getResource() == null) {
                PropertiesDataObject propertiesDO = I18nServiceImpl.getPropertiesDataObject(srcDataObject.getPrimaryFile(), bundleName);
                if (propertiesDO == null) {
                    propertiesDO = I18nServiceImpl.createPropertiesDataObject(srcDataObject.getPrimaryFile(), bundleName);
                    if (propertiesDO == null) {
                        return;
                    }
                } else if (oldI18nString == null && newI18nString.getValue() == null) {
                    rh.setResource((DataObject)propertiesDO);
                    newI18nString.setValue(rh.getValueForKey(key));
                    newI18nString.setComment(rh.getCommentForKey(key));
                    return;
                }
                rh.setResource((DataObject)propertiesDO);
                key = rh.findFreeKey(key);
                newI18nString.setKey(key);
            }
            rh.setLocalization(localeSuffix);
            if (!I18nServiceImpl.isValueUpToDate((ResourceHolder)rh, (I18nString)newI18nString)) {
                if (newI18nString.allData != null) {
                    if (oldI18nString != null && newI18nString.getValue() != null) {
                        I18nServiceImpl.updateAllData(newI18nString, localeSuffix);
                    }
                    rh.setAllData(key, newI18nString.allData);
                    newI18nString.allData = null;
                    if (oldI18nString == null) {
                        newI18nString.setValue(rh.getValueForKey(key));
                        newI18nString.setComment(rh.getCommentForKey(key));
                    }
                } else {
                    rh.addProperty((Object)key, newI18nString.getValue(), newI18nString.getComment(), true);
                }
                this.registerChange(srcDataObject, rh.getResource(), newI18nString.getKey(), null);
            }
        }
    }

    private static boolean isValueUpToDate(ResourceHolder rh, I18nString i18nString) {
        String storedValue = rh.getValueForKey(i18nString.getKey());
        String storedComment = rh.getCommentForKey(i18nString.getKey());
        if ("".equals(storedComment)) {
            storedComment = null;
        }
        String newValue = i18nString.getValue();
        String newComment = i18nString.getComment();
        if ("".equals(newComment)) {
            newComment = null;
        }
        return Objects.equals(storedValue, newValue) && Objects.equals(storedComment, newComment);
    }

    private static void updateAllData(FormI18nString newI18nString, String localeSuffix) {
        String[] allData;
        String[] stringArray = allData = newI18nString.allData instanceof String[] ? (String[])newI18nString.allData : null;
        if (allData != null) {
            for (int i = 0; i < allData.length; i += 3) {
                String locale = allData[i];
                if (!localeSuffix.equals(locale)) continue;
                allData[i + 1] = newI18nString.getValue();
                allData[i + 2] = newI18nString.getComment();
                break;
            }
        }
    }

    public PropertyEditor getPropertyEditor(Class type, PropertyEditor existing) {
        return existing instanceof FormI18nStringEditor ? existing : new FormI18nStringEditor();
    }

    private static boolean isPlainStringEditor(PropertyEditor pe) {
        return pe != null && pe.getClass().getName().endsWith(".StringEditor");
    }

    public Component getBundleSelectionComponent(final PropertyEditor prEd, FileObject srcFile) {
        try {
            final FileSelector fs = new FileSelector(srcFile, JavaResourceHolder.getTemplate());
            return fs.getDialog(NbBundle.getMessage(I18nServiceImpl.class, (String)"CTL_SELECT_BUNDLE_TITLE"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ClassPath cp;
                    DataObject bundleDO = fs.getSelectedDataObject();
                    if (bundleDO != null && (cp = ClassPath.getClassPath((FileObject)bundleDO.getPrimaryFile(), (String)"classpath/source")) != null) {
                        String bundleName = cp.getResourceName(bundleDO.getPrimaryFile(), '/', false);
                        prEd.setValue(bundleName);
                    }
                }
            });
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public String[][] getAvailableLocales(FileObject srcFile, String bundleName) {
        PropertiesDataObject dobj = null;
        try {
            dobj = I18nServiceImpl.getPropertiesDataObject(srcFile, bundleName);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (dobj == null) {
            return new String[][]{new String[0], null};
        }
        ArrayList<MultiDataObject.Entry> list = new ArrayList<MultiDataObject.Entry>();
        list.add(dobj.getPrimaryEntry());
        list.addAll(dobj.secondaryEntries());
        try {
            String baseName = dobj.getName() + "_";
            for (FileObject fo : dobj.getPrimaryFile().getParent().getChildren()) {
                DataObject dobj2;
                String fileName = fo.getNameExt();
                if (!fileName.endsWith(".properties") || !fileName.startsWith(baseName) || !((dobj2 = DataObject.find((FileObject)fo)) instanceof PropertiesDataObject)) continue;
                list.add(((MultiDataObject)dobj2).getPrimaryEntry());
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                MultiDataObject.Entry e1 = (MultiDataObject.Entry)o1;
                MultiDataObject.Entry e2 = (MultiDataObject.Entry)o2;
                return e1.getFile().getName().compareTo(e2.getFile().getName());
            }
        });
        String[] locales = new String[list.size()];
        String[] displays = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MultiDataObject.Entry entry = (MultiDataObject.Entry)list.get(i);
            locales[i] = org.netbeans.modules.properties.Util.getLocaleSuffix((MultiDataObject.Entry)entry);
            displays[i] = org.netbeans.modules.properties.Util.getLocaleLabel((MultiDataObject.Entry)entry);
        }
        return new String[][]{locales, displays};
    }

    public Component getCreateLocaleComponent(final PropertyEditor prEd, FileObject srcFile, String bundleName) {
        PropertiesDataObject propertiesDO;
        try {
            propertiesDO = I18nServiceImpl.getPropertiesDataObject(srcFile, bundleName);
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        final Dialog[] dialog = new Dialog[1];
        final LocalePanel localePanel = new LocalePanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)localePanel, NbBundle.getBundle(PropertiesDataObject.class).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == DialogDescriptor.OK_OPTION) {
                    String locale = localePanel.getLocale().toString();
                    org.netbeans.modules.properties.Util.createLocaleFile((PropertiesDataObject)propertiesDO, (String)locale, (boolean)false);
                    prEd.setValue("_" + locale);
                }
                dialog[0].setVisible(false);
                dialog[0].dispose();
            }
        });
        dialog[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialog[0];
    }

    public void autoSave(DataObject srcDataObject) {
        Map relatedMap = (Map)this.changesMap.remove(srcDataObject);
        if (relatedMap != null) {
            for (DataObject propertiesDO : relatedMap.keySet()) {
                SaveCookie save = (SaveCookie)propertiesDO.getCookie(SaveCookie.class);
                if (save == null) continue;
                try {
                    save.save();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    public void close(DataObject srcDataObject) {
        Map relatedMap = (Map)this.changesMap.remove(srcDataObject);
        if (relatedMap != null) {
            for (Map.Entry e : relatedMap.entrySet()) {
                PropertiesDataObject propertiesDO = (PropertiesDataObject)e.getKey();
                ChangeInfo changes = (ChangeInfo)e.getValue();
                JavaResourceHolder rh = new JavaResourceHolder();
                rh.setResource((DataObject)propertiesDO);
                for (Map.Entry e2 : changes.changed.entrySet()) {
                    String key = (String)e2.getKey();
                    Object allData = e2.getValue();
                    rh.setAllData(key, allData);
                }
                for (String key : changes.added) {
                    rh.removeProperty((Object)key);
                }
            }
        }
    }

    public boolean isDefaultInternationalizableProject(FileObject srcFile) {
        return I18nServiceImpl.isNbBundleAvailable(srcFile);
    }

    static boolean isNbBundleAvailable(FileObject srcFile) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute");
        if (classPath != null && classPath.findResource("org/openide/util/NbBundle.class") != null) {
            return true;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)srcFile);
        return p != null && p.getClass().getName().startsWith("org.netbeans.modules.apisupport.") && p.getClass().getName().endsWith("Project");
    }

    public List<URL> getResourceFiles(FileObject srcFile, String bundleName) {
        PropertiesDataObject dobj = null;
        try {
            dobj = I18nServiceImpl.getPropertiesDataObject(srcFile, bundleName);
            if (dobj != null) {
                ArrayList<URL> list = new ArrayList<URL>();
                list.add(dobj.getPrimaryEntry().getFile().toURL());
                for (MultiDataObject.Entry e : dobj.secondaryEntries()) {
                    list.add(e.getFile().toURL());
                }
                return list;
            }
            FileObject root = I18nServiceImpl.getResourcesRoot(srcFile);
            if (root != null) {
                return Collections.singletonList(new File(FileUtil.toFile((FileObject)root).getPath() + File.separator + bundleName + ".properties").toURI().toURL());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(I18nServiceImpl.class.getName()).log(Level.INFO, null, ex);
        }
        return Collections.emptyList();
    }

    private static PropertiesDataObject getPropertiesDataObject(FileObject srcFile, String bundleName) throws DataObjectNotFoundException {
        DataObject dobj;
        FileObject bundleFile;
        if (bundleName.startsWith("/")) {
            bundleName = bundleName.substring(1);
        }
        if (!bundleName.toLowerCase().endsWith(".properties")) {
            bundleName = bundleName + ".properties";
        }
        if ((bundleFile = Util.getResource((FileObject)srcFile, (String)bundleName)) != null && (dobj = DataObject.find((FileObject)bundleFile)) instanceof PropertiesDataObject) {
            return (PropertiesDataObject)dobj;
        }
        return null;
    }

    private static DataObject createPropertiesDataObject(FileObject srcFile, String filePath) throws IOException {
        if (filePath == null) {
            return null;
        }
        FileObject root = I18nServiceImpl.getResourcesRoot(srcFile);
        return org.netbeans.modules.properties.Util.createPropertiesDataObject((FileObject)root, (String)filePath);
    }

    private static FileObject getResourcesRoot(FileObject srcFile) {
        Sources srcs;
        SourceGroup[] grps;
        FileObject root = null;
        Project owner = FileOwnerQuery.getOwner((FileObject)srcFile);
        if (owner != null && (grps = (srcs = ProjectUtils.getSources((Project)owner)).getSourceGroups("resources")) != null && grps.length > 0) {
            root = grps[0].getRootFolder();
        }
        if (root == null) {
            root = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source").getRoots()[0];
        }
        return root;
    }

    private void registerChange(DataObject srcDO, DataObject propertiesDO, String key, Object allData) {
        ChangeInfo changes;
        if (propertiesDO == null) {
            return;
        }
        HashMap<DataObject, ChangeInfo> relatedMap = (HashMap<DataObject, ChangeInfo>)this.changesMap.get(srcDO);
        if (relatedMap == null) {
            relatedMap = new HashMap<DataObject, ChangeInfo>();
            this.changesMap.put(srcDO, relatedMap);
        }
        if ((changes = (ChangeInfo)relatedMap.get(propertiesDO)) == null) {
            changes = new ChangeInfo();
            relatedMap.put(propertiesDO, changes);
        }
        if (!changes.changed.containsKey(key) && !changes.added.contains(key)) {
            if (allData != null) {
                changes.changed.put(key, allData);
            } else {
                changes.added.add(key);
            }
        }
    }

    private static class ChangeInfo {
        Map changed = new HashMap();
        Set added = new HashSet();

        private ChangeInfo() {
        }
    }
}

