/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jdk.jshell.SourceCodeAnalysis;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.modules.jshell.editor.HistoryCompletionProvider;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.JShellToken;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.parsing.JShellLexer;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.modules.jshell.tool.JShellTool;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class CommandCompletionProvider
implements CompletionProvider {
    private static final String ICON_JAR = "org/netbeans/modules/jshell/resources/jar.png";
    private static final String ICON_FILE = "org/netbeans/modules/jshell/resources/file.png";
    private static final String ICON_FOLDER = "org/netbeans/modules/jshell/resources/folder.png";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        int a = HistoryCompletionProvider.isFirstJavaLine(component);
        if (queryType != 9 && queryType != 1 || HistoryCompletionProvider.isFirstJavaLine(component) == -1) {
            return null;
        }
        ShellSession session = HistoryCompletionProvider.checkInputSection(component);
        if (session == null) {
            return null;
        }
        return new AsyncCompletionTask((AsyncCompletionQuery)new T(session, session.getModel(), session.getModel().getInputSection()), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private void completeClasspathParameter(CompletionResultSet results, Document doc, int caretOffset) {
    }

    private static class CommandCompletionItem
    implements CompletionItem,
    CompletionDocumentation {
        private final int fromOffset;
        private final String command;
        private final ShellSession session;
        private final boolean lowerPriority;

        public CommandCompletionItem(ShellSession session, int fromOffset, String command, boolean lowerPriority) {
            this.fromOffset = fromOffset;
            this.command = command;
            this.session = session;
            this.lowerPriority = lowerPriority;
        }

        public void defaultAction(JTextComponent component) {
            if (component == null) {
                return;
            }
            Completion.get().hideAll();
            Document doc = component.getDocument();
            if (doc == null) {
                return;
            }
            int caret = component.getCaretPosition();
            int l = caret - this.fromOffset;
            try {
                doc.insertString(this.fromOffset, "/" + this.command + " ", null);
                doc.remove(this.fromOffset + this.command.length() + 2, l);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void processKeyEvent(KeyEvent evt) {
        }

        private ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jshell/resources/jshell-command.png", (boolean)false);
        }

        public String getLeftHtmlText() {
            return Bundle.Completion_CommandTemplate(this.command);
        }

        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), null, (Graphics)g, (Font)defaultFont);
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        public CompletionTask createDocumentationTask() {
            JShellTool tool = this.session.getJShellTool();
            return tool == null ? null : new CommandDocumentationTask(tool, this.command);
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public int getSortPriority() {
            return this.lowerPriority ? 3000 : 500;
        }

        public CharSequence getSortText() {
            return this.getInsertPrefix();
        }

        public CharSequence getInsertPrefix() {
            return "/" + this.command;
        }

        public String getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class ToolCompletionItem
    implements CompletionItem {
        protected final String insertText;
        private final int insertAt;
        private final int delete;
        protected final ShellSession session;
        protected final boolean lowerPriority;

        public ToolCompletionItem(String insertText, int insertAt, int delete, ShellSession session, boolean empty) {
            this.insertText = insertText;
            this.insertAt = insertAt;
            this.delete = delete;
            this.session = session;
            this.lowerPriority = empty;
        }

        protected boolean closeCompletion() {
            return true;
        }

        public void defaultAction(JTextComponent component) {
            Document doc = component.getDocument();
            try {
                doc.insertString(this.insertAt, this.insertText, null);
                doc.remove(this.insertAt + this.insertText.length(), this.delete);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.closeCompletion()) {
                Completion.get().hideAll();
            }
        }

        protected ImageIcon getIcon() {
            return null;
        }

        protected String getLeftHtmlText() {
            return this.insertText;
        }

        public void processKeyEvent(KeyEvent evt) {
        }

        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), null, (Graphics)g, (Font)defaultFont);
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public int getSortPriority() {
            return this.lowerPriority ? 3000 : 500;
        }

        public CharSequence getSortText() {
            return this.insertText;
        }

        public CharSequence getInsertPrefix() {
            return this.insertText;
        }
    }

    private static class OptionCompletionItem
    extends ToolCompletionItem {
        private final String command;

        public OptionCompletionItem(String insertText, int insertAt, int delete, ShellSession session, String command) {
            super(insertText, insertAt, delete, session, false);
            this.command = command;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<b>" + this.insertText + "</b>";
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new OptionDocumentationTask(this.session, this.command, this.insertText.substring(1));
        }
    }

    private static class OptionDocumentationTask
    implements CompletionTask,
    CompletionDocumentation {
        final ShellSession session;
        final String command;
        final String option;
        String htmlText;

        public OptionDocumentationTask(ShellSession session, String command, String option) {
            this.session = session;
            this.command = command;
            this.option = option;
        }

        public void query(CompletionResultSet resultSet) {
            String cmd = "/" + this.command + " ";
            String doc = this.session.getJShellTool().commandDocumentation(cmd, cmd.length(), false);
            String[] lines = doc.split("\n");
            StringBuilder htmlStringContents = new StringBuilder();
            String match = "^/" + this.command + ".*-" + this.option;
            Pattern p = Pattern.compile(match);
            String endMarker = "/" + this.command;
            boolean copy = false;
            for (String l : lines) {
                if (copy) {
                    if (l.trim().startsWith(endMarker)) break;
                    String l2 = l.trim();
                    if (l2.isEmpty()) {
                        htmlStringContents.append("<p/>");
                    } else {
                        htmlStringContents.append(l).append(" ");
                    }
                }
                if (!p.matcher(l).find()) continue;
                copy = true;
                htmlStringContents.append("<b>").append(l).append("</b><br/>");
            }
            this.htmlText = htmlStringContents.toString();
            resultSet.setDocumentation((CompletionDocumentation)this);
            resultSet.finish();
        }

        public void refresh(CompletionResultSet resultSet) {
            this.query(resultSet);
        }

        public void cancel() {
        }

        public String getText() {
            return this.htmlText;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class CommandDocumentationTask
    implements CompletionTask,
    CompletionDocumentation {
        final JShellTool shellTool;
        final String command;
        String htmlText;

        public CommandDocumentationTask(JShellTool shellTool, String command) {
            this.shellTool = shellTool;
            this.command = command;
        }

        public void query(CompletionResultSet resultSet) {
            String cmd = "/" + this.command + " ";
            String doc = this.shellTool.commandDocumentation(cmd, cmd.length(), false);
            if (doc == null) {
                resultSet.finish();
                return;
            }
            String[] lines = doc.split("\n");
            StringBuilder htmlStringContents = new StringBuilder();
            String match = "^/" + this.command;
            Pattern p = Pattern.compile(match);
            boolean paragraph = false;
            for (String l : lines) {
                String l2 = l.trim();
                if (l2.isEmpty() && !paragraph) {
                    htmlStringContents.append("<p/>");
                    paragraph = true;
                } else {
                    paragraph = false;
                }
                if (p.matcher(l).find()) {
                    htmlStringContents.append("<code><pre><b>").append(l).append("</b></pre></code><br/>");
                    continue;
                }
                String emphasis = l.replaceAll("(/\\p{Alpha}+)", "<code><i><u>$1</u></i><code>");
                htmlStringContents.append(emphasis).append(" ");
            }
            this.htmlText = htmlStringContents.toString();
            resultSet.setDocumentation((CompletionDocumentation)this);
            resultSet.finish();
        }

        public void refresh(CompletionResultSet resultSet) {
        }

        public void cancel() {
        }

        public String getText() {
            return this.htmlText;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class FileCompletionItem
    extends ToolCompletionItem {
        private final Path basePath;
        private final String fileResource;
        private ImageIcon icon;

        public FileCompletionItem(String insertText, int insertAt, int delete, ShellSession session, String fileResource, Path basePath) {
            super(insertText, insertAt, delete, session, false);
            this.fileResource = fileResource;
            this.basePath = basePath;
        }

        @Override
        protected boolean closeCompletion() {
            return !this.insertText.endsWith("/");
        }

        @Override
        protected String getLeftHtmlText() {
            int from = this.insertText.endsWith("/") ? this.insertText.length() - 2 : this.insertText.length() - 1;
            int lastSlash = this.insertText.lastIndexOf("/", from);
            if (lastSlash == 0 || lastSlash + 1 > from) {
                return this.insertText;
            }
            return this.insertText.substring(lastSlash + 1);
        }

        @Override
        protected ImageIcon getIcon() {
            FileObject f;
            if (this.insertText.endsWith("/")) {
                return ImageUtilities.loadImageIcon((String)CommandCompletionProvider.ICON_FOLDER, (boolean)false);
            }
            if (this.fileResource != null) {
                return ImageUtilities.loadImageIcon((String)this.fileResource, (boolean)true);
            }
            if (this.icon != null) {
                return this.icon;
            }
            Path p = this.basePath.resolve(this.insertText);
            if (p != null && (f = FileUtil.toFileObject((File)p.toFile())) != null) {
                Node n;
                try {
                    DataObject d = DataObject.find((FileObject)f);
                    n = d.getNodeDelegate();
                }
                catch (DataObjectNotFoundException ex) {
                    n = (Node)f.getLookup().lookup(Node.class);
                }
                if (n != null) {
                    return new ImageIcon(n.getIcon(1));
                }
            }
            this.icon = ImageUtilities.loadImageIcon((String)CommandCompletionProvider.ICON_FILE, (boolean)false);
            return this.icon;
        }
    }

    private static class T
    extends AsyncCompletionQuery {
        private final ShellSession session;
        private final ConsoleModel model;
        private final ConsoleSection section;

        public T(ShellSession session, ConsoleModel model, ConsoleSection section) {
            this.session = session;
            this.model = model;
            this.section = section;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                this.query2(resultSet, doc, caretOffset);
            }
            finally {
                resultSet.finish();
            }
        }

        private void query2(CompletionResultSet resultSet, Document doc, int caretOffset) {
            String cmdName;
            Object prefix;
            Rng[] ranges = this.section.getAllSnippetBounds();
            if (ranges == null || ranges.length == 0) {
                return;
            }
            if (ranges.length > 1 && caretOffset >= ranges[0].end) {
                return;
            }
            int s = ranges[0].start;
            int l = caretOffset - s;
            try {
                prefix = doc.getText(s, l);
            }
            catch (BadLocationException ex) {
                return;
            }
            if (((String)prefix).isEmpty()) {
                this.completeCommand(resultSet, "", s);
            }
            if (!((String)prefix).startsWith("/")) {
                return;
            }
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence seq = th.tokenSequence(JShellToken.language());
            if (seq == null || !seq.isValid()) {
                return;
            }
            Token tukac = null;
            seq.move(s);
            if (!seq.moveNext()) {
                return;
            }
            tukac = seq.token();
            if (tukac.id() == JShellToken.ERR_COMMAND && caretOffset <= seq.offset() + tukac.length()) {
                this.completeCommand(resultSet, tukac.text().toString(), s);
                return;
            }
            if (tukac.id() != JShellToken.COMMAND) {
                return;
            }
            String partName = tukac.text().toString().substring(1);
            boolean inCommand = caretOffset <= seq.offset() + tukac.length();
            List<String> candidates = JShellLexer.getCommandsFromPrefix(partName);
            if (candidates.size() > 1) {
                if (inCommand) {
                    this.completeCommand(resultSet, tukac.text().toString(), s);
                }
                return;
            }
            if (candidates.size() == 1) {
                cmdName = candidates.get(0);
                if (inCommand && !partName.equals(candidates.get(0))) {
                    this.completeCommand(resultSet, tukac.text().toString(), s);
                    prefix = (String)prefix + " ";
                }
            } else {
                return;
            }
            if (seq.move(caretOffset) > 0) {
                if (!seq.moveNext()) {
                    return;
                }
            } else {
                seq.movePrevious();
            }
            tukac = seq.token();
            String sectionContents = this.section.getContents(doc);
            int sectionOffset = caretOffset - s;
            int sectionTokenStart = seq.offset() - s;
            if (tukac.id() == JShellToken.WHITESPACE) {
                sectionTokenStart = -1;
            }
            int[] anchor = new int[1];
            if (this.isTaskCancelled()) {
                return;
            }
            if (sectionContents.length() < sectionOffset) {
                try {
                    sectionContents = doc.getText(s, doc.getLength() - s);
                }
                catch (BadLocationException ex) {
                    return;
                }
            }
            List<SourceCodeAnalysis.Suggestion> suggestions = this.session.getJShellTool().commandCompletionSuggestions(sectionContents, sectionOffset, anchor);
            boolean onlyOptions = true;
            int insertAt = anchor[0] + s;
            int deleteLen = sectionOffset - anchor[0];
            prefix = sectionContents.substring(anchor[0], anchor[0] + deleteLen);
            ArrayList<ToolCompletionItem> otherItems = new ArrayList<ToolCompletionItem>();
            block12: for (SourceCodeAnalysis.Suggestion sugItem : suggestions) {
                String text = sugItem.continuation();
                if (text.trim().equals("/" + cmdName)) continue;
                if (onlyOptions) {
                    if (text.startsWith("-")) {
                        resultSet.addItem((CompletionItem)new OptionCompletionItem(text, insertAt, deleteLen, this.session, cmdName));
                        continue;
                    }
                    onlyOptions = false;
                }
                switch (cmdName) {
                    case "open": 
                    case "save": 
                    case "classpath": {
                        Path p = this.session.resolvePath(sectionTokenStart == -1 ? "" : sectionContents.substring(sectionTokenStart, anchor[0]));
                        otherItems.add(new FileCompletionItem(text, insertAt, deleteLen, this.session, CommandCompletionProvider.ICON_JAR, p));
                        continue block12;
                    }
                }
                otherItems.add(new ToolCompletionItem(text, insertAt, deleteLen, this.session, false));
            }
            resultSet.addAllItems(otherItems);
        }

        private void completeCommand(CompletionResultSet resultSet, String prefix, int startAt) {
            if (prefix.startsWith("/")) {
                prefix = prefix.substring(1).trim();
            }
            List<String> candidates = JShellLexer.getCommandsFromPrefix(prefix);
            for (String s : candidates) {
                resultSet.addItem((CompletionItem)new CommandCompletionItem(this.session, startAt, s, prefix.length() < 2));
            }
        }
    }
}

