/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.actions.IconsUtils;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.model.CaseElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;

public final class NavigatorScanner {
    private static final Logger LOGGER = Logger.getLogger(NavigatorScanner.class.getName());
    private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
    private static final String FONT_INHERITED_COLOR = "<font color=\"#7D694A\">";
    private static final String CLOSE_FONT = "</font>";
    private static ImageIcon interfaceIcon = null;
    private static ImageIcon traitIcon = null;
    private static ImageIcon enumIcon = null;
    private static ImageIcon enumCaseIcon = null;
    private static boolean isLogged = false;
    private final FileScope fileScope;
    private final Set<TypeElement> deprecatedTypes;
    private static final Comparator<TraitScope> TRAIT_SCOPE_COMPARATOR = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());

    public static NavigatorScanner create(Model model, boolean resolveDeprecatedElements) {
        return new NavigatorScanner(model, resolveDeprecatedElements);
    }

    private NavigatorScanner(Model model, boolean resolveDeprecatedElements) {
        this.fileScope = model.getFileScope();
        if (resolveDeprecatedElements) {
            if (!isLogged) {
                LOGGER.info("Resolving of deprecated elements in Navigator scanner - IDE will be possibly slow!");
                isLogged = true;
            }
            this.deprecatedTypes = ElementFilter.forDeprecated(true).filter(model.getIndexScope().getIndex().getTypes(NameKind.empty()));
        } else {
            this.deprecatedTypes = Collections.emptySet();
        }
    }

    public List<? extends StructureItem> scan() {
        ArrayList<StructureItem> items = new ArrayList<StructureItem>();
        this.processNamespaces(items, this.fileScope.getDeclaredNamespaces());
        return items;
    }

    private void processNamespaces(List<StructureItem> items, Collection<? extends NamespaceScope> declaredNamespaces) {
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            ArrayList<StructureItem> namespaceChildren;
            ArrayList<StructureItem> arrayList = namespaceChildren = namespaceScope.isDefaultNamespace() ? items : new ArrayList<StructureItem>();
            if (!namespaceScope.isDefaultNamespace()) {
                items.add(new PHPNamespaceStructureItem(namespaceScope, namespaceChildren));
            }
            Collection<? extends UseScope> declaredUses = namespaceScope.getAllDeclaredSingleUses();
            for (UseScope useScope : declaredUses) {
                namespaceChildren.add(new PHPUseStructureItem(useScope));
            }
            Collection<? extends FunctionScope> declaredFunctions = namespaceScope.getDeclaredFunctions();
            for (FunctionScope fnc : declaredFunctions) {
                if (fnc.isAnonymous()) continue;
                ArrayList arrayList2 = new ArrayList();
                namespaceChildren.add(new PHPFunctionStructureItem(fnc, arrayList2));
            }
            Collection<? extends ConstantElement> collection = namespaceScope.getDeclaredConstants();
            for (ConstantElement constantElement : collection) {
                namespaceChildren.add(new PHPConstantStructureItem(constantElement, "const"));
            }
            this.processTypes(items, namespaceChildren, namespaceScope.getDeclaredTypes());
        }
    }

    private void processTypes(List<StructureItem> items, List<StructureItem> namespaceChildren, Collection<? extends TypeScope> declaredTypes) {
        for (TypeScope typeScope : declaredTypes) {
            Object variables;
            ArrayList<PHPStructureItem> children = new ArrayList<PHPStructureItem>();
            if (typeScope instanceof ClassScope) {
                namespaceChildren.add(new PHPClassStructureItem((ClassScope)typeScope, children));
            } else if (typeScope instanceof InterfaceScope) {
                namespaceChildren.add(new PHPInterfaceStructureItem((InterfaceScope)typeScope, children));
            } else if (typeScope instanceof TraitScope) {
                namespaceChildren.add(new PHPTraitStructureItem((TraitScope)typeScope, children));
            } else if (typeScope instanceof EnumScope) {
                namespaceChildren.add(new PHPEnumStructureItem((EnumScope)typeScope, children));
            }
            HashSet<String> declMethodNames = new HashSet<String>();
            Collection<? extends MethodScope> declaredMethods = typeScope.getDeclaredMethods();
            for (MethodScope methodScope : declaredMethods) {
                if (methodScope.getName() == null || methodScope.getName().isEmpty()) continue;
                variables = new ArrayList();
                if (methodScope.isConstructor()) {
                    children.add(new PHPConstructorStructureItem(methodScope, (List<? extends StructureItem>)variables));
                } else {
                    children.add(new PHPMethodStructureItem(methodScope, (List<? extends StructureItem>)variables));
                }
                declMethodNames.add(methodScope.getName());
            }
            for (MethodScope methodScope : typeScope.getInheritedMethods()) {
                if (methodScope.getName().isEmpty() || declMethodNames.contains(methodScope.getName())) continue;
                variables = new ArrayList();
                if (methodScope.isConstructor()) {
                    children.add(new PHPConstructorStructureItem(methodScope, (List<? extends StructureItem>)variables, true));
                    continue;
                }
                children.add(new PHPMethodStructureItem(methodScope, (List<? extends StructureItem>)variables, true));
            }
            HashSet<String> declClsConstantNames = new HashSet<String>();
            Collection<? extends ClassConstantElement> collection = typeScope.getDeclaredConstants();
            for (ClassConstantElement classConstantElement : collection) {
                children.add(new PHPClassConstantStructureItem(classConstantElement, "con"));
                declClsConstantNames.add(classConstantElement.getName());
            }
            for (ClassConstantElement classConstantElement : typeScope.getInheritedConstants()) {
                if (declClsConstantNames.contains(classConstantElement.getName())) continue;
                children.add(new PHPClassConstantStructureItem(classConstantElement, "con", true));
            }
            if (typeScope instanceof ClassScope) {
                ClassScope cls = (ClassScope)typeScope;
                HashSet<String> hashSet = new HashSet<String>();
                Collection<? extends FieldElement> declaredFields = cls.getDeclaredFields();
                for (FieldElement fieldElement : declaredFields) {
                    children.add(new PHPFieldStructureItem(fieldElement));
                    hashSet.add(fieldElement.getName());
                }
                for (FieldElement fieldElement : cls.getInheritedFields()) {
                    if (hashSet.contains(fieldElement.getName())) continue;
                    children.add(new PHPFieldStructureItem(fieldElement, true));
                }
            }
            if (typeScope instanceof TraitScope) {
                TraitScope trait = (TraitScope)typeScope;
                Collection<? extends FieldElement> collection2 = trait.getDeclaredFields();
                for (FieldElement fieldElement : collection2) {
                    children.add(new PHPFieldStructureItem(fieldElement));
                }
            }
            if (!(typeScope instanceof EnumScope)) continue;
            EnumScope enumScope = (EnumScope)typeScope;
            Collection<? extends CaseElement> collection3 = enumScope.getDeclaredEnumCases();
            for (CaseElement caseElement : collection3) {
                children.add(new PHPEnumCaseStructureItem(caseElement, "ecase"));
                declClsConstantNames.add(caseElement.getName());
            }
        }
    }

    private boolean isDeprecatedType(String type, ModelElement modelElement) {
        boolean result = false;
        String typeName = CodeUtils.removeNullableTypePrefix(type);
        QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(typeName), modelElement.getOffset(), modelElement.getInScope());
        for (TypeElement typeElement : this.deprecatedTypes) {
            if (!typeElement.getFullyQualifiedName().equals(fullyQualifiedName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void processTypeName(StringBuilder sb, ModelElement modelElement, HtmlFormatter formatter) {
        String type = sb.toString();
        if (sb.length() > 0) {
            sb.delete(0, sb.length());
            this.processTypeName(type, modelElement, formatter);
        }
    }

    private void processTypeName(String type, ModelElement element, HtmlFormatter formatter) {
        String typeName;
        boolean deprecatedType;
        if (CodeUtils.isNullableType(type)) {
            formatter.appendText("?");
        }
        if (deprecatedType = this.isDeprecatedType(typeName = CodeUtils.removeNullableTypePrefix(type), element)) {
            formatter.deprecated(true);
        }
        formatter.appendText(typeName);
        if (deprecatedType) {
            formatter.deprecated(false);
        }
    }

    protected void appendName(ModelElement modelElement, HtmlFormatter formatter) {
        String name = modelElement.getName();
        if (CodeUtils.isSyntheticTypeName(name)) {
            name = "{}";
        }
        if (modelElement.isDeprecated()) {
            formatter.deprecated(true);
            formatter.appendText(name);
            formatter.deprecated(false);
        } else {
            formatter.appendText(name);
        }
    }

    private class PHPConstructorStructureItem
    extends PHPStructureInheritedItem {
        public PHPConstructorStructureItem(MethodScope elementHandle, List<? extends StructureItem> children) {
            this(elementHandle, children, false);
        }

        public PHPConstructorStructureItem(MethodScope elementHandle, List<? extends StructureItem> children, boolean isInherited) {
            super(elementHandle, children, "con", isInherited);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), formatter, this.isInherited());
            return formatter.getText();
        }
    }

    private class PHPEnumCaseStructureItem
    extends PHPStructureItem {
        public PHPEnumCaseStructureItem(CaseElement elementHandle, String prefix) {
            super(elementHandle, null, prefix);
        }

        public CaseElement getEnumCase() {
            return (CaseElement)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            CaseElement enumCase;
            String value;
            formatter.reset();
            if (this.getEnumCase().isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(this.getName());
            if (this.getEnumCase().isDeprecated()) {
                formatter.deprecated(false);
            }
            if ((value = (enumCase = this.getEnumCase()).getValue()) != null) {
                formatter.appendText(" ");
                formatter.appendHtml(NavigatorScanner.FONT_GRAY_COLOR);
                formatter.appendText(value);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (enumCaseIcon == null) {
                enumCaseIcon = IconsUtils.loadEnumCaseIcon();
            }
            return enumCaseIcon;
        }
    }

    private class PHPEnumStructureItem
    extends PHPStructureItem {
        private final Collection<? extends InterfaceScope> interfaces;
        private final Collection<? extends TraitScope> usedTraits;
        private final QualifiedName backingType;

        public PHPEnumStructureItem(ModelElement elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
            this.interfaces = this.getEnumScope().getSuperInterfaceScopes();
            this.usedTraits = this.getEnumScope().getTraits();
            this.backingType = this.getEnumScope().getBackingType();
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (enumIcon == null) {
                enumIcon = IconsUtils.loadEnumIcon();
            }
            return enumIcon;
        }

        private EnumScope getEnumScope() {
            return (EnumScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            NavigatorScanner.this.appendName(this.getEnumScope(), formatter);
            if (this.backingType != null) {
                formatter.appendHtml("<font color=\"#999999\">(");
                formatter.appendText(this.backingType.toString());
                formatter.appendHtml(")</font>");
            }
            if (this.interfaces != null && !this.interfaces.isEmpty()) {
                formatter.appendHtml("<font color=\"#999999\">:");
                this.appendInterfaces(this.interfaces, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            if (this.usedTraits != null && !this.usedTraits.isEmpty()) {
                formatter.appendHtml("<font color=\"#999999\">#");
                this.appendUsedTraits(this.usedTraits, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPTraitStructureItem
    extends PHPStructureItem {
        private final Collection<? extends TraitScope> usedTraits;

        public PHPTraitStructureItem(ModelElement elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
            this.usedTraits = this.getTraitScope().getTraits();
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (traitIcon == null) {
                traitIcon = IconsUtils.loadTraitIcon();
            }
            return traitIcon;
        }

        private TraitScope getTraitScope() {
            return (TraitScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            NavigatorScanner.this.appendName(this.getTraitScope(), formatter);
            if (this.usedTraits != null && this.usedTraits.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">#");
                this.appendUsedTraits(this.usedTraits, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPInterfaceStructureItem
    extends PHPStructureItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";
        private final Collection<? extends InterfaceScope> interfaces;

        public PHPInterfaceStructureItem(InterfaceScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
            this.interfaces = this.getInterfaceScope().getSuperInterfaceScopes();
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (interfaceIcon == null) {
                interfaceIcon = IconsUtils.loadInterfaceIcon();
            }
            return interfaceIcon;
        }

        private InterfaceScope getInterfaceScope() {
            return (InterfaceScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            NavigatorScanner.this.appendName(this.getInterfaceScope(), formatter);
            if (this.interfaces != null && this.interfaces.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">::");
                this.appendInterfaces(this.interfaces, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPMethodStructureItem
    extends PHPStructureInheritedItem {
        public PHPMethodStructureItem(MethodScope elementHandle, List<? extends StructureItem> children) {
            this(elementHandle, children, false);
        }

        public PHPMethodStructureItem(MethodScope elementHandle, List<? extends StructureItem> children, boolean isInherited) {
            super(elementHandle, children, "fn", isInherited);
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), formatter, this.isInherited());
            return formatter.getText();
        }
    }

    private class PHPFunctionStructureItem
    extends PHPStructureItem {
        public PHPFunctionStructureItem(FunctionScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "fn");
        }

        public FunctionScope getFunctionScope() {
            return (FunctionScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getFunctionScope(), formatter);
            return formatter.getText();
        }
    }

    private class PHPClassConstantStructureItem
    extends PHPConstantStructureItem
    implements StructureItem.InheritedItem {
        private boolean isInherited;

        public PHPClassConstantStructureItem(ConstantElement elementHandle, String prefix) {
            this(elementHandle, prefix, false);
        }

        public PHPClassConstantStructureItem(ConstantElement elementHandle, String prefix, boolean isInherited) {
            super(elementHandle, prefix);
            this.isInherited = isInherited;
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public ElementHandle getDeclaringElement() {
            return this.getConstant().getInScope();
        }

        @Override
        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendConstantDescription(this.getConstant(), formatter, this.isInherited());
            return formatter.getText();
        }
    }

    private class PHPConstantStructureItem
    extends PHPStructureItem {
        public PHPConstantStructureItem(ConstantElement elementHandle, String prefix) {
            super(elementHandle, null, prefix);
        }

        public ConstantElement getConstant() {
            return (ConstantElement)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendConstantDescription(this.getConstant(), formatter);
            return formatter.getText();
        }
    }

    private class PHPClassStructureItem
    extends PHPStructureItem {
        private final String superClassName;
        private final Collection<? extends InterfaceScope> interfaces;
        private final Collection<? extends TraitScope> usedTraits;

        public PHPClassStructureItem(ClassScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
            this.superClassName = ModelUtils.getFirst(this.getClassScope().getSuperClassNames());
            this.interfaces = this.getClassScope().getSuperInterfaceScopes();
            this.usedTraits = this.getClassScope().getTraits();
        }

        private ClassScope getClassScope() {
            return (ClassScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            NavigatorScanner.this.appendName(this.getClassScope(), formatter);
            if (this.superClassName != null) {
                formatter.appendHtml("<font color=\"#999999\">::");
                formatter.appendText(this.superClassName);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            if (this.interfaces != null && this.interfaces.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">:");
                this.appendInterfaces(this.interfaces, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            if (this.usedTraits != null && this.usedTraits.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">#");
                this.appendUsedTraits(this.usedTraits, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPUseStructureItem
    extends PHPStructureItem {
        public PHPUseStructureItem(UseScope elementHandle) {
            super(elementHandle, null, "aaaa_use");
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            UseScope useElement = (UseScope)this.getElementHandle();
            String name = this.getName();
            boolean deprecatedType = NavigatorScanner.this.isDeprecatedType(name, useElement);
            if (deprecatedType) {
                formatter.deprecated(true);
            }
            formatter.appendText(name);
            AliasedName aliasedName = useElement.getAliasedName();
            if (aliasedName != null) {
                formatter.appendText(" as ");
                formatter.appendText(aliasedName.getAliasName());
            }
            if (deprecatedType) {
                formatter.deprecated(false);
            }
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RULE;
        }
    }

    private class PHPNamespaceStructureItem
    extends PHPStructureItem {
        public PHPNamespaceStructureItem(NamespaceScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "namespace");
        }

        public NamespaceScope getNamespaceScope() {
            return (NamespaceScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            if (this.getNamespaceScope().isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(this.getName());
            if (this.getNamespaceScope().isDeprecated()) {
                formatter.deprecated(false);
            }
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.MODULE;
        }
    }

    private class PHPSimpleStructureItem
    extends PHPStructureItem {
        private String simpleText;

        public PHPSimpleStructureItem(ModelElement elementHandle, String prefix) {
            super(elementHandle, null, prefix);
            this.simpleText = elementHandle.getName();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.appendText(this.simpleText);
            return formatter.getText();
        }
    }

    private class PHPFieldStructureItem
    extends PHPSimpleStructureItem
    implements StructureItem.InheritedItem {
        private final boolean isInherited;

        public PHPFieldStructureItem(FieldElement elementHandle) {
            this(elementHandle, false);
        }

        public PHPFieldStructureItem(FieldElement elementHandle, boolean isInherited) {
            super(elementHandle, "field");
            this.isInherited = isInherited;
        }

        public FieldElement getField() {
            return (FieldElement)this.getElementHandle();
        }

        @Override
        public String getHtml(HtmlFormatter formatter) {
            FieldElement field = this.getField();
            if (field.isDeprecated()) {
                formatter.deprecated(true);
            }
            if (this.isInherited()) {
                formatter.appendHtml(NavigatorScanner.FONT_INHERITED_COLOR);
            }
            formatter.appendText(field.getName());
            if (this.isInherited()) {
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            if (field.isDeprecated()) {
                formatter.deprecated(false);
            }
            if (StringUtils.hasText((String)field.getDefaultType())) {
                this.processDeclaredType(field, formatter, field.getDefaultType(), false);
            }
            return formatter.getText();
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public ElementHandle getDeclaringElement() {
            return this.getField().getInScope();
        }
    }

    private abstract class PHPStructureInheritedItem
    extends PHPStructureItem
    implements StructureItem.InheritedItem {
        private final boolean isInherited;

        public PHPStructureInheritedItem(ModelElement elementHandle, List<? extends StructureItem> children, String sortPrefix, boolean isInherited) {
            super(elementHandle, children, sortPrefix);
            this.isInherited = isInherited;
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public ElementHandle getDeclaringElement() {
            return this.getModelElement().getInScope();
        }
    }

    private abstract class PHPStructureItem
    implements StructureItem {
        private final ModelElement modelElement;
        private final List<? extends StructureItem> children;
        private final String sortPrefix;

        public PHPStructureItem(ModelElement elementHandle, List<? extends StructureItem> children, String sortPrefix) {
            this.modelElement = elementHandle;
            this.sortPrefix = sortPrefix;
            this.children = children != null ? children : Collections.emptyList();
        }

        public boolean equals(Object obj) {
            PHPStructureItem item;
            boolean thesame = false;
            if (obj instanceof PHPStructureItem && (item = (PHPStructureItem)obj).getName() != null && this.getName() != null) {
                thesame = item.modelElement.getName().equals(this.modelElement.getName()) && item.modelElement.getOffset() == this.modelElement.getOffset();
            }
            return thesame;
        }

        public int hashCode() {
            int hashCode = 11;
            if (this.getName() != null) {
                hashCode = 31 * this.getName().hashCode() + hashCode;
            }
            hashCode = (int)(31L * this.getPosition() + (long)hashCode);
            return hashCode;
        }

        public String getName() {
            return this.modelElement.getName();
        }

        public String getSortText() {
            return this.sortPrefix + this.modelElement.getName();
        }

        public ElementHandle getElementHandle() {
            return this.modelElement.getPHPElement();
        }

        public ModelElement getModelElement() {
            return this.modelElement;
        }

        public ElementKind getKind() {
            return this.modelElement.getPHPElement().getKind();
        }

        public Set<Modifier> getModifiers() {
            return this.modelElement.getPHPElement().getModifiers();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.modelElement.getOffset();
        }

        public long getEndPosition() {
            OffsetRange blockRange;
            if (this.modelElement instanceof Scope && (blockRange = ((Scope)this.modelElement).getBlockRange()) != null) {
                return blockRange.getEnd();
            }
            return this.modelElement.getNameRange().getEnd();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        protected void appendInterfaces(Collection<? extends InterfaceScope> interfaes, HtmlFormatter formatter) {
            boolean first = true;
            for (InterfaceScope interfaceScope : interfaes) {
                if (interfaceScope == null) continue;
                if (!first) {
                    formatter.appendText(", ");
                } else {
                    first = false;
                }
                NavigatorScanner.this.appendName(interfaceScope, formatter);
            }
        }

        protected void appendUsedTraits(Collection<? extends TraitScope> usedTraits, HtmlFormatter formatter) {
            boolean first = true;
            ArrayList<? extends TraitScope> traits = new ArrayList<TraitScope>(usedTraits);
            Collections.sort(traits, TRAIT_SCOPE_COMPARATOR);
            for (TraitScope traitScope : traits) {
                if (!first) {
                    formatter.appendText(", ");
                } else {
                    first = false;
                }
                NavigatorScanner.this.appendName(traitScope, formatter);
            }
        }

        protected void appendConstantDescription(ConstantElement constant, HtmlFormatter formatter) {
            this.appendConstantDescription(constant, formatter, false);
        }

        protected void appendConstantDescription(ConstantElement constant, HtmlFormatter formatter, boolean isInherited) {
            String value;
            ClassConstantElement classConstant;
            if (constant.isDeprecated()) {
                formatter.deprecated(true);
            }
            if (isInherited) {
                formatter.appendHtml(NavigatorScanner.FONT_INHERITED_COLOR);
            }
            formatter.appendText(this.getName());
            if (isInherited) {
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            if (constant.isDeprecated()) {
                formatter.deprecated(false);
            }
            if (constant instanceof ClassConstantElement && StringUtils.hasText((String)(classConstant = (ClassConstantElement)constant).getDeclaredType())) {
                this.processDeclaredType(classConstant, formatter, classConstant.getDeclaredType(), false);
            }
            if ((value = constant.getValue()) != null) {
                formatter.appendText(" ");
                formatter.appendHtml(NavigatorScanner.FONT_GRAY_COLOR);
                formatter.appendText(value);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
        }

        protected void appendFunctionDescription(FunctionScope function, HtmlFormatter formatter) {
            this.appendFunctionDescription(function, formatter, false);
        }

        protected void appendFunctionDescription(FunctionScope function, HtmlFormatter formatter, boolean isInherited) {
            formatter.reset();
            if (function == null) {
                return;
            }
            if (isInherited) {
                formatter.appendHtml(NavigatorScanner.FONT_INHERITED_COLOR);
            }
            if (function.isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(function.getName());
            if (function.isDeprecated()) {
                formatter.deprecated(false);
            }
            formatter.appendText("(");
            List<? extends ParameterElement> parameters = function.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                this.processParameters(function, formatter, parameters);
            }
            formatter.appendText(")");
            if (isInherited) {
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            Collection<? extends String> returnTypes = function.getReturnTypeNames();
            String declaredReturnType = function.getDeclaredReturnType();
            if (StringUtils.hasText((String)declaredReturnType)) {
                this.processReturnTypes(function, formatter, declaredReturnType);
            } else if (!returnTypes.isEmpty()) {
                this.processReturnTypes(function, formatter, returnTypes);
            }
        }

        private void processParameters(FunctionScope function, HtmlFormatter formatter, List<? extends ParameterElement> parameters) {
            boolean first = true;
            for (ParameterElement parameterElement : parameters) {
                String name = parameterElement.getName();
                Set<TypeResolver> types = parameterElement.getTypes();
                if (name == null) continue;
                if (!first) {
                    formatter.appendText(", ");
                }
                if (parameterElement.hasDeclaredType()) {
                    this.processDeclaredType(function, formatter, parameterElement.getDeclaredType(), false);
                } else if (parameterElement.getPhpdocType() != null) {
                    this.processDeclaredType(function, formatter, parameterElement.getPhpdocType(), false);
                } else assert (types.isEmpty()) : function.getName() + " has " + types.size() + " parameter(s)";
                formatter.appendText(name);
                first = false;
            }
        }

        private void processReturnTypes(FunctionScope function, HtmlFormatter formatter, Collection<? extends String> returnTypes) {
            formatter.appendHtml("<font color=\"#999999\">:");
            HashSet ignoredTypes = new HashSet();
            returnTypes.stream().filter(returnType -> CodeUtils.isNullableType(returnType)).forEach(returnType -> ignoredTypes.add(returnType.substring(1)));
            int i = 0;
            for (String string : returnTypes) {
                if (ignoredTypes.contains(string)) continue;
                if (++i > 1) {
                    formatter.appendText(Type.getTypeSeparator(function.isReturnIntersectionType()));
                }
                NavigatorScanner.this.processTypeName(string, function, formatter);
            }
            formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
        }

        private void processReturnTypes(FunctionScope function, HtmlFormatter formatter, @NullAllowed String declaredReturnType) {
            this.processDeclaredType(function, formatter, declaredReturnType, true);
        }

        protected void processDeclaredType(ModelElement modelElement, HtmlFormatter formatter, @NullAllowed String declaredType, boolean isReturn) {
            if (declaredType == null) {
                return;
            }
            if (isReturn || modelElement instanceof FieldElement || modelElement instanceof ClassConstantElement) {
                formatter.appendHtml("<font color=\"#999999\">:");
            } else {
                formatter.appendHtml(NavigatorScanner.FONT_GRAY_COLOR);
            }
            StringBuilder sb = new StringBuilder(declaredType.length());
            block4: for (int i = 0; i < declaredType.length(); ++i) {
                char c = declaredType.charAt(i);
                switch (c) {
                    case '(': 
                    case '?': {
                        formatter.appendText(String.valueOf(c));
                        continue block4;
                    }
                    case '&': 
                    case ')': 
                    case '|': {
                        NavigatorScanner.this.processTypeName(sb, modelElement, formatter);
                        formatter.appendText(String.valueOf(c));
                        continue block4;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            if (sb.length() > 0) {
                NavigatorScanner.this.processTypeName(sb, modelElement, formatter);
            }
            if (!isReturn && modelElement instanceof FunctionScope) {
                formatter.appendText(" ");
            }
            formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
        }
    }
}

