/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.awt.Image;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.text.Line;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class Nodes {
    public static Node constructSemiLogicalView(Map<FileObject, List<ErrorDescription>> errors, List<FixDescription> fixesOut) {
        HashMap<Project, HashMap<FileObject, List<ErrorDescription>>> projects = new HashMap<Project, HashMap<FileObject, List<ErrorDescription>>>();
        for (FileObject file : errors.keySet()) {
            HashMap<FileObject, List<ErrorDescription>> projectErrors;
            Project project = FileOwnerQuery.getOwner((FileObject)file);
            if (project == null) {
                Logger.getLogger(Nodes.class.getName()).log(Level.WARNING, "Cannot find project for: {0}", FileUtil.getFileDisplayName((FileObject)file));
            }
            if ((projectErrors = (HashMap<FileObject, List<ErrorDescription>>)projects.get(project)) == null) {
                projectErrors = new HashMap<FileObject, List<ErrorDescription>>();
                projects.put(project, projectErrors);
            }
            projectErrors.put(file, errors.get(file));
        }
        projects.remove(null);
        LinkedList<Node> nodes = new LinkedList<Node>();
        HashMap<ErrorDescription, List<FixDescription>> errors2Fixes = new HashMap<ErrorDescription, List<FixDescription>>();
        for (Project p : projects.keySet()) {
            nodes.add(Nodes.constructSemiLogicalView(p, (Map)projects.get(p), errors2Fixes));
        }
        for (List descs : errors2Fixes.values()) {
            fixesOut.addAll(descs);
        }
        return new AbstractNode((Children)new DirectChildren(nodes));
    }

    private static Node constructSemiLogicalView(final Project p, Map<FileObject, List<ErrorDescription>> errors, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
        Node view;
        LogicalViewProvider lvp = (LogicalViewProvider)p.getLookup().lookup(LogicalViewProvider.class);
        if (lvp != null) {
            view = lvp.createLogicalView();
        } else {
            try {
                view = DataObject.find((FileObject)p.getProjectDirectory()).getNodeDelegate();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new AbstractNode(Children.LEAF);
            }
        }
        HashMap<Node, List<ErrorDescription>> fileNodes = new HashMap<Node, List<ErrorDescription>>();
        for (Map.Entry<FileObject, List<ErrorDescription>> entry : errors.entrySet()) {
            FileObject file = entry.getKey();
            List<ErrorDescription> eds = entry.getValue();
            Node foundChild = Nodes.locateChild(view, lvp, file);
            if (foundChild == null) {
                AbstractNode n = new AbstractNode(Children.LEAF){

                    public Image getIcon(int type) {
                        return ImageUtilities.icon2Image((Icon)ProjectUtils.getInformation((Project)p).getIcon());
                    }

                    public Image getOpenedIcon(int type) {
                        return this.getIcon(type);
                    }

                    public String getHtmlDisplayName() {
                        return view.getHtmlDisplayName() != null ? NbBundle.getMessage(Nodes.class, (String)"ERR_ProjectNotSupported", (Object)view.getHtmlDisplayName()) : null;
                    }

                    public String getDisplayName() {
                        return NbBundle.getMessage(Nodes.class, (String)"ERR_ProjectNotSupported", (Object)view.getDisplayName());
                    }
                };
                return n;
            }
            fileNodes.put(foundChild, eds);
            for (ErrorDescription e : eds) {
                LinkedList<FixDescription> desc = new LinkedList<FixDescription>();
                for (Fix f : e.getFixes().getFixes()) {
                    desc.add(new FixDescription(e, f));
                }
                errors2Fixes.put(e, desc);
            }
        }
        errors = Collections.unmodifiableMap(new HashMap<FileObject, List<ErrorDescription>>(errors));
        return new Wrapper(view, fileNodes, errors2Fixes);
    }

    private static Node locateChild(Node parent, LogicalViewProvider lvp, FileObject file) {
        if (lvp != null) {
            return lvp.findPath(parent, (Object)file);
        }
        throw new UnsupportedOperationException("Not done yet");
    }

    private static Lookup lookupForNode(Node n, Map<Node, List<ErrorDescription>> fileNodes, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
        LinkedList<FixDescription> fixes = new LinkedList<FixDescription>();
        for (Map.Entry<Node, List<ErrorDescription>> e : fileNodes.entrySet()) {
            if (!Nodes.isParent(n, e.getKey())) continue;
            for (ErrorDescription ed : e.getValue()) {
                for (FixDescription f : errors2Fixes.get(ed)) {
                    fixes.add(f);
                }
            }
        }
        return Lookups.fixed((Object[])fixes.toArray(new FixDescription[0]));
    }

    private static Lookup lookupForNode(Node n, List<ErrorDescription> errors, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
        LinkedList<FixDescription> fixes = new LinkedList<FixDescription>();
        for (ErrorDescription ed : errors) {
            for (FixDescription f : errors2Fixes.get(ed)) {
                fixes.add(f);
            }
        }
        return Lookups.fixed((Object[])fixes.toArray(new FixDescription[0]));
    }

    private static boolean isParent(Node parent, Node child) {
        if (NodeOp.isSon((Node)parent, (Node)child)) {
            return true;
        }
        Node p = child.getParentNode();
        if (p == null) {
            return false;
        }
        return Nodes.isParent(parent, p);
    }

    private static final class OpenCookieImpl
    implements OpenCookie {
        private ErrorDescription ed;

        public OpenCookieImpl(ErrorDescription ed) {
            this.ed = ed;
        }

        public void open() {
            try {
                PositionRef pos = this.ed.getRange().getBegin();
                int line = pos.getLine();
                int column = pos.getColumn();
                Line l = pos.getCloneableEditorSupport().getLineSet().getCurrent(line);
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class FixNode
    extends AbstractNode
    implements ChangeListener {
        private FixDescription fix;

        public FixNode(ErrorDescription ed, FixDescription fix) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{new OpenCookieImpl(ed), fix}));
            this.fix = fix;
            int line = -1;
            try {
                line = ed.getRange().getBegin().getLine();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setDisplayName((line != -1 ? line + ":" : "") + fix.getText() + "(" + ed.getDescription() + ")");
            this.setIconBaseWithExtension("org/netbeans/modules/java/hints/analyzer/ui/suggestion.png");
            fix.addChangeListener(this);
        }

        public String getHtmlDisplayName() {
            if (this.fix.isFixed()) {
                return "<html><s>" + this.getDisplayName();
            }
            return "<html>" + this.getDisplayName();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireDisplayNameChange(null, null);
        }

        public Action getPreferredAction() {
            return OpenAction.get(OpenAction.class);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class FixChildren
    extends Children.Keys<FixDescription> {
        private ErrorDescription ed;

        public FixChildren(ErrorDescription ed, List<FixDescription> eds) {
            this.ed = ed;
            this.setKeys(eds);
        }

        protected Node[] createNodes(FixDescription key) {
            return new Node[]{new FixNode(this.ed, key)};
        }
    }

    private static final class ErrorDescriptionNode
    extends AbstractNode {
        private ErrorDescription ed;

        public ErrorDescriptionNode(ErrorDescription ed, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
            super((Children)new FixChildren(ed, errors2Fixes.get(ed)));
            this.ed = ed;
            int line = -1;
            try {
                line = ed.getRange().getBegin().getLine();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setDisplayName((line != -1 ? line + ":" : "") + ed.getDescription());
            this.setIconBaseWithExtension("org/netbeans/modules/java/hints/analyzer/ui/warning-glyph.gif");
        }
    }

    private static final class ErrorDescriptionChildren
    extends Children.Keys<ErrorDescription> {
        private Map<ErrorDescription, List<FixDescription>> errors2Fixes;

        public ErrorDescriptionChildren(List<ErrorDescription> ed, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
            this.setKeys(ed);
            this.errors2Fixes = errors2Fixes;
        }

        protected Node[] createNodes(ErrorDescription key) {
            LinkedList<FixNode> fixes = new LinkedList<FixNode>();
            for (FixDescription fd : this.errors2Fixes.get(key)) {
                fixes.add(new FixNode(key, fd));
            }
            return fixes.toArray(new Node[0]);
        }
    }

    private static final class DirectChildren
    extends Children.Keys<Node> {
        public DirectChildren(Collection<Node> nodes) {
            this.setKeys(nodes);
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }

    private static class WrapperChildren
    extends Children.Keys<Node> {
        private final Node orig;
        private final Map<Node, List<ErrorDescription>> fileNodes;
        private final Map<ErrorDescription, List<FixDescription>> errors2Fixes;

        public WrapperChildren(Node orig, Map<Node, List<ErrorDescription>> fileNodes, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
            this.orig = orig;
            this.fileNodes = fileNodes;
            this.errors2Fixes = errors2Fixes;
        }

        protected void addNotify() {
            super.addNotify();
            this.doSetKeys();
        }

        private void doSetKeys() {
            Node[] nodes = this.orig.getChildren().getNodes(true);
            LinkedList<Node> toSet = new LinkedList<Node>();
            block0: for (Node n : nodes) {
                for (Node c : this.fileNodes.keySet()) {
                    if (n != c && !Nodes.isParent(n, c)) continue;
                    toSet.add(n);
                    continue block0;
                }
            }
            this.setKeys(toSet);
        }

        protected Node[] createNodes(Node key) {
            if (this.fileNodes.containsKey(key)) {
                return new Node[]{new Wrapper(key, this.fileNodes.get(key), this.errors2Fixes)};
            }
            return new Node[]{new Wrapper(key, this.fileNodes, this.errors2Fixes)};
        }
    }

    private static class Wrapper
    extends FilterNode {
        public Wrapper(Node orig, Map<Node, List<ErrorDescription>> fileNodes, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
            super(orig, (Children)new WrapperChildren(orig, fileNodes, errors2Fixes), Nodes.lookupForNode(orig, fileNodes, (Map<ErrorDescription, List<FixDescription>>)errors2Fixes));
        }

        public Wrapper(Node orig, List<ErrorDescription> errors, Map<ErrorDescription, List<FixDescription>> errors2Fixes) {
            super(orig, (Children)new ErrorDescriptionChildren(errors, errors2Fixes), Nodes.lookupForNode(orig, errors, (Map<ErrorDescription, List<FixDescription>>)errors2Fixes));
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }
}

