/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.editor;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.metamodel.Component;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.impl.metamodel.ComponentImpl;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.LibraryType;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;

public class JsfFacesComponentsProvider {
    private static final Logger LOGGER = Logger.getLogger(JsfFacesComponentsProvider.class.getName());

    private JsfFacesComponentsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends Library> getLibraries(Project project) {
        long start = System.currentTimeMillis();
        try {
            MetadataModel<JsfModel> model = JSFUtils.getModel(project);
            if (model == null) {
                List list = Collections.emptyList();
                return list;
            }
            Collection collection = (Collection)model.runReadAction((MetadataModelAction)new MetadataModelAction<JsfModel, Collection<? extends Library>>(){

                public Collection<? extends Library> run(JsfModel metadata) throws Exception {
                    List<Component> facesComponents = metadata.getElements(Component.class);
                    HashMap libraries = new HashMap();
                    for (Component component : facesComponents) {
                        if (!(component instanceof ComponentImpl)) continue;
                        ComponentImpl facesComponent = (ComponentImpl)component;
                        JsfFacesComponentsProvider.includeComponentIntoLibraries(libraries, facesComponent);
                    }
                    return libraries.values();
                }
            });
            return collection;
        }
        finally {
            LOGGER.log(Level.FINEST, "JsfFacesComponentsProvider parsed for elements in {0} ms.", System.currentTimeMillis() - start);
        }
    }

    private static void includeComponentIntoLibraries(Map<String, FacesComponentLibrary> libraries, ComponentImpl facesComponent) {
        if (!facesComponent.isCreateTag()) {
            return;
        }
        String namespace = facesComponent.getNamespace();
        FacesComponentLibrary library = libraries.get(namespace);
        if (library == null) {
            library = new FacesComponentLibrary(namespace);
            libraries.put(namespace, library);
        }
        library.addComponent(new FacesLibraryComponent(library, facesComponent));
    }

    private static final class FacesComponentTag
    implements Tag {
        private final String tagName;

        public FacesComponentTag(String tagName) {
            this.tagName = tagName;
        }

        public String getName() {
            return this.tagName;
        }

        public String getDescription() {
            return "";
        }

        public boolean hasNonGenenericAttributes() {
            return false;
        }

        public Collection<Attribute> getAttributes() {
            return Collections.emptyList();
        }

        public Attribute getAttribute(String name) {
            return null;
        }
    }

    public static final class FacesLibraryComponent
    implements LibraryComponent {
        private final ElementHandle handle;
        private final String name;
        private final Library library;
        private final Tag tag;

        public FacesLibraryComponent(Library library, ComponentImpl component) {
            this.handle = component.getTypeElementHandle();
            this.name = component.getTagName();
            this.library = library;
            this.tag = new FacesComponentTag(component.getTagName());
        }

        public String getName() {
            return this.name;
        }

        public Tag getTag() {
            return this.tag;
        }

        public Library getLibrary() {
            return this.library;
        }

        public String[][] getDescription() {
            return new String[0][0];
        }

        public FileObject getComponentFile(Project project) {
            WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
            if (webModule == null) {
                return null;
            }
            JavaSource js = JSFConfigUtilities.createJavaSource(webModule);
            if (js != null) {
                FileObject file = SourceUtils.getFile((ElementHandle)this.handle, (ClasspathInfo)js.getClasspathInfo());
                if (file != null) {
                    return file;
                }
                String qualifiedName = this.handle.getQualifiedName();
                String relPath = qualifiedName.replace('.', '/') + ".class";
                ClassPath classPath = js.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                for (ClassPath.Entry entry : classPath.entries()) {
                    FileObject[] roots;
                    if (entry.isValid()) {
                        roots = new FileObject[]{entry.getRoot()};
                    } else {
                        SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                        roots = res.getRoots();
                    }
                    for (FileObject root : roots) {
                        file = root.getFileObject(relPath);
                        if (file == null) continue;
                        return file;
                    }
                }
            }
            return null;
        }
    }

    public static final class FacesComponentLibrary
    implements Library {
        private static final String FACES_COMPONENT = "Faces Component";
        private final String namespace;
        private final Map<String, LibraryComponent> components;

        public FacesComponentLibrary(String namespace) {
            this.namespace = namespace;
            this.components = new HashMap<String, LibraryComponent>(1);
        }

        public void addComponent(LibraryComponent component) {
            this.components.put(component.getName(), component);
        }

        public String getDefaultNamespace() {
            return this.namespace;
        }

        public LibraryType getType() {
            return LibraryType.COMPONENT;
        }

        public Collection<? extends LibraryComponent> getComponents() {
            return this.components.values();
        }

        public LibraryComponent getComponent(String componentName) {
            return this.components.get(componentName);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getDefaultPrefix() {
            return LibraryUtils.generateDefaultPrefix((String)this.getNamespace());
        }

        public String getDisplayName() {
            return FACES_COMPONENT;
        }

        public Set<String> getValidNamespaces() {
            return Collections.emptySortedSet();
        }
    }
}

