/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.j2ee;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.j2ee.EjbSupportImpl;
import org.netbeans.modules.tomcat5.j2ee.JaxRsStackSupportImpl;
import org.netbeans.modules.tomcat5.j2ee.JaxWsStack;
import org.netbeans.modules.tomcat5.j2ee.JpaSupportImpl;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class TomcatPlatformImpl
extends J2eePlatformImpl2 {
    private static final String[] WSCOMPILE_LIBS = new String[]{"jaxrpc/lib/jaxrpc-api.jar", "jaxrpc/lib/jaxrpc-impl.jar", "jaxrpc/lib/jaxrpc-spi.jar", "saaj/lib/saaj-api.jar", "saaj/lib/saaj-impl.jar", "jwsdp-shared/lib/mail.jar", "jwsdp-shared/lib/activation.jar"};
    private static final String[] JWSDP_LIBS = new String[]{"fastinfoset/lib/FastInfoset.jar", "jaxb/lib/jaxb1-impl.jar", "jaxb/lib/jaxb-impl.jar", "jaxb/lib/jaxb-api.jar", "jaxb/lib/jaxb-xjc.jar", "jaxws/lib/jaxws-api.jar", "jaxws/lib/jaxws-rt.jar", "jaxws/lib/jaxws-tools.jar", "jaxws/lib/jsr181-api.jar", "jaxws/lib/jsr250-api.jar", "saaj/lib/saaj-api.jar", "saaj/lib/saaj-impl.jar", "sjsxp/lib/sjsxp.jar", "sjsxp/lib/jsr173_api.jar", "jwsdp-shared/lib/activation.jar", "jwsdp-shared/lib/jaas.jar", "jwsdp-shared/lib/jta-spec1_0_1.jar", "jwsdp-shared/lib/mail.jar", "jwsdp-shared/lib/relaxngDatatype.jar", "jwsdp-shared/lib/resolver.jar", "jwsdp-shared/lib/xmlsec.jar", "jwsdp-shared/lib/xsdlib.jar"};
    private static final String[] WSIT_LIBS = new String[]{"shared/lib/webservices-rt.jar", "shared/lib/webservices-tools.jar"};
    private static final String[] JWSDP_WSGEN_LIBS = new String[]{"jaxws/lib/jaxws-tools.jar", "jaxws/lib/jaxws-rt.jar", "sjsxp/lib/sjsxp.jar", "jaxb/lib/jaxb-xjc.jar", "saaj/lib/saaj-impl.jar", "saaj/lib/saaj-api.jar", "jwsdp-shared/lib/relaxngDatatype.jar", "jwsdp-shared/lib/resolver.jar"};
    private static final String[] JWSDP_WSIMPORT_LIBS = new String[]{"jaxws/lib/jaxws-tools.jar", "jaxws/lib/jaxws-rt.jar", "sjsxp/lib/sjsxp.jar", "jaxb/lib/jaxb-xjc.jar", "jwsdp-shared/lib/relaxngDatatype.jar", "jwsdp-shared/lib/resolver.jar"};
    private static final String[] WSIT_WSIMPORT_LIBS = new String[]{"shared/lib/webservices-rt.jar", "shared/lib/webservices-tools.jar"};
    private static final String[] WSIT_WSGEN_LIBS = new String[]{"shared/lib/webservices-rt.jar", "shared/lib/webservices-tools.jar"};
    private static final String[] KEYSTORE_LOCATION = new String[]{"certs/server-keystore.jks"};
    private static final String[] TRUSTSTORE_LOCATION = new String[]{"certs/server-truststore.jks"};
    private static final String[] KEYSTORE_CLIENT_LOCATION = new String[]{"certs/client-keystore.jks"};
    private static final String[] TRUSTSTORE_CLIENT_LOCATION = new String[]{"certs/client-truststore.jks"};
    private static final String ICON = "org/netbeans/modules/tomcat5/resources/tomcat5instance.png";
    private final String displayName;
    private final TomcatProperties tp;
    private final TomcatManager manager;
    private LibraryImplementation[] libraries;

    public TomcatPlatformImpl(TomcatManager manager) {
        this.manager = manager;
        this.tp = manager.getTomcatProperties();
        this.displayName = this.tp.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyLibrariesChanged() {
        TomcatPlatformImpl tomcatPlatformImpl = this;
        synchronized (tomcatPlatformImpl) {
            this.libraries = null;
        }
        this.firePropertyChange("libraries", null, this.getLibraries());
    }

    public synchronized LibraryImplementation[] getLibraries() {
        if (this.libraries == null) {
            J2eeLibraryTypeProvider libProvider = new J2eeLibraryTypeProvider();
            LibraryImplementation lib = libProvider.createLibrary();
            lib.setName(NbBundle.getMessage(TomcatPlatformImpl.class, (String)"LBL_lib_name", (Object)this.displayName));
            this.loadLibraries(lib);
            this.libraries = new LibraryImplementation[1];
            this.libraries[0] = lib;
        }
        return this.libraries;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)ICON);
    }

    public File[] getPlatformRoots() {
        if (this.tp.getCatalinaBase() != null) {
            return new File[]{this.tp.getCatalinaHome(), this.tp.getCatalinaBase()};
        }
        return new File[]{this.tp.getCatalinaHome()};
    }

    public File getServerHome() {
        return this.tp.getCatalinaHome();
    }

    public File getDomainHome() {
        return this.tp.getCatalinaBase();
    }

    public File getMiddlewareHome() {
        return null;
    }

    public File[] getToolClasspathEntries(String toolName) {
        if ("wscompile".equals(toolName) && this.isToolSupported("wscompile")) {
            File[] retValue = new File[WSCOMPILE_LIBS.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < WSCOMPILE_LIBS.length; ++i) {
                retValue[i] = new File(homeDir, WSCOMPILE_LIBS[i]);
            }
            return retValue;
        }
        if ("wsgen".equals(toolName) && this.isToolSupported("wsgen")) {
            if (this.isToolSupported("wsit")) {
                File[] retValue = new File[WSIT_WSGEN_LIBS.length];
                File homeDir = this.tp.getCatalinaHome();
                for (int i = 0; i < WSIT_WSGEN_LIBS.length; ++i) {
                    retValue[i] = new File(homeDir, WSIT_WSGEN_LIBS[i]);
                }
                return retValue;
            }
            File[] retValue = new File[JWSDP_WSGEN_LIBS.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < JWSDP_WSGEN_LIBS.length; ++i) {
                retValue[i] = new File(homeDir, JWSDP_WSGEN_LIBS[i]);
            }
            return retValue;
        }
        if ("wsimport".equals(toolName) && this.isToolSupported("wsimport")) {
            if (this.isToolSupported("wsit")) {
                File[] retValue = new File[WSIT_WSIMPORT_LIBS.length];
                File homeDir = this.tp.getCatalinaHome();
                for (int i = 0; i < WSIT_WSIMPORT_LIBS.length; ++i) {
                    retValue[i] = new File(homeDir, WSIT_WSIMPORT_LIBS[i]);
                }
                return retValue;
            }
            File[] retValue = new File[JWSDP_WSIMPORT_LIBS.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < JWSDP_WSIMPORT_LIBS.length; ++i) {
                retValue[i] = new File(homeDir, JWSDP_WSIMPORT_LIBS[i]);
            }
            return retValue;
        }
        if ("jwsdp".equals(toolName)) {
            if (this.isToolSupported("wsit")) {
                return this.getToolClasspathEntries("wsit");
            }
            if (this.isToolSupported("jwsdp")) {
                File[] retValue = new File[JWSDP_LIBS.length];
                File homeDir = this.tp.getCatalinaHome();
                for (int i = 0; i < JWSDP_LIBS.length; ++i) {
                    retValue[i] = new File(homeDir, JWSDP_LIBS[i]);
                }
                return retValue;
            }
        }
        if ("keystore".equals(toolName) && this.isToolSupported("keystore")) {
            File[] retValue = new File[KEYSTORE_LOCATION.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < KEYSTORE_LOCATION.length; ++i) {
                retValue[i] = new File(homeDir, KEYSTORE_LOCATION[i]);
            }
            return retValue;
        }
        if ("truststore".equals(toolName) && this.isToolSupported("truststore")) {
            File[] retValue = new File[TRUSTSTORE_LOCATION.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < TRUSTSTORE_LOCATION.length; ++i) {
                retValue[i] = new File(homeDir, TRUSTSTORE_LOCATION[i]);
            }
            return retValue;
        }
        if ("keystoreClient".equals(toolName) && this.isToolSupported("keystoreClient")) {
            File[] retValue = new File[KEYSTORE_CLIENT_LOCATION.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < KEYSTORE_CLIENT_LOCATION.length; ++i) {
                retValue[i] = new File(homeDir, KEYSTORE_CLIENT_LOCATION[i]);
            }
            return retValue;
        }
        if ("truststoreClient".equals(toolName) && this.isToolSupported("truststoreClient")) {
            File[] retValue = new File[TRUSTSTORE_CLIENT_LOCATION.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < TRUSTSTORE_CLIENT_LOCATION.length; ++i) {
                retValue[i] = new File(homeDir, TRUSTSTORE_CLIENT_LOCATION[i]);
            }
            return retValue;
        }
        if ("wsit".equals(toolName) && this.isToolSupported("wsit")) {
            File[] retValue = new File[WSIT_LIBS.length];
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < WSIT_LIBS.length; ++i) {
                retValue[i] = new File(homeDir, WSIT_LIBS[i]);
            }
            return retValue;
        }
        return null;
    }

    public boolean isToolSupported(String toolName) {
        if ("wscompile".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < WSCOMPILE_LIBS.length; ++i) {
                if (new File(homeDir, WSCOMPILE_LIBS[i]).exists()) continue;
                return false;
            }
            return true;
        }
        if ("wsgen".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            boolean wsit = this.isToolSupported("wsit");
            if (wsit) {
                for (int i = 0; i < WSIT_WSGEN_LIBS.length; ++i) {
                    if (new File(homeDir, WSIT_WSGEN_LIBS[i]).exists()) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < JWSDP_WSGEN_LIBS.length; ++i) {
                    if (new File(homeDir, JWSDP_WSGEN_LIBS[i]).exists()) continue;
                    return false;
                }
            }
            return true;
        }
        if ("wsimport".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            boolean wsit = this.isToolSupported("wsit");
            if (wsit) {
                for (int i = 0; i < WSIT_WSIMPORT_LIBS.length; ++i) {
                    if (new File(homeDir, WSIT_WSIMPORT_LIBS[i]).exists()) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < JWSDP_WSIMPORT_LIBS.length; ++i) {
                    if (new File(homeDir, JWSDP_WSIMPORT_LIBS[i]).exists()) continue;
                    return false;
                }
            }
            return true;
        }
        if ("jwsdp".equals(toolName)) {
            if (this.isToolSupported("wsit")) {
                return true;
            }
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < JWSDP_LIBS.length; ++i) {
                if (new File(homeDir, JWSDP_LIBS[i]).exists()) continue;
                return false;
            }
            return true;
        }
        if ("keystore".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < KEYSTORE_LOCATION.length; ++i) {
                if (new File(homeDir, KEYSTORE_LOCATION[i]).exists()) continue;
                return false;
            }
            return true;
        }
        if ("truststore".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < TRUSTSTORE_LOCATION.length; ++i) {
                if (new File(homeDir, TRUSTSTORE_LOCATION[i]).exists()) continue;
                return false;
            }
            return true;
        }
        if ("keystoreClient".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < KEYSTORE_CLIENT_LOCATION.length; ++i) {
                if (new File(homeDir, KEYSTORE_CLIENT_LOCATION[i]).exists()) continue;
                return false;
            }
            return true;
        }
        if ("truststoreClient".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < TRUSTSTORE_CLIENT_LOCATION.length; ++i) {
                if (new File(homeDir, TRUSTSTORE_CLIENT_LOCATION[i]).exists()) continue;
                return false;
            }
            return true;
        }
        if ("wsit".equals(toolName)) {
            File homeDir = this.tp.getCatalinaHome();
            for (int i = 0; i < WSIT_LIBS.length; ++i) {
                if (new File(homeDir, WSIT_LIBS[i]).exists()) continue;
                return false;
            }
            return true;
        }
        if ("jsr109".equals(toolName)) {
            return false;
        }
        return "jaxws-tester".equals(toolName);
    }

    public Set<J2eeModule.Type> getSupportedTypes() {
        return Collections.singleton(J2eeModule.Type.WAR);
    }

    public Set<Profile> getSupportedProfiles() {
        HashSet<Profile> profiles = new HashSet<Profile>(10);
        if (this.manager.isTomEE()) {
            if (this.manager.getTomEEType().ordinal() >= 3) {
                switch (this.manager.getTomEEVersion()) {
                    case TOMEE_90: {
                        profiles.add(Profile.JAKARTA_EE_9_1_FULL);
                        break;
                    }
                    case TOMEE_80: {
                        profiles.add(Profile.JAKARTA_EE_8_FULL);
                        profiles.add(Profile.JAVA_EE_8_FULL);
                        profiles.add(Profile.JAVA_EE_7_FULL);
                        profiles.add(Profile.JAVA_EE_6_FULL);
                        break;
                    }
                }
            }
            switch (this.manager.getTomEEVersion()) {
                case TOMEE_90: {
                    profiles.add(Profile.JAKARTA_EE_9_1_WEB);
                    break;
                }
                case TOMEE_80: {
                    profiles.add(Profile.JAKARTA_EE_8_WEB);
                    profiles.add(Profile.JAVA_EE_8_WEB);
                    profiles.add(Profile.JAVA_EE_7_WEB);
                    profiles.add(Profile.JAVA_EE_6_WEB);
                    profiles.add(Profile.JAVA_EE_5);
                    break;
                }
                case TOMEE_71: 
                case TOMEE_70: {
                    profiles.add(Profile.JAVA_EE_7_WEB);
                    profiles.add(Profile.JAVA_EE_6_WEB);
                    profiles.add(Profile.JAVA_EE_5);
                    break;
                }
                case TOMEE_17: 
                case TOMEE_16: 
                case TOMEE_15: {
                    profiles.add(Profile.JAVA_EE_6_WEB);
                    profiles.add(Profile.JAVA_EE_5);
                    break;
                }
            }
        } else {
            switch (this.manager.getTomcatVersion()) {
                case TOMCAT_110: {
                    profiles.add(Profile.JAKARTA_EE_10_WEB);
                    break;
                }
                case TOMCAT_101: {
                    profiles.add(Profile.JAKARTA_EE_10_WEB);
                    break;
                }
                case TOMCAT_100: {
                    profiles.add(Profile.JAKARTA_EE_9_1_WEB);
                    profiles.add(Profile.JAKARTA_EE_9_WEB);
                    break;
                }
                case TOMCAT_90: {
                    profiles.add(Profile.JAKARTA_EE_8_WEB);
                    profiles.add(Profile.JAVA_EE_8_WEB);
                    profiles.add(Profile.JAVA_EE_7_WEB);
                    profiles.add(Profile.JAVA_EE_6_WEB);
                    profiles.add(Profile.JAVA_EE_5);
                }
                case TOMCAT_80: {
                    profiles.add(Profile.JAVA_EE_7_WEB);
                    profiles.add(Profile.JAVA_EE_6_WEB);
                    profiles.add(Profile.JAVA_EE_5);
                    break;
                }
                case TOMCAT_70: {
                    profiles.add(Profile.JAVA_EE_6_WEB);
                    profiles.add(Profile.JAVA_EE_5);
                    break;
                }
                case TOMCAT_60: {
                    profiles.add(Profile.JAVA_EE_5);
                    break;
                }
                case TOMCAT_55: 
                case TOMCAT_50: {
                    profiles.add(Profile.J2EE_14);
                    break;
                }
            }
        }
        return profiles;
    }

    public Set<String> getSupportedJavaPlatformVersions() {
        Set<String> versions = new HashSet<String>(16);
        if (this.manager.isTomEE()) {
            switch (this.manager.getTomEEVersion()) {
                case TOMEE_90: {
                    versions = TomcatPlatformImpl.versionRange(11, 23);
                    break;
                }
                case TOMEE_80: {
                    versions = TomcatPlatformImpl.versionRange(8, 23);
                    break;
                }
                case TOMEE_71: 
                case TOMEE_70: {
                    versions = TomcatPlatformImpl.versionRange(7, 8);
                    break;
                }
                case TOMEE_17: 
                case TOMEE_16: 
                case TOMEE_15: {
                    versions = TomcatPlatformImpl.versionRange(6, 8);
                    break;
                }
            }
        } else {
            switch (this.manager.getTomcatVersion()) {
                case TOMCAT_110: {
                    versions = TomcatPlatformImpl.versionRange(21, 23);
                    break;
                }
                case TOMCAT_101: {
                    versions = TomcatPlatformImpl.versionRange(11, 23);
                    break;
                }
                case TOMCAT_100: 
                case TOMCAT_90: {
                    versions = TomcatPlatformImpl.versionRange(8, 23);
                    break;
                }
                case TOMCAT_80: {
                    versions = TomcatPlatformImpl.versionRange(7, 23);
                    break;
                }
                case TOMCAT_70: {
                    versions = TomcatPlatformImpl.versionRange(6, 23);
                    break;
                }
                case TOMCAT_60: {
                    versions = TomcatPlatformImpl.versionRange(5, 8);
                    break;
                }
                case TOMCAT_55: 
                case TOMCAT_50: {
                    versions = TomcatPlatformImpl.versionRange(4, 8);
                    break;
                }
            }
        }
        return versions;
    }

    public JavaPlatform getJavaPlatform() {
        return this.tp.getJavaPlatform();
    }

    public Lookup getLookup() {
        ArrayList<Object> content = new ArrayList<Object>();
        WSStack wsStack = WSStackFactory.createWSStack(JaxWs.class, (WSStackImplementation)new JaxWsStack(this.tp.getCatalinaHome()), (WSStack.Source)WSStack.Source.SERVER);
        Collections.addAll(content, this.tp.getCatalinaHome(), new EjbSupportImpl(this.manager), wsStack);
        if (this.manager.isTomEE()) {
            content.add(new JpaSupportImpl(this.manager));
            if (this.manager.isTomEEJaxRS()) {
                content.add(new JaxRsStackSupportImpl(this));
            }
        }
        Lookup baseLookup = Lookups.fixed((Object[])content.toArray());
        return LookupProviderSupport.createCompositeLookup((Lookup)baseLookup, (String)"J2EE/DeploymentPlugins/Tomcat5/Lookup");
    }

    private void loadLibraries(LibraryImplementation lib) {
        lib.setContent("classpath", this.tp.getClasses());
        lib.setContent("javadoc", this.tp.getJavadocs());
        lib.setContent("src", this.tp.getSources());
    }

    private static Set<String> versionRange(int min, int max) {
        return IntStream.range(min, max + 1).mapToObj(v -> v > 8 ? Integer.toString(v) : "1." + v).collect(Collectors.toSet());
    }
}

