/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.regex.result.TraceFinderResult;
import com.oracle.truffle.regex.runtime.nodes.DispatchNode;
import com.oracle.truffle.regex.runtime.nodes.DispatchNodeGen;
import com.oracle.truffle.regex.runtime.nodes.TraceFinderGetResultNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=TraceFinderGetResultNode.class)
public final class TraceFinderGetResultNodeGen
extends TraceFinderGetResultNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile conditionProfile_;
    @Node.Child
    private DispatchNode calcResult_;

    private TraceFinderGetResultNodeGen() {
    }

    @Override
    public int[] execute(TraceFinderResult arg0Value) {
        int state = this.state_;
        if (state != 0) {
            return TraceFinderGetResultNode.doTraceFinderCalc(arg0Value, this.conditionProfile_, this.calcResult_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeAndSpecialize(TraceFinderResult arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            this.conditionProfile_ = ConditionProfile.create();
            this.calcResult_ = (DispatchNode)super.insert((Node)DispatchNodeGen.create());
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            int[] nArray = TraceFinderGetResultNode.doTraceFinderCalc(arg0Value, this.conditionProfile_, this.calcResult_);
            return nArray;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static TraceFinderGetResultNode create() {
        return new TraceFinderGetResultNodeGen();
    }

    public static TraceFinderGetResultNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=TraceFinderGetResultNode.class)
    private static final class Uncached
    extends TraceFinderGetResultNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int[] execute(TraceFinderResult arg0Value) {
            return TraceFinderGetResultNode.doTraceFinderCalc(arg0Value, ConditionProfile.getUncached(), DispatchNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

