/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleReport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class GradleProject
implements Serializable,
Lookup.Provider {
    final NbGradleProject.Quality quality;
    final long evaluationTime = System.currentTimeMillis();
    final Lookup lookup;
    final GradleBaseProject baseProject;

    public GradleProject(NbGradleProject.Quality quality, Set<GradleReport> problems, Collection infos) {
        this.quality = quality;
        LinkedHashSet<GradleReport> probs = new LinkedHashSet<GradleReport>();
        for (GradleReport prob : problems) {
            if (prob == null) continue;
            probs.add(prob);
        }
        InstanceContent ic = new InstanceContent();
        for (Object i : infos) {
            ic.add(i);
        }
        this.lookup = new AbstractLookup((AbstractLookup.Content)ic);
        this.baseProject = (GradleBaseProject)this.lookup.lookup(GradleBaseProject.class);
        assert (this.baseProject != null) : "GradleProject always shall have a GradleBaseProject in it's lookup!";
        GradleProject.setProblems(this.baseProject, probs);
    }

    private GradleProject(NbGradleProject.Quality quality, GradleReport[] problems, GradleProject origin) {
        this.quality = quality;
        LinkedHashSet<GradleReport> probs = new LinkedHashSet<GradleReport>();
        for (GradleReport prob : problems) {
            if (prob == null) continue;
            probs.add(prob);
        }
        this.lookup = origin.lookup;
        this.baseProject = (GradleBaseProject)this.lookup.lookup(GradleBaseProject.class);
        assert (this.baseProject != null) : "GradleProject always shall have a GradleBaseProject in it's lookup!";
        GradleProject.setProblems(this.baseProject, probs);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    Set<GradleReport> getProblems() {
        return this.baseProject.getProblems();
    }

    public NbGradleProject.Quality getQuality() {
        return this.quality;
    }

    public long getEvaluationTime() {
        return this.evaluationTime;
    }

    @NonNull
    public GradleBaseProject getBaseProject() {
        return this.baseProject;
    }

    public String toString() {
        return "GradleProject{quality=" + (Object)((Object)this.quality) + ", baseProject=" + this.baseProject + '}';
    }

    public final GradleProject invalidate(GradleReport ... problems) {
        if (this.getQuality().worseThan(NbGradleProject.Quality.EVALUATED)) {
            if (problems != null && problems.length > 0) {
                return new GradleProject(this.getQuality(), problems, this);
            }
            return this;
        }
        return new GradleProject(NbGradleProject.Quality.EVALUATED, problems, this);
    }

    public final GradleProject invalidate(String ... reason) {
        GradleFiles gf = new GradleFiles(this.baseProject.getProjectDir(), true);
        Path scriptPath = gf.getBuildScript() != null ? gf.getBuildScript().toPath() : null;
        ArrayList<GradleReport> reports = new ArrayList<GradleReport>();
        for (String s : reason) {
            reports.add(GradleProject.createGradleReport(scriptPath, s, new String[0]));
        }
        return this.invalidate(reports.toArray(new GradleReport[reports.size()]));
    }

    private static void setProblems(GradleBaseProject baseProject, Set<GradleReport> problems) {
        NbGradleProjectImpl.ACCESSOR.setProblems(baseProject, problems);
    }

    public static GradleReport createGradleReport(GradleReport.Severity severity, String errorClass, String location, int line, String message, GradleReport causedBy, String ... traceLines) {
        return NbGradleProjectImpl.ACCESSOR.createReport(severity, errorClass, location, line, message, causedBy, traceLines);
    }

    public static GradleReport createGradleReport(Path script, String message, String ... detail) {
        return GradleProject.createGradleReport(GradleReport.Severity.ERROR, null, Objects.toString(script), -1, message, null, detail);
    }
}

