/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.validation;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.Parameters;

public final class ValidationResult {
    private final List<Message> errors = new ArrayList<Message>();
    private final List<Message> warnings = new ArrayList<Message>();

    public ValidationResult() {
    }

    public ValidationResult(ValidationResult anotherResult) {
        this.merge(anotherResult);
    }

    public boolean isFaultless() {
        return !this.hasErrors() && !this.hasWarnings();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Message> getErrors() {
        return new ArrayList<Message>(this.errors);
    }

    @CheckForNull
    public Message getFirstError() {
        if (this.hasErrors()) {
            return this.errors.get(0);
        }
        return null;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<Message> getWarnings() {
        return new ArrayList<Message>(this.warnings);
    }

    @CheckForNull
    public Message getFirstWarning() {
        if (this.hasWarnings()) {
            return this.warnings.get(0);
        }
        return null;
    }

    public void addError(Message error) {
        Parameters.notNull((CharSequence)"error", (Object)error);
        this.errors.add(error);
    }

    public void addWarning(Message warning) {
        Parameters.notNull((CharSequence)"warning", (Object)warning);
        this.warnings.add(warning);
    }

    public void merge(ValidationResult otherResult) {
        Parameters.notNull((CharSequence)"otherResult", (Object)otherResult);
        this.errors.addAll(otherResult.errors);
        this.warnings.addAll(otherResult.warnings);
    }

    public static final class Message {
        private final Object source;
        private final String message;
        private final String type;

        public Message(Object source, String message) {
            this(source, message, null);
        }

        public Message(Object source, String message, @NullAllowed String type) {
            Parameters.notNull((CharSequence)"source", (Object)source);
            Parameters.notNull((CharSequence)"message", (Object)message);
            this.source = source;
            this.message = message;
            this.type = type;
        }

        public Object getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.message;
        }

        @CheckForNull
        public String getType() {
            return this.type;
        }

        public boolean isType(@NonNull String type) {
            Parameters.notNull((CharSequence)"type", (Object)type);
            return type.equals(this.type);
        }

        public String toString() {
            return "Message{source=" + this.source + ", message=" + this.message + ", type=" + this.type + '}';
        }
    }
}

