/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.config;

import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.server.config.Config;
import org.netbeans.modules.glassfish.tooling.server.config.ConfigBuilder;
import org.netbeans.modules.glassfish.tooling.server.config.ServerConfigException;

public class ConfigBuilderProvider {
    private static final URL CONFIG_V3 = ConfigBuilderProvider.class.getResource("GlassFishV3.xml");
    private static final Config.Next CONFIG_V4 = new Config.Next(GlassFishVersion.GF_4, ConfigBuilderProvider.class.getResource("GlassFishV4.xml"));
    private static final Config.Next CONFIG_V4_1 = new Config.Next(GlassFishVersion.GF_4_1, ConfigBuilderProvider.class.getResource("GlassFishV4_1.xml"));
    private static final Config.Next CONFIG_V5 = new Config.Next(GlassFishVersion.GF_5, ConfigBuilderProvider.class.getResource("GlassFishV5.xml"));
    private static final Config.Next CONFIG_V5_0_1 = new Config.Next(GlassFishVersion.GF_5_0_1, ConfigBuilderProvider.class.getResource("GlassFishV5.xml"));
    private static final Config.Next CONFIG_V5_1 = new Config.Next(GlassFishVersion.GF_5_1_0, ConfigBuilderProvider.class.getResource("GlassFishV5_1_0.xml"));
    private static final Config.Next CONFIG_V6 = new Config.Next(GlassFishVersion.GF_6, ConfigBuilderProvider.class.getResource("GlassFishV6.xml"));
    private static final Config.Next CONFIG_V6_1_0 = new Config.Next(GlassFishVersion.GF_6_1_0, ConfigBuilderProvider.class.getResource("GlassFishV6_1_0.xml"));
    private static final Config.Next CONFIG_V6_2_0 = new Config.Next(GlassFishVersion.GF_6_2_0, ConfigBuilderProvider.class.getResource("GlassFishV6_2_0.xml"));
    private static final Config.Next CONFIG_V6_2_1 = new Config.Next(GlassFishVersion.GF_6_2_1, ConfigBuilderProvider.class.getResource("GlassFishV6_2_1.xml"));
    private static final Config.Next CONFIG_V6_2_2 = new Config.Next(GlassFishVersion.GF_6_2_2, ConfigBuilderProvider.class.getResource("GlassFishV6_2_2.xml"));
    private static final Config.Next CONFIG_V6_2_3 = new Config.Next(GlassFishVersion.GF_6_2_3, ConfigBuilderProvider.class.getResource("GlassFishV6_2_3.xml"));
    private static final Config.Next CONFIG_V6_2_4 = new Config.Next(GlassFishVersion.GF_6_2_4, ConfigBuilderProvider.class.getResource("GlassFishV6_2_4.xml"));
    private static final Config.Next CONFIG_V6_2_5 = new Config.Next(GlassFishVersion.GF_6_2_5, ConfigBuilderProvider.class.getResource("GlassFishV6_2_4.xml"));
    private static final Config.Next CONFIG_V7_0_0 = new Config.Next(GlassFishVersion.GF_7_0_0, ConfigBuilderProvider.class.getResource("GlassFishV7_0_0.xml"));
    private static final Config.Next CONFIG_V7_0_1 = new Config.Next(GlassFishVersion.GF_7_0_1, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_2 = new Config.Next(GlassFishVersion.GF_7_0_2, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_3 = new Config.Next(GlassFishVersion.GF_7_0_3, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_4 = new Config.Next(GlassFishVersion.GF_7_0_4, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_5 = new Config.Next(GlassFishVersion.GF_7_0_5, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_6 = new Config.Next(GlassFishVersion.GF_7_0_6, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_7 = new Config.Next(GlassFishVersion.GF_7_0_7, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_8 = new Config.Next(GlassFishVersion.GF_7_0_8, ConfigBuilderProvider.class.getResource("GlassFishV7_0_1.xml"));
    private static final Config.Next CONFIG_V7_0_9 = new Config.Next(GlassFishVersion.GF_7_0_9, ConfigBuilderProvider.class.getResource("GlassFishV7_0_9.xml"));
    private static final Config.Next CONFIG_V7_0_10 = new Config.Next(GlassFishVersion.GF_7_0_10, ConfigBuilderProvider.class.getResource("GlassFishV7_0_9.xml"));
    private static final Config.Next CONFIG_V7_0_11 = new Config.Next(GlassFishVersion.GF_7_0_11, ConfigBuilderProvider.class.getResource("GlassFishV7_0_9.xml"));
    private static final Config config = new Config(CONFIG_V3, CONFIG_V4, CONFIG_V4_1, CONFIG_V5, CONFIG_V5_0_1, CONFIG_V5_1, CONFIG_V6, CONFIG_V6_1_0, CONFIG_V6_2_0, CONFIG_V6_2_1, CONFIG_V6_2_2, CONFIG_V6_2_3, CONFIG_V6_2_4, CONFIG_V6_2_5, CONFIG_V7_0_0, CONFIG_V7_0_1, CONFIG_V7_0_2, CONFIG_V7_0_3, CONFIG_V7_0_4, CONFIG_V7_0_5, CONFIG_V7_0_6, CONFIG_V7_0_7, CONFIG_V7_0_8, CONFIG_V7_0_9, CONFIG_V7_0_10, CONFIG_V7_0_11);
    private static final ConcurrentMap<GlassFishServer, ConfigBuilder> builders = new ConcurrentHashMap<GlassFishServer, ConfigBuilder>(32);

    public static URL getBuilderConfig(GlassFishVersion version) {
        return ConfigBuilderProvider.config.configFiles[ConfigBuilderProvider.config.index[version.ordinal()]];
    }

    public static ConfigBuilder getBuilder(GlassFishServer server) {
        if (server == null) {
            throw new ServerConfigException("GlassFish server entity shall not be null");
        }
        String serverHome = server.getServerHome();
        return builders.computeIfAbsent(server, key -> new ConfigBuilder(config, serverHome, serverHome, serverHome));
    }

    public static void destroyBuilder(GlassFishServer server) {
        if (server == null) {
            throw new ServerConfigException("GlassFish server entity shall not be null");
        }
        builders.remove(server);
    }
}

