/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnectionConvertor;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class ConnectionList {
    private static final String PREF_PREFERRED_CONNECTION_NAME = "preferredConnection";
    private static ConnectionList DEFAULT;
    private final List<ConnectionListener> listeners = new CopyOnWriteArrayList<ConnectionListener>();
    private final Preferences dbPreferences;
    private String lastPrefName;
    private Lookup.Result<DatabaseConnection> result = this.getLookupResult();
    private Reference<DatabaseConnection> preferred = new WeakReference<Object>(null);
    private WeakHashMap<DatabaseConnection, Boolean> lastKnownConnections = new WeakHashMap();
    private boolean prefChanged;

    public static ConnectionList getDefault(boolean initialize) {
        if (initialize) {
            return ConnectionList.getDefault();
        }
        return DEFAULT;
    }

    public static synchronized ConnectionList getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ConnectionList();
        }
        return DEFAULT;
    }

    private ConnectionList() {
        this.result.allInstances();
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                ConnectionList.this.fireListeners();
            }
        });
        this.dbPreferences = NbPreferences.forModule(ConnectionList.class);
        this.dbPreferences.addPreferenceChangeListener(new PreferenceChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getNode() == null || !evt.getNode().absolutePath().equals(ConnectionList.this.dbPreferences.absolutePath())) {
                    return;
                }
                if (!ConnectionList.PREF_PREFERRED_CONNECTION_NAME.equals(evt.getKey())) {
                    return;
                }
                DatabaseConnection c = ConnectionList.this.getPreferredConnection(true);
                ConnectionList connectionList = ConnectionList.this;
                synchronized (connectionList) {
                    Reference ref = ConnectionList.this.preferred;
                    DatabaseConnection pref = (DatabaseConnection)ref.get();
                    if (c == pref) {
                        return;
                    }
                    ConnectionList.this.prefChanged = true;
                }
                ConnectionList.this.fireListeners();
            }
        });
    }

    public DatabaseConnection[] getConnections() {
        Collection dbconns = this.result.allInstances();
        return dbconns.toArray(new DatabaseConnection[dbconns.size()]);
    }

    public DatabaseConnection getConnection(DatabaseConnection impl) {
        if (impl == null) {
            throw new NullPointerException();
        }
        DatabaseConnection[] dbconns = this.getConnections();
        for (int i = 0; i < dbconns.length; ++i) {
            if (!impl.equals(dbconns[i])) continue;
            return dbconns[i];
        }
        return null;
    }

    public void add(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (this.contains(dbconn)) {
            throw new DatabaseException(NbBundle.getMessage(ConnectionList.class, (String)"EXC_ConnectionAlreadyExists"));
        }
        try {
            DatabaseConnectionConvertor.create(dbconn);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean contains(DatabaseConnection dbconn) {
        return this.getConnection(dbconn) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        ConnectionList connectionList = this;
        synchronized (connectionList) {
            DatabaseConnection pref = this.preferred.get();
            if (pref == dbconn) {
                this.preferred.clear();
            }
        }
        try {
            DatabaseConnectionConvertor.remove(dbconn);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners() {
        DatabaseConnection[] connections = this.getConnections();
        DatabaseConnection publicPref = this.getPreferredConnection(true);
        ConnectionList connectionList = this;
        synchronized (connectionList) {
            boolean theSame;
            Reference<DatabaseConnection> ref = this.preferred;
            DatabaseConnection pref = ref.get();
            if (pref != null && pref != publicPref) {
                ref.clear();
                this.prefChanged = true;
            }
            if (connections.length == this.lastKnownConnections.size()) {
                theSame = this.prefChanged;
                for (int i = 0; i < connections.length; ++i) {
                    if (this.lastKnownConnections.containsKey(connections[i])) continue;
                    theSame = false;
                    break;
                }
            } else {
                theSame = false;
            }
            if (!this.prefChanged && theSame) {
                return;
            }
            this.lastKnownConnections.clear();
            for (DatabaseConnection dc : connections) {
                this.lastKnownConnections.put(dc, Boolean.TRUE);
            }
            this.prefChanged = false;
        }
        for (ConnectionListener listener : this.listeners) {
            listener.connectionsChanged();
        }
    }

    private synchronized Lookup.Result<DatabaseConnection> getLookupResult() {
        return Lookups.forPath((String)"Databases/Connections").lookupResult(DatabaseConnection.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredConnection(DatabaseConnection c) {
        if (!this.contains(c)) {
            throw new IllegalArgumentException();
        }
        ConnectionList connectionList = this;
        synchronized (connectionList) {
            Reference<DatabaseConnection> ref = this.preferred;
            if (ref.get() == c) {
                return;
            }
            ref.clear();
            this.preferred = new PreferredRef(c);
            this.lastPrefName = null;
        }
        this.dbPreferences.put(PREF_PREFERRED_CONNECTION_NAME, c.getName());
        this.fireListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection getPreferredConnection(boolean selectFirst) {
        String fallback;
        DatabaseConnection p;
        ConnectionList connectionList = this;
        synchronized (connectionList) {
            p = this.preferred.get();
            if (p != null) {
                return p;
            }
            fallback = this.lastPrefName;
        }
        String prefName = this.dbPreferences.get(PREF_PREFERRED_CONNECTION_NAME, null);
        DatabaseConnection[] conns = this.getConnections();
        DatabaseConnection selected = ConnectionList.findConnection(prefName, conns);
        boolean prefChanged = false;
        if (selected == null) {
            if (conns.length > 0) {
                selected = ConnectionList.findConnection(fallback, conns);
            }
            if (selected != null) {
                prefChanged = !Objects.equals(this.lastPrefName, selected.getName());
                this.lastPrefName = selected.getName();
            } else {
                return null;
            }
        }
        ConnectionList connectionList2 = this;
        synchronized (connectionList2) {
            p = this.preferred.get();
            if (p == null) {
                this.preferred = new PreferredRef(selected);
                p = selected;
            }
        }
        if (prefChanged) {
            this.fireListeners();
        }
        return p;
    }

    private static DatabaseConnection findConnection(String name, DatabaseConnection[] conns) {
        for (int i = 0; i < conns.length; ++i) {
            DatabaseConnection c = conns[i];
            if (name != null && !name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    private class PreferredRef
    extends WeakReference<DatabaseConnection>
    implements PropertyChangeListener {
        private final PropertyChangeListener l;

        public PreferredRef(DatabaseConnection referent) {
            super(referent);
            this.l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)referent);
            referent.addPropertyChangeListener(this.l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DatabaseConnection c = (DatabaseConnection)this.get();
            if (c != null && "name".equals(evt)) {
                ConnectionList.this.dbPreferences.put(ConnectionList.PREF_PREFERRED_CONNECTION_NAME, c.getName());
            }
        }

        @Override
        public void clear() {
            DatabaseConnection c = (DatabaseConnection)this.get();
            super.clear();
            if (c != null) {
                c.removePropertyChangeListener(this.l);
            }
        }
    }
}

