/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Bitness;
import eu.hansolo.jdktools.HashAlgorithm;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.Match;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.util.OutputFormat;
import eu.hansolo.jdktools.versioning.Semver;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.PropertyManager;
import io.foojay.api.discoclient.event.DCEvt;
import io.foojay.api.discoclient.event.DownloadEvt;
import io.foojay.api.discoclient.event.Evt;
import io.foojay.api.discoclient.event.EvtObserver;
import io.foojay.api.discoclient.event.EvtType;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Feature;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.Scope;
import io.foojay.api.discoclient.util.Helper;
import io.foojay.api.discoclient.util.PkgInfo;
import io.foojay.api.discoclient.util.ReadableConsumerByteChannel;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class DiscoClient {
    public static final ConcurrentHashMap<String, List<Scope>> SCOPE_LOOKUP = new ConcurrentHashMap();
    private static final Map<String, Distribution> DISTRIBUTIONS = new ConcurrentHashMap<String, Distribution>();
    private static final String[] DETECT_ALPINE_CMDS = new String[]{"/bin/sh", "-c", "cat /etc/os-release | grep 'NAME=' | grep -ic 'Alpine'"};
    private static final String[] UX_DETECT_ARCH_CMDS = new String[]{"/bin/sh", "-c", "uname -m"};
    private static final String[] WIN_DETECT_ARCH_CMDS = new String[]{"/bin/sh", "-c", "uname -m"};
    private final Map<String, List<EvtObserver>> observers = new ConcurrentHashMap<String, List<EvtObserver>>();
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private String userAgent = "";

    public DiscoClient() {
        this("");
    }

    public DiscoClient(String userAgent) {
        this.userAgent = userAgent;
        DiscoClient.preloadDistributions();
    }

    private static void preloadDistributions() {
        Helper.preloadDistributions().thenAccept(distros -> {
            DISTRIBUTIONS.putAll((Map<String, Distribution>)distros);
            DISTRIBUTIONS.entrySet().stream().forEach(entry -> SCOPE_LOOKUP.put((String)entry.getKey(), ((Distribution)entry.getValue()).getScopes()));
            Helper.getAsync(PropertyManager.INSTANCE.getString("distro_url"), "").thenAccept(response -> {
                if (null != response && response.statusCode() == 200) {
                    String jsonText = (String)response.body();
                    ConcurrentHashMap<String, Distribution> distributionsFound = new ConcurrentHashMap<String, Distribution>();
                    if (!jsonText.isEmpty()) {
                        distributionsFound.putAll(Helper.getDistributionsFromJsonText(jsonText));
                    }
                    if (!distributionsFound.isEmpty()) {
                        DISTRIBUTIONS.clear();
                        DISTRIBUTIONS.putAll(distributionsFound);
                    }
                }
                initialized.set(true);
            });
        });
    }

    public boolean isInitialzed() {
        return initialized.get();
    }

    public Queue<Pkg> getAllPackages() {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath()).append("?release_status=ea").append("&release_status=ga");
        String query = queryBuilder.toString();
        if (query.isEmpty()) {
            return new ConcurrentLinkedQueue<Pkg>();
        }
        ConcurrentLinkedQueue<Pkg> pkgs = new ConcurrentLinkedQueue<Pkg>();
        HashSet<Pkg> pkgsFound = new HashSet<Pkg>();
        Gson gson = new Gson();
        String bodyText = Helper.get(query, this.userAgent).body();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject bundleJsonObj = jsonArray.get(i).getAsJsonObject();
                pkgsFound.add(new Pkg(bundleJsonObj.toString()));
            }
        }
        pkgs.addAll(pkgsFound);
        return pkgs;
    }

    public CompletableFuture<Queue<Pkg>> getAllPackagesAsync() {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath()).append("?release_status=ea").append("&release_status=ga");
        String query = queryBuilder.toString();
        CompletionStage future = Helper.getAsync(query, this.userAgent).thenApply(response -> {
            ConcurrentLinkedQueue<Pkg> pkgsFound = new ConcurrentLinkedQueue<Pkg>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject bundleJsonObj = jsonArray.get(i).getAsJsonObject();
                    pkgsFound.add(new Pkg(bundleJsonObj.toString()));
                }
            }
            return pkgsFound;
        });
        return future;
    }

    public List<Pkg> getPkgs(List<Distribution> distributions, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libcType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, List<ReleaseStatus> releaseStatus, TermOfSupport termOfSupport, List<Scope> scopes, Match match) {
        return this.getPkgs(distributions, versionNumber, latest, operatingSystem, libcType, architecture, bitness, archiveType, packageType, javafxBundled, directlyDownloadable, releaseStatus, termOfSupport, new ArrayList<String>(), scopes, match);
    }

    public List<Pkg> getPkgs(List<Distribution> distributions, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libcType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, List<ReleaseStatus> releaseStatus, TermOfSupport termOfSupport, List<String> ftrs, List<Scope> scopes, Match match) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath());
        int initialLength = queryBuilder.length();
        if (null != distributions && !distributions.isEmpty()) {
            distributions.forEach(distribution -> {
                if (null != distribution) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("distro").append("=").append(distribution.getApiString());
                }
            });
        }
        if (null != versionNumber) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("version").append("=").append(Helper.encodeValue(versionNumber.toString(OutputFormat.REDUCED_COMPRESSED, true, true)));
        }
        if (null != latest && Latest.NONE != latest && Latest.NOT_FOUND != latest) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("latest").append("=").append(latest.getApiString());
        }
        if (null != operatingSystem && OperatingSystem.NONE != operatingSystem && OperatingSystem.NOT_FOUND != operatingSystem) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("operating_system").append("=").append(operatingSystem.getApiString());
        }
        if (null != libcType && LibCType.NONE != libcType && LibCType.NOT_FOUND != libcType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("libc_type").append("=").append(libcType.getApiString());
        }
        if (null != architecture && Architecture.NONE != architecture && Architecture.NOT_FOUND != architecture) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("architecture").append("=").append(architecture.getApiString());
        }
        if (null != bitness && Bitness.NONE != bitness && Bitness.NOT_FOUND != bitness) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("bitness").append("=").append(bitness.getApiString());
        }
        if (null != archiveType && ArchiveType.NONE != archiveType && ArchiveType.NOT_FOUND != archiveType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("archive_type").append("=").append(archiveType.getApiString());
        }
        if (null != packageType && PackageType.NONE != packageType && PackageType.NOT_FOUND != packageType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("package_type").append("=").append(packageType.getApiString());
        }
        if (null != scopes && !scopes.isEmpty()) {
            scopes.forEach(scope -> {
                if (null != scope && Scope.NONE != scope && Scope.NOT_FOUND != scope) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("discovery_scope_id").append("=").append(scope.getApiString());
                }
            });
        }
        if (null != match && Match.NONE != match && Match.NOT_FOUND != match) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("match").append("=").append(match.getApiString());
        }
        if (null != javafxBundled) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("javafx_bundled").append("=").append(javafxBundled);
        }
        if (null != directlyDownloadable) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("directly_downloadable").append("=").append(directlyDownloadable);
        }
        if (null != releaseStatus && !releaseStatus.isEmpty()) {
            releaseStatus.forEach(rs -> {
                if (null != rs && ReleaseStatus.NONE != rs && ReleaseStatus.NOT_FOUND != rs) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("release_status").append("=").append(rs.getApiString());
                }
            });
        }
        if (null != termOfSupport && TermOfSupport.NONE != termOfSupport && TermOfSupport.NOT_FOUND != termOfSupport) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("term_of_support").append("=").append(termOfSupport.getApiString());
        }
        if (null != ftrs && !ftrs.isEmpty()) {
            ArrayList features;
            if (ftrs.isEmpty()) {
                features = new ArrayList();
            } else {
                HashSet<Feature> featuresFound = new HashSet<Feature>();
                for (String featureString : ftrs) {
                    Feature feat = Feature.fromText(featureString);
                    if (Feature.NOT_FOUND == feat || Feature.NONE == feat) continue;
                    featuresFound.add(feat);
                }
                features = featuresFound.isEmpty() ? new ArrayList() : new ArrayList(featuresFound);
            }
            features.forEach(feature -> {
                queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                queryBuilder.append("feature").append("=").append(feature.getApiString());
            });
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            return new ArrayList<Pkg>();
        }
        LinkedList<Pkg> pkgs = new LinkedList<Pkg>();
        String bodyText = Helper.get(query, this.userAgent).body();
        HashSet<Pkg> pkgsFound = new HashSet<Pkg>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject pkgJsonObj = jsonArray.get(i).getAsJsonObject();
                pkgsFound.add(new Pkg(pkgJsonObj.toString()));
            }
        }
        pkgs.addAll(pkgsFound);
        return pkgs;
    }

    public CompletableFuture<List<Pkg>> getPkgsAsync(List<Distribution> distributions, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libCType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, List<ReleaseStatus> releaseStatus, TermOfSupport termOfSupport, List<Scope> scopes, Match match) {
        return this.getPkgsAsync(distributions, versionNumber, latest, operatingSystem, libCType, architecture, bitness, archiveType, packageType, javafxBundled, directlyDownloadable, releaseStatus, termOfSupport, new ArrayList<String>(), scopes, match);
    }

    public CompletableFuture<List<Pkg>> getPkgsAsync(List<Distribution> distributions, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libCType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, List<ReleaseStatus> releaseStatus, TermOfSupport termOfSupport, List<String> ftrs, List<Scope> scopes, Match match) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath());
        int initialLength = queryBuilder.length();
        if (null != distributions && !distributions.isEmpty()) {
            distributions.forEach(distribution -> {
                if (null != distribution) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("distro").append("=").append(distribution.getApiString());
                }
            });
        }
        if (null != versionNumber) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("version").append("=").append(Helper.encodeValue(versionNumber.toString(OutputFormat.REDUCED_COMPRESSED, true, true)));
        }
        if (null != latest && Latest.NONE != latest && Latest.NOT_FOUND != latest) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("latest").append("=").append(latest.getApiString());
        }
        if (null != operatingSystem && OperatingSystem.NONE != operatingSystem && OperatingSystem.NOT_FOUND != operatingSystem) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("operating_system").append("=").append(operatingSystem.getApiString());
        }
        if (null != libCType && LibCType.NONE != libCType && LibCType.NOT_FOUND != libCType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("libc_type").append("=").append(libCType.getApiString());
        }
        if (null != architecture && Architecture.NONE != architecture && Architecture.NOT_FOUND != architecture) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("architecture").append("=").append(architecture.getApiString());
        }
        if (null != bitness && Bitness.NONE != bitness && Bitness.NOT_FOUND != bitness) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("bitness").append("=").append(bitness.getApiString());
        }
        if (null != archiveType && ArchiveType.NONE != archiveType && ArchiveType.NOT_FOUND != archiveType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("archive_type").append("=").append(archiveType.getApiString());
        }
        if (null != packageType && PackageType.NONE != packageType && PackageType.NOT_FOUND != packageType) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("package_type").append("=").append(packageType.getApiString());
        }
        if (null != scopes && !scopes.isEmpty()) {
            scopes.forEach(scope -> {
                if (null != scope && Scope.NONE != scope && Scope.NOT_FOUND != scope) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("discovery_scope_id").append("=").append(scope.getApiString());
                }
            });
        }
        if (null != match && Match.NONE != match && Match.NOT_FOUND != match) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("match").append("=").append(match.getApiString());
        }
        if (null != javafxBundled) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("javafx_bundled").append("=").append(javafxBundled);
        }
        if (null != directlyDownloadable) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("directly_downloadable").append("=").append(directlyDownloadable);
        }
        if (null != releaseStatus && !releaseStatus.isEmpty()) {
            releaseStatus.forEach(rs -> {
                if (null != rs && ReleaseStatus.NONE != rs && ReleaseStatus.NOT_FOUND != rs) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("release_status").append("=").append(rs.getApiString());
                }
            });
        }
        if (null != termOfSupport && TermOfSupport.NONE != termOfSupport && TermOfSupport.NOT_FOUND != termOfSupport) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("term_of_support").append("=").append(termOfSupport.getApiString());
        }
        if (null != ftrs && !ftrs.isEmpty()) {
            ArrayList features;
            if (ftrs.isEmpty()) {
                features = new ArrayList();
            } else {
                HashSet<Feature> featuresFound = new HashSet<Feature>();
                for (String featureString : ftrs) {
                    Feature feat = Feature.fromText(featureString);
                    if (Feature.NOT_FOUND == feat || Feature.NONE == feat) continue;
                    featuresFound.add(feat);
                }
                features = featuresFound.isEmpty() ? new ArrayList() : new ArrayList(featuresFound);
            }
            features.forEach(feature -> {
                queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                queryBuilder.append("feature").append("=").append(feature.getApiString());
            });
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            return new CompletableFuture<List<Pkg>>();
        }
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            LinkedList pkgs = new LinkedList();
            HashSet<Pkg> pkgsFound = new HashSet<Pkg>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject pkgJsonObj = jsonArray.get(i).getAsJsonObject();
                    pkgsFound.add(new Pkg(pkgJsonObj.toString()));
                }
            }
            pkgs.addAll(pkgsFound);
            return pkgs;
        });
    }

    public String getPkgsAsJson(List<Distribution> distributions, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libcType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, List<ReleaseStatus> releaseStatus, TermOfSupport termOfSupport, List<Scope> scopes, Match match) {
        return this.getPkgs(distributions, versionNumber, latest, operatingSystem, libcType, architecture, bitness, archiveType, packageType, javafxBundled, directlyDownloadable, releaseStatus, termOfSupport, scopes, match).toString();
    }

    public CompletableFuture<String> getPkgsAsJsonAsync(List<Distribution> distributions, VersionNumber versionNumber, Latest latest, OperatingSystem operatingSystem, LibCType libcType, Architecture architecture, Bitness bitness, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable, List<ReleaseStatus> releaseStatus, TermOfSupport termOfSupport, List<Scope> scopes, Match match) {
        return this.getPkgsAsync(distributions, versionNumber, latest, operatingSystem, libcType, architecture, bitness, archiveType, packageType, javafxBundled, directlyDownloadable, releaseStatus, termOfSupport, scopes, match).thenApply(pkgs -> pkgs.toString());
    }

    public List<Pkg> getPkgsForFeatureVersion(List<Distribution> distributions, int featureVersion, List<ReleaseStatus> releaseStatus, Boolean directlyDownloadable, List<Scope> scopes, Match match) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath());
        int initialLength = queryBuilder.length();
        if (featureVersion <= 6) {
            throw new IllegalArgumentException("Feature version has to be larger or equal to 6");
        }
        if (null != distributions && !distributions.isEmpty()) {
            distributions.forEach(distribution -> {
                if (null != distribution) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("distro").append("=").append(distribution.getApiString());
                }
            });
        }
        queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
        queryBuilder.append("version").append("=").append(Helper.encodeValue(featureVersion + "..<" + (featureVersion + 1)));
        if (null != scopes && !scopes.isEmpty()) {
            scopes.forEach(scope -> {
                if (null != scope && Scope.NONE != scope && Scope.NOT_FOUND != scope) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("discovery_scope_id").append("=").append(scope.getApiString());
                }
            });
        }
        if (null != match && Match.NONE != match && Match.NOT_FOUND != match) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("match").append("=").append(match.getApiString());
        }
        if (null != directlyDownloadable) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("directly_downloadable").append("=").append(directlyDownloadable);
        }
        if (null != releaseStatus && !releaseStatus.isEmpty()) {
            releaseStatus.forEach(rs -> {
                if (null != rs && ReleaseStatus.NONE != rs && ReleaseStatus.NOT_FOUND != rs) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("release_status").append("=").append(rs.getApiString());
                }
            });
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            return new ArrayList<Pkg>();
        }
        LinkedList<Pkg> pkgs = new LinkedList<Pkg>();
        String bodyText = Helper.get(query, this.userAgent).body();
        HashSet<Pkg> pkgsFound = new HashSet<Pkg>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject pkgJsonObj = jsonArray.get(i).getAsJsonObject();
                pkgsFound.add(new Pkg(pkgJsonObj.toString()));
            }
        }
        pkgs.addAll(pkgsFound);
        return pkgs;
    }

    public CompletableFuture<List<Pkg>> getPkgsForFeatureVersionAsync(List<Distribution> distributions, int featureVersion, List<ReleaseStatus> releaseStatus, Boolean directlyDownloadable, List<Scope> scopes, Match match) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath());
        int initialLength = queryBuilder.length();
        if (featureVersion <= 6) {
            throw new IllegalArgumentException("Feature version has to be larger or equal to 6");
        }
        if (null != distributions && !distributions.isEmpty()) {
            distributions.forEach(distribution -> {
                if (null != distribution) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("distro").append("=").append(distribution.getApiString());
                }
            });
        }
        queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
        queryBuilder.append("version").append("=").append(Helper.encodeValue(featureVersion + "..<" + (featureVersion + 1)));
        if (null != scopes && !scopes.isEmpty()) {
            scopes.forEach(scope -> {
                if (null != scope && Scope.NONE != scope && Scope.NOT_FOUND != scope) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("discovery_scope_id").append("=").append(scope.getApiString());
                }
            });
        }
        if (null != match && Match.NONE != match && Match.NOT_FOUND != match) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("match").append("=").append(match.getApiString());
        }
        if (null != directlyDownloadable) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("directly_downloadable").append("=").append(directlyDownloadable);
        }
        if (null != releaseStatus && !releaseStatus.isEmpty()) {
            releaseStatus.forEach(rs -> {
                if (null != rs && ReleaseStatus.NONE != rs && ReleaseStatus.NOT_FOUND != rs) {
                    queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
                    queryBuilder.append("release_status").append("=").append(rs.getApiString());
                }
            });
        }
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            LinkedList pkgs = new LinkedList();
            HashSet<Pkg> pkgsFound = new HashSet<Pkg>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject pkgJsonObj = jsonArray.get(i).getAsJsonObject();
                    pkgsFound.add(new Pkg(pkgJsonObj.toString()));
                }
            }
            pkgs.addAll(pkgsFound);
            return pkgs;
        });
    }

    public final MajorVersion getMajorVersion(String parameter) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath());
        if (null != parameter || !parameter.isEmpty()) {
            queryBuilder.append("/").append(parameter);
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            return null;
        }
        Gson gson = new Gson();
        String bodyText = Helper.get(query, this.userAgent).body();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            if (jsonArray.size() > 0) {
                JsonObject json = jsonArray.get(0).getAsJsonObject();
                MajorVersion majorVersion = new MajorVersion(json.toString());
                return majorVersion;
            }
            return null;
        }
        return null;
    }

    public final CompletableFuture<MajorVersion> getMajorVersionAsync(String parameter) {
        String query;
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath());
        if (null != parameter || !parameter.isEmpty()) {
            queryBuilder.append("/").append(parameter);
        }
        if ((query = queryBuilder.toString()).isEmpty()) {
            return null;
        }
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                if (jsonArray.size() > 0) {
                    JsonObject json = jsonArray.get(0).getAsJsonObject();
                    MajorVersion majorVersion = new MajorVersion(json.toString());
                    return majorVersion;
                }
                return null;
            }
            return null;
        });
    }

    public final Queue<MajorVersion> getAllMajorVersions() {
        return this.getAllMajorVersions(false);
    }

    public final Queue<MajorVersion> getAllMajorVersions(boolean include_ea) {
        return this.getAllMajorVersions(include_ea, true);
    }

    public final Queue<MajorVersion> getAllMajorVersions(boolean include_ea, boolean include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("?ea=").append(include_ea).append(include_build ? "" : "&include_build=false");
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        ConcurrentLinkedQueue<MajorVersion> majorVersionsFound = new ConcurrentLinkedQueue<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final List<MajorVersion> getAllMajorVersions(Optional<Boolean> maintained, Optional<Boolean> include_ea, Optional<Boolean> include_ga, Optional<Boolean> include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath());
        int initialLength = queryBuilder.length();
        if (null != maintained && maintained.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("maintained=").append(maintained.get());
        }
        if (null != include_ea && include_ea.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ea=").append(include_ea.get());
        }
        if (null != include_ga && include_ga.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ga=").append(include_ga.get());
        }
        if (null != include_build && include_build.isPresent() && !include_build.get().booleanValue()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("include_build=false");
        }
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final CompletableFuture<List<MajorVersion>> getAllMajorVersionsAsync() {
        return this.getAllMajorVersionsAsync(false);
    }

    public final CompletableFuture<List<MajorVersion>> getAllMajorVersionsAsync(boolean include_ea) {
        return this.getAllMajorVersionsAsync(include_ea, true);
    }

    public final CompletableFuture<List<MajorVersion>> getAllMajorVersionsAsync(boolean include_ea, boolean include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("?ea=").append(include_ea).append(include_build ? "" : "&include_build=false");
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(reponse -> {
            CopyOnWriteArrayList<MajorVersion> majorVersionsFound = new CopyOnWriteArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)reponse.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final CompletableFuture<List<MajorVersion>> getAllMajorVersionsAsync(Optional<Boolean> maintained, Optional<Boolean> include_ea, Optional<Boolean> include_ga, Optional<Boolean> include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath());
        int initialLength = queryBuilder.length();
        if (null != maintained && maintained.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("maintained=").append(maintained.get());
        }
        if (null != include_ea && include_ea.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ea=").append(include_ea.get());
        }
        if (null != include_ga && include_ga.isPresent()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("ga=").append(include_ga.get());
        }
        if (null != include_build && include_build.isPresent() && !include_build.get().booleanValue()) {
            queryBuilder.append(queryBuilder.length() == initialLength ? "?" : "&");
            queryBuilder.append("include_build=false");
        }
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final MajorVersion getMajorVersion(int featureVersion, boolean include_ea) {
        return this.getMajorVersion(featureVersion, include_ea, true);
    }

    public final MajorVersion getMajorVersion(int featureVersion, boolean include_ea, boolean include_build) {
        Gson gson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("?include_ea=").append(include_ea).append(include_build ? "" : "&include_build=false");
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject json = jsonArray.get(i).getAsJsonObject();
                MajorVersion majorVersion = new MajorVersion(json.toString());
                if (majorVersion.getAsInt() != featureVersion) continue;
                return majorVersion;
            }
            return null;
        }
        return null;
    }

    public final CompletableFuture<MajorVersion> getMajorVersionAsync(int featureVersion, boolean include_ea) {
        return this.getMajorVersionAsync(featureVersion, include_ea, true);
    }

    public final CompletableFuture<MajorVersion> getMajorVersionAsync(int featureVersion, boolean include_ea, boolean include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("?include_ea=").append(include_ea).append(include_build ? "" : "&include_build=false");
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject json = jsonArray.get(i).getAsJsonObject();
                    MajorVersion majorVersion = new MajorVersion(json.toString());
                    if (majorVersion.getAsInt() != featureVersion) continue;
                    return majorVersion;
                }
                return null;
            }
            return null;
        });
    }

    public final String getMajorVersionAsJson(String parameter) {
        MajorVersion majorVersion = this.getMajorVersion(parameter);
        if (null == majorVersion) {
            return "{" + "\n" + "  \"value\"" + ":" + "\"" + majorVersion + "\"" + "," + "\n" + "  \"detail\"" + ":" + "\"Requested release has wrong format or is null.\"" + "," + "\n" + "  \"supported\"" + ":" + "\"1 - next early access" + ",current, last, latest, next, prev, last_lts, latest_lts, last_mts, latest_mts, last_sts, latest_mts, next_lts, next_mts, next_sts\"" + "\n" + "}";
        }
        return majorVersion.toString();
    }

    public final CompletableFuture<String> getMajorVersionAsJsonAsync(String parameter) {
        return this.getMajorVersionAsync(parameter).thenApply(majorVersion -> {
            if (null == majorVersion) {
                return "{" + "\n" + "  \"value\"" + ":" + "\"" + majorVersion + "\"" + "," + "\n" + "  \"detail\"" + ":" + "\"Requested release has wrong format or is null.\"" + "," + "\n" + "  \"supported\"" + ":" + "\"1 - next early access" + ",current, last, latest, next, prev, last_lts, latest_lts, last_mts, latest_mts, last_sts, latest_mts, next_lts, next_mts, next_sts\"" + "\n" + "}";
            }
            return majorVersion.toString();
        });
    }

    public final List<MajorVersion> getMaintainedMajorVersions() {
        return this.getMaintainedMajorVersions(false);
    }

    public final List<MajorVersion> getMaintainedMajorVersions(boolean include_ea) {
        return this.getMaintainedMajorVersions(include_ea, true);
    }

    public final List<MajorVersion> getMaintainedMajorVersions(boolean include_ea, boolean include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("?maintained=true&ga=true").append(include_ea ? "&ea=true" : "").append(include_build ? "" : "&include_build=false");
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final CompletableFuture<List<MajorVersion>> getMaintainedMajorVersionsAsync() {
        return this.getMaintainedMajorVersionsAsync(false);
    }

    public final CompletableFuture<List<MajorVersion>> getMaintainedMajorVersionsAsync(boolean include_ea) {
        return this.getMaintainedMajorVersionsAsync(include_ea, true);
    }

    public final CompletableFuture<List<MajorVersion>> getMaintainedMajorVersionsAsync(boolean include_ea, boolean include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("?maintained=true&ga=true").append(include_ea ? "&ea=true" : "").append(include_build ? "" : "&include_build=false");
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final List<MajorVersion> getUsefulMajorVersions() {
        return this.getUsefulMajorVersions(true);
    }

    public final List<MajorVersion> getUsefulMajorVersions(boolean include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("/useful").append(include_build ? "" : "&include_build=false");
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
            }
        }
        return majorVersionsFound;
    }

    public final CompletableFuture<List<MajorVersion>> getUsefulMajorVersionsAsync() {
        return this.getUsefulMajorVersionsAsync(true);
    }

    public final CompletableFuture<List<MajorVersion>> getUsefulMajorVersionsAsync(boolean include_build) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getMajorVersionsPath()).append("/useful").append(include_build ? "" : "include_build=false");
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            ArrayList<MajorVersion> majorVersionsFound = new ArrayList<MajorVersion>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject majorVersionJsonObj = jsonArray.get(i).getAsJsonObject();
                    majorVersionsFound.add(new MajorVersion(majorVersionJsonObj.toString()));
                }
            }
            return majorVersionsFound;
        });
    }

    public final MajorVersion getLatestLts(boolean include_ea) {
        return this.getLatestLts(include_ea, true);
    }

    public final MajorVersion getLatestLts(boolean include_ea, boolean include_build) {
        Queue<MajorVersion> majorVersions = this.getAllMajorVersions(include_ea, include_build);
        return majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS == majorVersion.getTermOfSupport()).filter(majorVersion -> include_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get();
    }

    public final CompletableFuture<MajorVersion> getLatestLtsAsync(boolean include_ea) {
        return this.getLatestLtsAsync(include_ea, true);
    }

    public final CompletableFuture<MajorVersion> getLatestLtsAsync(boolean include_ea, boolean include_build) {
        return this.getAllMajorVersionsAsync(include_ea, include_build).thenApply(majorVersions -> majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS == majorVersion.getTermOfSupport()).filter(majorVersion -> include_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get());
    }

    public final MajorVersion getLatestMts(boolean include_ea) {
        return this.getLatestMts(include_ea, true);
    }

    public final MajorVersion getLatestMts(boolean include_ea, boolean include_build) {
        Queue<MajorVersion> majorVersions = this.getAllMajorVersions(include_ea, include_build);
        return majorVersions.stream().filter(majorVersion -> TermOfSupport.MTS == majorVersion.getTermOfSupport()).filter(majorVersion -> include_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get();
    }

    public final CompletableFuture<MajorVersion> getLatestMtsAsync(boolean include_ea) {
        return this.getLatestLtsAsync(include_ea, true);
    }

    public final CompletableFuture<MajorVersion> getLatestMtsAsync(boolean include_ea, boolean include_build) {
        return this.getAllMajorVersionsAsync(include_ea, include_build).thenApply(majorVersions -> majorVersions.stream().filter(majorVersion -> TermOfSupport.MTS == majorVersion.getTermOfSupport()).filter(majorVersion -> include_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get());
    }

    public final MajorVersion getLatestSts(boolean include_ea) {
        return this.getLatestSts(include_ea, true);
    }

    public final MajorVersion getLatestSts(boolean include_ea, boolean include_build) {
        Queue<MajorVersion> majorVersions = this.getAllMajorVersions(include_ea, include_build);
        return majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS != majorVersion.getTermOfSupport()).filter(majorVersion -> include_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get();
    }

    public final CompletableFuture<MajorVersion> getLatestStsAsync(boolean include_ea) {
        return this.getLatestStsAsync(include_ea, true);
    }

    public final CompletableFuture<MajorVersion> getLatestStsAsync(boolean include_ea, boolean include_build) {
        return this.getAllMajorVersionsAsync(include_ea, include_build).thenApply(majorVersions -> majorVersions.stream().filter(majorVersion -> TermOfSupport.LTS != majorVersion.getTermOfSupport()).filter(majorVersion -> include_ea ? majorVersion.getVersions().size() > 0 : majorVersion.getVersions().size() > 1).findFirst().get());
    }

    public final Set<Distribution> getDistributionsThatSupportVersion(String version) {
        Semver semver = Semver.fromText(version).getSemver1();
        if (null == semver) {
            return new HashSet<Distribution>();
        }
        return this.getDistributionsThatSupportVersion(semver);
    }

    public final Set<Distribution> getDistributionsThatSupportVersion(Semver semVer) {
        return this.getDistributionsForSemver(semVer);
    }

    public final CompletableFuture<Set<Distribution>> getDistributionsThatSupportSemverAsync(Semver semVer) {
        return this.getDistributionsForSemverAsync(semVer);
    }

    public final CompletableFuture<List<Distribution>> getDistributionsThatSupportVersionAsync(String version) {
        return this.getDistributionsThatSupportVersionAsync(VersionNumber.fromText(version));
    }

    public final CompletableFuture<List<Distribution>> getDistributionsThatSupportVersionAsync(VersionNumber versionNumber) {
        return this.getDistributionsForVersionAsync(versionNumber);
    }

    public final List<Distribution> getDistributionsThatSupportVersion(VersionNumber versionNumber) {
        return this.getDistributionsForVersion(versionNumber);
    }

    public final List<Distribution> getDistributionsThatSupport(Semver semVer, OperatingSystem operatingSystem, Architecture architecture, LibCType libcType, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.getPkgs(null, semVer.getVersionNumber(), Latest.NONE, operatingSystem, libcType, architecture, Bitness.NONE, archiveType, packageType, javafxBundled, directlyDownloadable, List.of(semVer.getReleaseStatus()), TermOfSupport.NONE, List.of(Scope.PUBLIC), Match.ANY).stream().map(pkg -> pkg.getDistribution()).distinct().collect(Collectors.toList());
    }

    public final CompletableFuture<List<Distribution>> getDistributionsThatSupportAsync(Semver semVer, OperatingSystem operatingSystem, Architecture architecture, LibCType libcType, ArchiveType archiveType, PackageType packageType, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.getPkgsAsync(null, semVer.getVersionNumber(), Latest.NONE, operatingSystem, libcType, architecture, Bitness.NONE, archiveType, packageType, javafxBundled, directlyDownloadable, List.of(semVer.getReleaseStatus()), TermOfSupport.NONE, List.of(Scope.PUBLIC), Match.ANY).thenApply(pkgs -> pkgs.stream().map(pkg -> pkg.getDistribution()).distinct().collect(Collectors.toList()));
    }

    public final List<Pkg> updateAvailableFor(Distribution distribution, Semver semver, Boolean javafxBundled) {
        return this.updateAvailableFor(distribution, semver, DiscoClient.getOperatingSystem(), DiscoClient.getArchitecture(), javafxBundled, Boolean.TRUE);
    }

    public final List<Pkg> updateAvailableFor(Distribution distribution, Semver semver, Architecture architecture, Boolean javafxBundled) {
        return this.updateAvailableFor(distribution, semver, DiscoClient.getOperatingSystem(), architecture, javafxBundled, Boolean.TRUE);
    }

    public final List<Pkg> updateAvailableFor(Distribution distribution, Semver semver, Architecture architecture, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.updateAvailableFor(distribution, semver, DiscoClient.getOperatingSystem(), architecture, javafxBundled, directlyDownloadable);
    }

    public final List<Pkg> updateAvailableFor(Distribution distribution, Semver semver, OperatingSystem operatingSystem, Architecture architecture, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.updateAvailableFor(distribution, semver, operatingSystem, architecture, javafxBundled, directlyDownloadable, null);
    }

    public final List<Pkg> updateAvailableFor(Distribution distribution, Semver semver, OperatingSystem operatingSystem, Architecture architecture, Boolean javafxBundled, Boolean directlyDownloadable, String feature) {
        List<Pkg> updatesFound = new ArrayList<Pkg>();
        try {
            List<String> features = null == feature ? List.of() : List.of(feature);
            List<Pkg> pkgs = this.getPkgs(null == distribution ? null : List.of(distribution), semver.getVersionNumber(), Latest.AVAILABLE, operatingSystem, LibCType.NONE, architecture, Bitness.NONE, ArchiveType.NONE, PackageType.JDK, javafxBundled, directlyDownloadable, List.of(ReleaseStatus.EA, ReleaseStatus.GA), TermOfSupport.NONE, features, List.of(Scope.PUBLIC), Match.ANY);
            Collections.sort(pkgs, Comparator.comparing(Pkg::getJavaVersion).reversed());
            if (pkgs.isEmpty()) {
                return updatesFound;
            }
            Pkg firstEntry = pkgs.get(0);
            Semver semVerFound = firstEntry.getJavaVersion();
            if (ReleaseStatus.EA == semVerFound.getReleaseStatus()) {
                if (semVerFound.compareTo(semver) > 0) {
                    updatesFound = pkgs.stream().filter(pkg -> pkg.getJavaVersion().compareTo(semVerFound) == 0).collect(Collectors.toList());
                }
            } else if (semVerFound.compareToIgnoreBuild(semver) > 0) {
                updatesFound = pkgs.stream().filter(pkg -> pkg.getJavaVersion().compareToIgnoreBuild(semVerFound) == 0).collect(Collectors.toList());
            }
            return updatesFound;
        }
        catch (RuntimeException e) {
            System.out.println("Error getting updates for " + distribution.getName() + ": " + e);
            return updatesFound;
        }
    }

    public final CompletableFuture<List<Pkg>> updateAvailableForAsync(Distribution distribution, Semver semver, Boolean javafxBundled) {
        return this.updateAvailableForAsync(distribution, semver, DiscoClient.getOperatingSystem(), DiscoClient.getArchitecture(), javafxBundled, Boolean.TRUE);
    }

    public final CompletableFuture<List<Pkg>> updateAvailableForAsync(Distribution distribution, Semver semver, Architecture architecture, Boolean javafxBundled) {
        return this.updateAvailableForAsync(distribution, semver, DiscoClient.getOperatingSystem(), architecture, javafxBundled, Boolean.TRUE);
    }

    public final CompletableFuture<List<Pkg>> updateAvailableForAsync(Distribution distribution, Semver semver, Architecture architecture, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.updateAvailableForAsync(distribution, semver, DiscoClient.getOperatingSystem(), architecture, javafxBundled, directlyDownloadable);
    }

    public final CompletableFuture<List<Pkg>> updateAvailableForAsync(Distribution distribution, Semver semver, OperatingSystem operatingSystem, Architecture architecture, Boolean javafxBundled, Boolean directlyDownloadable) {
        return this.getPkgsAsync(null == distribution ? null : List.of(distribution), semver.getVersionNumber(), Latest.AVAILABLE, operatingSystem, LibCType.NONE, architecture, Bitness.NONE, ArchiveType.NONE, PackageType.JDK, javafxBundled, directlyDownloadable, List.of(ReleaseStatus.EA, ReleaseStatus.GA), TermOfSupport.NONE, List.of(Scope.PUBLIC), Match.ANY).thenApplyAsync(pkgs -> {
            Collections.sort(pkgs, Comparator.comparing(Pkg::getJavaVersion).reversed());
            List<Object> updatesFound = new ArrayList();
            if (pkgs.isEmpty()) {
                return updatesFound;
            }
            Pkg firstEntry = (Pkg)pkgs.get(0);
            Semver semVerFound = firstEntry.getJavaVersion();
            if (ReleaseStatus.EA == semVerFound.getReleaseStatus()) {
                if (semVerFound.compareTo(semver) > 0) {
                    updatesFound = pkgs.stream().filter(pkg -> pkg.getJavaVersion().compareTo(semVerFound) == 0).collect(Collectors.toList());
                }
            } else if (semVerFound.compareToIgnoreBuild(semver) > 0) {
                updatesFound = pkgs.stream().filter(pkg -> pkg.getJavaVersion().compareToIgnoreBuild(semVerFound) == 0).collect(Collectors.toList());
            }
            return updatesFound;
        });
    }

    public final List<Distribution> getDistributions() {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath());
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                Distribution distribution = DiscoClient.getDistributionFromText(api_parameter);
                if (null == distribution) continue;
                distributionsFound.add(distribution);
            }
        }
        return distributionsFound;
    }

    public final CompletableFuture<List<Distribution>> getDistributionsAsync() {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath());
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                    Distribution distributionFound = DiscoClient.getDistributionFromText(api_parameter);
                    if (null == distributionFound) continue;
                    distributionsFound.add(distributionFound);
                }
            }
            return distributionsFound;
        });
    }

    public final Set<Distribution> getDistributionsForSemver(Semver semVer) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath()).append("/versions/").append(Helper.encodeValue(semVer.toString(true)));
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        LinkedHashSet<Distribution> distributionsFound = new LinkedHashSet<Distribution>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                Distribution distributionFound;
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.has("api_parameter") ? distributionJsonObj.get("api_parameter").getAsString() : "";
                Distribution distribution = distributionFound = api_parameter.isEmpty() ? null : DiscoClient.getDistributionFromText(api_parameter);
                if (null == distributionFound) continue;
                distributionsFound.add(distributionFound);
            }
        }
        return distributionsFound;
    }

    public final CompletableFuture<Set<Distribution>> getDistributionsForSemverAsync(Semver semVer) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath()).append("/versions/").append(Helper.encodeValue(semVer.toString(true)));
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            LinkedHashSet<Distribution> distributionsFound = new LinkedHashSet<Distribution>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Distribution distributionFound;
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.has("api_parameter") ? distributionJsonObj.get("api_parameter").getAsString() : "";
                    Distribution distribution = distributionFound = api_parameter.isEmpty() ? null : DiscoClient.getDistributionFromText(api_parameter);
                    if (null == distributionFound) continue;
                    distributionsFound.add(distributionFound);
                }
            }
            return distributionsFound;
        });
    }

    public final List<Distribution> getDistributionsForVersion(VersionNumber versionNumber) {
        return this.getDistributionsForVersion(versionNumber, List.of(), Match.ANY);
    }

    public final List<Distribution> getDistributionsForVersion(VersionNumber versionNumber, List<Scope> scopes, Match match) {
        StringBuilder scopeBuilder = new StringBuilder();
        if (!scopes.isEmpty()) {
            scopeBuilder.append("?discovery_scope_id=").append(scopes.stream().map(scope -> scope.getApiString()).collect(Collectors.joining("&discovery_scope_id=")));
            if (null != match && Match.NONE != match && Match.NOT_FOUND != match) {
                scopeBuilder.append("&match=").append(match.getApiString());
            }
        }
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath()).append("/versions/").append(Helper.encodeValue(versionNumber.toString(OutputFormat.REDUCED_COMPRESSED, true, true))).append((CharSequence)scopeBuilder);
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                Distribution distributionFound = DiscoClient.getDistributionFromText(api_parameter);
                if (null == distributionFound) continue;
                distributionsFound.add(distributionFound);
            }
        }
        return distributionsFound;
    }

    public final CompletableFuture<List<Distribution>> getDistributionsForVersionAsync(VersionNumber versionNumber) {
        return this.getDistributionsForVersionAsync(versionNumber, List.of(), Match.ANY);
    }

    public final CompletableFuture<List<Distribution>> getDistributionsForVersionAsync(VersionNumber versionNumber, List<Scope> scopes, Match match) {
        StringBuilder scopeBuilder = new StringBuilder();
        if (!scopes.isEmpty()) {
            scopeBuilder.append("?discovery_scope_id=").append(scopes.stream().map(scope -> scope.getApiString()).collect(Collectors.joining("&discovery_scope_id=")));
            if (null != match && Match.NONE != match && Match.NOT_FOUND != match) {
                scopeBuilder.append("&match=").append(match.getApiString());
            }
        }
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath()).append("/versions/").append(Helper.encodeValue(versionNumber.toString(OutputFormat.REDUCED_COMPRESSED, true, true))).append((CharSequence)scopeBuilder);
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            LinkedList<Distribution> distributionsFound = new LinkedList<Distribution>();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                    Distribution distributionFound = DiscoClient.getDistributionFromText(api_parameter);
                    if (null == distributionFound) continue;
                    distributionsFound.add(distributionFound);
                }
            }
            return distributionsFound;
        });
    }

    public static Map<Distribution, List<VersionNumber>> getVersionsPerDistribution() {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath());
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, "").body();
        LinkedHashMap<Distribution, List<VersionNumber>> distributionsFound = new LinkedHashMap<Distribution, List<VersionNumber>>();
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(bodyText, JsonElement.class);
        if (element instanceof JsonObject) {
            JsonObject jsonObject = element.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                Distribution distribution = DiscoClient.getDistributionFromText(api_parameter);
                LinkedList<VersionNumber> versions = new LinkedList<VersionNumber>();
                JsonArray versionsArray = distributionJsonObj.get("versions").getAsJsonArray();
                if (null == distribution) continue;
                for (int j = 0; j < versionsArray.size(); ++j) {
                    VersionNumber versionNumber = VersionNumber.fromText(versionsArray.get(j).getAsString());
                    versions.add(versionNumber);
                }
                distributionsFound.put(distribution, versions);
            }
        }
        return distributionsFound;
    }

    public static CompletableFuture<Map<Distribution, List<VersionNumber>>> getVersionsPerDistributionAsync() {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getDistributionsPath());
        String query = queryBuilder.toString();
        return Helper.getAsync(query, "").thenApply(response -> {
            LinkedHashMap distributionsFound = new LinkedHashMap();
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((String)response.body(), JsonElement.class);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = element.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject distributionJsonObj = jsonArray.get(i).getAsJsonObject();
                    String api_parameter = distributionJsonObj.get("api_parameter").getAsString();
                    Distribution distribution = DiscoClient.getDistributionFromText(api_parameter);
                    LinkedList<VersionNumber> versions = new LinkedList<VersionNumber>();
                    JsonArray versionsArray = distributionJsonObj.get("versions").getAsJsonArray();
                    if (null == distribution) continue;
                    for (int j = 0; j < versionsArray.size(); ++j) {
                        VersionNumber versionNumber = VersionNumber.fromText(versionsArray.get(j).getAsString());
                        versions.add(versionNumber);
                    }
                    distributionsFound.put(distribution, versions);
                }
            }
            return distributionsFound;
        });
    }

    public Map<String, Distribution> getDistros() {
        return DISTRIBUTIONS;
    }

    public List<Distribution> getDistributionsBasedOnOpenJDK() {
        return DISTRIBUTIONS.values().stream().filter(distribution -> distribution.getScopes().contains(Scope.BUILD_OF_OPEN_JDK)).filter(distribution -> distribution.getScopes().contains(Scope.PUBLIC)).collect(Collectors.toList());
    }

    public List<Distribution> getDistributionsBasedOnGraalVm() {
        return DISTRIBUTIONS.values().stream().filter(distribution -> distribution.getScopes().contains(Scope.BUILD_OF_GRAALVM)).filter(distribution -> distribution.getScopes().contains(Scope.PUBLIC)).collect(Collectors.toList());
    }

    public final String getPkgDirectDownloadUri(String pkgId) {
        if (null == pkgId || pkgId.isEmpty()) {
            throw new IllegalArgumentException("Package ID not valid");
        }
        Pkg pkg = this.getPkg(pkgId);
        if (PropertyManager.INSTANCE.getApiVersion().equals("2.0")) {
            return this.getPkgInfoByEphemeralId(pkg.getEphemeralId(), pkg.getJavaVersion()).getDirectDownloadUri();
        }
        return this.getPkgInfoByPkgId(pkgId, pkg.getJavaVersion()).getDirectDownloadUri();
    }

    public final CompletableFuture<String> getPkgDirectDownloadUriAsync(String pkgId) {
        if (null == pkgId || pkgId.isEmpty()) {
            throw new IllegalArgumentException("Package ID not valid");
        }
        if (PropertyManager.INSTANCE.getApiVersion().equals("2.0")) {
            return (CompletableFuture)((CompletableFuture)this.getPkgAsync(pkgId).thenApply(pkg -> this.getPkgInfoByEphemeralIdAsync(pkg.getEphemeralId(), pkg.getJavaVersion()).thenApply(pkgInfo -> pkgInfo.getDirectDownloadUri()))).join();
        }
        return (CompletableFuture)((CompletableFuture)this.getPkgAsync(pkgId).thenApply(pkg -> this.getPkgInfoByPkgIdAsync(pkgId, pkg.getJavaVersion()).thenApply(pkgInfo -> pkgInfo.getDirectDownloadUri()))).join();
    }

    public final String getPkgDownloadSiteUri(String pkgId) {
        if (null == pkgId || pkgId.isEmpty()) {
            throw new IllegalArgumentException("Package ID not valid");
        }
        Pkg pkg = this.getPkg(pkgId);
        if (PropertyManager.INSTANCE.getApiVersion().equals("2.0")) {
            return this.getPkgInfoByEphemeralId(pkg.getEphemeralId(), pkg.getJavaVersion()).getDownloadSiteUri();
        }
        return this.getPkgInfoByPkgId(pkgId, pkg.getJavaVersion()).getDownloadSiteUri();
    }

    public final CompletableFuture<String> getPkgDownloadSiteUriAsync(String pkgId) {
        if (null == pkgId || pkgId.isEmpty()) {
            throw new IllegalArgumentException("Package ID not valid");
        }
        if (PropertyManager.INSTANCE.getApiVersion().equals("2.0")) {
            return (CompletableFuture)((CompletableFuture)this.getPkgAsync(pkgId).thenApply(pkg -> this.getPkgInfoByEphemeralIdAsync(pkg.getEphemeralId(), pkg.getJavaVersion()).thenApply(pkgInfo -> pkgInfo.getDownloadSiteUri()))).join();
        }
        return (CompletableFuture)((CompletableFuture)this.getPkgAsync(pkgId).thenApply(pkg -> this.getPkgInfoByPkgIdAsync(pkgId, pkg.getJavaVersion()).thenApply(pkgInfo -> pkgInfo.getDownloadSiteUri()))).join();
    }

    public PkgInfo getPkgInfoByEphemeralId(String ephemeralId, Semver javaVersion) {
        if (null == ephemeralId || ephemeralId.isEmpty() || null == javaVersion) {
            throw new IllegalArgumentException("ephemeralId or javaVersion cannot be null");
        }
        Gson packageInfoGson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getEphemeralIdsPath()).append("/").append(ephemeralId);
        String query = queryBuilder.toString();
        String packageInfoBody = Helper.get(query, this.userAgent).body();
        JsonElement packageInfoElement = (JsonElement)packageInfoGson.fromJson(packageInfoBody, JsonElement.class);
        if (packageInfoElement instanceof JsonObject) {
            JsonObject jsonObject = packageInfoElement.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            if (jsonArray.size() > 0) {
                HashAlgorithm checksumType;
                JsonObject packageInfoJson = jsonArray.get(0).getAsJsonObject();
                String filename = packageInfoJson.has("filename") ? packageInfoJson.get("filename").getAsString() : "";
                String directDownloadUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("direct_download_uri").getAsString() : "";
                String downloadSiteUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("download_site_uri").getAsString() : "";
                String signatureUri = packageInfoJson.has("signature_uri") ? packageInfoJson.get("signature_uri").getAsString() : "";
                String checksumUri = packageInfoJson.has("checksum_uri") ? packageInfoJson.get("checksum_uri").getAsString() : "";
                String checksum = packageInfoJson.has("checksum") ? packageInfoJson.get("checksum").getAsString() : "";
                HashAlgorithm hashAlgorithm = checksumType = packageInfoJson.has("checksum_type") ? HashAlgorithm.fromText(packageInfoJson.get("checksum_type").getAsString()) : HashAlgorithm.NONE;
                if (null == filename) {
                    return null;
                }
                return new PkgInfo(filename, javaVersion, directDownloadUri, downloadSiteUri, signatureUri, checksumUri, checksum, checksumType);
            }
            return null;
        }
        return null;
    }

    public CompletableFuture<PkgInfo> getPkgInfoByEphemeralIdAsync(String ephemeralId, Semver javaVersion) {
        if (null == ephemeralId || ephemeralId.isEmpty() || null == javaVersion) {
            throw new IllegalArgumentException("ephemeralId or javaVersion cannot be null");
        }
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getEphemeralIdsPath()).append("/").append(ephemeralId);
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            Gson packageInfoGson = new Gson();
            JsonElement packageInfoElement = (JsonElement)packageInfoGson.fromJson((String)response.body(), JsonElement.class);
            if (packageInfoElement instanceof JsonObject) {
                JsonObject jsonObject = packageInfoElement.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                if (jsonArray.size() > 0) {
                    HashAlgorithm checksumType;
                    JsonObject packageInfoJson = jsonArray.get(0).getAsJsonObject();
                    String filename = packageInfoJson.has("filename") ? packageInfoJson.get("filename").getAsString() : "";
                    String directDownloadUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("direct_download_uri").getAsString() : "";
                    String downloadSiteUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("download_site_uri").getAsString() : "";
                    String signatureUri = packageInfoJson.has("signature_uri") ? packageInfoJson.get("signature_uri").getAsString() : "";
                    String checksumUri = packageInfoJson.has("checksum_uri") ? packageInfoJson.get("checksum_uri").getAsString() : "";
                    String checksum = packageInfoJson.has("checksum") ? packageInfoJson.get("checksum").getAsString() : "";
                    HashAlgorithm hashAlgorithm = checksumType = packageInfoJson.has("checksum_type") ? HashAlgorithm.fromText(packageInfoJson.get("checksum_type").getAsString()) : HashAlgorithm.NONE;
                    if (null == filename) {
                        return null;
                    }
                    return new PkgInfo(filename, javaVersion, directDownloadUri, downloadSiteUri, signatureUri, checksumUri, checksum, checksumType);
                }
                return null;
            }
            return null;
        });
    }

    public PkgInfo getPkgInfoByPkgId(String pkgId, Semver javaVersion) {
        if (null == pkgId || pkgId.isEmpty() || null == javaVersion) {
            throw new IllegalArgumentException("pkgId or javaVersion cannot be null");
        }
        Gson packageInfoGson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getIdsPath()).append("/").append(pkgId);
        String query = queryBuilder.toString();
        String packageInfoBody = Helper.get(query, this.userAgent).body();
        JsonElement packageInfoElement = (JsonElement)packageInfoGson.fromJson(packageInfoBody, JsonElement.class);
        if (packageInfoElement instanceof JsonObject) {
            JsonObject jsonObject = packageInfoElement.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            if (jsonArray.size() > 0) {
                HashAlgorithm checksumType;
                JsonObject packageInfoJson = jsonArray.get(0).getAsJsonObject();
                String filename = packageInfoJson.has("filename") ? packageInfoJson.get("filename").getAsString() : "";
                String directDownloadUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("direct_download_uri").getAsString() : "";
                String downloadSiteUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("download_site_uri").getAsString() : "";
                String signatureUri = packageInfoJson.has("signature_uri") ? packageInfoJson.get("signature_uri").getAsString() : "";
                String checksumUri = packageInfoJson.has("checksum_uri") ? packageInfoJson.get("checksum_uri").getAsString() : "";
                String checksum = packageInfoJson.has("checksum") ? packageInfoJson.get("checksum").getAsString() : "";
                HashAlgorithm hashAlgorithm = checksumType = packageInfoJson.has("checksum_type") ? HashAlgorithm.fromText(packageInfoJson.get("checksum_type").getAsString()) : HashAlgorithm.NONE;
                if (null == filename) {
                    return null;
                }
                return new PkgInfo(filename, javaVersion, directDownloadUri, downloadSiteUri, signatureUri, checksumUri, checksum, checksumType);
            }
            return null;
        }
        return null;
    }

    public CompletableFuture<PkgInfo> getPkgInfoByPkgIdAsync(String pkgId, Semver javaVersion) {
        if (null == pkgId || pkgId.isEmpty() || null == javaVersion) {
            throw new IllegalArgumentException("pkgId or javaVersion cannot be null");
        }
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getIdsPath()).append("/").append(pkgId);
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            Gson packageInfoGson = new Gson();
            JsonElement packageInfoElement = (JsonElement)packageInfoGson.fromJson((String)response.body(), JsonElement.class);
            if (packageInfoElement instanceof JsonObject) {
                JsonObject jsonObject = packageInfoElement.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                if (jsonArray.size() > 0) {
                    HashAlgorithm checksumType;
                    JsonObject packageInfoJson = jsonArray.get(0).getAsJsonObject();
                    String filename = packageInfoJson.has("filename") ? packageInfoJson.get("filename").getAsString() : "";
                    String directDownloadUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("direct_download_uri").getAsString() : "";
                    String downloadSiteUri = packageInfoJson.has("direct_download_uri") ? packageInfoJson.get("download_site_uri").getAsString() : "";
                    String signatureUri = packageInfoJson.has("signature_uri") ? packageInfoJson.get("signature_uri").getAsString() : "";
                    String checksumUri = packageInfoJson.has("checksum_uri") ? packageInfoJson.get("checksum_uri").getAsString() : "";
                    String checksum = packageInfoJson.has("checksum") ? packageInfoJson.get("checksum").getAsString() : "";
                    HashAlgorithm hashAlgorithm = checksumType = packageInfoJson.has("checksum_type") ? HashAlgorithm.fromText(packageInfoJson.get("checksum_type").getAsString()) : HashAlgorithm.NONE;
                    if (null == filename) {
                        return null;
                    }
                    return new PkgInfo(filename, javaVersion, directDownloadUri, downloadSiteUri, signatureUri, checksumUri, checksum, checksumType);
                }
                return null;
            }
            return null;
        });
    }

    public final Future<?> downloadPkg(String pkgId, String targetFileName) throws InterruptedException {
        if (null == pkgId || pkgId.isEmpty()) {
            throw new IllegalArgumentException("pkgId cannot be null or empty");
        }
        if (null == targetFileName || targetFileName.isEmpty()) {
            throw new IllegalArgumentException("targetFileName cannot be null or empty");
        }
        Pkg pkg = this.getPkg(pkgId);
        if (null == pkg) {
            return null;
        }
        if (PropertyManager.INSTANCE.getApiVersion().equals("2.0")) {
            Semver javaVersion = pkg.getJavaVersion();
            String ephemeralId = pkg.getEphemeralId();
            return this.downloadPkg(ephemeralId, javaVersion, targetFileName);
        }
        Semver javaVersion = pkg.getJavaVersion();
        return this.downloadPkgByPkgId(pkgId, javaVersion, targetFileName);
    }

    public final Future<?> downloadPkg(String ephemeralId, Semver javaVersion, String targetFileName) throws InterruptedException {
        if (null == ephemeralId || ephemeralId.isEmpty()) {
            throw new IllegalArgumentException("ephemeralId cannot be null or empty");
        }
        if (null == javaVersion) {
            throw new IllegalArgumentException("javaVersion cannot be null");
        }
        if (null == targetFileName || targetFileName.isEmpty()) {
            throw new IllegalArgumentException("targetFileName cannot be null or empty");
        }
        String url = this.getPkgInfoByEphemeralId(ephemeralId, javaVersion).getDirectDownloadUri();
        FutureTask<Boolean> task = this.createDownloadTask(targetFileName, url);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(task);
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        return future;
    }

    public final Future<?> downloadPkg(PkgInfo pkgInfo, String targetFileName) throws InterruptedException {
        if (null == pkgInfo) {
            throw new IllegalArgumentException("pkgInfo cannot be null");
        }
        if (null == targetFileName || targetFileName.isEmpty()) {
            throw new IllegalArgumentException("targetFileName cannot be null or empty");
        }
        FutureTask<Boolean> task = this.createDownloadTask(targetFileName, pkgInfo.getDirectDownloadUri());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(task);
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        return future;
    }

    private final Future<?> downloadPkgByPkgId(String pkgId, Semver javaVersion, String targetFileName) throws InterruptedException {
        String url = this.getPkgInfoByPkgId(pkgId, javaVersion).getDirectDownloadUri();
        FutureTask<Boolean> task = this.createDownloadTask(targetFileName, url);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(task);
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        return future;
    }

    public Pkg getPkg(String pkgId) {
        Gson pkgGson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath()).append("/").append(pkgId);
        String query = queryBuilder.toString();
        String bodyText = Helper.get(query, this.userAgent).body();
        JsonElement pkgElement = (JsonElement)pkgGson.fromJson(bodyText, JsonElement.class);
        if (pkgElement instanceof JsonObject) {
            JsonObject jsonObject = pkgElement.getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("result");
            if (jsonArray.size() > 0) {
                JsonObject pkgJson = jsonArray.get(0).getAsJsonObject();
                return new Pkg(pkgJson.toString());
            }
            return null;
        }
        return null;
    }

    public CompletableFuture<Pkg> getPkgAsync(String pkgId) {
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append(PropertyManager.INSTANCE.getPackagesPath()).append("/").append(pkgId);
        String query = queryBuilder.toString();
        return Helper.getAsync(query, this.userAgent).thenApply(response -> {
            Gson pkgGson = new Gson();
            JsonElement pkgElement = (JsonElement)pkgGson.fromJson((String)response.body(), JsonElement.class);
            if (pkgElement instanceof JsonObject) {
                JsonObject jsonObject = pkgElement.getAsJsonObject();
                JsonArray jsonArray = jsonObject.getAsJsonArray("result");
                if (jsonArray.size() > 0) {
                    JsonObject pkgJson = jsonArray.get(0).getAsJsonObject();
                    return new Pkg(pkgJson.toString());
                }
                return null;
            }
            return null;
        });
    }

    public static Distribution getDistributionFromText(String text) {
        if (null == text) {
            return null;
        }
        if (DISTRIBUTIONS.isEmpty()) {
            DiscoClient.preloadDistributions();
            while (!initialized.get()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return DISTRIBUTIONS.values().stream().filter(distribution -> distribution.getFromText(text) != null).findFirst().orElse(null);
    }

    public String getReleaseDetailsUrl(String javaVersion) {
        if (null == javaVersion || javaVersion.isEmpty()) {
            return "";
        }
        return this.getReleaseDetailsUrl(Semver.fromText(javaVersion).getSemver1());
    }

    public String getReleaseDetailsUrl(Semver javaVersion) {
        JsonObject jsonObj;
        JsonArray jsonArray;
        if (null == javaVersion) {
            return "";
        }
        Gson gson = new Gson();
        StringBuilder queryBuilder = new StringBuilder().append(PropertyManager.INSTANCE.getString("url")).append("/").append("disco").append("/").append("v").append("3.0").append("/").append("release_details").append("/").append(javaVersion.getVersionNumber().toString(OutputFormat.REDUCED_COMPRESSED, true, false));
        String query = queryBuilder.toString();
        String jsonText = Helper.get(query, this.userAgent).body();
        JsonElement packageInfoElement = (JsonElement)gson.fromJson(jsonText, JsonElement.class);
        if (packageInfoElement instanceof JsonObject && (jsonArray = (jsonObj = packageInfoElement.getAsJsonObject()).getAsJsonArray("result")).size() > 0) {
            JsonObject releaseDetailsJson = jsonArray.get(0).getAsJsonObject();
            String releaseDetailsUrl = releaseDetailsJson.has("release_details_url") ? releaseDetailsJson.get("release_details_url").getAsString() : "";
            return null == releaseDetailsUrl ? "" : releaseDetailsUrl;
        }
        return "";
    }

    public void cancelRequest() {
        Helper.cancelRequest();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        if (null == userAgent || userAgent.isEmpty()) {
            return;
        }
        this.userAgent = userAgent;
    }

    public static final OperatingSystem getOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return OperatingSystem.WINDOWS;
        }
        if (os.indexOf("mac") >= 0) {
            return OperatingSystem.MACOS;
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(DETECT_ALPINE_CMDS);
                Process process = processBuilder.start();
                String result = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining("\n"));
                return null == result ? OperatingSystem.LINUX : (result.equals("1") ? OperatingSystem.ALPINE_LINUX : OperatingSystem.LINUX);
            }
            catch (IOException e) {
                e.printStackTrace();
                return OperatingSystem.LINUX;
            }
        }
        if (os.indexOf("sunos") >= 0) {
            return OperatingSystem.SOLARIS;
        }
        return OperatingSystem.NONE;
    }

    public static Architecture getArchitecture() {
        try {
            ProcessBuilder processBuilder = OperatingSystem.WINDOWS == DiscoClient.getOperatingSystem() ? new ProcessBuilder(WIN_DETECT_ARCH_CMDS) : new ProcessBuilder(UX_DETECT_ARCH_CMDS);
            Process process = processBuilder.start();
            String result = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining("\n"));
            return Architecture.fromText(result);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Architecture.NOT_FOUND;
        }
    }

    public final List<ArchiveType> getArchiveTypes(OperatingSystem os) {
        switch (os) {
            case WINDOWS: {
                return List.of(ArchiveType.CAB, ArchiveType.MSI, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case MACOS: {
                return List.of(ArchiveType.DMG, ArchiveType.PKG, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case LINUX: {
                return List.of(ArchiveType.APK, ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case LINUX_MUSL: {
                return List.of(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case ALPINE_LINUX: {
                return List.of(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case SOLARIS: {
                return List.of(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case AIX: {
                return List.of(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
            case QNX: {
                return List.of(ArchiveType.DEB, ArchiveType.RPM, ArchiveType.TAR, ArchiveType.ZIP);
            }
        }
        return Arrays.stream(ArchiveType.values()).filter(ext -> ArchiveType.NONE != ext).filter(ext -> ArchiveType.NOT_FOUND != ext).collect(Collectors.toList());
    }

    private final FutureTask<Boolean> createDownloadTask(String fileName, String url) {
        return new FutureTask<Boolean>(() -> {
            try {
                URLConnection connection = new URL(url).openConnection();
                int fileSize = connection.getContentLength();
                this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_STARTED, fileSize));
                ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
                ReadableConsumerByteChannel rcbc = new ReadableConsumerByteChannel(rbc, b -> this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_PROGRESS, (long)fileSize, b)));
                FileOutputStream fos = new FileOutputStream(fileName);
                fos.getChannel().transferFrom(rcbc, 0L, Long.MAX_VALUE);
                fos.close();
                rcbc.close();
                rbc.close();
                this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_FINISHED, fileSize));
                return true;
            }
            catch (IOException ex) {
                this.fireEvt(new DownloadEvt((Object)this, DownloadEvt.DOWNLOAD_FAILED, 0L));
                return false;
            }
        });
    }

    public final void setOnEvt(EvtType<? extends Evt> type, EvtObserver observer) {
        if (!this.observers.keySet().contains(type.getName())) {
            this.observers.put(type.getName(), new CopyOnWriteArrayList());
        }
        if (!this.observers.get(type.getName()).contains(observer)) {
            this.observers.get(type.getName()).add(observer);
        }
    }

    public final void removeOnEvt(EvtType<? extends Evt> type, EvtObserver observer) {
        if (!this.observers.keySet().contains(type.getName())) {
            return;
        }
        if (this.observers.get(type.getName()).contains(observer)) {
            this.observers.get(type.getName()).remove(observer);
        }
    }

    public final void removeAllObservers() {
        this.observers.entrySet().forEach(entry -> ((List)entry.getValue()).clear());
    }

    public final void fireEvt(Evt evt) {
        EvtType<? extends Evt> type = evt.getEvtType();
        if (this.observers.containsKey(type.getName())) {
            this.observers.get(type.getName()).forEach(observer -> observer.handle(evt));
        }
        if (this.observers.keySet().contains(DCEvt.ANY.getName())) {
            this.observers.get(DCEvt.ANY.getName()).forEach(observer -> observer.handle(evt));
        }
    }
}

