/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.lib.v8debug.JSONReader;
import org.netbeans.lib.v8debug.JSONWriter;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Event;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.connection.DebuggerConnection;
import org.netbeans.lib.v8debug.connection.IOListener;
import org.netbeans.lib.v8debug.connection.LinkedJSONContainterFactory;
import org.netbeans.lib.v8debug.connection.Utils;

public final class ServerConnection {
    private static final Logger LOG = Logger.getLogger(ServerConnection.class.getName());
    private static final String SERVER_PROTOCOL_VERSION = "1";
    private final ServerSocket server;
    private Socket currentSocket;
    private InputStream clientIn;
    private OutputStream clientOut;
    private final Object outLock = new Object();
    private final byte[] buffer = new byte[4096];
    private final ContainerFactory containerFactory = new LinkedJSONContainterFactory();
    private final Set<IOListener> ioListeners = new CopyOnWriteArraySet<IOListener>();

    public ServerConnection() throws IOException {
        this.server = new ServerSocket(0);
    }

    public ServerConnection(int serverPort) throws IOException, IllegalArgumentException {
        this.server = new ServerSocket(serverPort);
    }

    public void runConnectionLoop(Map<String, String> properties, Listener listener) throws IOException {
        Socket socket = this.server.accept();
        socket.setTcpNoDelay(true);
        this.currentSocket = socket;
        this.clientIn = socket.getInputStream();
        this.clientOut = socket.getOutputStream();
        this.sendProperties(properties);
        this.runEventLoop(listener);
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    private void runEventLoop(Listener listener) throws IOException {
        int n;
        byte[] emptyArray;
        int contentLength = -1;
        int[] beginPos = new int[]{0};
        int[] fromPtr = new int[]{0};
        int readOffset = 0;
        String tools = null;
        byte[] messageBytes = emptyArray = new byte[0];
        while ((n = this.clientIn.read(this.buffer, readOffset, 4096 - readOffset)) > 0) {
            n += readOffset;
            int from = 0;
            do {
                if (contentLength < 0) {
                    fromPtr[0] = from;
                    contentLength = DebuggerConnection.readContentLength(this.buffer, fromPtr, n, beginPos);
                    if (contentLength < 0) break;
                    from = fromPtr[0];
                }
                if (tools == null) {
                    fromPtr[0] = from;
                    tools = DebuggerConnection.readTools(this.buffer, fromPtr, n);
                    if (tools == null) break;
                    from = fromPtr[0];
                }
                int length = Math.min(contentLength - messageBytes.length, n - from);
                messageBytes = Utils.joinArrays(messageBytes, this.buffer, from, length);
                from += length;
                if (messageBytes.length != contentLength) continue;
                String message = new String(messageBytes, DebuggerConnection.CHAR_SET);
                try {
                    this.received(listener, tools, message);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (ParseException pex) {
                    throw new IOException(pex.getLocalizedMessage(), pex);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, message, t);
                }
                contentLength = -1;
                tools = null;
                messageBytes = emptyArray;
            } while (from < n);
            if (from < n) {
                System.arraycopy(this.buffer, from, this.buffer, 0, n - from);
                readOffset = n - from;
                continue;
            }
            readOffset = 0;
        }
    }

    private void received(Listener listener, String tools, String message) throws ParseException, IOException {
        this.fireReceived(message);
        LOG.log(Level.FINE, "RECEIVED: {0}, {1}", new Object[]{tools, message});
        if (message.isEmpty()) {
            return;
        }
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(message, this.containerFactory);
        V8Request request = JSONReader.getRequest(obj);
        ResponseProvider rp = listener.request(request);
        if (V8Command.Disconnect.equals((Object)request.getCommand())) {
            try {
                this.closeCurrentConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (rp != null) {
            rp.sendTo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProperties(Map<String, String> properties) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            sb.append(prop.getKey());
            sb.append(": ");
            sb.append(prop.getValue());
            sb.append("\r\n");
        }
        if (!properties.containsKey("Protocol-Version")) {
            sb.append("Protocol-Version: 1\r\n");
        }
        sb.append("Content-Length: 0\r\n\r\n");
        byte[] bytes = sb.toString().getBytes(DebuggerConnection.CHAR_SET);
        Object object = this.outLock;
        synchronized (object) {
            this.clientOut.write(bytes);
        }
    }

    private void send(V8Response response) throws IOException {
        JSONObject obj = JSONWriter.store(response);
        this.sendJSON(obj);
    }

    public void send(V8Event event) throws IOException {
        JSONObject obj = JSONWriter.store(event);
        this.sendJSON(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJSON(JSONObject obj) throws IOException {
        String text = obj.toJSONString();
        text = text.replace("\\/", "/");
        this.fireSent(text);
        LOG.log(Level.FINE, "SEND: {0}", text);
        byte[] bytes = text.getBytes(DebuggerConnection.CHAR_SET);
        String contentLength = "Content-Length: " + bytes.length + "\r\n" + "\r\n";
        Object object = this.outLock;
        synchronized (object) {
            if (this.clientOut == null) {
                throw new IOException("No client connection is opened.");
            }
            this.clientOut.write(contentLength.getBytes(DebuggerConnection.CHAR_SET));
            this.clientOut.write(bytes);
        }
    }

    public boolean isConnected() {
        return this.currentSocket != null && this.clientOut != null;
    }

    public void closeCurrentConnection() throws IOException {
        if (this.currentSocket != null) {
            this.currentSocket.close();
            this.currentSocket = null;
        }
    }

    public void closeServer() throws IOException {
        if (this.server != null) {
            this.server.close();
        }
        this.fireClosed();
    }

    public void addIOListener(IOListener iol) {
        this.ioListeners.add(iol);
    }

    public void removeIOListener(IOListener iol) {
        this.ioListeners.remove(iol);
    }

    private void fireSent(String str) {
        for (IOListener iol : this.ioListeners) {
            iol.sent(str);
        }
    }

    private void fireReceived(String str) {
        for (IOListener iol : this.ioListeners) {
            iol.received(str);
        }
    }

    private void fireClosed() {
        for (IOListener iol : this.ioListeners) {
            iol.closed();
        }
    }

    public static final class ResponseProvider {
        private V8Response response;
        private ServerConnection sc;

        private ResponseProvider(V8Response response) {
            this.response = response;
        }

        public static ResponseProvider create(V8Response response) {
            return new ResponseProvider(response);
        }

        public static ResponseProvider createLazy() {
            return new ResponseProvider(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResponse(V8Response response) throws IOException {
            ServerConnection sc;
            ResponseProvider responseProvider = this;
            synchronized (responseProvider) {
                if (this.response != null) {
                    throw new IllegalStateException("Response has been set already.");
                }
                this.response = response;
                sc = this.sc;
            }
            if (sc != null) {
                sc.send(response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendTo(ServerConnection sc) throws IOException {
            V8Response response;
            ResponseProvider responseProvider = this;
            synchronized (responseProvider) {
                response = this.response;
                this.sc = sc;
            }
            if (response != null) {
                sc.send(response);
            }
        }
    }

    public static interface Listener {
        public ResponseProvider request(V8Request var1);
    }
}

