/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.custom.hints.AddAttributeToSourceFix;
import org.netbeans.modules.html.custom.hints.Bundle;
import org.netbeans.modules.html.custom.hints.Utils;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;

public class MissingRequiredAttributes
extends Hint {
    private static final Rule RULE = new RuleI(false);
    private static final Rule LINE_RULE = new RuleI(true);

    public MissingRequiredAttributes(Collection<Attribute> attributes, OpenTag element, RuleContext context, OffsetRange range, boolean lineHint) {
        super(lineHint ? LINE_RULE : RULE, Bundle.missingRequiredAttributes(Utils.attributes2String(attributes)), context.parserResult.getSnapshot().getSource().getFileObject(), range, MissingRequiredAttributes.getFixes(attributes, element, context), 30);
    }

    private static List<HintFix> getFixes(Collection<Attribute> attributes, OpenTag element, RuleContext context) {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        Snapshot snap = context.parserResult.getSnapshot();
        for (Attribute aName : attributes) {
            fixes.add(new AddAttributeToSourceFix(aName, element, snap));
        }
        if (attributes.size() > 1) {
            fixes.add(new AddAttributeToSourceFix(attributes, element, snap));
        }
        return fixes;
    }

    private static class RuleI
    implements Rule {
        private final boolean lineHint;

        public RuleI(boolean lineHint) {
            this.lineHint = lineHint;
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return Bundle.missingRequiredAttributesRule();
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return this.lineHint ? HintSeverity.CURRENT_LINE_WARNING : HintSeverity.WARNING;
        }
    }
}

