/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.Page;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;

public class PageInspectorListener
implements Runnable,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(PageInspectorListener.class.getSimpleName());
    private PageInspector pageInspector;
    private Project project;
    private Page page;
    private FileObject file;
    private Lookup.Result<PageInspector> lookupResult;

    @Override
    public void run() {
        this.lookupResult = Lookup.getDefault().lookupResult(PageInspector.class);
        this.lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                PageInspectorListener.this.refreshPageInspector();
            }
        });
        this.refreshPageInspector();
    }

    private void refreshPageInspector() {
        Collection allInstances = this.lookupResult.allInstances();
        if (!allInstances.isEmpty()) {
            PageInspector pi = (PageInspector)allInstances.iterator().next();
            if (this.pageInspector != null) {
                this.pageInspector.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.pageInspector = pi;
            this.pageInspector.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String documentURL;
        if ("model".equals(pce.getPropertyName())) {
            LOGGER.log(Level.FINE, "PageInspector.PROP_MODEL PropertyChangeEvent");
            Node[] activatedNodes = TopComponent.getRegistry().getActivatedNodes();
            if (activatedNodes == null || activatedNodes.length == 0) {
                LOGGER.log(Level.FINE, "No activated nodes");
                return;
            }
            Node activatedNode = activatedNodes[0];
            LOGGER.log(Level.FINE, "Activated node {0}", activatedNode);
            this.project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (this.project == null) {
                LOGGER.log(Level.FINE, "No project in lookup");
                return;
            }
            LOGGER.log(Level.FINE, "Project in lookup {0}", this.project);
            if (this.page != null) {
                this.page.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.page = this.pageInspector.getPage();
            if (this.page == null) {
                LOGGER.log(Level.FINE, "No page object");
                this.project = null;
                return;
            }
            this.page.addPropertyChangeListener((PropertyChangeListener)this);
        } else if ("highlightedNodes".equals(pce.getPropertyName())) {
            if (this.file != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)this.file);
                    EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                    if (ec != null) {
                        ec.open();
                    }
                    this.file = null;
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if ("document".equals(pce.getPropertyName()) && (documentURL = this.page.getDocumentURL()) != null) {
            LOGGER.log(Level.FINE, "Document URL {0}", documentURL);
            try {
                URL url = new URL(documentURL);
                this.file = ServerURLMapping.fromServer((Project)this.project, (URL)url);
                LOGGER.log(Level.FINE, "Document URL converted to file {0}", this.file);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

