/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.ByteBufferAccess;
import java.nio.ByteBuffer;

abstract class AbstractByteBufferAccess
extends ByteBufferAccess {
    AbstractByteBufferAccess() {
    }

    @Override
    public final int getInt16(ByteBuffer buffer, int index) {
        return this.wrap(buffer).getShort(index);
    }

    @Override
    public final int getInt32(ByteBuffer buffer, int index) {
        return this.wrap(buffer).getInt(index);
    }

    @Override
    public final float getFloat(ByteBuffer buffer, int index) {
        return this.wrap(buffer).getFloat(index);
    }

    @Override
    public final double getDouble(ByteBuffer buffer, int index) {
        return this.wrap(buffer).getDouble(index);
    }

    @Override
    public long getInt64(ByteBuffer buffer, int index) {
        return this.wrap(buffer).getLong(index);
    }

    @Override
    public final void putInt16(ByteBuffer buffer, int index, int value) {
        this.wrap(buffer).putShort(index, (short)value);
    }

    @Override
    public final void putInt32(ByteBuffer buffer, int index, int value) {
        this.wrap(buffer).putInt(index, value);
    }

    @Override
    public final void putInt64(ByteBuffer buffer, int index, long value) {
        this.wrap(buffer).putLong(index, value);
    }

    @Override
    public final void putFloat(ByteBuffer buffer, int index, float value) {
        this.wrap(buffer).putFloat(index, value);
    }

    @Override
    public final void putDouble(ByteBuffer buffer, int index, double value) {
        this.wrap(buffer).putDouble(index, value);
    }

    protected ByteBuffer wrap(ByteBuffer buffer) {
        return buffer;
    }
}

