/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.api;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.selenium2.webclient.api.Bundle;
import org.netbeans.modules.selenium2.webclient.api.RunInfo;
import org.netbeans.modules.selenium2.webclient.api.Utilities;
import org.netbeans.modules.selenium2.webclient.spi.JumpToCallStackCallback;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public final class TestRunnerReporter {
    private static final Logger LOGGER = Logger.getLogger(TestRunnerReporter.class.getName());
    private final String NB_LINE;
    static final Pattern MULTI_CAPABILITIES = Pattern.compile("\\[launcher\\] Running (?<MULTICAPABILITIES>[\\d]+) instances of WebDriver");
    static final String CAPABILITY = "(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?";
    static final Pattern OK_PATTERN = Pattern.compile("^(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?([^(not )]*)ok (?<INDEX>[\\d]+) (?<FULLTITLE>.*), suite=(?<SUITE>.*), testcase=(?<TESTCASE>.*), duration=(?<DURATION>[\\d]+)");
    static final Pattern OK_SKIP_PATTERN = Pattern.compile("^(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?([^(not )]*)ok (?<INDEX>[\\d]+) (?<FULLTITLE>.*) # SKIP -, suite=(?<SUITE>.*), testcase=(?<TESTCASE>.*)");
    static final Pattern NOT_OK_PATTERN = Pattern.compile("^(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?(.*)not ok (?<INDEX>[\\d]+) (?<FULLTITLE>.*), suite=(?<SUITE>.*), testcase=(?<TESTCASE>.*), duration=(?<DURATION>[\\d]+)");
    static final Pattern SESSION_START_PATTERN = Pattern.compile("^(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?1\\.\\.(?<TOTAL>[\\d]+)");
    static final Pattern SESSION_END_PATTERN = Pattern.compile("^(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?(.*)tests (?<TOTAL>[\\d]+), pass (?<PASS>[\\d]+), fail (?<FAIL>[\\d]+), skip (?<SKIP>[\\d]+)");
    static final String SKIP = " # SKIP -";
    static final Pattern DONE_PATTERN = Pattern.compile("^(.*)Done.");
    private final RunInfo runInfo;
    private TestSession testSession;
    private TestSuite testSuite;
    private long testSuiteRuntime = 0L;
    private boolean hasTests = false;
    private int testIndex = 0;
    private Trouble trouble;
    private final ArrayList<String> stackTrace = new ArrayList();
    private String runningSuite;
    private String testcase;
    private long duration;
    private final boolean showOutput;
    private int multiCapabilities = 0;
    private String browser;
    private boolean normalSessionEnd = false;

    public TestRunnerReporter(RunInfo runInfo, String reporterSuffix) {
        assert (runInfo != null);
        this.runInfo = runInfo;
        this.showOutput = runInfo.isShowOutput();
        this.NB_LINE = reporterSuffix;
    }

    public String processLine(String logMessage) {
        int index = logMessage.indexOf(this.NB_LINE);
        String line = TestRunnerReporter.removeEscapeCharachters(logMessage).replace(this.NB_LINE, "");
        Matcher matcher = MULTI_CAPABILITIES.matcher(line);
        if (matcher.find()) {
            this.multiCapabilities = Integer.parseInt(matcher.group("MULTICAPABILITIES"));
            return logMessage;
        }
        matcher = DONE_PATTERN.matcher(line);
        if (matcher.find()) {
            if (!this.normalSessionEnd) {
                this.sessionFinishedAbnormally(line);
            }
            return logMessage;
        }
        if (index == -1) {
            if (this.trouble != null) {
                this.stackTrace.add(this.getStacktrace(line));
                return this.showOutput ? line : null;
            }
            return logMessage;
        }
        matcher = SESSION_START_PATTERN.matcher(line);
        if (matcher.find()) {
            if (this.multiCapabilities == 0 || this.multiCapabilities > 0 && matcher.group("CAPABILITY") == null || this.multiCapabilities > 0 && Integer.parseInt(matcher.group("CAPABILITY")) == 1) {
                this.sessionStarted(line);
                this.normalSessionEnd = false;
            }
            return this.showOutput ? line : null;
        }
        matcher = SESSION_END_PATTERN.matcher(line);
        if (matcher.find()) {
            this.handleTrouble();
            if (this.multiCapabilities == 0 || this.multiCapabilities > 0 && matcher.group("CAPABILITY") == null || this.multiCapabilities > 0 && Integer.parseInt(matcher.group("CAPABILITY")) == this.multiCapabilities) {
                this.sessionFinished(line);
                this.normalSessionEnd = true;
            }
            return this.showOutput ? "" : null;
        }
        matcher = OK_PATTERN.matcher(line);
        if (matcher.find()) {
            String output2display = this.parseTestResult(matcher);
            this.addTestCase(this.testcase, Status.PASSED, this.duration);
            if (!this.showOutput) {
                return null;
            }
            this.getManager().displayOutput(this.testSession, output2display, false);
            return output2display;
        }
        matcher = OK_SKIP_PATTERN.matcher(line);
        if (matcher.find()) {
            String output2display = this.parseTestResult(matcher).concat(SKIP);
            this.addTestCase(this.testcase, Status.SKIPPED, this.duration);
            if (!this.showOutput) {
                return null;
            }
            this.getManager().displayOutput(this.testSession, output2display, false);
            return output2display;
        }
        matcher = NOT_OK_PATTERN.matcher(line);
        if (matcher.find()) {
            String output2display = this.parseTestResult(matcher);
            if (!this.showOutput) {
                return null;
            }
            this.getManager().displayOutput(this.testSession, output2display, false);
            return output2display;
        }
        if (this.trouble != null) {
            this.stackTrace.add(this.getStacktrace(line));
        }
        return this.showOutput ? line : null;
    }

    private String getStacktrace(String line) {
        if (this.multiCapabilities > 0) {
            return line.replaceFirst(CAPABILITY, "");
        }
        return line;
    }

    private String getSuiteName(String suite) {
        if (this.browser == null) {
            return suite;
        }
        return "[" + this.browser + "] " + suite;
    }

    private String parseTestResult(Matcher matcher) {
        this.handleTrouble();
        this.testIndex = Integer.parseInt(matcher.group("INDEX"));
        this.browser = matcher.group("BROWSER");
        String suite = this.getSuiteName(matcher.group("SUITE"));
        this.testcase = matcher.group("TESTCASE");
        if (matcher.pattern().pattern().equals(NOT_OK_PATTERN.pattern())) {
            this.trouble = new Trouble(false);
        }
        this.duration = matcher.pattern().pattern().equals(OK_SKIP_PATTERN.pattern()) ? 0L : Long.parseLong(matcher.group("DURATION"));
        if (this.runningSuite == null) {
            this.runningSuite = suite;
            this.suiteStarted(this.runningSuite);
        } else if (!this.runningSuite.equals(suite)) {
            this.suiteFinished(this.runningSuite);
            this.runningSuite = suite;
            this.suiteStarted(this.runningSuite);
        }
        return (matcher.pattern().pattern().equals(NOT_OK_PATTERN.pattern()) ? "not ok " : "ok ") + this.testIndex + " " + this.runningSuite + " " + this.testcase;
    }

    private void handleTrouble() {
        if (this.trouble != null) {
            this.trouble.setStackTrace(this.stackTrace.toArray(new String[this.stackTrace.size()]));
            this.addTestCase(this.testcase, Status.FAILED, this.duration, this.trouble);
            this.stackTrace.clear();
            this.trouble = null;
        }
    }

    static String removeEscapeCharachters(String line) {
        return line.replace("[?25l", "").replace("[2K", "").replace("\u001b", "").replaceAll("\\[[;\\d]*m", "").trim();
    }

    private Manager getManager() {
        return Manager.getInstance();
    }

    private String getOutputTitle() {
        String testFile;
        StringBuilder sb = new StringBuilder(30);
        sb.append(ProjectUtils.getInformation((Project)this.runInfo.getProject()).getDisplayName());
        if (!this.runInfo.isTestingProject() && (testFile = this.runInfo.getTestFile()) != null) {
            sb.append(":");
            sb.append(new File(testFile).getName());
        }
        return this.runInfo.isSelenium() ? Bundle.TestRunner_selenium_runner_title(sb.toString()) : Bundle.TestRunner_unit_runner_title(sb.toString());
    }

    private void sessionStarted(String line) {
        assert (this.testSession == null);
        this.getManager().setNodeFactory(Utilities.getTestRunnerNodeFactory(new CallStackCallback(this.runInfo.getProject())));
        this.testSession = new TestSession(this.getOutputTitle(), this.runInfo.getProject(), TestSession.SessionType.TEST);
        this.testSession.setRerunHandler(this.runInfo.getRerunHandler());
        this.getManager().testStarted(this.testSession);
        if (this.showOutput) {
            this.getManager().displayOutput(this.testSession, line, false);
        }
    }

    private void sessionFinished(String line) {
        assert (this.testSession != null);
        if (this.testSuite != null) {
            this.suiteFinished(null);
        }
        if (!this.hasTests) {
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_tests_none_1(), true);
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_tests_none_2(), true);
        } else {
            this.getManager().displayOutput(this.testSession, Bundle.TestRunner_output_full(), false);
        }
        this.getManager().sessionFinished(this.testSession);
        this.testSession = null;
        this.runningSuite = null;
        this.hasTests = false;
    }

    private void sessionFinishedAbnormally(String line) {
        this.getManager().displayOutput(this.testSession, Bundle.TestRunner_session_finished_abnormally(), false);
        this.getManager().sessionFinished(this.testSession);
        this.testSession = null;
        this.runningSuite = null;
        this.hasTests = false;
    }

    private void suiteStarted(String line) {
        assert (this.testSession != null);
        if (this.testSuite != null) {
            this.suiteFinished(null);
        }
        assert (this.testSuite == null);
        assert (this.testSuiteRuntime == 0L);
        String name = Bundle.TestRunner_suite_name(line);
        if (!StringUtilities.hasText((String)name)) {
            name = Bundle.TestRunner_noName();
        }
        this.testSuite = new TestSuite(name);
        this.testSession.addSuite(this.testSuite);
        this.getManager().displaySuiteRunning(this.testSession, this.testSuite.getName());
    }

    private void suiteFinished(@NullAllowed String line) {
        assert (this.testSession != null);
        if (this.testSuite == null) {
            return;
        }
        this.getManager().displayReport(this.testSession, this.testSession.getReport(this.testSuiteRuntime), true);
        this.testSuite = null;
        this.testSuiteRuntime = 0L;
    }

    private void addTestCase(String name, Status status) {
        this.addTestCase(name, status, 0L);
    }

    private void addTestCase(String name, Status status, long runtime) {
        this.addTestCase(name, status, runtime, null);
    }

    private void addTestCase(String name, Status status, long runtime, Trouble trouble) {
        this.hasTests = true;
        Testcase testCase = new Testcase(name, "Selenium", this.testSession);
        testCase.setStatus(status);
        this.testSuiteRuntime += runtime;
        testCase.setTimeMillis(runtime);
        if (trouble != null) {
            testCase.setTrouble(trouble);
        }
        this.testSession.addTestCase(testCase);
    }

    public static final class CallStackCallback
    implements JumpToCallStackCallback {
        static final Pattern FILE_LINE_PATTERN_UNIX = Pattern.compile("^(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?(.*)at ([^/(]*)(?<FILE>[^:]+):(?<LINE>\\d+):(?<COLUMN>\\d+)");
        static final Pattern FILE_LINE_PATTERN_WINDOWS = Pattern.compile("^(\\[(?<BROWSER>.*) #(?<CAPABILITY>[\\d]+)\\] )?(.*)at (.*)(?<DRIVE>[a-zA-Z]:)(?<FILE>[^:]+):(?<LINE>\\d+):(?<COLUMN>\\d+)");
        final Project project;

        public CallStackCallback(Project project) {
            assert (project != null);
            this.project = project;
        }

        @Override
        public Pair<File, int[]> parseLocation(String callStack, boolean underTestRoot) {
            Matcher matcher = FILE_LINE_PATTERN_WINDOWS.matcher(callStack.trim());
            boolean matchFound = matcher.find();
            String drive = null;
            if (matchFound) {
                drive = matcher.group("DRIVE");
            } else {
                matcher = FILE_LINE_PATTERN_UNIX.matcher(callStack.trim());
                matchFound = matcher.find();
            }
            if (matchFound) {
                File file;
                String pathname = drive == null ? matcher.group("FILE") : drive.concat(matcher.group("FILE"));
                File path = new File(pathname.replace("(", ""));
                FileObject projectDir = this.project.getProjectDirectory();
                if (path.isAbsolute()) {
                    file = path;
                } else {
                    file = new File(FileUtil.toFile((FileObject)projectDir), path.getPath());
                    if (!file.isFile()) {
                        return null;
                    }
                }
                FileObject parent = underTestRoot ? Utilities.getTestsSeleniumFolder(this.project, false) : projectDir;
                FileObject fo = FileUtil.toFileObject((File)file);
                if (fo == null || underTestRoot && !FileUtil.isParentOf((FileObject)parent, (FileObject)fo)) {
                    return null;
                }
                return Pair.of((Object)file, (Object)new int[]{Integer.parseInt(matcher.group("LINE")), Integer.parseInt(matcher.group("COLUMN"))});
            }
            return null;
        }
    }
}

