/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UnicodeSet;
import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class NormalizationChecker
extends Checker {
    private static final UnicodeSet COMPOSING_CHARACTERS = new UnicodeSet("[[:nfc_qc=maybe:][:^ccc=0:]]").freeze();
    private char[] buf = new char[128];
    private char[] bufHolder = null;
    private int pos;
    private boolean atStartOfRun;
    private boolean alreadyComplainedAboutThisRun;
    private final boolean sourceTextMode;

    private static boolean isComposingCharOrSurrogate(char c) {
        if (UCharacter.isHighSurrogate((char)c) || UCharacter.isLowSurrogate((char)c)) {
            return true;
        }
        return NormalizationChecker.isComposingChar(c);
    }

    private static boolean isComposingChar(int c) {
        return COMPOSING_CHARACTERS.contains(c);
    }

    public static boolean startsWithComposingChar(String str) throws SAXException {
        int first32;
        if (str.length() == 0) {
            return false;
        }
        int first = str.charAt(0);
        if (UCharacter.isHighSurrogate((char)first)) {
            try {
                char second = str.charAt(1);
                first32 = UCharacter.getCodePoint((char)first, (char)second);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new SAXException("Malformed UTF-16!");
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e.getMessage());
            }
        } else {
            first32 = first;
        }
        return NormalizationChecker.isComposingChar(first32);
    }

    public NormalizationChecker() {
        this(false);
    }

    public NormalizationChecker(boolean sourceTextMode) {
        this.sourceTextMode = sourceTextMode;
        this.reset();
    }

    @Override
    public void reset() {
        this.atStartOfRun = true;
        this.alreadyComplainedAboutThisRun = false;
        this.pos = 0;
        if (this.bufHolder != null) {
            this.buf = this.bufHolder;
            this.bufHolder = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i;
        if (this.alreadyComplainedAboutThisRun) {
            return;
        }
        if (this.atStartOfRun) {
            char c = ch[start];
            if (this.pos == 1) {
                if (NormalizationChecker.isComposingChar(UCharacter.getCodePoint((char)this.buf[0], (char)c))) {
                    this.warn("Text run starts with a composing character.");
                }
                this.atStartOfRun = false;
            } else {
                if (length == 1 && UCharacter.isHighSurrogate((char)c)) {
                    this.buf[0] = c;
                    this.pos = 1;
                    return;
                }
                if (UCharacter.isHighSurrogate((char)c)) {
                    if (NormalizationChecker.isComposingChar(UCharacter.getCodePoint((char)c, (char)ch[start + 1]))) {
                        this.warn("Text run starts with a composing character.");
                    }
                } else if (NormalizationChecker.isComposingCharOrSurrogate(c)) {
                    this.warn("Text run starts with a composing character.");
                }
                this.atStartOfRun = false;
            }
        }
        int stop = start + length;
        if (this.pos > 0) {
            for (i = start; i < stop && NormalizationChecker.isComposingCharOrSurrogate(ch[i]); ++i) {
            }
            this.appendToBuf(ch, start, i);
            if (i == stop) {
                return;
            }
            if (!Normalizer.isNormalized((char[])this.buf, (int)0, (int)this.pos, (Normalizer.Mode)Normalizer.NFC, (int)0)) {
                this.errAboutTextRun();
            }
            this.pos = 0;
        }
        if (i < stop) {
            start = i;
            for (i = stop - 1; i > start && NormalizationChecker.isComposingCharOrSurrogate(ch[i]); --i) {
            }
            if (i > start && !Normalizer.isNormalized((char[])ch, (int)start, (int)i, (Normalizer.Mode)Normalizer.NFC, (int)0)) {
                this.errAboutTextRun();
            }
            this.appendToBuf(ch, i, stop);
        }
    }

    private void errAboutTextRun() throws SAXException {
        if (this.sourceTextMode) {
            this.warn("Source text is not in Unicode Normalization Form C.");
        } else {
            this.warn("Text run is not in Unicode Normalization Form C.");
        }
        this.alreadyComplainedAboutThisRun = true;
    }

    private void appendToBuf(char[] ch, int start, int end) {
        if (start == end) {
            return;
        }
        int neededBufLen = this.pos + (end - start);
        if (neededBufLen > this.buf.length) {
            char[] newBuf = new char[neededBufLen];
            System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
            if (this.bufHolder == null) {
                this.bufHolder = this.buf;
            }
            this.buf = newBuf;
        }
        System.arraycopy(ch, start, this.buf, this.pos, end - start);
        this.pos += end - start;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flush();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.flush();
        if (!target.isEmpty() && NormalizationChecker.startsWithComposingChar(target)) {
            this.warn("Processing instruction target starts with a composing character.");
        }
        if (!data.isEmpty()) {
            if (NormalizationChecker.startsWithComposingChar(data)) {
                this.warn("Processing instruction data starts with a composing character.");
            } else if (!Normalizer.isNormalized((String)data, (Normalizer.Mode)Normalizer.NFC, (int)0)) {
                this.warn("Processing instruction data in not in Unicode Normalization Form C.");
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.flush();
        if (NormalizationChecker.startsWithComposingChar(localName)) {
            this.warn("Element name \u201c " + localName + "\u201d starts with a composing character.");
        }
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String value;
            String name = atts.getLocalName(i);
            if (NormalizationChecker.startsWithComposingChar(name)) {
                this.warn("Attribute name \u201c " + localName + "\u201d starts with a composing character.");
            }
            if ("".equals(value = atts.getValue(i))) continue;
            if (NormalizationChecker.startsWithComposingChar(value)) {
                this.warn("The value of attribute \u201c" + atts.getLocalName(i) + "\u201d" + ("".equals(atts.getURI(i)) ? "" : " in namespace \u201c" + atts.getURI(i) + "\u201d") + " on element \u201c" + localName + "\u201d from namespace \u201c" + uri + "\u201d starts with a composing character.");
                continue;
            }
            if (Normalizer.isNormalized((String)value, (Normalizer.Mode)Normalizer.NFC, (int)0)) continue;
            this.warn("The value of attribute \u201c" + atts.getLocalName(i) + "\u201d" + ("".equals(atts.getURI(i)) ? "" : " in namespace \u201c" + atts.getURI(i) + "\u201d") + " on element \u201c" + localName + "\u201d from namespace \u201c" + uri + "\u201d is not in Unicode Normalization Form C.");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (NormalizationChecker.startsWithComposingChar(prefix)) {
            this.warn("Namespace prefix \u201c " + prefix + "\u201d starts with a composing character.");
        }
        if (NormalizationChecker.startsWithComposingChar(uri)) {
            this.warn("Namespace URI \u201c " + uri + "\u201d starts with a composing character.");
        }
    }

    public void flush() throws SAXException {
        if (!this.alreadyComplainedAboutThisRun && !Normalizer.isNormalized((char[])this.buf, (int)0, (int)this.pos, (Normalizer.Mode)Normalizer.NFC, (int)0)) {
            this.errAboutTextRun();
        }
        this.reset();
    }
}

