/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.EventListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.javascript2.debug.EditorLineHandler;
import org.netbeans.modules.javascript2.debug.EditorLineHandlerFactory;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.WeakListeners;

public class JSLineBreakpoint
extends Breakpoint {
    public static final String PROP_URL = "url";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_FILE = "fileChanged";
    public static final String PROP_CONDITION = "condition";
    private EditorLineHandler line;
    private boolean isEnabled = true;
    private volatile String condition;
    private final FileRemoveListener myListener = new FileRemoveListener();
    private FileChangeListener myWeakListener;
    private final LineChangesListener lineChangeslistener = new LineChangesListener();
    private PropertyChangeListener lineChangesWeak;

    public JSLineBreakpoint(EditorLineHandler line) {
        this.line = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
        FileObject fileObject = line.getFileObject();
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
        }
    }

    public EditorLineHandler getLineHandler() {
        return this.line;
    }

    public void setLineHandler(EditorLineHandler line) {
        this.dispose();
        EditorLineHandler oldLine = this.line;
        this.line = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
        FileObject fileObject = line.getFileObject();
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
        }
        this.firePropertyChange(PROP_FILE, oldLine.getFileObject(), line.getFileObject());
        this.firePropertyChange(PROP_LINE_NUMBER, oldLine.getLineNumber(), line.getLineNumber());
    }

    public void setLine(int lineNumber) {
        if (this.line.getLineNumber() == lineNumber) {
            return;
        }
        this.line.setLineNumber(lineNumber);
    }

    public int getLineNumber() {
        return this.line.getLineNumber();
    }

    public FileObject getFileObject() {
        return this.line.getFileObject();
    }

    public URL getURL() {
        return this.line.getURL();
    }

    public void disable() {
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.isEnabled) {
            return;
        }
        this.isEnabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected void dispose() {
        super.dispose();
        this.line.dispose();
        FileObject fileObject = this.line.getFileObject();
        if (fileObject != null) {
            fileObject.removeFileChangeListener(this.myWeakListener);
            this.myWeakListener = null;
        }
    }

    public final String getCondition() {
        return this.condition;
    }

    public final void setCondition(String condition) {
        String oldCondition = this.condition;
        if (condition != null && condition.equals(oldCondition) || condition == null && oldCondition == null) {
            return;
        }
        this.condition = condition;
        this.firePropertyChange(PROP_CONDITION, oldCondition, condition);
    }

    public final boolean isConditional() {
        return this.condition != null && !this.condition.isEmpty();
    }

    final void setValid(String message) {
        this.setValidity(Breakpoint.VALIDITY.VALID, message);
    }

    final void setInvalid(String message) {
        this.setValidity(Breakpoint.VALIDITY.INVALID, message);
    }

    final void resetValidity() {
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
    }

    public String toString() {
        return "JSLineBreakpoint{line=" + this.line + ", FileObject = " + this.getFileObject() + ", isEnabled=" + this.isEnabled + ", condition=" + this.condition + '}';
    }

    private class LineChangesListener
    implements PropertyChangeListener {
        private LineChangesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (JSLineBreakpoint.PROP_LINE_NUMBER.equals(evt.getPropertyName())) {
                JSLineBreakpoint.this.firePropertyChange(JSLineBreakpoint.PROP_LINE_NUMBER, evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private class FileRemoveListener
    extends FileChangeAdapter {
        private FileRemoveListener() {
        }

        public void fileDeleted(FileEvent arg0) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)JSLineBreakpoint.this);
        }

        public void fileRenamed(FileRenameEvent fe) {
            FileObject renamedFo = fe.getFile();
            int oldLineNumber = JSLineBreakpoint.this.line.getLineNumber();
            EditorLineHandler newLine = EditorLineHandlerFactory.getHandler(renamedFo, oldLineNumber);
            int newLineNumber = newLine.getLineNumber();
            JSLineBreakpoint.this.line = newLine;
            JSLineBreakpoint.this.firePropertyChange(JSLineBreakpoint.PROP_LINE_NUMBER, oldLineNumber, newLineNumber);
            JSLineBreakpoint.this.firePropertyChange(JSLineBreakpoint.PROP_FILE, fe.getName(), renamedFo.getName());
        }
    }
}

