/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;

public class EmbeddedHintsCollector
extends JavaParserResultTask<Parser.Result> {
    private static final Map<Snapshot, List<ErrorDescription>> hints = new WeakHashMap<Snapshot, List<ErrorDescription>>();
    private boolean javaFound;
    private volatile boolean cancelled;
    private List<ErrorDescription> allHints;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAnnotations(Snapshot snap, List<ErrorDescription> descs) {
        if (snap.getMimePath().size() == 1) {
            Document doc = snap.getSource().getDocument(false);
            if (doc == null) {
                return;
            }
            HintsController.setErrors((Document)doc, (String)"java-hints", descs);
            return;
        }
        Map<Snapshot, List<ErrorDescription>> map = hints;
        synchronized (map) {
            hints.put(snap, descs);
        }
    }

    public EmbeddedHintsCollector() {
        super(JavaSource.Phase.PARSED, TaskIndexingMode.DISALLOWED_DURING_SCAN);
    }

    private void collectResult(Snapshot snap) {
        List<ErrorDescription> partial = hints.get(snap);
        if (this.allHints == null) {
            this.allHints = new ArrayList<ErrorDescription>();
        }
        if (partial != null) {
            this.allHints.addAll(partial);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        Map<Snapshot, List<ErrorDescription>> map;
        this.cancelled = false;
        Snapshot mySnapshot = result.getSnapshot();
        if (mySnapshot.getMimePath().size() > 1) {
            return;
        }
        if (mySnapshot.getMimeType().equals("text/x-java")) {
            return;
        }
        try {
            map = hints;
            synchronized (map) {
                for (Snapshot snap : hints.keySet()) {
                    if (!snap.getSource().equals(mySnapshot.getSource())) continue;
                    this.collectResult(snap);
                }
            }
            if (this.cancelled) {
                return;
            }
            if (this.allHints != null) {
                HintsController.setErrors((Document)result.getSnapshot().getSource().getDocument(false), (String)"java-hints", this.allHints);
            }
        }
        finally {
            map = hints;
            synchronized (map) {
                hints.clear();
                this.allHints = null;
            }
        }
    }

    public int getPriority() {
        return 10000;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (snapshot.getMimePath().size() > 1) {
                return Collections.emptyList();
            }
            return Collections.singleton(new EmbeddedHintsCollector());
        }
    }
}

