/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.LanguagesNavigatorModel;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class LanguagesNavigator
implements NavigatorPanel {
    private JComponent panelUI;
    private JTree tree;
    private MyLookupListener lookupListener;
    private DataObject dataObject;
    private JEditorPane lastEditor;
    private MyCaretListener caretListener;

    public String getDisplayHint() {
        return "This is Navigator";
    }

    public String getDisplayName() {
        return "Navigator";
    }

    public JComponent getComponent() {
        if (this.panelUI == null) {
            this.tree = new JTree(){

                @Override
                public String getToolTipText(MouseEvent ev) {
                    TreePath path = LanguagesNavigator.this.tree.getPathForLocation(ev.getX(), ev.getY());
                    if (path == null) {
                        return null;
                    }
                    Object node = path.getLastPathComponent();
                    LanguagesNavigatorModel model = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
                    return model.getTooltip(node);
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            Listener listener = new Listener();
            this.tree.addMouseListener(listener);
            this.tree.addKeyListener(listener);
            this.tree.setToggleClickCount(Integer.MAX_VALUE);
            this.tree.setModel(new LanguagesNavigatorModel());
            this.tree.setCellRenderer(new Renderer());
            this.panelUI = new JScrollPane(this.tree);
        }
        return this.panelUI;
    }

    public void panelActivated(Lookup context) {
        this.getComponent();
        Lookup.Result result = context.lookupResult(DataObject.class);
        DataObject dataObject = (DataObject)result.allInstances().iterator().next();
        if (this.lookupListener != null) {
            this.lookupListener.remove();
        }
        this.lookupListener = new MyLookupListener((Lookup.Result<DataObject>)result);
        this.setDataObject(dataObject);
    }

    public void panelDeactivated() {
        if (this.lastEditor != null) {
            this.lastEditor.removeCaretListener(this.caretListener);
        }
        this.lastEditor = null;
    }

    public Lookup getLookup() {
        return null;
    }

    private void setDataObject(DataObject dataObject) {
        if (this.dataObject == dataObject) {
            return;
        }
        final EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (ec == null) {
            return;
        }
        LanguagesNavigatorModel model = (LanguagesNavigatorModel)this.tree.getModel();
        try {
            NbEditorDocument document = (NbEditorDocument)ec.openDocument();
            String mimeType = (String)document.getProperty((Object)"mimeType");
            if (mimeType == null) {
                return;
            }
            if (!LanguagesManager.getDefault().isSupported(mimeType)) {
                return;
            }
            model.setContext(document);
        }
        catch (IOException ex) {
            model.setContext(null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ec.getOpenedPanes() != null && ec.getOpenedPanes().length > 0) {
                    LanguagesNavigator.this.setCurrentEditor(ec.getOpenedPanes()[0]);
                } else {
                    LanguagesNavigator.this.setCurrentEditor(null);
                }
            }
        });
    }

    private void setCurrentEditor(JEditorPane editor) {
        if (this.caretListener == null) {
            this.caretListener = new MyCaretListener();
        }
        if (this.lastEditor != null) {
            this.lastEditor.removeCaretListener(this.caretListener);
        }
        this.lastEditor = editor;
        if (this.lastEditor != null) {
            this.lastEditor.addCaretListener(this.caretListener);
        }
    }

    class Listener
    implements MouseListener,
    KeyListener {
        Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            if (ev.getClickCount() != 2) {
                return;
            }
            TreePath path = LanguagesNavigator.this.tree.getPathForLocation(ev.getX(), ev.getY());
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            LanguagesNavigatorModel model = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
            model.show(node);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() != 10) {
                return;
            }
            TreePath path = LanguagesNavigator.this.tree.getSelectionPath();
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            LanguagesNavigatorModel model = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
            model.show(node);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        private static Map<String, Icon> icons = new HashMap<String, Icon>();

        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel l = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                l.setIcon(null);
                l.setText((String)((DefaultMutableTreeNode)value).getUserObject());
                return l;
            }
            LanguagesNavigatorModel model = (LanguagesNavigatorModel)tree.getModel();
            l.setIcon(Renderer.getCIcon(model.getIcon(value)));
            l.setText(model.getDisplayName(value));
            return l;
        }

        private static Icon getCIcon(String resourceName) {
            if (resourceName == null) {
                return null;
            }
            if (!icons.containsKey(resourceName)) {
                Image image = ImageUtilities.loadImage((String)resourceName);
                if (image == null) {
                    image = ImageUtilities.loadImage((String)"org/netbeans/modules/languages/resources/node.gif");
                }
                icons.put(resourceName, new ImageIcon(image));
            }
            return icons.get(resourceName);
        }
    }

    class MyLookupListener
    implements LookupListener {
        private Lookup.Result<DataObject> result;

        MyLookupListener(Lookup.Result<DataObject> result) {
            this.result = result;
            result.addLookupListener((LookupListener)this);
        }

        void remove() {
            this.result.removeLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent ev) {
            Iterator it = this.result.allInstances().iterator();
            if (!it.hasNext()) {
                LanguagesNavigator.this.setDataObject(null);
            } else {
                LanguagesNavigator.this.setDataObject((DataObject)it.next());
            }
        }
    }

    class MyCaretListener
    implements CaretListener {
        MyCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            LanguagesNavigatorModel model = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
            TreePath treePath = model.getTreePath(e.getDot());
            if (treePath == null) {
                return;
            }
            LanguagesNavigator.this.tree.setSelectionPath(treePath);
            LanguagesNavigator.this.tree.scrollPathToVisible(treePath);
        }
    }
}

