/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.knockout;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.web.inspect.PageInspectorImpl;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.knockout.Bundle;
import org.netbeans.modules.web.inspect.webkit.knockout.KnockoutPanel;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="KnockoutTC", persistenceType=0, iconBase="org/netbeans/modules/web/inspect/resources/knockout.png")
public final class KnockoutTC
extends TopComponent {
    public static final String ID = "KnockoutTC";
    private KnockoutPanel currentPanel;
    private Reference<PageModel> lastKnockoutPageModel;
    private String lastKnockoutVersion;

    public KnockoutTC() {
        this.setName(Bundle.CTL_KnockoutTC());
        this.setToolTipText(Bundle.HINT_KnockoutTC());
        this.setLayout(new BorderLayout());
        this.associateLookup((Lookup)new KnockoutTCLookup());
        PageInspectorImpl.getDefault().addPropertyChangeListener(this.createInspectorListener());
        this.update();
    }

    final void update() {
        if (EventQueue.isDispatchThread()) {
            PageModel knockoutPageModel;
            PageModel pageModel = PageInspectorImpl.getDefault().getPage();
            if (this.currentPanel != null) {
                if (pageModel == this.currentPanel.getPageModel()) {
                    return;
                }
                this.currentPanel.dispose();
            }
            this.removeAll();
            this.currentPanel = new KnockoutPanel((WebKitPageModel)pageModel);
            if (this.lastKnockoutPageModel != null && (knockoutPageModel = this.lastKnockoutPageModel.get()) != null && knockoutPageModel == pageModel) {
                this.currentPanel.knockoutUsed(this.lastKnockoutVersion);
            }
            this.add(this.currentPanel);
            ((KnockoutTCLookup)this.getLookup()).setPanel(this.currentPanel);
            this.revalidate();
            this.repaint();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KnockoutTC.this.update();
                }
            });
        }
    }

    protected void componentOpened() {
        super.componentOpened();
        this.update();
    }

    void knockoutUsed(PageModel pageModel, String koVersion) {
        assert (EventQueue.isDispatchThread());
        if (this.currentPanel != null) {
            if (this.currentPanel.getPageModel() == pageModel) {
                this.currentPanel.knockoutUsed(koVersion);
                this.lastKnockoutVersion = null;
            } else {
                this.lastKnockoutPageModel = new WeakReference<PageModel>(pageModel);
                this.lastKnockoutVersion = koVersion;
            }
        }
    }

    boolean isKnockoutUsed() {
        if (this.currentPanel == null) {
            return this.lastKnockoutVersion != null;
        }
        return this.currentPanel.isKnockoutUsed();
    }

    void showKnockoutContext() {
        if (this.currentPanel != null) {
            this.currentPanel.showKnockoutContext();
        }
    }

    private PropertyChangeListener createInspectorListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("model".equals(propName)) {
                    KnockoutTC.this.update();
                }
            }
        };
    }

    private class KnockoutTCLookup
    extends ProxyLookup {
        private KnockoutTCLookup() {
        }

        void setPanel(KnockoutPanel panel) {
            Lookup lookup = Lookups.proxy((Lookup.Provider)panel.createLookupProvider(KnockoutTC.this.getActionMap()));
            this.setLookups(new Lookup[]{lookup});
        }
    }
}

