/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.spi.io.InputOutputProvider;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public abstract class IOProvider {
    private IOProvider() {
    }

    @NonNull
    public static IOProvider getDefault() {
        InputOutputProvider<?, ?, ?, ?> def = (InputOutputProvider<?, ?, ?, ?>)Lookup.getDefault().lookup(InputOutputProvider.class);
        if (def != null) {
            return IOProvider.wrapProvider(def);
        }
        def = IOProvider.getBridgingDefault();
        if (def != null) {
            return IOProvider.wrapProvider(def);
        }
        return IOProvider.wrapProvider(new Trivial());
    }

    private static <IO, OW extends PrintWriter, P, F> IOProvider wrapProvider(InputOutputProvider<IO, OW, P, F> provider) {
        return new Impl<IO, OW, P, F>(provider);
    }

    private static InputOutputProvider<?, ?, ?, ?> getBridgingDefault() {
        return IOProvider.getBridging("getDefault", new Class[0], new Object[0]);
    }

    private static InputOutputProvider<?, ?, ?, ?> getBridging(String name) {
        return IOProvider.getBridging("get", new Class[]{String.class}, new Object[]{name});
    }

    private static InputOutputProvider<?, ?, ?, ?> getBridging(String methodName, Class<?>[] paramTypes, Object[] params) {
        String className = "org.openide.io.BridgingGetter";
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (cl != null) {
            try {
                Class<?> c = Class.forName(className, true, cl);
                Object instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method m = c.getDeclaredMethod(methodName, paramTypes);
                Object result = m.invoke(instance, params);
                if (result instanceof InputOutputProvider) {
                    return (InputOutputProvider)result;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    @NonNull
    public static IOProvider get(@NonNull String id) {
        Parameters.notNull((CharSequence)"id", (Object)id);
        Collection providers = Lookup.getDefault().lookupAll(InputOutputProvider.class);
        for (InputOutputProvider p : providers) {
            if (!p.getId().equals(id)) continue;
            return IOProvider.wrapProvider(p);
        }
        InputOutputProvider<?, ?, ?, ?> bridgingImpl = IOProvider.getBridging(id);
        if (bridgingImpl != null) {
            return IOProvider.wrapProvider(bridgingImpl);
        }
        return IOProvider.getDefault();
    }

    @NonNull
    public abstract String getId();

    @NonNull
    public abstract InputOutput getIO(@NonNull String var1, boolean var2);

    @NonNull
    public abstract InputOutput getIO(@NonNull String var1, boolean var2, @NonNull Lookup var3);

    private static class Trivial
    implements InputOutputProvider<Object, PrintWriter, Void, Void> {
        private Trivial() {
        }

        @Override
        public String getId() {
            return "Trivial";
        }

        @Override
        public Object getIO(String name, boolean newIO, Lookup lookup) {
            return this;
        }

        @Override
        public Reader getIn(Object io) {
            return new InputStreamReader(System.in);
        }

        @Override
        public PrintWriter getOut(Object io) {
            return new PrintWriter(System.out);
        }

        @Override
        public PrintWriter getErr(Object io) {
            return new PrintWriter(System.err);
        }

        @Override
        public void print(Object io, PrintWriter writer, String text, Hyperlink link, OutputColor color, boolean printLineEnd) {
            writer.print(text);
            if (printLineEnd) {
                writer.println();
            }
        }

        @Override
        public Lookup getIOLookup(Object io) {
            return Lookup.EMPTY;
        }

        @Override
        public void resetIO(Object io) {
        }

        @Override
        public void showIO(Object io, Set<ShowOperation> operations) {
        }

        @Override
        public void closeIO(Object io) {
        }

        @Override
        public boolean isIOClosed(Object io) {
            return false;
        }

        @Override
        public Void getCurrentPosition(Object io, PrintWriter writer) {
            return null;
        }

        @Override
        public void scrollTo(Object io, PrintWriter writer, Void position) {
        }

        @Override
        public Void startFold(Object io, PrintWriter writer, boolean expanded) {
            return null;
        }

        @Override
        public void endFold(Object io, PrintWriter writer, Void fold) {
        }

        @Override
        public void setFoldExpanded(Object io, PrintWriter writer, Void fold, boolean expanded) {
        }

        @Override
        public String getIODescription(Object io) {
            return null;
        }

        @Override
        public void setIODescription(Object io, String description) {
        }
    }

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends IOProvider {
        private final InputOutputProvider<IO, OW, P, F> impl;

        public Impl(InputOutputProvider<IO, OW, P, F> impl) {
            this.impl = impl;
        }

        @Override
        public String getId() {
            return this.impl.getId();
        }

        @Override
        public InputOutput getIO(String name, boolean newIO) {
            return this.getIO(name, newIO, Lookup.EMPTY);
        }

        @Override
        public InputOutput getIO(String name, boolean newIO, Lookup lookup) {
            Parameters.notNull((CharSequence)"name", (Object)name);
            Parameters.notNull((CharSequence)"lookup", (Object)lookup);
            return InputOutput.create(this.impl, this.impl.getIO(name, newIO, lookup));
        }
    }
}

