/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ZoomManager {
    public static final int DEFAULT_ZOOM_PERCENT = 100;
    public static final int MIN_ZOOM_PERCENT = 33;
    public static final int MAX_ZOOM_PERCENT = 200;
    private static final int ZOOM_STEP_THRESHOLD = 100;
    private static final int ZOOM_STEP_SMALL = 5;
    private static final int ZOOM_STEP_LARGE = 25;
    private Scene scene;
    private int zoomPercentage = 100;
    private EventListenerList listeners;

    public ZoomManager(Scene scene) {
        this.scene = scene;
        this.listeners = new EventListenerList();
        scene.addSceneListener(new Scene.SceneListener(){

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                int newZoomPercentage = (int)(ZoomManager.this.getScene().getZoomFactor() * 100.0);
                if (newZoomPercentage != ZoomManager.this.zoomPercentage) {
                    ZoomManager.this.zoomPercentage = newZoomPercentage;
                    ZoomManager.this.fireZoomEvent(ZoomManager.this.zoomPercentage);
                }
            }
        });
    }

    public void addZoomListener(ZoomListener listener) {
        this.listeners.add(ZoomListener.class, listener);
    }

    public void addToolbarActions(JToolBar toolbar) {
        toolbar.add(new FitDiagramAction(this));
        toolbar.add(new FitWidthAction(this));
        toolbar.add(new ZoomDefaultAction(this));
        toolbar.add(new ZoomComboBox(this));
        ZoomInAction inAction = new ZoomInAction(this);
        this.addZoomListener(inAction);
        toolbar.add(inAction);
        ZoomOutAction outAction = new ZoomOutAction(this);
        this.addZoomListener(outAction);
        toolbar.add(outAction);
    }

    public static int calculateZoomInValue(int percent) {
        int newZoomValue = percent >= 100 ? (percent + 25) / 25 * 25 : (percent + 5) / 5 * 5;
        return newZoomValue;
    }

    public static int calculateZoomOutValue(int percent) {
        int newZoomValue = percent > 100 ? (percent - 1) / 25 * 25 : (percent - 1) / 5 * 5;
        return newZoomValue;
    }

    private void fireZoomEvent(int percent) {
        Object[] list = this.listeners.getListenerList();
        ZoomEvent event = null;
        for (int ii = list.length - 2; ii >= 0; ii -= 2) {
            if (list[ii] != ZoomListener.class) continue;
            if (event == null) {
                event = new ZoomEvent(this, percent);
            }
            ((ZoomListener)list[ii + 1]).zoomChanged(event);
        }
    }

    public Scene getScene() {
        return this.scene;
    }

    public int getZoom() {
        return this.zoomPercentage;
    }

    public void removeZoomListener(ZoomListener listener) {
        this.listeners.remove(ZoomListener.class, listener);
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public void setZoom(int percent) {
        JScrollPane pane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.scene.getView());
        assert (pane != null) : "Scene view component not in a JScrollPane?!?";
        if (pane == null) {
            return;
        }
        JViewport viewport = pane.getViewport();
        Rectangle visRect = viewport.getViewRect();
        Point center = new Point(visRect.x + visRect.width / 2, visRect.y + visRect.height / 2);
        this.setZoom(percent, center);
    }

    public void setZoom(int percent, Point center) {
        if (percent < 33) {
            percent = 33;
        } else if (percent > 200) {
            percent = 200;
        }
        Point sceneCenter = this.scene.convertViewToScene(center);
        this.zoomPercentage = percent;
        double factor = (double)percent / 100.0;
        this.scene.setZoomFactor(factor);
        this.scene.validate();
        this.scene.repaint();
        Point newViewCenter = this.scene.convertSceneToView(sceneCenter);
        JComponent view = this.scene.getView();
        Rectangle visRect = view.getVisibleRect();
        visRect.x = newViewCenter.x - (center.x - visRect.x);
        visRect.y = newViewCenter.y - (center.y - visRect.y);
        Dimension viewSize = view.getSize();
        if (visRect.x + visRect.width > viewSize.width) {
            visRect.x = viewSize.width - visRect.width;
        }
        if (visRect.y + visRect.height > viewSize.height) {
            visRect.y = viewSize.height - visRect.height;
        }
        if (visRect.x < 0) {
            visRect.x = 0;
        }
        if (visRect.y < 0) {
            visRect.y = 0;
        }
        view.scrollRectToVisible(visRect);
        view.revalidate();
        view.repaint();
        this.fireZoomEvent(percent);
    }

    private static interface ZoomListener
    extends EventListener {
        public void zoomChanged(ZoomEvent var1);
    }

    private static class FitDiagramAction
    extends AbstractAction {
        private ZoomManager manager;

        public FitDiagramAction(ZoomManager manager) {
            this.manager = manager;
            String path = NbBundle.getMessage(FitDiagramAction.class, (String)"IMG_FitDiagramAction");
            Image img = ImageUtilities.loadImage((String)path);
            if (img != null) {
                this.putValue("SmallIcon", new ImageIcon(img));
            }
            String desc = NbBundle.getMessage(FitDiagramAction.class, (String)"LBL_FitDiagramAction");
            this.putValue("Name", desc);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Scene scene = this.manager.getScene();
            JScrollPane pane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, scene.getView());
            if (pane == null) {
                return;
            }
            JViewport viewport = pane.getViewport();
            Rectangle visRect = viewport.getViewRect();
            Rectangle compRect = scene.getPreferredBounds();
            int zoomX = visRect.width * 100 / compRect.width;
            int zoomY = visRect.height * 100 / compRect.height;
            int zoom = Math.min(zoomX, zoomY);
            this.manager.setZoom(zoom);
        }
    }

    private static class FitWidthAction
    extends AbstractAction {
        private ZoomManager manager;

        public FitWidthAction(ZoomManager manager) {
            this.manager = manager;
            String path = NbBundle.getMessage(FitWidthAction.class, (String)"IMG_FitWidthAction");
            Image img = ImageUtilities.loadImage((String)path);
            if (img != null) {
                this.putValue("SmallIcon", new ImageIcon(img));
            }
            String desc = NbBundle.getMessage(FitWidthAction.class, (String)"LBL_FitWidthAction");
            this.putValue("Name", desc);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Scene scene = this.manager.getScene();
            JScrollPane pane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, scene.getView());
            if (pane == null) {
                return;
            }
            JViewport viewport = pane.getViewport();
            Rectangle visRect = viewport.getViewRect();
            Rectangle compRect = scene.getPreferredBounds();
            int zoom = visRect.width * 100 / compRect.width;
            this.manager.setZoom(zoom);
        }
    }

    private static class ZoomDefaultAction
    extends AbstractAction {
        private ZoomManager manager;

        public ZoomDefaultAction(ZoomManager manager) {
            this.manager = manager;
            String path = NbBundle.getMessage(ZoomDefaultAction.class, (String)"IMG_ZoomDefaultAction");
            Image img = ImageUtilities.loadImage((String)path);
            if (img != null) {
                this.putValue("SmallIcon", new ImageIcon(img));
            }
            String desc = NbBundle.getMessage(ZoomDefaultAction.class, (String)"LBL_ZoomDefaultAction");
            this.putValue("Name", desc);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.manager.setZoom(100);
        }
    }

    private static class ZoomComboBox
    extends JComboBox {
        private ZoomManager manager;

        public ZoomComboBox(ZoomManager manager) {
            super(new Model());
            this.manager = manager;
            this.setPrototypeDisplayValue(100000);
            this.setMaximumSize(this.getPreferredSize());
            this.setEditable(true);
            Listener l = new Listener(manager);
            this.addActionListener(l);
            manager.addZoomListener(l);
        }

        private static class Model
        extends DefaultComboBoxModel {
            public Model() {
                this.addElement(new Value(33));
                this.addElement(new Value(50));
                this.addElement(new Value(75));
                Value def = new Value(100);
                this.addElement(def);
                this.addElement(new Value(150));
                this.addElement(new Value(200));
                this.setSelectedItem(def);
            }
        }

        private class Listener
        implements ActionListener,
        ZoomListener {
            private ZoomManager manager;

            public Listener(ZoomManager manager) {
                this.manager = manager;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object src = event.getSource();
                String cmd = event.getActionCommand();
                if (src == ZoomComboBox.this && cmd.equals(ZoomComboBox.this.getActionCommand())) {
                    Object item = ZoomComboBox.this.getSelectedItem();
                    Value value = null;
                    if (item instanceof String) {
                        String str = (String)item;
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        try {
                            int i = Integer.parseInt(str);
                            value = new Value(i);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (item instanceof Value) {
                        value = (Value)item;
                    }
                    if (value == null) {
                        value = new Value(ZoomComboBox.this.manager.getZoom());
                    }
                    this.manager.setZoom(value.getValue());
                }
            }

            @Override
            public void zoomChanged(ZoomEvent event) {
                ZoomComboBox.this.removeActionListener(this);
                ZoomComboBox.this.setSelectedItem(new Value(event.getPercent()));
                ZoomComboBox.this.addActionListener(this);
            }
        }

        private static class Value {
            private int value;
            private String str;

            public Value(int value) {
                this.value = value;
                this.str = value + "%";
            }

            public boolean equals(Object o) {
                if (o instanceof Value) {
                    return this.value == ((Value)o).getValue();
                }
                return false;
            }

            public int hashCode() {
                return this.value;
            }

            public int getValue() {
                return this.value;
            }

            public String toString() {
                return this.str;
            }
        }
    }

    private static class ZoomInAction
    extends AbstractAction
    implements ZoomListener {
        private ZoomManager manager;

        public ZoomInAction(ZoomManager manager) {
            this.manager = manager;
            String path = NbBundle.getMessage(ZoomInAction.class, (String)"IMG_ZoomInAction");
            Image img = ImageUtilities.loadImage((String)path);
            if (img != null) {
                this.putValue("SmallIcon", new ImageIcon(img));
            }
            String desc = NbBundle.getMessage(ZoomInAction.class, (String)"LBL_ZoomInAction");
            this.putValue("Name", desc);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int percent = this.manager.getZoom();
            percent = ZoomManager.calculateZoomInValue(percent);
            this.manager.setZoom(percent);
        }

        @Override
        public void zoomChanged(ZoomEvent event) {
            boolean enable = event.getPercent() < 200;
            this.setEnabled(enable);
        }
    }

    private static class ZoomOutAction
    extends AbstractAction
    implements ZoomListener {
        private ZoomManager manager;

        public ZoomOutAction(ZoomManager manager) {
            this.manager = manager;
            String path = NbBundle.getMessage(ZoomOutAction.class, (String)"IMG_ZoomOutAction");
            Image img = ImageUtilities.loadImage((String)path);
            if (img != null) {
                this.putValue("SmallIcon", new ImageIcon(img));
            }
            String desc = NbBundle.getMessage(ZoomOutAction.class, (String)"LBL_ZoomOutAction");
            this.putValue("Name", desc);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int percent = this.manager.getZoom();
            percent = ZoomManager.calculateZoomOutValue(percent);
            this.manager.setZoom(percent);
        }

        @Override
        public void zoomChanged(ZoomEvent event) {
            boolean enable = event.getPercent() > 33;
            this.setEnabled(enable);
        }
    }

    private static class ZoomEvent
    extends EventObject {
        private int percent;

        public ZoomEvent(Object src, int percent) {
            super(src);
            this.percent = percent;
        }

        public int getPercent() {
            return this.percent;
        }
    }
}

