/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.devops;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.devops.Bundle;
import org.netbeans.modules.cloud.oracle.devops.DeployArtifactItem;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class DeployArtifactNode
extends OCINode {
    private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/deploy_artifact.svg";

    public DeployArtifactNode(OCIItem item) {
        super(item, Children.LEAF);
        this.setIconBaseWithExtension(ICON);
    }

    public static NodeProvider<DeployArtifactItem> createNode() {
        return DeployArtifactNode::new;
    }

    public static ChildrenProvider<DevopsProjectItem, DeployArtifactItem.DeployArtifactFolder> listDeployArtifacts() {
        return project -> {
            try (DevopsClient client = new DevopsClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());){
                ListDeployArtifactsRequest request = ListDeployArtifactsRequest.builder().projectId(project.getKey().getValue()).build();
                ListDeployArtifactsResponse response = client.listDeployArtifacts(request);
                List projects = response.getDeployArtifactCollection().getItems();
                List<DeployArtifactItem.DeployArtifactFolder> list = Collections.singletonList(new DeployArtifactItem.DeployArtifactFolder(OCID.of(project.getKey().getValue(), "DeployArtifactFolder"), project.getCompartmentId(), Bundle.DeployArtifacts(), projects.stream().map(p -> new DeployArtifactItem(OCID.of(p.getId(), "DeployArtifact"), project.getCompartmentId(), p.getDisplayName())).collect(Collectors.toList())));
                return list;
            }
        };
    }

    public static NodeProvider<DeployArtifactItem.DeployArtifactFolder> createFolderNode() {
        return DeployArtifactFolderNode::new;
    }

    public static ChildrenProvider<DeployArtifactItem.DeployArtifactFolder, DeployArtifactItem> expandRepositories() {
        return repositories -> repositories.getArtidfacts();
    }

    public static class DeployArtifactFolderNode
    extends OCINode {
        private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/deploy_artifact_folder.svg";

        public DeployArtifactFolderNode(DeployArtifactItem.DeployArtifactFolder folder) {
            super(folder);
            this.setIconBaseWithExtension(ICON);
        }
    }
}

