/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.devops;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.requests.ListRepositoriesRequest;
import com.oracle.bmc.devops.responses.ListRepositoriesResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.devops.Bundle;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.devops.RepositoryItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class RepositoryNode
extends OCINode {
    private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/repository.svg";

    public RepositoryNode(OCIItem item) {
        super(item, Children.LEAF);
        this.setIconBaseWithExtension(ICON);
    }

    public static NodeProvider<RepositoryItem> createNode() {
        return RepositoryNode::new;
    }

    public static ChildrenProvider<DevopsProjectItem, RepositoryItem.RepositoryFolder> listRepositories() {
        return project -> {
            try (DevopsClient client = new DevopsClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());){
                ListRepositoriesRequest listRepositoriesRequest = ListRepositoriesRequest.builder().projectId(project.getKey().getValue()).build();
                ListRepositoriesResponse response = client.listRepositories(listRepositoriesRequest);
                List projects = response.getRepositoryCollection().getItems();
                List<RepositoryItem.RepositoryFolder> list = Collections.singletonList(new RepositoryItem.RepositoryFolder(OCID.of(project.getKey().getValue(), "RepositoryFolder"), project.getCompartmentId(), Bundle.Repositories(), projects.stream().map(p -> new RepositoryItem(OCID.of(p.getId(), "Repository"), project.getCompartmentId(), p.getName())).collect(Collectors.toList())));
                return list;
            }
        };
    }

    public static NodeProvider<RepositoryItem.RepositoryFolder> createFolderNode() {
        return RepositoryFolderNode::new;
    }

    public static ChildrenProvider<RepositoryItem.RepositoryFolder, RepositoryItem> expandRepositories() {
        return repositories -> repositories.getRepositories();
    }

    public static class RepositoryFolderNode
    extends OCINode {
        private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/repository_folder.svg";

        public RepositoryFolderNode(RepositoryItem.RepositoryFolder item) {
            super(item);
            this.setIconBaseWithExtension(ICON);
        }
    }
}

