/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation;

import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.CdiAnnotationAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.InterceptorBindingVerifier;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.TargetAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.TargetVerifier;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.openide.util.NbBundle;

public class InterceptorBindingAnalyzer
implements AnnotationModelAnalyzer.AnnotationAnalyzer {
    @Override
    public void analyze(TypeElement element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (!AnnotationUtil.hasAnnotation(element, "jakarta.interceptor.InterceptorBinding", (CompilationInfo)model.getCompilationController())) {
            return;
        }
        result.requireCdiEnabled(element, model);
        InterceptorTargetAnalyzer analyzer = new InterceptorTargetAnalyzer(element, model, result);
        if (cancel.get()) {
            return;
        }
        if (!analyzer.hasRuntimeRetention()) {
            result.addError((Element)element, model, NbBundle.getMessage(InterceptorBindingAnalyzer.class, (String)"ERR_IncorrectRuntimeRetention"));
        }
        if (cancel.get()) {
            return;
        }
        if (!analyzer.hasTarget()) {
            result.addError((Element)element, model, NbBundle.getMessage(InterceptorBindingAnalyzer.class, (String)"ERR_IncorrectInterceptorBindingTarget"));
        } else {
            if (cancel.get()) {
                return;
            }
            Set<ElementType> declaredTargetTypes = analyzer.getDeclaredTargetTypes();
            if (cancel.get()) {
                return;
            }
            this.checkTransitiveInterceptorBindings(element, declaredTargetTypes, model, result);
        }
    }

    private void checkTransitiveInterceptorBindings(TypeElement element, Set<ElementType> declaredTargetTypes, WebBeansModel model, ModelAnalyzer.Result result) {
        if (declaredTargetTypes == null || declaredTargetTypes.size() == 1) {
            return;
        }
        Collection<AnnotationMirror> interceptorBindings = model.getInterceptorBindings(element);
        for (AnnotationMirror iBinding : interceptorBindings) {
            Set<ElementType> bindingTargetTypes;
            Element binding = iBinding.getAnnotationType().asElement();
            if (!(binding instanceof TypeElement) || (bindingTargetTypes = TargetAnalyzer.getDeclaredTargetTypes(new AnnotationHelper((CompilationInfo)model.getCompilationController()), (TypeElement)binding)).size() != 1 || !bindingTargetTypes.contains((Object)ElementType.TYPE)) continue;
            result.addError((Element)element, model, NbBundle.getMessage(InterceptorBindingAnalyzer.class, (String)"ERR_IncorrectTransitiveInterceptorBinding", (Object)((TypeElement)binding).getQualifiedName().toString()));
        }
    }

    private static class InterceptorTargetAnalyzer
    extends CdiAnnotationAnalyzer {
        InterceptorTargetAnalyzer(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
            super(element, model, result);
        }

        @Override
        protected String getCdiMetaAnnotation() {
            return "InterceptorBinding";
        }

        @Override
        protected TargetVerifier getTargetVerifier() {
            return InterceptorBindingVerifier.getInstance();
        }
    }
}

