/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.jakarta.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.jakarta.web.beans.impl.model.DecoratorObject;
import org.netbeans.modules.jakarta.web.beans.impl.model.EventInjectionPointLogic;
import org.netbeans.modules.jakarta.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.jakarta.web.beans.impl.model.InterceptorBindingChecker;
import org.netbeans.modules.jakarta.web.beans.impl.model.InterceptorObject;
import org.netbeans.modules.jakarta.web.beans.impl.model.StereotypeChecker;
import org.netbeans.modules.jakarta.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.jakarta.web.beans.impl.model.results.InterceptorsResultImpl;
import org.netbeans.modules.jakarta.web.beans.impl.model.results.ResultImpl;

abstract class DecoratorInterceptorLogic
extends EventInjectionPointLogic {
    DecoratorInterceptorLogic(WebBeansModelImplementation model) {
        super(model);
    }

    @Override
    public Collection<TypeElement> getDecorators(TypeElement element) {
        Collection decorators = this.getModel().getDecoratorsManager().getObjects();
        ArrayList<TypeElement> result = new ArrayList<TypeElement>(decorators.size());
        for (DecoratorObject decoratorObject : decorators) {
            TypeElement decorator = decoratorObject.getTypeElement();
            if (!this.isDecoratorFor(decorator, element)) continue;
            result.add(decorator);
        }
        return result;
    }

    @Override
    public Collection<AnnotationMirror> getInterceptorBindings(Element element) {
        InterceptorBindingChecker interceptorChecker = new InterceptorBindingChecker(this.getModel().getHelper());
        StereotypeChecker stereotypeChecker = new StereotypeChecker(this.getModel().getHelper().getHelper());
        IntereptorBindingHandler handler = new IntereptorBindingHandler(interceptorChecker, stereotypeChecker);
        HashSet<AnnotationMirror> result = new HashSet<AnnotationMirror>();
        DecoratorInterceptorLogic.transitiveVisitAnnotatedElements(element, result, this.getModel().getHelper().getHelper(), handler);
        if (element.getKind() == ElementKind.METHOD) {
            TypeElement enclosedClass = this.getCompilationController().getElementUtilities().enclosingTypeElement(element);
            Collection<AnnotationMirror> classBindings = this.getInterceptorBindings(enclosedClass);
            result.addAll(classBindings);
        }
        return result;
    }

    @Override
    public InterceptorsResultImpl getInterceptors(Element element) {
        Collection interceptors = this.getModel().getInterceptorsManager().getObjects();
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        Collection<AnnotationMirror> elementBindings = this.getInterceptorBindings(element);
        Set<String> elementBindingsFqns = DecoratorInterceptorLogic.getAnnotationFqns(elementBindings);
        for (InterceptorObject interceptor : interceptors) {
            TypeElement typeElement = interceptor.getTypeElement();
            if (!this.hasInterceptorBindings(typeElement, elementBindingsFqns)) continue;
            result.add(typeElement);
        }
        this.filterBindingsByMembers(elementBindings, result, TypeElement.class);
        return this.getInterceptorsResult(element, result);
    }

    private InterceptorsResultImpl getInterceptorsResult(Element element, Set<TypeElement> interceptors) {
        LinkedHashSet<String> interceptorClasses = this.getModel().getBeansModel().getInterceptorClasses();
        ArrayList<TypeElement> enabledInterceptors = new ArrayList<TypeElement>(interceptors.size());
        for (String fqn : interceptorClasses) {
            TypeElement interceptor = this.getCompilationController().getElements().getTypeElement(fqn);
            if (!interceptors.contains(interceptor)) continue;
            enabledInterceptors.add(interceptor);
        }
        interceptors.removeAll(enabledInterceptors);
        InterceptorsResultImpl result = new InterceptorsResultImpl(element, enabledInterceptors, interceptors, this.getModel().getHelper());
        return result;
    }

    static void transitiveVisitAnnotatedElements(Element element, Set<AnnotationMirror> result, AnnotationHelper helper, TransitiveAnnotationHandler handler) {
        List<? extends AnnotationMirror> annotationMirrors = helper.getCompilationInfo().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Element annotationElement;
            if (result.contains(annotationMirror) || !((annotationElement = annotationMirror.getAnnotationType().asElement()) instanceof TypeElement)) continue;
            boolean isTargetAnnotation = handler.isTargetAnotation((TypeElement)annotationElement);
            if (isTargetAnnotation) {
                result.add(annotationMirror);
            }
            if (!handler.proceed(element, (TypeElement)annotationElement, isTargetAnnotation)) continue;
            DecoratorInterceptorLogic.transitiveVisitAnnotatedElements((TypeElement)annotationElement, result, helper, handler);
        }
    }

    private boolean hasInterceptorBindings(TypeElement typeElement, Set<String> elementBindings) {
        Collection<AnnotationMirror> requiredBindings = this.getInterceptorBindings(typeElement);
        Set<String> requiredInterceptorFqns = DecoratorInterceptorLogic.getAnnotationFqns(requiredBindings);
        return elementBindings.containsAll(requiredInterceptorFqns);
    }

    private boolean isDecoratorFor(TypeElement decorator, TypeElement element) {
        EventInjectionPointLogic.Triple<VariableElement, TypeMirror, Void> data = this.getDelegateInjectionPoint(decorator);
        if (data == null) {
            return false;
        }
        VariableElement delegate = data.getFirst();
        TypeMirror delegateType = data.getSecond();
        HashSet<TypeElement> set = new HashSet<TypeElement>();
        set.add(element);
        this.filterBindingsByType(delegate, delegateType, set);
        if (set.isEmpty()) {
            return false;
        }
        return this.checkQualifiers(element, delegate, delegateType, set);
    }

    private EventInjectionPointLogic.Triple<VariableElement, TypeMirror, Void> getDelegateInjectionPoint(TypeElement decorator) {
        List<? extends Element> allMembers = this.getCompilationController().getElements().getAllMembers(decorator);
        List<VariableElement> fields = ElementFilter.fieldsIn(allMembers);
        for (VariableElement field : fields) {
            if (!AnnotationObjectProvider.hasAnnotation(field, "jakarta.decorator.Delegate", this.getModel().getHelper()) || !AnnotationObjectProvider.hasAnnotation(field, "jakarta.inject.Inject", this.getModel().getHelper())) continue;
            TypeMirror delegateType = this.getCompilationController().getTypes().asMemberOf((DeclaredType)decorator.asType(), field);
            return new EventInjectionPointLogic.Triple<VariableElement, TypeMirror, Object>(field, delegateType, null);
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(allMembers);
        List<ExecutableElement> ctors = ElementFilter.constructorsIn(allMembers);
        LinkedHashSet<ExecutableElement> allMethods = new LinkedHashSet<ExecutableElement>();
        allMethods.addAll(ctors);
        allMethods.addAll(methods);
        for (ExecutableElement method : allMethods) {
            EventInjectionPointLogic.Triple<VariableElement, TypeMirror, Void> result;
            if (!AnnotationObjectProvider.hasAnnotation(method, "jakarta.inject.Inject", this.getModel().getHelper()) || (result = this.getDelegate(method, decorator)) == null) continue;
            return result;
        }
        return null;
    }

    private EventInjectionPointLogic.Triple<VariableElement, TypeMirror, Void> getDelegate(ExecutableElement method, TypeElement decorator) {
        List<? extends VariableElement> parameters = method.getParameters();
        int index = 0;
        VariableElement delegate = null;
        for (VariableElement variableElement : parameters) {
            if (AnnotationObjectProvider.hasAnnotation(variableElement, "jakarta.decorator.Delegate", this.getModel().getHelper())) {
                delegate = variableElement;
                break;
            }
            ++index;
        }
        if (delegate == null) {
            return null;
        }
        ExecutableType methodType = (ExecutableType)this.getCompilationController().getTypes().asMemberOf((DeclaredType)decorator.asType(), method);
        List<? extends TypeMirror> list = methodType.getParameterTypes();
        TypeMirror typeMirror = list.get(index);
        return new EventInjectionPointLogic.Triple<VariableElement, TypeMirror, Object>(delegate, typeMirror, null);
    }

    private boolean checkQualifiers(TypeElement element, VariableElement delegate, TypeMirror delegateType, Set<TypeElement> set) {
        LinkedList<AnnotationMirror> quilifierAnnotations = new LinkedList<AnnotationMirror>();
        boolean anyQualifier = false;
        try {
            anyQualifier = this.hasAnyQualifier(delegate, false, false, quilifierAnnotations);
        }
        catch (FieldInjectionPointLogic.InjectionPointDefinitionError e) {
            return false;
        }
        boolean defaultQualifier = !anyQualifier && quilifierAnnotations.size() == 0;
        boolean newQualifier = false;
        if (quilifierAnnotations.size() == 1) {
            newQualifier = this.getModel().getHelper().hasAnnotation(quilifierAnnotations, "jakarta.enterprise.inject.New");
            defaultQualifier = this.getModel().getHelper().hasAnnotation(quilifierAnnotations, "jakarta.enterprise.inject.Default");
        } else if (quilifierAnnotations.size() == 0 && anyQualifier) {
            return true;
        }
        if (defaultQualifier) {
            if (this.hasImplicitDefaultQualifier(element)) {
                return true;
            }
            List<AnnotationMirror> qualifiers = this.getQualifiers(element, true);
            return this.getModel().getHelper().hasAnnotation(qualifiers, "jakarta.enterprise.inject.Default");
        }
        if (newQualifier) {
            ResultImpl lookupResult = this.handleNewQualifier(delegate, delegateType, quilifierAnnotations);
            Set<TypeElement> typeElements = lookupResult.getTypeElements();
            return typeElements.contains(element);
        }
        if (!this.checkQualifiers(element, quilifierAnnotations)) {
            return false;
        }
        this.filterBindingsByMembers(quilifierAnnotations, set, TypeElement.class);
        return !set.isEmpty();
    }

    private boolean checkQualifiers(TypeElement element, List<AnnotationMirror> quilifierAnnotations) {
        Set<String> requiredAnnotationFqns = DecoratorInterceptorLogic.getAnnotationFqns(quilifierAnnotations);
        List<AnnotationMirror> elementAnnotations = this.getQualifiers(element, true);
        Set<String> elementAnnotationFqns = DecoratorInterceptorLogic.getAnnotationFqns(elementAnnotations);
        if (requiredAnnotationFqns.contains("jakarta.enterprise.inject.Default") && !elementAnnotationFqns.contains("jakarta.enterprise.inject.Default") && !this.hasImplicitDefaultQualifier(element)) {
            return false;
        }
        requiredAnnotationFqns.remove("jakarta.enterprise.inject.Default");
        return elementAnnotationFqns.containsAll(requiredAnnotationFqns);
    }

    private static final class IntereptorBindingHandler
    implements TransitiveAnnotationHandler {
        private final InterceptorBindingChecker interceptorChecker;
        private final StereotypeChecker stereotypeChecker;

        private IntereptorBindingHandler(InterceptorBindingChecker interceptorChecker, StereotypeChecker stereotypeChecker) {
            this.interceptorChecker = interceptorChecker;
            this.stereotypeChecker = stereotypeChecker;
        }

        @Override
        public boolean proceed(Element annotatedElement, TypeElement element, boolean isTargetAnnotation) {
            if (isTargetAnnotation) {
                return true;
            }
            this.stereotypeChecker.init(element);
            boolean isStereotype = this.stereotypeChecker.check();
            this.stereotypeChecker.clean();
            if (isStereotype && annotatedElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                this.stereotypeChecker.init((TypeElement)annotatedElement);
                isStereotype = this.stereotypeChecker.check();
                this.stereotypeChecker.clean();
            }
            return isStereotype;
        }

        @Override
        public boolean isTargetAnotation(TypeElement element) {
            this.interceptorChecker.init(element);
            boolean isInterceptor = this.interceptorChecker.check();
            this.interceptorChecker.clean();
            return isInterceptor;
        }
    }

    static interface TransitiveAnnotationHandler {
        public boolean proceed(Element var1, TypeElement var2, boolean var3);

        public boolean isTargetAnotation(TypeElement var1);
    }
}

