char volume_multipass_vert[] = "#version 110\n"
                               "\n"
                               "uniform mat4 texgen;\n"
                               "\n"
                               "varying vec4 cameraPos;\n"
                               "varying vec4 vertexPos;\n"
                               "varying vec3 lightDirection;\n"
                               "varying mat4 texgen_withProjectionMatrixInverse;\n"
                               "varying vec4 baseColor;\n"
                               "\n"
                               "varying float near;\n"
                               "varying float far;\n"
                               "varying float near_mult_far;\n"
                               "varying float far_sub_near;\n"
                               "\n"
                               "void main(void)\n"
                               "{\n"
                               "    // compute near and far values from projection matrix.\n"
                               "    near = gl_ProjectionMatrix[2][3] / (gl_ProjectionMatrix[2][2]-1.0);\n"
                               "    far = gl_ProjectionMatrix[2][3] / (1.0+gl_ProjectionMatrix[2][2]);\n"
                               "\n"
                               "    near_mult_far = near*far;\n"
                               "    far_sub_near = far-near;\n"
                               "\n"
                               "    gl_Position = ftransform();\n"
                               "\n"
                               "    cameraPos = gl_ModelViewMatrixInverse * vec4(0,0,0,1);\n"
                               "    vertexPos = gl_Vertex;\n"
                               "    baseColor = gl_FrontMaterial.diffuse;\n"
                               "\n"
                               "    vec4 lightPosition = gl_ModelViewMatrixInverse * gl_LightSource[0].position;\n"
                               "    if (lightPosition[3]==0.0)\n"
                               "    {\n"
                               "        // directional light source\n"
                               "        lightDirection = -normalize(lightPosition.xyz);\n"
                               "    }\n"
                               "    else\n"
                               "    {\n"
                               "        // positional light source\n"
                               "        lightDirection = normalize((lightPosition-vertexPos).xyz);\n"
                               "    }\n"
                               "\n"
                               "    texgen_withProjectionMatrixInverse =  texgen * gl_ProjectionMatrixInverse;\n"
                               "}\n"
                               "\n";
