//
//  AboutBox.m
//  X-MasTree
//
//  Created by John Schilling on 12/7/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "AboutBox.h"

#define ANIMATE_SECONDS         3.00
#define MAX_ABOUT_FRAMES        1

@implementation AboutBox

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark

- (id)init
{
    if( ![super init] ) return nil;
	/* INIT CODE HERE */
    return self;
}

- (void)awakeFromNib
{
    NSString *appNameString = [[[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleExecutable"] retain];
    NSString *versionString = [[[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"] retain];
    [_appNameField setStringValue: appNameString];
    [_versionNumberField setStringValue:[NSString stringWithFormat:@"Version Number %@", versionString]];
}

- (void)mouseDown:(NSEvent *)theEvent
{
    [[self window] makeFirstResponder:[[self window] contentView]];
}

- (BOOL)windowShouldClose:(id)sender
{
    //[self stopAnimeTimer];
    return YES;
}

- (void)dealloc
{
    [super dealloc];
}

- (IBAction)openAboutBoxWindow:(id)sender
{
    //[self startAnimeTimer];
    [[self window] makeKeyAndOrderFront:self];
}

- (IBAction)openLink:(id)sender
{
    NSString *URL;
    switch ([sender tag]) {
        case 0:
        URL = @"http://www.jschilling.net";
        break;
        
        case 1:
        URL = @"mailto:john@jschilling.net?subject=X-MasTree";
        break;
        
        case 2:
        URL = @"https://www.paypal.com/xclick/business=john%40jschilling.net&no_note=1&tax=0&currency_code=USD";
        break;
        
        case 3:
        URL = @"http://www.macteens.com";
        break;
        
        case 4:
        URL = @"http://soloot.jp/mt/e-wa/";
        break;
    }
    [[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString: URL]];
    [[self window] close];
}


- (void)startAnimeTimer
{
    NSTimer *aTimer = [NSTimer scheduledTimerWithTimeInterval:(float)ANIMATE_SECONDS
                                target:self 
                                selector:@selector(animate:) 
                                userInfo:nil 
                                repeats:YES];
    [self stopAnimeTimer];
    _animeIndex = 0;
    _animeTimer = [aTimer retain];
}

- (void)stopAnimeTimer
{
    if (_animeTimer) [_animeTimer invalidate];
    if (_animeTimer) [_animeTimer release];
    _animeTimer = nil;
}

- (void)animate:(NSTimer *)timer
{
    _animeIndex++;
    if (_animeIndex > MAX_ABOUT_FRAMES) _animeIndex = 0;
    [_aboutView setImage:[NSImage imageNamed:[NSString stringWithFormat:@"About%d.tiff", _animeIndex]]];
}

@end
