//
//  ShapedView.m
//  ShapedWindowz3
//
//  Created by John Schilling on 10/20/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "ShapedView.h"


@implementation ShapedView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code here.
    }
    return self;
}

- (void)dealloc
{
    if (_image) [_image release];
    _image = nil;
    [super dealloc];
}

- (void)drawRect:(NSRect)rect {
    [[NSColor clearColor] set];
    NSRectFill( rect );
    if (_image) [_image compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver];
}

- (void)setImage:(NSImage *)anImage
{
    if (anImage) {
        _image = anImage;
        NSSize imageSize;
        imageSize = [_image size];
        [[self window] setContentSize:imageSize];
    }
}

- (void)updateImage:(NSImage *)anImage
{
    if (anImage) {
        _image = [anImage copy];
        [self setNeedsDisplay:YES];
    }
}

@end
