/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.build.DependencyFile;
import com.android.sdklib.build.FileGatherer;
import com.android.sdklib.build.SourceSearcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class RenderScriptChecker {
    @NonNull
    protected final List<File> mSourceFolders;
    @NonNull
    private final File mBinFolder;
    protected Set<File> mOldOutputs;
    protected Set<File> mOldInputs;
    protected List<DependencyFile> mDependencyFiles;

    public RenderScriptChecker(@NonNull List<File> sourceFolders, @NonNull File binFolder) {
        this.mSourceFolders = sourceFolders;
        this.mBinFolder = binFolder;
    }

    public void loadDependencies() throws IOException {
        File renderscriptDeps = new File(this.mBinFolder, "rsDeps");
        File[] depsFiles = null;
        if (renderscriptDeps.isDirectory()) {
            depsFiles = renderscriptDeps.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return s.endsWith(".d");
                }
            });
        }
        int count = depsFiles != null ? depsFiles.length : 0;
        this.mDependencyFiles = Lists.newArrayListWithCapacity((int)0);
        this.mOldOutputs = Sets.newHashSet();
        this.mOldInputs = Sets.newHashSet();
        if (count > 0) {
            for (File file : depsFiles) {
                DependencyFile depFile = new DependencyFile(file, this.mSourceFolders);
                depFile.parse();
                this.mDependencyFiles.add(depFile);
                this.mOldOutputs.addAll(depFile.getOutputFiles());
                this.mOldInputs.addAll(depFile.getInputFiles());
            }
        }
    }

    @NonNull
    public List<File> findInputFiles() throws IOException {
        SourceSearcher searcher = new SourceSearcher(this.mSourceFolders, "rs", "fs");
        FileGatherer fileGatherer = new FileGatherer();
        searcher.search(fileGatherer);
        return fileGatherer.getFiles();
    }

    @Nullable
    public Set<File> getOldOutputs() {
        return this.mOldOutputs;
    }

    @Nullable
    public Set<File> getOldInputs() {
        return this.mOldInputs;
    }

    public void cleanDependencies() {
        if (this.mDependencyFiles != null) {
            for (DependencyFile depFile : this.mDependencyFiles) {
                depFile.getFile().delete();
            }
        }
    }

    @NonNull
    public List<File> getSourceFolders() {
        return this.mSourceFolders;
    }
}

