/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkersContribution;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class GroupsContribution
extends MarkersContribution {
    protected IContributionItem[] getContributionItems() {
        ExtendedMarkersView view = this.getView();
        if (view == null) {
            return new IContributionItem[0];
        }
        Collection groups = view.getBuilder().getGenerator().getMarkerGroups();
        if (groups.isEmpty()) {
            return new IContributionItem[0];
        }
        Iterator groupsIterator = groups.iterator();
        IContributionItem[] items = new IContributionItem[groups.size() + 1];
        int i = 0;
        while (i < items.length - 1) {
            MarkerGroup group = (MarkerGroup)groupsIterator.next();
            items[i] = this.getContributionItem(group);
            ++i;
        }
        items[items.length - 1] = this.getContributionItem(null);
        return items;
    }

    private IContributionItem getContributionItem(final MarkerGroup group) {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 16);
                item.setText(group == null ? MarkerMessages.ProblemView_None : group.getMarkerField().getName());
                ExtendedMarkersView view = GroupsContribution.this.getView();
                item.addListener(13, this.getMenuItemListener(group, view));
                if (view != null) {
                    if (group == null) {
                        item.setSelection(view.getCategoryGroup() == null);
                    } else {
                        item.setSelection(group.equals(view.getCategoryGroup()));
                    }
                }
            }

            private Listener getMenuItemListener(MarkerGroup group2, ExtendedMarkersView view) {
                return new Listener(this, view, group2){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ExtendedMarkersView val$view;
                    private final /* synthetic */ MarkerGroup val$group;
                    {
                        this.this$1 = var1_1;
                        this.val$view = extendedMarkersView;
                        this.val$group = markerGroup;
                    }

                    public void handleEvent(Event event) {
                        MenuItem item = (MenuItem)event.widget;
                        if (item.getSelection() && this.val$view != null) {
                            this.val$view.setCategoryGroup(this.val$group);
                        }
                    }
                };
            }
        };
    }
}

