/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElementTemplate;
import lombok.ast.AnnotationValue;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.Identifier;
import lombok.ast.Node;

public class AnnotationElement
extends AbstractNode
implements DescribedNode {
    private AbstractNode name = null;
    private AbstractNode value = null;

    public Annotation upToAnnotation() {
        if (!(this.getParent() instanceof Annotation)) {
            return null;
        }
        Annotation out = (Annotation)this.getParent();
        if (!out.rawElements().contains(this)) {
            return null;
        }
        return out;
    }

    public Identifier astName() {
        if (!(this.name instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.name;
    }

    public AnnotationElement astName(Identifier name) {
        return this.rawName(name);
    }

    private AnnotationElement rawName(Node name) {
        if (name == this.name) {
            return this;
        }
        if (name != null) {
            this.adopt((AbstractNode)name);
        }
        if (this.name != null) {
            this.disown(this.name);
        }
        this.name = (AbstractNode)name;
        return this;
    }

    public AnnotationValue astValue() {
        if (!(this.value instanceof AnnotationValue)) {
            return null;
        }
        return (AnnotationValue)((Object)this.value);
    }

    public AnnotationElement astValue(AnnotationValue value) {
        if (value == null) {
            throw new NullPointerException("value is mandatory");
        }
        return this.rawValue(value);
    }

    public Node rawValue() {
        return this.value;
    }

    public AnnotationElement rawValue(Node value) {
        if (value == this.value) {
            return this;
        }
        if (value != null) {
            this.adopt((AbstractNode)value);
        }
        if (this.value != null) {
            this.disown(this.value);
        }
        this.value = (AbstractNode)value;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.name != null) {
            result.add(this.name);
        }
        if (this.value != null) {
            result.add(this.value);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.name == original) {
            if (replacement instanceof Identifier) {
                this.astName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.value == original) {
            this.rawValue(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.name == child) {
            this.disown((AbstractNode)child);
            this.name = null;
            return true;
        }
        if (this.value == child) {
            this.disown((AbstractNode)child);
            this.value = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitAnnotationElement(this)) {
            return;
        }
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.value != null) {
            this.value.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public AnnotationElement copy() {
        AnnotationElement result = new AnnotationElement();
        if (this.name != null) {
            result.rawName(this.name.copy());
        }
        if (this.value != null) {
            result.rawValue(this.value.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return AnnotationElementTemplate.getDescription(this);
    }

    public List<Node> getValues() {
        return AnnotationElementTemplate.getValues(this);
    }
}

