/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorInvocation;
import lombok.ast.EnumConstant;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;

public class NormalTypeBody
extends AbstractNode
implements TypeBody {
    ListAccessor<TypeMember, NormalTypeBody> members = ListAccessor.of(this, TypeMember.class, "NormalTypeBody");

    @Override
    public ConstructorInvocation upIfAnonymousClassToConstructorInvocation() {
        if (!(this.getParent() instanceof ConstructorInvocation)) {
            return null;
        }
        ConstructorInvocation out = (ConstructorInvocation)this.getParent();
        if (out.rawAnonymousClassBody() != this) {
            return null;
        }
        return out;
    }

    @Override
    public EnumConstant upToEnumConstant() {
        if (!(this.getParent() instanceof EnumConstant)) {
            return null;
        }
        EnumConstant out = (EnumConstant)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    @Override
    public TypeDeclaration upToTypeDeclaration() {
        if (!(this.getParent() instanceof TypeDeclaration)) {
            return null;
        }
        TypeDeclaration out = (TypeDeclaration)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public RawListAccessor<TypeMember, NormalTypeBody> rawMembers() {
        return this.members.asRaw();
    }

    public StrictListAccessor<TypeMember, NormalTypeBody> astMembers() {
        return this.members.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.members.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return this.rawMembers().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        return this.rawMembers().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitNormalTypeBody(this)) {
            return;
        }
        for (AbstractNode child : this.members.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public NormalTypeBody copy() {
        NormalTypeBody result = new NormalTypeBody();
        for (AbstractNode n : this.members.backingList()) {
            result.rawMembers().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }
}

