/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled;

import lombok.ast.libs.org.parboiled.Action;
import lombok.ast.libs.org.parboiled.BaseActions;
import lombok.ast.libs.org.parboiled.Capture;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.annotations.Cached;
import lombok.ast.libs.org.parboiled.annotations.DontLabel;
import lombok.ast.libs.org.parboiled.annotations.Label;
import lombok.ast.libs.org.parboiled.annotations.SuppressNode;
import lombok.ast.libs.org.parboiled.annotations.SuppressSubnodes;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.errors.GrammarException;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.google.collect.ObjectArrays;
import lombok.ast.libs.org.parboiled.matchers.ActionMatcher;
import lombok.ast.libs.org.parboiled.matchers.AnyMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharIgnoreCaseMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharRangeMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharSetMatcher;
import lombok.ast.libs.org.parboiled.matchers.EmptyMatcher;
import lombok.ast.libs.org.parboiled.matchers.FirstOfMatcher;
import lombok.ast.libs.org.parboiled.matchers.OneOrMoreMatcher;
import lombok.ast.libs.org.parboiled.matchers.OptionalMatcher;
import lombok.ast.libs.org.parboiled.matchers.SequenceMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestNotMatcher;
import lombok.ast.libs.org.parboiled.matchers.ZeroOrMoreMatcher;
import lombok.ast.libs.org.parboiled.support.Characters;
import lombok.ast.libs.org.parboiled.support.Checks;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParser<V>
extends BaseActions<V> {
    public <P extends BaseParser<V>> P newInstance() {
        throw new UnsupportedOperationException("Illegal parser instance, you have to use Parboiled.createParser(...) to create your parser instance!");
    }

    @Cached
    @DontLabel
    public Rule Ch(char c) {
        return new CharMatcher(c).label("'" + StringUtils.escape(c) + '\'');
    }

    @Cached
    @DontLabel
    public Rule CharIgnoreCase(char c) {
        if (Character.isLowerCase(c) == Character.isUpperCase(c)) {
            return this.Ch(c);
        }
        CharIgnoreCaseMatcher matcher = new CharIgnoreCaseMatcher(c);
        return matcher.label("'" + StringUtils.escape(matcher.charLow) + '/' + StringUtils.escape(matcher.charUp) + '\'');
    }

    @Cached
    @DontLabel
    public Rule CharRange(char cLow, char cHigh) {
        return cLow == cHigh ? this.Ch(cLow) : new CharRangeMatcher(cLow, cHigh).label(StringUtils.escape(cLow) + ".." + StringUtils.escape(cHigh));
    }

    @DontLabel
    public Rule CharSet(@NotNull String characters) {
        if (characters == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.CharSet(...) corresponds to @NotNull parameter and must not be null");
        }
        return this.CharSet(characters.toCharArray());
    }

    @DontLabel
    public Rule CharSet(char ... characters) {
        if (characters == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.CharSet(...) corresponds to @NotNull parameter and must not be null");
        }
        Preconditions.checkArgument(characters.length > 0);
        return characters.length == 1 ? this.Ch(characters[0]) : this.CharSet(Characters.of(characters));
    }

    @Cached
    @DontLabel
    public Rule CharSet(@NotNull Characters characters) {
        if (characters == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.CharSet(...) corresponds to @NotNull parameter and must not be null");
        }
        if (!characters.isSubtractive() && characters.getChars().length == 1) {
            return this.Ch(characters.getChars()[0]);
        }
        return new CharSetMatcher(characters).label(characters.toString());
    }

    @DontLabel
    public Rule String(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.String(...) corresponds to @NotNull parameter and must not be null");
        }
        return this.String(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule String(char ... characters) {
        if (characters.length == 1) {
            return this.Ch(characters[0]);
        }
        Object[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.Ch(characters[i]);
        }
        return ((SequenceMatcher)this.Sequence(matchers)).label('\"' + String.valueOf(characters) + '\"');
    }

    @DontLabel
    public Rule StringIgnoreCase(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.StringIgnoreCase(...) corresponds to @NotNull parameter and must not be null");
        }
        return this.StringIgnoreCase(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule StringIgnoreCase(char ... characters) {
        if (characters.length == 1) {
            return this.CharIgnoreCase(characters[0]);
        }
        Object[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.CharIgnoreCase(characters[i]);
        }
        return ((SequenceMatcher)this.Sequence(matchers)).label('\"' + String.valueOf(characters) + '\"');
    }

    @DontLabel
    public Rule FirstOf(Object rule, Object rule2, Object ... moreRules) {
        if (moreRules == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.BaseParser.FirstOf(...) corresponds to @NotNull parameter and must not be null");
        }
        return this.FirstOf(ObjectArrays.concat(rule, ObjectArrays.concat(rule2, moreRules)));
    }

    @Cached
    @Label(value="FirstOf")
    public Rule FirstOf(@NotNull Object[] rules) {
        if (rules == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.FirstOf(...) corresponds to @NotNull parameter and must not be null");
        }
        return rules.length == 1 ? this.ToRule(rules[0]) : new FirstOfMatcher(this.ToRules(rules));
    }

    @Cached
    @Label(value="OneOrMore")
    public Rule OneOrMore(Object rule) {
        return new OneOrMoreMatcher(this.ToRule(rule));
    }

    @Cached
    @Label(value="Optional")
    public Rule Optional(Object rule) {
        return new OptionalMatcher(this.ToRule(rule));
    }

    @DontLabel
    public Rule Sequence(Object rule, Object rule2, Object ... moreRules) {
        if (moreRules == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.BaseParser.Sequence(...) corresponds to @NotNull parameter and must not be null");
        }
        return this.Sequence(ObjectArrays.concat(rule, ObjectArrays.concat(rule2, moreRules)));
    }

    @Cached
    @Label(value="Sequence")
    public Rule Sequence(@NotNull Object[] rules) {
        if (rules == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.Sequence(...) corresponds to @NotNull parameter and must not be null");
        }
        return rules.length == 1 ? this.ToRule(rules[0]) : new SequenceMatcher(this.ToRules(rules));
    }

    @Cached
    @SuppressNode
    public Rule Test(Object rule) {
        Rule subMatcher = this.ToRule(rule);
        return new TestMatcher(subMatcher).label("&(" + subMatcher + ")");
    }

    @Cached
    @SuppressNode
    public Rule TestNot(Object rule) {
        Rule subMatcher = this.ToRule(rule);
        return new TestNotMatcher(subMatcher).label("!(" + subMatcher + ")");
    }

    @Cached
    @Label(value="ZeroOrMore")
    public Rule ZeroOrMore(Object rule) {
        return new ZeroOrMoreMatcher(this.ToRule(rule));
    }

    @Label(value="EOI")
    public Rule Eoi() {
        return this.Ch('\uffff');
    }

    @Label(value="ANY")
    public Rule Any() {
        return new AnyMatcher();
    }

    @Label(value="EMPTY")
    public Rule Empty() {
        return new EmptyMatcher();
    }

    public static <T> T UP(T t) {
        throw new UnsupportedOperationException("Illegal UP(...) call outside of Action or Capture expression");
    }

    public static <T> T UP2(T expression) {
        return BaseParser.UP(expression);
    }

    public static <T> T UP3(T expression) {
        return BaseParser.UP(expression);
    }

    public static <T> T UP4(T expression) {
        return BaseParser.UP(expression);
    }

    public static <T> T UP5(T expression) {
        return BaseParser.UP(expression);
    }

    public static <T> T UP6(T expression) {
        return BaseParser.UP(expression);
    }

    public static <T> T DOWN(T t) {
        throw new UnsupportedOperationException("Illegal DOWN(...) call outside of Action or Capture expression");
    }

    public static <T> T DOWN2(T expression) {
        return BaseParser.DOWN(expression);
    }

    public static <T> T DOWN3(T expression) {
        return BaseParser.DOWN(expression);
    }

    public static <T> T DOWN4(T expression) {
        return BaseParser.DOWN(expression);
    }

    public static <T> T DOWN5(T expression) {
        return BaseParser.DOWN(expression);
    }

    public static <T> T DOWN6(T expression) {
        return BaseParser.DOWN(expression);
    }

    public static Action ACTION(boolean bl) {
        throw new UnsupportedOperationException("ACTION(...) calls can only be used in Rule creating parser methods");
    }

    public static <T> Capture<T> CAPTURE(T t) {
        throw new UnsupportedOperationException("CAPTURE(...) calls can only be used in Rule creating parser methods");
    }

    @DontLabel
    protected Rule FromCharLiteral(char c) {
        return this.Ch(c);
    }

    @DontLabel
    protected Rule FromStringLiteral(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.FromStringLiteral(...) corresponds to @NotNull parameter and must not be null");
        }
        return this.FromCharArray(string.toCharArray());
    }

    @DontLabel
    protected Rule FromCharArray(@NotNull char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.FromCharArray(...) corresponds to @NotNull parameter and must not be null");
        }
        return this.String(cArray);
    }

    public Rule[] ToRules(Object ... objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.BaseParser.ToRules(...) corresponds to @NotNull parameter and must not be null");
        }
        Rule[] ruleArray = new Rule[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ruleArray[i] = this.ToRule(objectArray[i]);
        }
        return ruleArray;
    }

    @DontLabel
    public Rule ToRule(Object object) {
        if (object instanceof Rule) {
            return (Rule)object;
        }
        if (object instanceof Character) {
            return this.FromCharLiteral(((Character)object).charValue());
        }
        if (object instanceof String) {
            return this.FromStringLiteral((String)object);
        }
        if (object instanceof char[]) {
            return this.FromCharArray((char[])object);
        }
        if (object instanceof Action) {
            Action action = (Action)object;
            return new ActionMatcher(action).label(action.toString());
        }
        Checks.ensure(!(object instanceof Boolean), "Rule specification contains an unwrapped Boolean value, if you were trying to specify a parser action wrap the expression with ACTION(...)");
        throw new GrammarException("'" + object + "' cannot be automatically converted to a parser Rule");
    }
}

